package dressing.ui.caisson;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.jface.tablecomboviewer.TableComboViewer;
import org.eclipse.nebula.widgets.tablecombo.TableCombo;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;

import com.badlogic.gdx.math.Vector3;

import dressing.model.ModelProvider;
import dressing.ui.engine3d.SceneTexture.CATEGORY;
import dressing.ui.util.SingleImageItemLabelProvider;
import gdxapp.object3d.DoorHandle;
import gdxapp.object3d.Profile;
import gdxapp.shaders.PbrMaterial;
import supercad.provider.FacadeHandleProvider;

public class FacadeHandleConfigurer extends Composite {

	private DoorHandle doorHandle;

	private TableComboViewer tableComboViewer;
	private Spinner widthSpinner;
	private Spinner heightSpinner;
	private Spinner depthSpinner;
	private Button btnPreview;
	private TableComboViewer tcvTexture;

	private final Vector3 size = new Vector3();
	private PbrMaterial mtl;
	private DoorHandle tmpDoorHandle;

	private Combo hCombo;
	private Combo vCombo;
	private Combo rotCombo;
	
	private boolean isProfile;

	public FacadeHandleConfigurer(Composite parent, DoorHandle doorHandle) {
		super(parent, SWT.NONE);
		this.doorHandle = doorHandle;
		isProfile = doorHandle instanceof Profile;
		createControl();
	}

	private void createControl() {
		setLayout(new GridLayout(1, false));
		Composite composite = new Composite(this, SWT.NONE);
		composite.setLayout(new GridLayout(2, false));
//		gd_composite.widthHint = 545;
		composite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));

		Composite paramComposite = new Composite(composite, SWT.NONE);
		paramComposite.setLayout(new GridLayout(2, false));
		paramComposite.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, true, 1, 1));
		Label lblMotif = new Label(paramComposite, SWT.NONE);
		lblMotif.setText("Motif");

		tableComboViewer = new TableComboViewer(paramComposite, SWT.READ_ONLY);
		TableCombo tableCombo = tableComboViewer.getTableCombo();
		tableCombo.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		tableCombo.setEditable(false);
		tableComboViewer.setContentProvider(ArrayContentProvider.getInstance());
		Object input = isProfile?FacadeHandleProvider.getInstance().getProfiles():
			FacadeHandleProvider.getInstance().getHandlers();
		tableComboViewer.setInput(input);
		tableCombo.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				tmpDoorHandle = ((DoorHandle) tableComboViewer.getStructuredSelection().getFirstElement());
				btnPreview.setImage(getImage(tmpDoorHandle));
				if(!isProfile)	
				{
					updateDimsCompnents(tmpDoorHandle.getDimension());
				}
			}
		});

		Label lblCouleur = new Label(paramComposite, SWT.NONE);
		lblCouleur.setText("Couleur");

		tcvTexture = new TableComboViewer(paramComposite, SWT.READ_ONLY);
		TableCombo tcTexture = tcvTexture.getTableCombo();
		tcTexture.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		tcvTexture.setLabelProvider(SingleImageItemLabelProvider.getInstance());
		tcvTexture.setContentProvider(ArrayContentProvider.getInstance());
		tcvTexture.setInput(ModelProvider.getMaterialsByCategory(CATEGORY.KNOBS).stream().distinct().toList());
		tcvTexture.addSelectionChangedListener(new ISelectionChangedListener() {
			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				mtl = (PbrMaterial) event.getStructuredSelection().getFirstElement();		
			}
		});
		if(!isProfile)
		{
			Label lblDimension = new Label(paramComposite, SWT.NONE);
			lblDimension.setText("Dimensions");

			Composite composite_4 = new Composite(paramComposite, SWT.NONE);
			composite_4.setLayout(new RowLayout(SWT.HORIZONTAL));

			Label lblX = new Label(composite_4, SWT.NONE);
			lblX.setText("L:");

			widthSpinner = new Spinner(composite_4, SWT.BORDER);
			widthSpinner.setMaximum(1000);
			widthSpinner.addModifyListener(new ModifyListener() {
				@Override
				public void modifyText(ModifyEvent e) {
					size.x = widthSpinner.getSelection() / 1000.0f;
				}
			});

			Label lblY = new Label(composite_4, SWT.NONE);
			lblY.setText("H:");

			heightSpinner = new Spinner(composite_4, SWT.BORDER);
			heightSpinner.setMaximum(1000);
			heightSpinner.addModifyListener(new ModifyListener() {
				@Override
				public void modifyText(ModifyEvent e) {
					size.y = heightSpinner.getSelection() / 1000.0f;
				}
			});

			Label lblX_1_1 = new Label(composite_4, SWT.NONE);
			lblX_1_1.setText("P:");

			depthSpinner = new Spinner(composite_4, SWT.BORDER);
			depthSpinner.setMaximum(1000);
			depthSpinner.addModifyListener(new ModifyListener() {
				@Override
				public void modifyText(ModifyEvent e) {
					size.z = depthSpinner.getSelection() / 1000.0f;
				}
			});

			Label lblPosition = new Label(paramComposite, SWT.NONE);
			lblPosition.setText("Position");

			Composite composite_3 = new Composite(paramComposite, SWT.NONE);
			composite_3.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
			composite_3.setLayout(new GridLayout(2, false));

			hCombo = new Combo(composite_3, SWT.READ_ONLY);
			hCombo.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
			hCombo.setItems("Gauche", "Centre", "Droite");

			vCombo = new Combo(composite_3, SWT.READ_ONLY);
			vCombo.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
			vCombo.setItems("Bas", "Centre", "Haut");

			Label lblOrientation = new Label(paramComposite, SWT.NONE);
			lblOrientation.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
			lblOrientation.setText("Orientation");

			rotCombo = new Combo(paramComposite, SWT.READ_ONLY);
			rotCombo.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
			rotCombo.setItems("Horizontale", "Verticale");
		}
		
		Composite modelPreview = new Composite(composite, SWT.READ_ONLY);
		GridData gd_modelPreview = new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1);
		gd_modelPreview.heightHint = 200;
		gd_modelPreview.widthHint = 200;
		modelPreview.setLayoutData(gd_modelPreview);
//		modelPreview.setSize(400, 400);
		modelPreview.setLayout(new GridLayout(1, false));

		btnPreview = new Button(modelPreview, SWT.CENTER);
		btnPreview.setText("");
		btnPreview.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		bind();
	}

	public void bind() {
		var handle =  FacadeHandleProvider.getInstance().getHandleById(this.doorHandle.getModelId());
		tableComboViewer.setSelection(new StructuredSelection(handle));
		tableComboViewer.getTableCombo().notifyListeners(SWT.Selection, null);
		if (doorHandle.getMaterial() != null) {
			try {
				for (var mtlX : ModelProvider.getMaterialsByCategory(CATEGORY.KNOBS)) {
					if (mtlX.getName().equals(doorHandle.getMaterial().getName())) {
						tcvTexture.setSelection(new StructuredSelection(mtlX));
						mtl = mtlX;
						break;
					}
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		if(!isProfile) {
			hCombo.select(this.doorHandle.getRelativePosition()[0] + 1);
			vCombo.select(this.doorHandle.getRelativePosition()[1] + 1);
			int rot = this.doorHandle.getRotation();
			rotCombo.select(rot == 0? 0:1);
		}
		
	}

	public void updateDoorHandle() {
		if (this.tmpDoorHandle == null || mtl == null)
			return;
		this.doorHandle.setModelId(tmpDoorHandle.getModelId());
		this.doorHandle.setModel(tmpDoorHandle.getModel());
		this.doorHandle.setMaterial(mtl);
		this.doorHandle.setName(tmpDoorHandle.getName());
		this.doorHandle.setPrice(tmpDoorHandle.getPrice());
		this.doorHandle.setPreviewPath(tmpDoorHandle.getPreviewPath());
		if(!isProfile) {
			this.doorHandle.setDimension(size.x, size.y, size.z);
			int v= vCombo.getSelectionIndex() - 1;
			int h = hCombo.getSelectionIndex() - 1;
			this.doorHandle.setRelativePosition(h, v);
			int rot = rotCombo.getSelectionIndex() == 0? 0:90;
			this.doorHandle.setRotation(rot);
		}
	}

	protected void textureChanged() {
		this.mtl = (PbrMaterial) tcvTexture.getStructuredSelection().getFirstElement();
	}

	protected Image getImage(DoorHandle doorHandle) {
		return doorHandle.getPreviewImg();
	}

	protected void updateDimsCompnents(Vector3 dims) {
		this.widthSpinner.setSelection((int) (dims.x * 1000));
		this.heightSpinner.setSelection((int) (dims.y * 1000));
		this.depthSpinner.setSelection((int) (dims.z * 1000));
	}

	@Override
	public void dispose() {
		super.dispose();
	}

	public DoorHandle getTmpDoorHandle() {
		return tmpDoorHandle;
	}

	public void setTmpDoorHandle(DoorHandle tmpDoorHandle) {
		this.tmpDoorHandle = tmpDoorHandle;
	}

	public PbrMaterial getMtl() {
		return mtl;
	}

	public void setMtl(PbrMaterial mtl) {
		this.mtl = mtl;
	}

	public DoorHandle getDoorHandle() {
		return doorHandle;
	}

	public void setDoorHandle(DoorHandle doorHandle) {
		this.doorHandle = doorHandle;
	}
	
	
	
	
}
