package dressing.ui;

import com.badlogic.gdx.math.Vector3;

import dressing.mathutils.Vector4;
import dressing.model.Space3DFree;
import gdxapp.object3d.KitchenElement;
import gdxapp.object3d.WorldObject;
import gdxapp.object3d.WorldObject.ObjectType;
import param.MechanicPrivateParam;
import param.MechanicPublicParam;
import param.TypeDefElement;

public class DesignChangeParamCommand implements ChangeCommand {
	
	String name;
	String description;

	WorldObject target;
	
	String paramKey;
	boolean isPublicParam=true;
	
	String oldValue;
	String newValue;
	
	TypeDefElement oldType;
	TypeDefElement newtype;
	
	private boolean isvalue = true;

	public DesignChangeParamCommand(String name, String description, WorldObject target, String paramKey,
			boolean isPublicParam, String oldValue, String newValue) {
		super();
		this.name = name;
		this.description = description;
		this.target = target;
		this.paramKey = paramKey;
		this.isPublicParam = isPublicParam;
		this.oldValue = oldValue;
		this.newValue = newValue;
		this.isvalue=true;
	}

	public DesignChangeParamCommand(String name, String description, WorldObject target, String paramKey,
			boolean isPublicParam, TypeDefElement oldType, TypeDefElement newtype) {
		super();
		this.name = name;
		this.description = description;
		this.target = target;
		this.paramKey = paramKey;
		this.isPublicParam = isPublicParam;
		this.oldType = oldType;
		this.newtype = newtype;
		this.isvalue=false;
	}

	@Override
	public void redo() {
		if(target!=null){
			if(target instanceof KitchenElement ) {
				KitchenElement element = (KitchenElement) target;
				try {
					if(isPublicParam)
					{
						MechanicPublicParam param = element.getMechanicDesign().getPublicParam(paramKey);
						if(param!=null)
						{
							if(isvalue) {
								param.setDefaultvalue(newValue);
							}else {
								param.setTypedefelement(newtype);
							}
						}
					}else {
						MechanicPrivateParam param = element.getMechanicDesign().getPrivateParam(paramKey);
						if(param!=null)
						{
							if(isvalue) {
								param.setValue(newValue);
							}else {
								param.setTypedefelement(newtype);
							}
						}
							
					}
					
					Space3DFree space=((Space3DFree)element.getDesignObject());
					space.update();
				
					target.setRequireRefrech(true);
				} catch (Exception e) {
					
					e.printStackTrace();

				}
			}
			
		}

	}

	@Override
	public void verify() {
		// TODO Auto-generated method stub

	}

	@Override
	public void undo() {
		if(target instanceof KitchenElement) {
			KitchenElement element = (KitchenElement) target;
				try {
					if(isPublicParam)
					{
						MechanicPublicParam param = element.getMechanicDesign().getPublicParam(paramKey);
						if(param!=null)
						{
							if(isvalue) {
								param.setDefaultvalue(oldValue);
							}else {
								param.setTypedefelement(oldType);
							}
						}
					}else {
						MechanicPrivateParam param = element.getMechanicDesign().getPrivateParam(paramKey);
						if(param!=null)
						{
							if(isvalue) {
								param.setValue(oldValue);
							}else {
								param.setTypedefelement(oldType);
							}
						}
							
					}
					
					Space3DFree space=((Space3DFree)element.getDesignObject());
					space.update();
					
					target.setRequireRefrech(true);
				} catch (Exception e) {
					
					e.printStackTrace();

				}
			}
	}

	public String getID() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getParamKey() {
		return paramKey;
	}

	public void setParamKey(String paramKey) {
		this.paramKey = paramKey;
	}

	public boolean isPublicParam() {
		return isPublicParam;
	}

	public void setPublicParam(boolean isPublicParam) {
		this.isPublicParam = isPublicParam;
	}

	public String getOldValue() {
		return oldValue;
	}

	public void setOldValue(String oldValue) {
		this.oldValue = oldValue;
	}

	public String getNewValue() {
		return newValue;
	}

	public void setNewValue(String newValue) {
		this.newValue = newValue;
	}

	public TypeDefElement getOldType() {
		return oldType;
	}

	public void setOldType(TypeDefElement oldType) {
		this.oldType = oldType;
	}

	public TypeDefElement getNewtype() {
		return newtype;
	}

	public void setNewtype(TypeDefElement newtype) {
		this.newtype = newtype;
	}

	public boolean isIsvalue() {
		return isvalue;
	}

	public void setIsvalue(boolean isvalue) {
		this.isvalue = isvalue;
	}

	public WorldObject getTarget() {
		return target;
	}

	public void setTarget(WorldObject target) {
		this.target = target;
	}

	@Override
	public void dispose() {
		name=null;
		description=null;
		target=null;
		paramKey=null;		
		oldValue=null;
		newValue=null;
		oldType=null;
		newtype=null;
	
	}
}
