package dressing.reporting.data.handle;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

import dressing.ui.util.StaticUiObjects;
import param.Material;
import reporting.data.handle.PieceCoupe;

public class DressingMaterialGroup {
	private String matName;
	List<PieceCoupe> pieceCoupes = new ArrayList<PieceCoupe>();
	private double pieceCount=0;
	private double totalSurface=0;
	private String stotalSurface;

	private double totalCost=0;
	private String stotalCost="";
	private String materialCost;

    private Material material; 
	public DressingMaterialGroup(Material material, List<PieceCoupe> pieceCoupes) {
		super();
		this.material=material;
		this.matName = this.material.getName();
		this.pieceCoupes = pieceCoupes;
		init();
	}

	private void init() {
		this.totalSurface=pieceCoupes.stream()    
				.mapToDouble(piececoupe -> ((piececoupe.getPieceL().doubleValue()/1000.0) * (piececoupe.getPieceH().doubleValue()/1000.0) * piececoupe.getQty()))
			    .sum();
		
		this.pieceCount = pieceCoupes.stream()
         .mapToDouble(PieceCoupe::getQty)
         .sum();
		this.totalCost=this.totalSurface*material.getPrice();

	        // Format the double value
	     stotalSurface = StaticUiObjects.decimalCotationFormat.format(totalSurface).replace(",", ".");
	     stotalCost = StaticUiObjects.decimalMoneyFormat.format(totalCost);
	     materialCost=StaticUiObjects.decimalMoneyFormat.format(material.getPrice());
	}

	public String getMatName() {
		return matName;
	}

	public void setMatName(String matName) {
		this.matName = matName;
	}

	public List<PieceCoupe> getPieceCoupes() {
		return pieceCoupes;
	}

	public void setPieceCoupes(List<PieceCoupe> pieceCoupes) {
		this.pieceCoupes = pieceCoupes;
	}

	public double getPieceCount() {
		return pieceCount;
	}

	public void setPieceCount(double pieceCount) {
		this.pieceCount = pieceCount;
	}

	public double getTotalSurface() {
		return totalSurface;
	}

	public void setTotalSurface(double totalSurface) {
		this.totalSurface = totalSurface;
	}

	public double getTotalCost() {
		return totalCost;
	}

	public Material getMaterial() {
		return material;
	}

	public String getStotalSurface() {
		return stotalSurface;
	}

	public String getStotalCost() {
		return stotalCost;
	}

	public String getMaterialCost() {
		return materialCost;
	}
	
}