package dressing.model;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map.Entry;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;

import org.eclipse.emf.common.util.EList;
import com.ibm.icu.text.UTF16.StringComparator;

import dressing.model.types.PortType;
import dressing.profiling.TimeProfiler;
import dressing.ui.engine3d.SceneTexture;
import dressing.ui.engine3d.SceneTexture.CATEGORY;
import gdxapp.object3d.DoorHandle;
import gdxapp.object3d.ModeledObject;
import gdxapp.object3d.ObjectModel;
import gdxapp.object3d.WorldObject;
import gdxapp.scenes.SceneEvent;
import gdxapp.shaders.PbrMaterial;
import param.DesignClasse;
import param.Material;
import param.MaterialType;
import param.MechanicDesign;
import param.MechanicDesignGroup;
import param.ModelRoot;
import param.TypeDef;
import dressing.config.WorkspaceConfiguration;
import dressing.config.persistence.ResourceManagers;
import dressing.events.EventDriver;
public class ModelProvider {
	private static ModelProvider instance;

	public synchronized static ModelProvider getIntance() {
		synchronized(ModelProvider.class) {
			if (instance == null) {
				instance = new ModelProvider();
			}
			return instance;
		}
	}
	public ModelProvider() {}
	
	private static ModelRoot modelroot;
	private static ProjectParent pparent = new ProjectParent();	
	private static ArrayList<Chant> listChant=new ArrayList<Chant>();
	private static List<ModeledObject> designObjects = new ArrayList<ModeledObject>();
	public static final HashMap<CATEGORY, List<PbrMaterial>> materials = new HashMap<CATEGORY, List<PbrMaterial>>(); 
	public static final ArrayList<ObjectModel> objectModels = new ArrayList<ObjectModel>();	
	public static ArrayList<SceneTexture> textures = new ArrayList<SceneTexture>();
	public final static ArrayList<PbrMaterial> tiles = new ArrayList<PbrMaterial>();
	private final static HashMap<String,BufferedImage> bufferedImagesHashMap = new HashMap<String, BufferedImage>();
	public static HashMap<UUID, DesignObject3D> libraryArticles = new HashMap<UUID, DesignObject3D>();
	private final static LinkedHashMap<PbrMaterial,SceneTexture> pbrMaterialSceneTextureHashMap = new LinkedHashMap<PbrMaterial,SceneTexture>();
	private final static LinkedHashMap<Material,SceneTexture> materialSceneTextureHashMap = new LinkedHashMap<Material,SceneTexture>();

	public static ProjectParent RootInstance()
	{
		if(pparent!=null)
			return pparent;
		else
		{
			 pparent = new ProjectParent();		
				return pparent;
		}
	}
	
	public List getTypePortelist() {
		ArrayList l = new ArrayList<>();
		for (PortType val : PortType.values()) {
			l.add(val);
		}
		return l;
	}
	
	public static ArrayList<Chant> getListChant() {
		return listChant;
	}
	public static void setListChant(ArrayList<Chant> listChant) {
		ModelProvider.listChant = listChant;
	}
	public static ModelRoot getModelroot() {
		if(modelroot==null) {
			modelroot=ResourceManagers.getIntance().getModelroot();
		}
		return modelroot;
	}
	public static void setModelroot(ModelRoot modelroot) {
		ModelProvider.modelroot = modelroot;
	}

	public static List<ModeledObject> getDesignObjects() {
		return designObjects;
	}
	public static void setDesignObjects(List<ModeledObject> designObjects) {
		ModelProvider.designObjects = designObjects;
		EventDriver.getDriver().deliverEvent(SceneEvent.UPDATE_DATAMODEL, designObjects);
	}
	public static List<ModeledObject> getDesignObjects(String categorie,String classe) {
		List<ModeledObject> designs=new ArrayList<ModeledObject>();
		if(designObjects !=null && !designObjects.isEmpty()) {
			for(ModeledObject object:designObjects) {
				String cat=object.getProperties().getProperty("category");
				String clss=object.getProperties().getProperty("class");
				if( (cat!=null && cat.contentEquals(categorie) ) && (clss!=null && clss.contentEquals(classe) ) ) {
					designs.add(object);
				}
			}
			return designs;
		}
		return designObjects;
	}
	public static List<ModeledObject> getDesignObjects(String classe) {
		List<ModeledObject> designs=new ArrayList<ModeledObject>();
		if(designObjects !=null && !designObjects.isEmpty()) {
			for(ModeledObject object:designObjects) {
				String clss=object.getProperties().getProperty("class");
				if(clss!=null && clss.contentEquals(classe)  ) {
					designs.add(object);
				}
			}
			return designs;
		}
		return designObjects;
	}
	public static List<ModeledObject> getDesignObjectsByCategory(String category) {
		List<ModeledObject> designs=new ArrayList<ModeledObject>();
		if(designObjects !=null && !designObjects.isEmpty()) {
			for(ModeledObject object:designObjects) {
				String clss=object.getProperties().getProperty("category");
				if(clss!=null && clss.contentEquals(category)  ) {
					designs.add(object);
				}
			}
			return designs;
		}
		return designObjects;
	}
	public static List<String> getDesignObjectsCategories() {
		List<String> categories=new ArrayList<String>();
		if(designObjects !=null && !designObjects.isEmpty()) {
			for(WorldObject object:designObjects) {
				String clss=object.getProperties().getProperty("category");
				if(clss!=null && !categories.contains(clss)  ) {
					categories.add(clss);
				}
			}
		}
		
		categories.sort(new StringComparator());
		System.err.println(new Date().toLocaleString());
		return categories;
	}
	
	public Object getMechanicDesignByGrp(String grpName) {
		Optional<DesignClasse> designClass = modelroot.getClasses().getDesignClasse().stream()
				.filter(e -> e.getName().equals("Cuisine")).findFirst();
		if(designClass.isPresent()) {
			var grp =  designClass.get().getCategorie().stream()
					.filter(c -> c.getName().equals(grpName)).findAny();
			if(grp.isPresent())
				return grp.get().getMechanicdesign();
		}
		return null;
		
	}
	
	public static ModeledObject getModeledObjectById(UUID uuid) {
		for(ModeledObject object:designObjects) {
			if(object.getUuid() != null && object.getUuid().equals(uuid))
				return object.clone();
		}
		return null;
	}
	
	public static BufferedImage getBufferedImage(String name) {
		BufferedImage bufferedImage = getBufferedImagesHashMap().get(name);
		return bufferedImage;
	}
	
	
	private static final HashMap<String, SceneTexture> registredTextures = new HashMap<String, SceneTexture>();
	
	
	public static void addTexture(String path, SceneTexture sceneTexture) {
		textures.add(sceneTexture);
		registredTextures.put(path, sceneTexture);
	}

	public static SceneTexture getSceneTexture(String path) {
		return registredTextures.get(path);

	}
	
	
	public static synchronized ArrayList<SceneTexture> getTextures() {
		return textures;
	}
	public static synchronized ArrayList<SceneTexture> getTextures(CATEGORY category) {
		return (ArrayList<SceneTexture>) textures.stream().filter(s->s.getCategory()==category).collect(Collectors.toList());
	}
	static long callfrequecy=0;
	//return the texture either by name or path
	public static SceneTexture getTexture(String path) {
		SceneTexture result = getSceneTexture(path);
		return result;
	}
	
	public static HashMap<String,BufferedImage> getBufferedImagesHashMap() {
		return bufferedImagesHashMap;
	}
	
	public static List<MechanicDesign> getMechanicDesigns(){
		List<MechanicDesign> designs = new ArrayList<MechanicDesign>();
		for(DesignClasse designClass : modelroot.getClasses().getDesignClasse()) {
			for(MechanicDesignGroup mdGroup: designClass.getCategorie()) {
				for(MechanicDesign mechanicDesignX: mdGroup.getMechanicdesign()) {
					designs.add(mechanicDesignX);
				}
				
			}
		}
		return designs;
	}
	
	public static MechanicDesign getMechanicDesignById(UUID uuid) {
		MechanicDesign mechanicDesign = null;
		for(DesignClasse designClass : modelroot.getClasses().getDesignClasse()) {
			for(MechanicDesignGroup mdGroup: designClass.getCategorie()) {
				if(mechanicDesign != null)
					break;
				for(MechanicDesign mechanicDesignX: mdGroup.getMechanicdesign()) {
					if(mechanicDesign != null)
						break;
					if(mechanicDesignX.getModelId().equals(uuid)) {
						mechanicDesign = mechanicDesignX;
						break;
					}
				}
				
			}
		}
		return mechanicDesign;
	}
	
	public static List<PbrMaterial> getMaterialsByCategory(CATEGORY category) {
		List<PbrMaterial> result = materials.get(category);
		if(result == null)
			result = new ArrayList<PbrMaterial>();
		return result;
	}
	
	public static MechanicDesign getMechanicDesignByName(String name) {
		MechanicDesign mechanicDesign = null;
		for(DesignClasse designClass : modelroot.getClasses().getDesignClasse()) {
			for(MechanicDesignGroup mdGroup: designClass.getCategorie()) {
				for(MechanicDesign mechanicDesignX: mdGroup.getMechanicdesign()) {
					if(mechanicDesignX.getName().equals(name)) {
						mechanicDesign = mechanicDesignX;
						break;
					}
				}
			}
		}
		return mechanicDesign;
	}

	public static MaterialType getMaterialTypeByName(String name) {
		MaterialType mtl = null;
		for(MaterialType material: ResourceManagers.getIntance().getMaterialTypesGroup().getMaterialTypes()) {
			if(material.getName().contentEquals(name)) {
				mtl = material;
				break;
			}
		}
		return mtl;
	}
	
	
	public PbrMaterial getTile(String name) {
		PbrMaterial tile = null;
		for(PbrMaterial mtl: tiles) {
			if(mtl.getName().contentEquals(name)) {
				tile = mtl;
				break;
			}
		}
		return tile;
	}
	public static ArrayList<PbrMaterial> getTiles() {
		return tiles;
	}
	
	
	public static void addPbrMaterial(PbrMaterial mtl, CATEGORY category) {
		List<PbrMaterial> collection = materials.get(category); 
		if(collection == null) {
			collection = new ArrayList<PbrMaterial>();
			materials.put(category, collection);
		}
		collection.add(mtl);
	}
	public static ObjectModel get3DObjectModel(UUID uuid) {
		ObjectModel model = null;
		for(ObjectModel modelX: objectModels) {
			if(modelX.getInfo().getUuid().equals(uuid)) {
				model = modelX;
				break;
			}
		}
		return model;
	}
	public static void addModelObject(ObjectModel model) {
		objectModels.add(model);
	}
	
	public static TypeDef getTypeDef(String key) {
		EList<TypeDef> types = modelroot.getCategorie().getTypedef();
		for (TypeDef type : types) {
			if (type.getKey().contentEquals(key)) {
				return type;
			}
		}
		return null;
	}
	
	public static List<PbrMaterial> getMaterials(){
		ArrayList<PbrMaterial> mtls = new ArrayList<PbrMaterial>();
		for(List<PbrMaterial> list: materials.values())
			mtls.addAll(list);
		return mtls;
	}
	
	// look for a material with a given name, if a category is not supplied we search the entire map
	public static PbrMaterial findMaterial(CATEGORY category, String name) {
		if(category == null) {
			for(Entry<CATEGORY, List<PbrMaterial>> entry: materials.entrySet()) {
				for(PbrMaterial mtl: entry.getValue()) {
					if(mtl.getName() != null && mtl.getName().equals(name))
						return mtl;
				}
			}
		}else {
			List<PbrMaterial> collection = materials.get(category);
			if(collection != null) {
				for(PbrMaterial mtl: collection) {
					if(mtl.getName() != null && mtl.getName().equals(name))
						return mtl;
				}
			}
		}
		return null;
	}

	public static SceneTexture getMaterialSceneTexture (Material material) {
		SceneTexture texture= materialSceneTextureHashMap.get(material);
		if(texture!=null) {
			return texture;
		}
		if (material != null && material.getImage() != null&& !material.getImage().isEmpty()) {
			String	path =material.getImage();
			if(!path.contains(WorkspaceConfiguration.TEXTURES_FOLDER))
				path = WorkspaceConfiguration.TEXTURES_FOLDER + File.separator + material.getImage();
			
			if (path != null && !path.isEmpty()) {
				try {
					SceneTexture sceneTexture  = ModelProvider.getTexture(path);
					if(sceneTexture != null)
						materialSceneTextureHashMap.put(material, sceneTexture);
						return sceneTexture;
					
				} catch (Exception e) {
					System.err.println("failed to get image label " + path);
					e.printStackTrace();
					return null;
				}
			}
		}
		return texture;
	}
}
