/*
 * Decompiled with CFR 0.152.
 */
package org.frs.supercad.tools.internal.modelinfo;

import api.backend.ApplicationContext;
import api.backend.SWTGLApplication;
import api.graphics.IDrawable;
import api.graphics.Model;
import api.graphics.ModelInstance;
import api.graphics.Scene;
import dressing.config.WorkspaceConfiguration;
import dressing.io.IOUtilities;
import dressing.model.persistence.mappers.MapperProvider;
import gdxapp.object3d.ModelInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import javax.inject.Inject;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.opengl.GLCanvas;
import org.eclipse.swt.opengl.GLData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.opengl.GL;

@Creatable
public class ModelInfoExporter {
    private final String PATH_TO_LP_KEY = "path_to_LP";
    private final String PATH_TO_HP_KEY = "path_to_HP";
    private final String PATH_TO_FRONT_IMG_KEY = "front-texture";
    private final String PATH_TO_TOP_IMG_KEY = "top-texture";
    private String modelPath;
    private UUID uuid;
    private String name;
    private Vector3f originalScale = new Vector3f();
    private float scale = 1.0f;
    private Vector3f size = new Vector3f();
    private Vector3f center = new Vector3f();
    private String pathToFront;
    private String pathToTop;
    private String pathToLowPoly;
    private boolean isConstraint;
    private boolean isExtrusionMaker;
    private boolean isDoor;
    private float altitude;
    private Text txtName;
    private Text txtID;
    private Text txtLP;
    private Text txtFrontImg;
    private Text txtTopImg;
    private Scene scene;
    private Spinner spnWidth;
    private Spinner spnHeight;
    private Spinner spnDepth;
    private Spinner spnX;
    private Spinner spnY;
    private Spinner spnZ;
    private GLCanvas canvas;
    @Inject
    private EHandlerService handlerService;
    @Inject
    private ECommandService commandService;
    private Spinner spnElevation;
    private ModelInstance instance;

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout gl_container = new GridLayout();
        gl_container.numColumns = 2;
        container.setLayout((Layout)gl_container);
        Composite canvasContainer = new Composite(container, 0);
        canvasContainer.setLayout((Layout)new GridLayout(1, false));
        canvasContainer.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        canvasContainer.setBackground(new Color(255, 0, 0));
        this.createCanvas(canvasContainer);
        Composite composite = new Composite(container, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 128, true, true, 1, 1));
        Label lblName = new Label(composite, 0);
        lblName.setBounds(0, 0, 70, 20);
        lblName.setText("Name: ");
        this.txtName = new Text(composite, 2048);
        this.txtName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblUuid = new Label(composite, 0);
        lblUuid.setText("UUID");
        Composite composite_2 = new Composite(composite, 0);
        composite_2.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        composite_2.setLayout((Layout)new GridLayout(2, false));
        this.txtID = new Text(composite_2, 2048);
        this.txtID.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button btnGenerate = new Button(composite_2, 0);
        btnGenerate.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ModelInfoExporter.this.uuid = UUID.randomUUID();
                ModelInfoExporter.this.txtID.setText(ModelInfoExporter.this.uuid.toString());
            }
        });
        btnGenerate.setText("generate");
        Label lblPathToLp = new Label(composite, 0);
        lblPathToLp.setText("path to LP:");
        Composite composite_2_1 = new Composite(composite, 0);
        composite_2_1.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        composite_2_1.setLayout((Layout)new GridLayout(2, false));
        this.txtLP = new Text(composite_2_1, 2048);
        GridData gd_txtLP = new GridData(4, 128, true, false, 1, 1);
        gd_txtLP.minimumWidth = 400;
        this.txtLP.setLayoutData((Object)gd_txtLP);
        Button btnGenerate_1 = new Button(composite_2_1, 0);
        btnGenerate_1.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ModelInfoExporter.this.openFileDialog(ModelInfoExporter.this.txtLP);
            }
        });
        btnGenerate_1.setText("...");
        Label lblFrontImg = new Label(composite, 0);
        lblFrontImg.setText("front img:");
        Composite composite_2_1_1 = new Composite(composite, 0);
        composite_2_1_1.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        composite_2_1_1.setLayout((Layout)new GridLayout(2, false));
        this.txtFrontImg = new Text(composite_2_1_1, 2048);
        this.txtFrontImg.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button btnGenerate_1_1 = new Button(composite_2_1_1, 0);
        btnGenerate_1_1.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ModelInfoExporter.this.openFileDialog(ModelInfoExporter.this.txtFrontImg);
            }
        });
        btnGenerate_1_1.setText("...");
        Label lblTopImg = new Label(composite, 0);
        lblTopImg.setText("top img");
        Composite composite_2_1_2 = new Composite(composite, 0);
        composite_2_1_2.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        composite_2_1_2.setLayout((Layout)new GridLayout(2, false));
        this.txtTopImg = new Text(composite_2_1_2, 2048);
        this.txtTopImg.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button btnGenerate_1_2 = new Button(composite_2_1_2, 0);
        btnGenerate_1_2.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ModelInfoExporter.this.openFileDialog(ModelInfoExporter.this.txtTopImg);
            }
        });
        btnGenerate_1_2.setText("...");
        Label lblSize = new Label(composite, 0);
        lblSize.setText("size: ");
        Composite composite_3 = new Composite(composite, 0);
        composite_3.setLayout((Layout)new GridLayout(5, false));
        this.spnWidth = new Spinner(composite_3, 2048);
        this.spnWidth.setEnabled(false);
        this.spnWidth.setMaximum(1000000);
        this.spnWidth.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ModelInfoExporter.this.size.x = ModelInfoExporter.this.spnWidth.getSelection();
            }
        });
        this.spnWidth.setBounds(0, 0, 59, 26);
        this.spnHeight = new Spinner(composite_3, 2048);
        this.spnHeight.setEnabled(false);
        this.spnHeight.setMaximum(1000000);
        this.spnHeight.setBounds(0, 0, 59, 26);
        this.spnHeight.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ModelInfoExporter.this.size.y = ModelInfoExporter.this.spnHeight.getSelection();
            }
        });
        this.spnDepth = new Spinner(composite_3, 2048);
        this.spnDepth.setEnabled(false);
        this.spnDepth.setMaximum(1000000);
        this.spnDepth.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ModelInfoExporter.this.size.z = ModelInfoExporter.this.spnDepth.getSelection();
            }
        });
        Label lblScale = new Label(composite_3, 0);
        lblScale.setText("scale:");
        final Spinner spnScale = new Spinner(composite_3, 2048);
        spnScale.setIncrement(10);
        spnScale.setPageIncrement(100);
        spnScale.setMaximum(1000000);
        spnScale.setMinimum(1);
        spnScale.setDigits(3);
        spnScale.setSelection(1000);
        spnScale.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ModelInfoExporter.this.scale = (float)((double)spnScale.getSelection() * Math.pow(10.0, -spnScale.getDigits()));
                ModelInfoExporter.this.scaleChanged();
            }
        });
        Label lblCenter = new Label(composite, 0);
        lblCenter.setText("center: ");
        Composite composite_3_1 = new Composite(composite, 0);
        composite_3_1.setLayout((Layout)new GridLayout(3, false));
        this.spnX = new Spinner(composite_3_1, 2048);
        this.spnX.setMaximum(1000000);
        this.spnX.setEnabled(false);
        this.spnY = new Spinner(composite_3_1, 2048);
        this.spnY.setMaximum(1000000);
        this.spnY.setEnabled(false);
        this.spnZ = new Spinner(composite_3_1, 2048);
        this.spnZ.setMaximum(1000000);
        this.spnZ.setEnabled(false);
        Label lblElevation = new Label(composite, 0);
        lblElevation.setText("Elevation: ");
        this.spnElevation = new Spinner(composite, 2048);
        this.spnElevation.setMaximum(9999);
        this.spnElevation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ModelInfoExporter.this.altitude = (float)ModelInfoExporter.this.spnElevation.getSelection() / 1000.0f;
            }
        });
        final Button btnCheckButton = new Button(composite, 32);
        btnCheckButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        btnCheckButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelInfoExporter.this.isConstraint = btnCheckButton.getSelection();
            }
        });
        btnCheckButton.setText("is Constraint");
        final Button btnCheckButton_1 = new Button(composite, 32);
        btnCheckButton_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelInfoExporter.this.isExtrusionMaker = btnCheckButton_1.getSelection();
            }
        });
        btnCheckButton_1.setText("is Extrusion Maker");
        new Label(composite, 0);
        final Button btnDoor = new Button(composite, 32);
        btnDoor.setText("door");
        btnDoor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelInfoExporter.this.isDoor = btnDoor.getSelection();
            }
        });
        new Label(composite, 0);
        Composite composite_4 = new Composite(composite, 0);
        composite_4.setLayout((Layout)new GridLayout(1, false));
        composite_4.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        Button btnNewButton = new Button(composite_4, 0);
        btnNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelInfoExporter.this.export();
            }
        });
        btnNewButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false, 1, 1));
        btnNewButton.setText("export");
    }

    protected void scaleChanged() {
        this.size.set((Vector3fc)new Vector3f((Vector3fc)this.originalScale).mul(this.scale));
        this.spnWidth.setSelection((int)this.size.x);
        this.spnHeight.setSelection((int)this.size.y);
        this.spnDepth.setSelection((int)this.size.z);
        this.instance.setTransform(new Matrix4f().scale(this.scale));
    }

    protected void openFileDialog(Text out) {
        String path;
        FileDialog fileDialog = new FileDialog(new Shell(), 0);
        if (this.modelPath != null) {
            File modelDir = new File(this.modelPath).getParentFile();
            fileDialog.setFilterPath(modelDir.getAbsolutePath());
        }
        if ((path = fileDialog.open()) != null) {
            out.setText(path);
        }
    }

    private void createCanvas(Composite parent) {
        GLData data = new GLData();
        data.doubleBuffer = true;
        this.canvas = new GLCanvas(parent, 2048, data);
        GridData gd_canvas = new GridData(0x1000000, 0x1000000, true, true, 1, 1);
        gd_canvas.widthHint = 300;
        gd_canvas.heightHint = 300;
        this.canvas.setLayoutData((Object)gd_canvas);
        this.canvas.setCurrent();
        GL.createCapabilities();
        ApplicationContext.setCanvas((GLCanvas)this.canvas);
        DropTarget dropTarget = new DropTarget((Control)this.canvas, 19);
        dropTarget.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                String[] paths = (String[])event.data;
                ModelInfoExporter.this.modelPath = paths[0];
                ModelInfoExporter.this.modelPathChanged();
            }
        });
    }

    private void modelPathChanged() {
        Model model = new Model(this.modelPath);
        model.load();
        this.instance = new ModelInstance(model);
        this.scale = 1.0f;
        this.scene.reset();
        this.scene.addDrawable((IDrawable)this.instance);
        this.originalScale.set((Vector3fc)this.instance.getSize().mul(1000.0f));
        this.size.set((Vector3fc)new Vector3f((Vector3fc)this.originalScale).mul(this.scale));
        float scale = 1000.0f / this.size.x;
        this.instance.getTransform().scale(scale);
        this.center = this.instance.getCenter().mul(1000.0f);
        this.scene.getCamera().lookAt(this.center);
        this.updateSizeUI();
        this.updateCenterUI();
        this.name = new File(this.modelPath).getName().split("\\.")[0];
        this.txtName.setText(this.name);
    }

    private void updateSizeUI() {
        this.spnWidth.setSelection(Math.round(this.size.x));
        this.spnHeight.setSelection(Math.round(this.size.y));
        this.spnDepth.setSelection(Math.round(this.size.z));
    }

    private void updateCenterUI() {
        this.spnX.setSelection(Math.round(this.center.x));
        this.spnY.setSelection(Math.round(this.center.y));
        this.spnZ.setSelection(Math.round(this.center.z));
    }

    public void export() {
        if (!this.verify()) {
            MessageBox messageBox = new MessageBox(new Shell(), 33);
            messageBox.setText("error");
            messageBox.setMessage("missing info");
            messageBox.open();
        } else {
            File folder = new File(WorkspaceConfiguration.getModelsDir() + File.separator + this.name + this.uuid.toString());
            Properties props = new Properties();
            props.put("category", "Model3D");
            props.put("class", "Cuisine");
            props.put("constraint", (Object)this.isConstraint);
            props.put("is_extrusin_maker", (Object)this.isExtrusionMaker);
            if (this.isDoor) {
                props.put("role", "door");
            }
            try {
                this.copyFiles(folder, props);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ModelInfo info = new ModelInfo();
            info.setName(this.name);
            info.setUuid(this.uuid);
            info.setWidth(this.size.x);
            info.setHeight(this.size.y);
            info.setDepth(this.size.z);
            info.setElevation(this.altitude);
            info.setProperties(props);
            String path = String.valueOf(folder) + File.separator + "info.xml";
            File file = new File(path);
            try {
                file.createNewFile();
                MapperProvider.getXmlMapper().write((Object)info, file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            String feedBack = "";
            if (this.convertObj(folder, info.getProperties().getProperty("path_to_LP"))) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("dressing.commandparameter.asset_path", folder.getAbsolutePath());
                ParameterizedCommand cmd = this.commandService.createCommand("dressing.command.assetmodeladded", map);
                this.handlerService.executeHandler(cmd);
                feedBack = "objet export\u00e9 et converti avec succ\u00e9e!";
            } else {
                IOUtilities.deleteFolder((File)folder);
                feedBack = "l' export \u00e0 \u00e9chou\u00e9!";
            }
            MessageBox messageBox = new MessageBox(new Shell(), 34);
            messageBox.setText("export termin\u00e9e");
            messageBox.setMessage(feedBack);
            messageBox.open();
        }
    }

    public boolean convertObj(File folder, String fileName) {
        Path modelPath = Paths.get(fileName, new String[0]).normalize();
        Path folderPath = Paths.get(folder.getAbsolutePath(), new String[0]).normalize();
        Path path = folderPath.relativize(modelPath);
        String executable = "fbx-conv.exe";
        String option = "-v -o g3dj";
        ProcessBuilder processBuilder = new ProcessBuilder("cmd.exe", "/c", executable + " " + option + " \"" + path.toString() + "\" model.g3dj");
        processBuilder.directory(folder);
        processBuilder.redirectErrorStream(true);
        try {
            String line;
            Process process = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
            }
            int exitCode = process.waitFor();
            System.out.println("Process exited with code: " + exitCode);
            if (exitCode != 0) {
                throw new Exception("issue with conversion");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private boolean verify() {
        this.name = this.txtName.getText();
        this.size.mul(0.001f);
        this.pathToLowPoly = this.txtLP.getText();
        this.pathToFront = this.txtFrontImg.getText();
        this.pathToTop = this.txtTopImg.getText();
        if (this.name == null || this.name.length() < 1 || this.uuid == null) {
            return false;
        }
        if (this.size.length() < 0.001f) {
            return false;
        }
        File file = new File(this.pathToLowPoly);
        if (!file.exists()) {
            return false;
        }
        file = new File(this.pathToFront);
        if (!file.exists()) {
            return false;
        }
        file = new File(this.pathToTop);
        return file.exists();
    }

    private void copyFiles(File folder, Properties properties) throws IOException {
        folder.mkdir();
        File src = new File(this.pathToFront);
        File dest = new File(folder, src.getName());
        dest.createNewFile();
        IOUtilities.copyFileUsingChannel((File)src, (File)dest);
        properties.put("front-texture", dest.getAbsolutePath());
        src = new File(this.pathToTop);
        dest = new File(folder, src.getName());
        dest.createNewFile();
        IOUtilities.copyFileUsingChannel((File)src, (File)dest);
        properties.put("top-texture", dest.getAbsolutePath());
        src = new File(this.pathToLowPoly);
        dest = new File(folder, src.getName());
        ArrayList files = IOUtilities.listFilesRec((File)src.getParentFile());
        for (File fileX : files) {
            String relPath = IOUtilities.getPathRelativeToParent((String)src.getParentFile().getAbsolutePath(), (String)fileX.getAbsolutePath());
            File destX = new File(folder, relPath);
            destX.getParentFile().mkdirs();
            destX.createNewFile();
            IOUtilities.copyFileUsingChannel((File)fileX, (File)destX);
        }
        properties.put("path_to_LP", dest.getAbsolutePath());
        src = new File(this.modelPath);
        dest = new File(folder, src.getName());
        List<File> files2 = IOUtilities.listFilesRec((File)src.getParentFile()).stream().filter(f -> !files.contains(f)).toList();
        for (File fileX : files2) {
            String relPath = IOUtilities.getPathRelativeToParent((String)src.getParentFile().getAbsolutePath(), (String)fileX.getAbsolutePath());
            File destX = new File(folder, relPath);
            destX.getParentFile().mkdirs();
            destX.createNewFile();
            IOUtilities.copyFileUsingChannel((File)fileX, (File)destX);
        }
        properties.put("path_to_HP", dest.getAbsolutePath());
    }

    public void run() {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setText("model info exporter");
        shell.setLayout((Layout)new FillLayout());
        Composite parent = new Composite((Composite)shell, 0);
        parent.setLayout((Layout)new FillLayout());
        this.createControl(parent);
        this.scene = new Scene();
        this.scene.init();
        SWTGLApplication app = new SWTGLApplication(this.canvas, this.scene);
        ApplicationContext.setApplication((SWTGLApplication)app);
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            display.readAndDispatch();
        }
    }
}

