package dressing.ui.util;

import org.eclipse.swt.widgets.Shell;
import com.badlogic.gdx.math.Vector3;

import dressing.mathutils.Edge;
import dressing.mathutils.Surface;
import dressing.mathutils.Vector4;
import dressing.model.DesignObject3D;
import dressing.model.Space3DFree;
import dressing.ui.ChangeCommand;
import dressing.ui.ChangeCommandController;
import dressing.ui.CommandStack;
import dressing.ui.MoveCommand;
import dressing.ui.RotateCommand;
import dressing.ui.ScaleCommand;
import dressing.ui.parts.GdxPart;
import gdxapp.Commun.AbstractScreen;
import gdxapp.Commun.Measure;
import gdxapp.object3d.Object2D;
import gdxapp.object3d.WorldObject;
import gdxapp.object3d.WorldObject.ObjectType;
import gdxapp.scenes.Scene;
import gdxapp.screens.room.RoomController;
import gdxapp.screens.wall.SurfaceController;
import gdxapp.ui.Note;
import param.MechanicDesign;
import param.MechanicPublicParam;

import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.swt.graphics.Rectangle;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.jface.action.Action;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.wb.swt.SWTResourceManager;
import org.eclipse.swt.widgets.Text;

public class NoteEditorWidow extends org.eclipse.jface.window.Window{

	public NoteEditorWidow(Shell parentShell) {
		super(parentShell);
		setShellStyle(SWT.SHELL_TRIM| SWT.APPLICATION_MODAL);
		setBlockOnOpen(true);
	}
	String[] values =  {"8","9","10","11","12","14","16","18","20","22","24","26","28","36","48","72"};

	public Shell shell;
	public Action runAction;
	public Note note;
	Color color;
	Listener controlListener=new Listener() {
		
		@Override
		public void handleEvent(Event event) {
			CommandStack command=updateObject();
			
		}
	};
	Listener KeyUpListener= new Listener() {
		
		@Override
		public void handleEvent(Event event) {
			if(event.keyCode==SWT.CR) {
				CommandStack command=updateObject();
				if(command!=null)
				{
					if(((AbstractScreen) Scene.game.getScreen()).getController().getChangeCommandController()!=null)
					{
						((AbstractScreen) Scene.game.getScreen()).getController().getChangeCommandController().addCommand(command);
					}

				}
			}
			
		}
	};
	private static NoteEditorWidow instance;

	private ComboViewer sizecomboViewer;
	private Text text;

	private Label colorLabel;

	public static NoteEditorWidow getInstance() {
	 		synchronized(NoteEditorWidow.class) {
	 			if (instance == null) {
	 				instance = new NoteEditorWidow(GdxPart.parentShell);
	 				instance.create();
	 				instance.constrainShellSize();
	 			}
	 			return instance;
	 		}
	 }
	/**
	 * Launch the application.
	 * @param args
	 */
	public static void main(String[] args) {
		try {
			Shell shell=new Shell();

			NoteEditorWidow window = new NoteEditorWidow(shell);
			window.open();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public Action getRunAction() {
		return runAction;
	}

	public void setRunAction(Action runAction) {
		this.runAction = runAction;
	}

	

	@Override
	protected boolean canHandleShellCloseEvent() {
		return true;
	}
	@Override
	protected void handleShellCloseEvent() {
		setReturnCode(CANCEL);
		hide();
	}
	

	/**  
	 * Create contents of the window.
	 * @return 
	 */
	protected Control createContents(Composite parent) {
		parent.setTouchEnabled(true);
		this.shell=parent.getShell();
		parent.getShell().setText("Mesure");
		shell.addShellListener(getShellListener());

		Composite composite = new Composite(parent, SWT.FILL);
		composite.setTouchEnabled(true);
		composite.setLayout(new GridLayout(1, false));
		
		Composite composite_1 = new Composite(composite, SWT.FILL);
		GridData gd_composite_1 = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1);
		gd_composite_1.widthHint = 266;
		gd_composite_1.heightHint = 192;
		composite_1.setLayoutData(gd_composite_1);
		composite_1.setLayout(new GridLayout(3, false));
		
		Label lblLongeur = new Label(composite_1, SWT.NONE);
		lblLongeur.setText("Taille");
		
		sizecomboViewer = new ComboViewer(composite_1, SWT.NONE);
		Combo combo = sizecomboViewer.getCombo();
		combo.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
		sizecomboViewer.setContentProvider(ArrayContentProvider.getInstance());
		sizecomboViewer.setLabelProvider(new LabelProvider());
		sizecomboViewer.setInput(values);
		
		Label lblCoulour = new Label(composite_1, SWT.NONE);
		lblCoulour.setText("Coulour");
		color = new Color(shell.getDisplay(), new RGB(0, 255, 0));

		colorLabel = new Label(composite_1, SWT.NONE);
		colorLabel.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		colorLabel.setText("                                                              ");
		colorLabel.setBackground(SWTResourceManager.getColor(SWT.COLOR_WIDGET_FOREGROUND));
		
		Button btncolorChooser = new Button(composite_1, SWT.NONE);
		btncolorChooser.setText("...");
		btncolorChooser.addSelectionListener(new SelectionAdapter() {
			    public void widgetSelected(SelectionEvent event) {
			      // Create the color-change dialog
			      ColorDialog dlg = new ColorDialog(shell);

			      // Set the selected color in the dialog from
			      // user's selected color
			      dlg.setRGB(colorLabel.getBackground().getRGB());

			      // Change the title bar text
			      dlg.setText("Choose a Color");

			      // Open the dialog and retrieve the selected color
			      RGB rgb = dlg.open();
			      if (rgb != null) {
			        // Dispose the old color, create the
			        // new one, and set into the label
			        color.dispose();
			        color = new Color(shell.getDisplay(), rgb);
			        colorLabel.setBackground(color);
				    text.setForeground(color);

			      }
			    }
			  });
		Label lblText = new Label(composite_1, SWT.NONE);
		lblText.setLayoutData(new GridData(SWT.LEFT, SWT.FILL, false, false, 1, 1));
		lblText.setText("Text");
		
		text = new Text(composite_1, SWT.BORDER | SWT.WRAP | SWT.V_SCROLL | SWT.MULTI);
		text.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1));
		sizecomboViewer.setContentProvider(ArrayContentProvider.getInstance());
		sizecomboViewer.setLabelProvider(new LabelProvider());
		Composite composite_2 = new Composite(composite, SWT.NONE);
		GridData gd_composite_2 = new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1);
		gd_composite_2.heightHint = 39;
		composite_2.setLayoutData(gd_composite_2);
		GridLayout gl_composite_2 = new GridLayout(2, false);
		gl_composite_2.horizontalSpacing = 0;
		composite_2.setLayout(gl_composite_2);
		
		Button btnRun = new Button(composite_2, SWT.NONE);
		btnRun.setImage(ResourceManager.getPluginImage("Dressing", "icons/Calculer.png"));
		GridData gd_btnRun = new GridData(SWT.FILL, SWT.BOTTOM, true, true, 1, 1);
		gd_btnRun.heightHint = 31;
		btnRun.setLayoutData(gd_btnRun);
		if(runAction !=null) {
			btnRun.setText(runAction.getText());
		}else {
			btnRun.setText("Terminer");
		}
		Button btnFermer = new Button(composite_2, SWT.NONE);
		GridData gd_btnFermer = new GridData(SWT.FILL, SWT.BOTTOM, true, true, 1, 1);
		gd_btnFermer.heightHint = 31;
		btnFermer.setLayoutData(gd_btnFermer);
		btnFermer.setText("Fermer");
		composite.setTabList(new Control[]{composite_1, composite_2});
		
		btnFermer.addSelectionListener(new SelectionAdapter() {
		
					@Override
					public void widgetSelected(SelectionEvent e) {
						// TODO Auto-generated method stub
						NoteEditorWidow.this.hide();
					}
					
				});
		btnRun.addSelectionListener(new SelectionAdapter() {

					@Override
					public void widgetSelected(SelectionEvent e) {
						note.setColor(new com.badlogic.gdx.graphics.Color(color.getRed()/255.0f, color.getGreen()/255.0f, color.getBlue()/255.0f, color.getAlpha()/255.0f));
						note.setContent(text.getText());
						IStructuredSelection selection =sizecomboViewer.getStructuredSelection();
						if(selection!=null&& !selection.isEmpty()) {
							String val=(String) selection.getFirstElement();
							note.setSize(Float.valueOf(val)/32f);
							
						}
						note.calculateSize();
						hide();
					}
					
				});
	
		ControlAdapter adaptor=new ControlAdapter() {

			@Override
			public void controlResized(ControlEvent e) {
				 Rectangle area2= NoteEditorWidow.this.getShell().getClientArea();
			     composite.setBounds(area2);
			}
			
		};
		parent.addControlListener(adaptor);
		composite.addControlListener(adaptor);
		getShell().addControlListener(adaptor);		
				
		return composite;

	}
	
	public Note getNote() {
		return note;
		
	}
	public void setNote(Note note) {
		this.note = note;
		if(note!=null) {
			text.setText(note.getContent());
			int size=(int) (note.getSize()*32f);
			color.dispose();
		    color = new Color(shell.getDisplay(), new RGBA((int)(note.getColor().r*255), (int)(note.getColor().g*255), (int)(note.getColor().b*255), (int)(note.getColor().a*255)));
		    text.setForeground(color);
		    colorLabel.setBackground(color);
			sizecomboViewer.setSelection(new StructuredSelection(String.valueOf(size)));
		}
	}
	
	public synchronized void  show() {
		if(!shell.isDisposed())
		{
			NoteEditorWidow.this.shell.setVisible(true);
			NoteEditorWidow.this.shell.setActive();

		}

	}
	public synchronized void hide() {
		if(!shell.isDisposed())
		{
			
			NoteEditorWidow.this.shell.setVisible(false);
		}

	}
	public CommandStack updateObject(){
		
		return null;
	}
	public void createController() {
		
	}
	
	
}
