package dressing.ui.caisson;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;

import dressing.config.persistence.ResourceManagers;
import dressing.model.DesignObject3D;
import dressing.model.ModelProvider;
import dressing.model.Piece2D;
import dressing.ui.components.TableComboViewerSearch;
import dressing.ui.emf.MechanicdesignLibrary.ModelEMFLabelProvider;
import dressing.ui.engine3d.SceneTexture;
import dressing.ui.engine3d.SceneTexture.CATEGORY;
import dressing.ui.util.SingleImageItemLabelProvider;
import dressing.ui.util.TypeDefContentProvider;
import dressing.ui.util.TypeDefElementLabelProvider;
import gdxapp.object3d.DoorHandle;
import gdxapp.shaders.PbrMaterial;
import param.MechanicDesignElment;
import param.MechanicPublicParam;
import param.TypeDef;
import param.impl.MaterialTypeImpl;
import param.impl.TypeDefElementImpl;

import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.nebula.widgets.tablecombo.TableCombo;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.jface.tablecomboviewer.TableComboViewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Group;

public class FacadeConfigComposite extends Composite {
	
	private Piece2D facade;
	private DoorHandle handle;
	private PbrMaterial finish;
	private SceneTexture albedoMap;
	//ui attributes
	
	//handle properties
	private FacadeHandleConfigurer handleConfigurer;
	private ComboViewer typeCombo;
	private TableComboViewerSearch albedoMapTCV;
	private ComboViewer finishTCV;
	
	private TypeDefElementImpl type;
	private MaterialTypeImpl mtlType;
	private boolean changed;
	

	public FacadeConfigComposite(Composite parent, Piece2D piece, DoorHandle doorHandle) {
		super(parent, SWT.NONE);
		this.facade = piece;
		this.handle = doorHandle;
		createControl();
	}

	private void createControl() {
		setLayout(new GridLayout(1, false));
		Composite mainContainer = new Composite(this, SWT.NONE);
		mainContainer.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		mainContainer.setLayout(new GridLayout(2, false));
		
		Label lblType = new Label(mainContainer, SWT.NONE);
		lblType.setText("Type");
		
		typeCombo = new ComboViewer(mainContainer, SWT.READ_ONLY);
		Combo combo_PorteType = typeCombo.getCombo();

		combo_PorteType.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		typeCombo.setContentProvider(TypeDefContentProvider.getInstance());
		typeCombo.setLabelProvider(TypeDefElementLabelProvider.getInstance());
		typeCombo.setInput(ModelProvider.getTypeDef("FACADE_TYPE"));
		typeCombo.addSelectionChangedListener(new ISelectionChangedListener() {
			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				type = (TypeDefElementImpl) event.getStructuredSelection().getFirstElement();	
			}
		});
		
		
		
		Label lblTexture = new Label(mainContainer, SWT.NONE);
		lblTexture.setText("Texture");
		
		SingleImageItemLabelProvider labelProvider = SingleImageItemLabelProvider.getInstance();
		
		albedoMapTCV = new TableComboViewerSearch(mainContainer, SWT.READ_ONLY);
		TableCombo albedoMapCV = albedoMapTCV.getTableCombo();
		albedoMapCV.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		albedoMapCV.setEditable(true);
		albedoMapCV.defineColumns(new String[] { "texture" });
		albedoMapTCV.setLabelProvider(labelProvider);
		albedoMapTCV.setContentProvider(ArrayContentProvider.getInstance());
		albedoMapTCV.setInput(ModelProvider.getTextures(CATEGORY.ELEMENT));
		albedoMapTCV.addSelectionChangedListener(new ISelectionChangedListener() {
			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				albedoMap = (SceneTexture) event.getStructuredSelection().getFirstElement();
			}
		});

		
		Label lblFinition = new Label(mainContainer, SWT.NONE);
		lblFinition.setText("Finition");
		
		finishTCV = new ComboViewer(mainContainer, SWT.READ_ONLY);
		Combo finishCV = finishTCV.getCombo();
		finishCV.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		finishTCV.setLabelProvider(ModelEMFLabelProvider.getInstance());
		finishTCV.setContentProvider(ArrayContentProvider.getInstance());
		finishTCV.setInput(ResourceManagers.getIntance().getMaterialTypesGroup().getMaterialTypes());
		finishTCV.addSelectionChangedListener(new ISelectionChangedListener() {
			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				mtlType = (MaterialTypeImpl) event.getStructuredSelection().getFirstElement();
			}
		});
		
		
		Composite handleConfigurerContainer = new Composite(mainContainer, SWT.NONE);
		handleConfigurerContainer.setLayout(new FillLayout(SWT.HORIZONTAL));
		handleConfigurerContainer.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
		if(handle != null) {
		Group grpPoigne = new Group(handleConfigurerContainer, SWT.NONE);
		grpPoigne.setText("Poignée");
		grpPoigne.setLayout(new FillLayout(SWT.HORIZONTAL));
			handleConfigurer = new FacadeHandleConfigurer(grpPoigne, handle);
		}
		bind();		
	}

	private void bind() {
		String mtlName = facade.getMaterialType().getMaterial().getName();
		if(mtlName != null) {
			var mtlType = ModelProvider.getMaterialTypeByName(mtlName);
			finishTCV.setSelection(new StructuredSelection(mtlType));
		}
		var albedoMap = facade.getMaterialType().getTexture();
		var texture = ModelProvider.getTexture(albedoMap);
		this.albedoMapTCV.setSelection(new StructuredSelection(texture));
		try {
			MechanicDesignElment element = facade.getMechanicDesignElementDefinition();
			var facadeType = element.getFacadeType();
			if(facadeType == null)
			{
				MechanicPublicParam paramFacade = facade.getMechanicDesignDefinition().getPublicParam("FACADE_TYPE");
				if(paramFacade!=null)
				{
					facadeType = paramFacade.getTypedefelement();
				}
			}
			if(facadeType == null)
			{
				facadeType = ModelProvider.getTypeDef("FACADE_TYPE").getElement("SIMPLE");
			}
			if(facadeType == null)
			{
				TypeDef type=ModelProvider.getTypeDef("FACADE_TYPE");
				facadeType = type.getTypedefelement().get(type.getTypedefelement().size()-1);
			}
			
			typeCombo.setSelection(new StructuredSelection(facadeType));
		} catch (Exception e) {
			e.printStackTrace();
		}		
	}
	
	public void update() {
		boolean changed = false;
		if(!mtlType.equals(facade.getMaterialType().getMaterial())){
			facade.getMaterialType().setMaterial(mtlType);
			changed = true;
		}
		if(!facade.getMaterialType().getTexture().equals(albedoMap.getPath())) {
			facade.getMaterialType().setTexture(albedoMap.getPath());
			changed = true;
		}
		var facadeType = facade.getMechanicDesignElementDefinition().getFacadeType();
		if(facadeType == null || !facade.getMechanicDesignElementDefinition().getFacadeType().equals(type)) {
			facade.getMechanicDesignElementDefinition().setFacadeType(type);
			facade.getMechanicDesignElementDefinition().setFacadeTypeFree(true);
		}
		if(changed)
			facade.getMechanicDesignElementDefinition().setMaterialTypeFree(true);
		if(handle != null) {
			handleConfigurer.updateDoorHandle();
		}
	}

}
