/*
 * Decompiled with CFR 0.152.
 */
package api.ui;

import api.graphics.Camera;
import api.ui.CameraController;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.joml.Vector2f;
import org.joml.Vector2i;
import org.joml.Vector2ic;

public class FlyCameraController
implements CameraController {
    Vector2i lastMousePosition = new Vector2i();
    Vector2i lastClickPosition = new Vector2i();
    boolean mouseIsDown;
    private Camera camera;
    private boolean cameraFrozen;

    public FlyCameraController(Camera camera) {
        this.camera = camera;
    }

    @Override
    public boolean mouseDoubleClick(MouseEvent e) {
        return false;
    }

    @Override
    public boolean mouseDown(MouseEvent e) {
        this.mouseIsDown = true;
        this.lastClickPosition = new Vector2i(e.x, e.y);
        return false;
    }

    @Override
    public boolean mouseUp(MouseEvent e) {
        this.mouseIsDown = false;
        System.err.println("mouse up from fly camera");
        return false;
    }

    @Override
    public boolean mouseMove(MouseEvent e) {
        if (this.mouseIsDown) {
            Vector2i currentMouseLocation = new Vector2i(e.x, e.y);
            Vector2f delta = new Vector2f((Vector2ic)currentMouseLocation).sub((float)this.lastClickPosition.x, (float)this.lastClickPosition.y);
            delta.mul(this.camera.getMouseSensitivity(), -this.camera.getMouseSensitivity());
            System.out.println(delta);
            float yaw = this.camera.getYaw() + delta.x;
            float pitch = this.camera.getPitch() + delta.y;
            this.camera.setYaw(yaw);
            this.camera.setPitch(pitch);
            this.camera.updateCameraVectors();
            this.lastClickPosition.set((Vector2ic)currentMouseLocation);
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseScrolled(MouseEvent e) {
        int amount = -e.count;
        float fov = this.camera.getZoom() + (float)amount * 0.5f;
        this.camera.setZoom(fov);
        return true;
    }

    @Override
    public boolean keyPressed(KeyEvent e) {
        Camera.Camera_Movement direction;
        int cfr_ignored_0 = e.keyCode;
        char character = e.character;
        switch (character) {
            case 'z': {
                direction = Camera.Camera_Movement.FORWARD;
                break;
            }
            case 's': {
                direction = Camera.Camera_Movement.BACKWARD;
                break;
            }
            case 'q': {
                direction = Camera.Camera_Movement.LEFT;
                break;
            }
            case 'd': {
                direction = Camera.Camera_Movement.RIGHT;
                break;
            }
            default: {
                return false;
            }
        }
        float delta = 0.083333336f;
        this.camera.move(direction, delta);
        return false;
    }

    @Override
    public boolean keyReleased(KeyEvent e) {
        return false;
    }

    @Override
    public boolean mouseDragged(MouseEvent e) {
        return false;
    }

    @Override
    public void freezeCamera(boolean freeze) {
        this.cameraFrozen = freeze;
    }
}

