package dressing.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import dressing.model.persistence.mappers.MapperProvider;
import gdxapp.scenes.ScenePreferences;

public class UserPreference {
	
	private Properties properties;
	private ScenePreferences scenePreferences;
	private int maxProjectBackUps = 10;
	private transient boolean loaded = false;

	private static UserPreference preference = new UserPreference();
	
	public UserPreference() {}
	
	
	public void save() {
		Runnable task = () -> {
			File f = new File(WorkspaceConfiguration.SETTING_PATH);
			if(!f.exists()) {
				f.getParentFile().mkdirs();
				try {
					f.createNewFile();
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
					System.err.println("could not create user preference file");
					return;
				}
			}
			if (f.exists()) {
				MapperProvider.getXmlMapper().write(this, f);
			}
		};
		Thread thread = new Thread(task);
		thread.start();
	}
	
	public void load() {
		properties = new Properties();
		File f = new File(WorkspaceConfiguration.SETTING_PATH);
		FileInputStream inputstream = null;
		if (f.exists()) {
			try {
				inputstream = new FileInputStream(f);
				preference = MapperProvider.getXmlMapper().fromXml(inputstream, UserPreference.class );
				inputstream.close();
				loaded = true;
			} catch (IOException e) {
				e.printStackTrace();
				if(preference == null)
					preference = new UserPreference();
			} finally {
				try {
					if (inputstream != null)
						inputstream.close();
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		}
	}
	
	

	public static UserPreference getPreference() {
		return preference;
	}

	public static void setPreference(UserPreference preference) {
		UserPreference.preference = preference;
	}

	public Properties getProperties() {
		return properties;
	}

	public void setProperties(Properties properties) {
		this.properties = properties;
	}

	public boolean isLoaded() {
		return loaded;
	}

	public void setLoaded(boolean loaded) {
		this.loaded = loaded;
	}
	
	public ScenePreferences getScenePreferences() {

		return scenePreferences;
	}

	public void setScenePreferences(ScenePreferences scenePreferences) {
		this.scenePreferences = scenePreferences;
	}
	
	public int getMaxProjectBackUps() {
		return maxProjectBackUps;
	}

	public void setMaxProjectBackUps(int maxProjectBackUps) {
		this.maxProjectBackUps = maxProjectBackUps;
	}

	public static void main(String[] args) {
		preference.load();
	}
	
	
	
}
