package org.frs.svg;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;

public class SvgPrinter {
	
	public static String writeTriangle(Triangle triangle) {		
		return writeTriangle(triangle.getV0(), triangle.getV1(), triangle.getV2(), triangle.getColor());
	}
	
	public static String writeTriangle(Vector3 v0, Vector3 v1, Vector3 v2, Vector3 color) {
		String colorStr = encodeColor(color);
		return String.format("<polyline points=\"%s %s %s %s \"  style=\"fill:%s;stroke:%s;stroke-width:1\"/> \n",
				toIntPair(v0), toIntPair(v1), toIntPair(v2), toIntPair(v0), colorStr, "none");
	}
	
	public static String writeLine(Vector3 v0, Vector3 v1, Vector3 color, float thickness) {
		return String.format("<line x1=%s y1=%s x2=%s y2=%s style=\"stroke:%s;stroke-width:%s\" />", v0.x, v0.y, v1.x, v1.y, encodeColor(color), thickness);
	}
	
	public static String generateArrows(Vector2 start, Vector2 end, Vector3 color) {
		Vector2 normal = end.cpy().sub(start).nor();
		normal.rotate(90);
		Vector2[] polyStart = new Vector2[3];
		Vector2 base = start.cpy().add(end.cpy().sub(start).nor().scl(6));
		polyStart[0] = start.cpy();
		polyStart[1] = normal.cpy().scl(3).add(base);
		polyStart[2] = normal.cpy().nor().scl(-3).add(base);
		Vector2[] polyEnd = new Vector2[3];
		base = end.cpy().add(start.cpy().sub(end).nor().scl(6));
		polyEnd[0] = end.cpy();
		polyEnd[1] = normal.cpy().nor().scl(3).add(base);
		polyEnd[2] = normal.cpy().nor().scl(-3).add(base);
		String str = generateArrowBlock(polyStart, color) + "\n";
		str +=  generateArrowBlock(polyEnd, color) + "\n";
		str += writeLine(new Vector3(start,0), new Vector3(end,0), color, 1.0f);
		return str;
	}

	public static String generateArrowBlock(Vector2[] vertices, Vector3 color) {
		return String.format("<polygon points=\"%s,%s %s,%s %s,%s \" style=\"fill:%s;stroke:%s;stroke-width:1\" />",
				 vertices[0].x, vertices[0].y, vertices[1].x, vertices[1].y,vertices[2].x, vertices[2].y, encodeColor(color), encodeColor(color));
	}
	
	
	public static String writeText(float x, float y,float rotation, String text, Vector3 color) {
		return String.format("<text transform=\"translate(%s, %s) rotate(%s)\"  fill=\"%s\"  style=\"text-anchor: middle;font-size:13px\">%s</text>", x, y, rotation,
				SVGWriter.encodeColor(color.x, color.y, color.z), text);
	}
		
	public static String encodeColor(Vector3 color) {
		if(color != null)
			return encodeColor(color.x, color.y, color.z);
		return "#FFFFFF";
	}
	
	public static String toIntPair(Vector3 point) {
		return (int)point.x + "," + (int)point.y;
	}
	
	public static String encodeColor(float r, float g, float b) {
		String red = Integer.toHexString(Math.min(Math.round(r * 255),255));
		if (Math.round(r * 255) < 10) {
			red = "0" + red;
		} 
		String green = Integer.toHexString(Math.min(Math.round(g * 255),255));
		if (Math.round(g * 255) < 10) {
			green = "0" + green;
		}
		String bleu = Integer.toHexString(Math.min(Math.round(b * 255),255));
		if (Math.round(b * 255) < 10) {
			bleu = "0" + bleu;
		} 
		return "#" + red + green + bleu;
	}
	
	public static void main(String...strings) {
		System.out.println(generateArrows(new Vector2(50,30), new Vector2(200,300), new Vector3()));
	}

	public static String writeCircle(Vector2 onScreenPosition, int radius, Vector3 fill, Vector3 stroke) {
		String x = Math.round(onScreenPosition.x) + "";
		String y = Math.round(onScreenPosition.y) + "";
		String fillColor = fill==null?"none":encodeColor(fill);
		return String.format("<circle cx=\"%s\" cy=\"%s\" r=\"%s\" stroke=\"%s\" "
				+ "stroke-width=\"2\" fill=\"%s\" />", x, y , radius, encodeColor(stroke), fillColor);
	}

}
