package gdxapp.screens.room3d;

import org.lwjgl.opengl.GL11;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.graphics.glutils.FrameBufferCubemap;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Vector3;

import dressing.model.ProjectManager;
import gdxapp.Commun.AbstractScreen;
import gdxapp.object3d.Object3D;
import gdxapp.object3d.WorldObject;
import gdxapp.scenes.SceneEvent;

public class Room3DScreen extends AbstractScreen {
	
	private final String TAG = Room3DScreen.class.getName();
    Room3DController controller;
    FrameBuffer frameBuffer = null;
    FrameBufferCubemap fbCubeMap; 
    Camera camera;
	private static Room3DScreen instance;
	ShaderProgram program;
	
    public Room3DScreen(){
        controller=Room3DController.getInstance();
        
    }
    
    public static Room3DScreen getInstance() {
		synchronized(Room3DScreen.class) {
			if (instance == null) {
				instance = new Room3DScreen();
			}
			return instance;
		}
	}
    
    @Override
    public void show() {
    	controller.refresh();
    	controller.setHandleEvent(true);
    }
    
    public void renderScene(){
        controller.sceneShader.setMapEnvironment(false);
        controller.sceneBatch.begin(controller.getCameraController().getCurrentCamera());
        GL11.glPolygonMode(GL11.GL_FRONT_AND_BACK, GL11.GL_FILL);
        GL11.glLineWidth(1.0f);
        try {
        	for(Object3D instance: controller.getActors()){
            	if(instance instanceof Object3D) {
            		WorldObject object= instance.getWorldObject();
                	if(!object.isHidden())
                    {
                		instance.render(controller.sceneBatch);
                    }
            	}
            }
        	for(var wall: ProjectManager.getManager().getCurrentScene().getWalls()) {
        		for(var frag: wall.get3DObjects()) {
        			if(!frag.getWorldObject().isHidden())
        			{
        				frag.render(controller.sceneBatch);
        			}
        		}
        	}

        	if(controller.getSelection() != null) {
        		controller.getSelection().drawBoundaries(controller.sceneShader.getProgram(), controller.getCameraController().getCurrentCamera().combined);
       	}
        controller.sceneBatch.end();
        
        controller.renderUI();
        controller.draw();
        	 
        }catch (Exception e) {
			e.printStackTrace();
		}finally {
			if(controller.sceneBatch.getCamera()!=null) {
				controller.sceneBatch.end();
			}
		}
        
    }
    

    
	@Override
    public void render(float delta) {
    	if( ProjectManager.instance.getCurrentScene().requireRefresh) {
    		controller.refresh();
    	}
        controller.getCameraController().update();
        controller.getUiStage().act();
        Gdx.gl20.glClearColor(255/255f, 255/255f,200/255f, 1.0f);
        Gdx.gl.glClear(GL20.GL_COLOR_BUFFER_BIT | GL20.GL_DEPTH_BUFFER_BIT | (Gdx.graphics.getBufferFormat().coverageSampling ? GL20.GL_COVERAGE_BUFFER_BIT_NV : 0));
        renderScene();
        controller.getUiStage().draw();

    }
    
	@Override
    public void resize(int width, int height) {

    }
    @Override
    public void pause() {

    }
    @Override
    public void resume() {
    	Gdx.app.debug(TAG, "resume of 3d screen....");

    }
    @Override
    public void hide() {
    	controller.setSelection(null);
    	controller.setHandleEvent(false);
    	Gdx.app.debug(TAG, "hide of 3d screen....");
    }
    @Override
    public void dispose() {
    	controller.dispose();
    	frameBuffer.dispose();
    }
	public Room3DController getController() {
		return controller;
	}
	public void setController(Room3DController controller) {
		this.controller = controller;
	}

	@Override
	public Vector3 toWorldCoordiantes(Vector3 screenCoords) {
		// TODO Auto-generated method stub
		return null;
	}
	
}
