package dressing.ui.util;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.custom.CBanner;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;

import com.badlogic.gdx.math.Vector3;

import dressing.mathutils.Vector4;
import dressing.model.ProjectManager;
import dressing.ui.parts.GdxPart;
import gdxapp.object3d.Object2D;
import gdxapp.object3d.WorldObject;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;

public class ModelInstanceConfigWindow extends org.eclipse.jface.window.Window{

	private Shell shell;
	
	private WorldObject worldObject;
	private Object2D object2D;
	private static ModelInstanceConfigWindow instance;

	private Spinner spinnerLargeur;

	private Spinner spinnerHauteur;

	private Spinner spinnerProfondeur;

	private Spinner spinnerX;

	private Spinner spinnerY;

	private Spinner spinnerZ;
	
	
	protected ModelInstanceConfigWindow(Shell parentShell) {
		super(parentShell);
		setShellStyle(SWT.SHELL_TRIM| SWT.APPLICATION_MODAL);
		setBlockOnOpen(true);
	}

	@Override
	protected Control createContents(Composite parent) {
		this.shell = parent.getShell();
		this.shell.setSize(400, 400);
		this.shell.setLayout(new FillLayout(SWT.VERTICAL));
		Composite composite = new Composite(parent, SWT.FILL);
		GridLayout gl_composite = new GridLayout(2, true);
		gl_composite.marginWidth = 10;
		gl_composite.marginTop = 10;
		gl_composite.marginRight = 10;
		gl_composite.marginLeft = 10;
		gl_composite.marginBottom = 10;
		gl_composite.horizontalSpacing = 10;
		composite.setLayout(gl_composite);
		composite.setSize(400, 400);
		
		
		Group grpDimension = new Group(composite, SWT.SHADOW_ETCHED_IN);
		grpDimension.setBounds(0, 0, 150, 100);
		grpDimension.setText("Dimensions");
		grpDimension.setLayout(new GridLayout(2, false));
		
		Label lblLargeur = new Label(grpDimension, SWT.NONE);
		lblLargeur.setText("Largeur");
		
		spinnerLargeur = new Spinner(grpDimension, SWT.BORDER);
		spinnerLargeur.setMaximum(10000);
		spinnerLargeur.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, true, false, 1, 1));
		
		Label lblHauteur = new Label(grpDimension, SWT.NONE);
		lblHauteur.setText("Hauteur");
		
		spinnerHauteur = new Spinner(grpDimension, SWT.BORDER);
		spinnerHauteur.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, true, false, 1, 1));
		spinnerHauteur.setMaximum(10000);
		
		Label lblProfondeur = new Label(grpDimension, SWT.NONE);
		lblProfondeur.setText("Profondeur");
		
		spinnerProfondeur = new Spinner(grpDimension, SWT.BORDER);
		spinnerProfondeur.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, true, false, 1, 1));
		spinnerProfondeur.setMaximum(10000);
		
		Group grpPosition = new Group(composite, SWT.SHADOW_ETCHED_IN);
		grpPosition.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		grpPosition.setText("Position");
		grpPosition.setLayout(new GridLayout(2, false));
		
		Label lblX = new Label(grpPosition, SWT.NONE);
		lblX.setText("X");
		
		spinnerX = new Spinner(grpPosition, SWT.BORDER);
		spinnerX.setMaximum(10000);
		spinnerX.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Label lblY = new Label(grpPosition, SWT.NONE);
		lblY.setText("Y");
		
		spinnerY = new Spinner(grpPosition, SWT.BORDER);
		spinnerY.setMaximum(10000);
		spinnerY.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Label lblZ = new Label(grpPosition, SWT.NONE);
		lblZ.setText("Z");
		
		spinnerZ = new Spinner(grpPosition, SWT.BORDER);
		spinnerZ.setMaximum(10000);
		spinnerZ.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Composite composite_1 = new Composite(composite, SWT.NONE);
		composite_1.setLayout(new GridLayout(2, false));
		composite_1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, true, 2, 1));
		
		Button btnUpdate = new Button(composite_1, SWT.NONE);
		btnUpdate.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseDown(MouseEvent e) {
				updateAndClose();
			}
		});
		btnUpdate.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, true, false, 1, 1));
		btnUpdate.setText("Modifier");
		
		Button btnCancel = new Button(composite_1, SWT.NONE);
		btnCancel.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseDown(MouseEvent e) {
				cancelAndClose();
			}
		});
		btnCancel.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, true, false, 1, 1));
		btnCancel.setText("Fermer");
		new Label(composite, SWT.NONE);
		new Label(composite, SWT.NONE);
		ControlAdapter adaptor=new ControlAdapter() {

			@Override
			public void controlResized(ControlEvent e) {
				 Rectangle area2= ModelInstanceConfigWindow.this.getShell().getClientArea();
			     composite.setBounds(area2);
			}
			
		};
		parent.addControlListener(adaptor);
		composite.addControlListener(adaptor);
		getShell().addControlListener(adaptor);
		return composite;
	}

	protected void cancelAndClose() {
		close();
		
	}

	protected void updateAndClose() {
		Vector4 newDimension = new Vector4(spinnerLargeur.getSelection(), spinnerHauteur.getSelection(), spinnerProfondeur.getSelection() ,0 ).scl(0.001f);
		Vector3 newPosition = new Vector3(spinnerX.getSelection(), spinnerY.getSelection(), spinnerZ.getSelection()).scl(0.001f);
		newPosition.y += newDimension.y/2;
		worldObject.setRealWorldPosition(newPosition);
		worldObject.setRealWorldDimension(newDimension);
		worldObject.setRequireRefrech(true);
		ProjectManager.getManager().getCurrentScene().update();
		close();
	}

	public WorldObject getWorldObject() {
		return worldObject;
	}

	public void setWorldObject(WorldObject worldObject) {
		this.worldObject = worldObject;
	}

	public Object2D getObject2D() {
		return object2D;
	}

	public void setObject2D(Object2D object2d) {
		object2D = object2d;
		setWorldObject(object2D.getWorldObject());
		Vector4 dimension = worldObject.getRealWorldDimension().cpy();
		dimension.scl(1000);
		spinnerLargeur.setSelection(Math.round(dimension.x));
		spinnerHauteur.setSelection(Math.round(dimension.y));
		spinnerProfondeur.setSelection(Math.round(dimension.z));
		Vector3 position = worldObject.getRealWorldPosition().cpy();
		position.scl(1000);
		spinnerX.setSelection(Math.round(position.x));
		float y = position.y - dimension.y/2;
		spinnerY.setSelection(Math.round(y));
		spinnerZ.setSelection(Math.round(position.z));
	}

	public static ModelInstanceConfigWindow getInstance() {
		if(instance == null)
			instance = new ModelInstanceConfigWindow(GdxPart.parentShell);
		instance.create();
		return instance;
	}	
}
