package gdxapp.object3d;

import java.io.Serializable;
import java.util.Properties;
import java.util.UUID;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import jakarta.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="info")
public class ModelInfo implements Serializable{
	
	private String name;
	private UUID uuid;
	private float width, height, depth, elevation;
	private Matrix4 transform;
	private Properties properties = new Properties();
	
	public void setToDefault() {
		name = "";
		uuid = UUID.randomUUID();
		name = "object_" + uuid;
		width = 1;
		height = 1;
		depth = 1;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	
	public UUID getUuid() {
		return uuid;
	}
	
	public void setUuid(UUID uuid) {
		this.uuid = uuid;
	}
	
	public Properties getProperties() {
		return properties;
	}
	
	public void setProperties(Properties properties) {
		this.properties = properties;
	}
	
	public float getWidth() {
		return width;
	}
	
	public void setWidth(float width) {
		this.width = width;
	}
	
	public float getHeight() {
		return height;
	}
	
	public void setHeight(float height) {
		this.height = height;
	}
	
	public float getDepth() {
		return depth;
	}
	
	public void setDepth(float depth) {
		this.depth = depth;
	}
	
	public Matrix4 getTransform() {
		return transform;
	}
	
	public void setTransform(Matrix4 transform) {
		this.transform = transform;
	}
	
	public Vector3 getScale() {
		return new Vector3(width, height, depth);
	}

	public Vector3 getTranslation() {
		return new Vector3(0, elevation, 0);
	}

	
	public float getElevation() {
		return elevation;
	}
	public void setElevation(float elevation) {
		this.elevation = elevation;
	}
	public ModelInfo clone() {
		ModelInfo info=new ModelInfo();
		info.setToDefault();
		info.setName(getName());
		info.setWidth(getWidth());
		info.setDepth(getDepth());
		info.setHeight(getHeight());
		info.setElevation(getElevation());
		info.setUuid(getUuid());
		info.setProperties((Properties) properties.clone());
		return info;
	}
	
	
}
