package dressing.ui.parts;

import java.awt.BorderLayout;
import java.awt.ScrollPane;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.IWorkbench;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.e4.ui.workbench.modeling.ISelectionListener;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.lwjgl.LwjglAWTCanvas;
import com.badlogic.gdx.backends.lwjgl.LwjglApplicationConfiguration;
import com.badlogic.gdx.backends.lwjgl.LwjglCanvas;
import com.badlogic.gdx.math.Vector2;

import dressing.config.ui.ActionListManager;
import dressing.events.Event;
import dressing.events.EventDriver;
import dressing.model.DesignObject3D;
import dressing.model.Kitchen;
import dressing.model.MechanicDesignCreator;
import dressing.model.ModelProvider;
import dressing.model.Piece2D;
import dressing.model.ProjectManager;
import dressing.model.ProjectRoot;
import dressing.model.Space3D;

import dressing.ui.AddObjectCommand;
import dressing.ui.Control.ConfigWindowsInvoker;
import dressing.ui.engine3d.DnDHelper;
import gdxapp.DressingRoomApp;
import gdxapp.Commun.AbstractScreen;
import gdxapp.object3d.KitchenElement;
import gdxapp.object3d.WorldObject;
import gdxapp.object3d.WorldObjectFactory;
import gdxapp.scenes.Scene;
import gdxapp.scenes.SceneEvent;
import gdxapp.screens.modelviewer.ViewerScreen;
import gdxapp.screens.room.RoomScreen;
import param.MechanicDesign;
import supercad.eclipse.service.EclipseServiceProvider;



public class GdxPart {
	
	
	@Inject
	static ESelectionService selectionService;
	@Inject
	static IEventBroker eventBroker;
	@Inject
	private static MDirtyable dirty;
	@Inject
	private static IWorkbench workbench;
	@Inject
	private EModelService modelService;
	@Inject
	private static EPartService partService;
	@Inject
	private MApplication application;
	@Inject
	private ConfigWindowsInvoker configWindowsInvoker;
	@Inject
	private ActionListManager actionListManager;
	public static Shell parentShell;
	
	@Inject
	public GdxPart() {}
	
	
	private DressingRoomApp gdxApp;
	private LwjglApplicationConfiguration config;
	private LwjglCanvas lwjglCanvas;
	private Composite swtAwtComponent;
	public static ScrollPane scrollPane;
	public static Shell shell;


	@PostConstruct
    public void createComposite(Composite parent) {
		gdxApp = new DressingRoomApp(eventBroker);
	    config = new LwjglApplicationConfiguration();
	    config.samples = 4;
	    config.width = 1400;
	    config.height = 1400;
		config.forceExit = true;
		config.useGL30 = false;
		config.disableAudio = true;
		lwjglCanvas = new LwjglCanvas(gdxApp, config) ;
		swtAwtComponent = new Composite(parent, SWT.EMBEDDED);
		java.awt.Frame frame = SWT_AWT.new_Frame(swtAwtComponent);
		SwingUtilities.invokeLater(new Runnable() {
			@Override
			public void run() {
				// TODO Auto-generated method stub
				javax.swing.JPanel panel = new javax.swing.JPanel();
				frame.add(panel);
				//add canvas
				panel.setLayout(new BorderLayout());
				scrollPane = new ScrollPane(ScrollPane.SCROLLBARS_ALWAYS);
				scrollPane.setSize(SWT.MAX, SWT.MAX);
				panel.add(scrollPane);
				lwjglCanvas.getCanvas().setSize(config.width,config.height);
				scrollPane.add(lwjglCanvas.getCanvas(),BorderLayout.CENTER);
			}
		});
		
		

		
		int operations = DND.DROP_MOVE | DND.DROP_COPY | DND.DROP_DEFAULT;
		DropTarget target = new DropTarget(swtAwtComponent, operations);
		final TextTransfer textTransfer = TextTransfer.getInstance();
		final FileTransfer fileTransfer = FileTransfer.getInstance();
		Transfer[] types = new Transfer[] {fileTransfer, textTransfer};
		target.setTransfer(types);
		target.addDropListener(new CanvasDropListener()); 
		ProjectRoot root = ProjectManager.getManager().getRoot();
		root.addPropertyChangeListener(new PropertyChangeListener() {
			@Override
			public void propertyChange(PropertyChangeEvent evt) {
				if(!parent.isDisposed()){
					parent.getDisplay().asyncExec(new Runnable() {
						@Override
						public void run() {
							dirty.setDirty(true);							
						}
					});
				}
			}
		});
		ISelectionListener selectionListener = new ISelectionListener() {
			
			@Override
			public void selectionChanged(MPart part, Object selection) {
				// TODO Auto-generated method stub
				if(selection instanceof Space3D design) {
					//ProjectManager.instance.getCurrentScene().caisson = (Space3D)selection;
					ProjectManager.instance.getCurrentScene().requireRefresh = true;
					KitchenElement selectedWobject =ProjectManager.instance.getCurrentScene().getKitchenElement( design);
					if(selectedWobject!=null)
					{
						ProjectManager.instance.getCurrentScene().setSelection(selectedWobject);
					}
				}
				if(selection instanceof Kitchen) {
					Gdx.app.postRunnable(new Runnable() {
				         @Override
				         public void run() {
				        	 if( !(Scene.game.getScreen()instanceof RoomScreen)) {
									Scene.game.setScreen(RoomScreen.getInstance());
								}
								ProjectManager.instance.setCurrentKitchen((Kitchen)selection);
				         }
				         
					});
					
				}
				if(selection instanceof Piece2D &&  Scene.game.getScreen() instanceof ViewerScreen) {
					ViewerScreen.getScreen().setRenderable(selection);
				}
					
			}
		};
		selectionService.addSelectionListener("dressing.part.projectexplorer",selectionListener);
	   createServiceProvider();
	   
	   parent.getShell().getDisplay().asyncExec(new Runnable() {
	         @Override
	         public void run() {
	        	 try {
//		     		Thread.currentThread().sleep(2000);
	     			parent.getShell().setMaximized(false);
	     			Thread.currentThread().sleep(500);
	     			parent.getShell().setMaximized(true);
	     		} catch (InterruptedException e) {
	     			// TODO Auto-generated catch block
	     			e.printStackTrace();
	     		}
	         }
	   });
		
	}				
	
	
	private void createServiceProvider() {
		EclipseServiceProvider serviceProvider = new EclipseServiceProvider(modelService, partService, application);
		EclipseServiceProvider.setServiceProvider(serviceProvider);
	}


	public static void setSelectedElement(Space3D space3D) {
//		eventBroker.send("item_selected", space3D);
		selectionService.setSelection(space3D);
		GdxPart.partService.activate(GdxPart.partService.findPart("dressing.part.gdx"));
	}

	@Focus
	public void setFocus() {
		swtAwtComponent.setFocus();
	}
	
	@Persist
	public static void save() {
		if(ProjectManager.getManager().getCurrentProject()!=null)
		{
			ProjectManager.getManager().saveProject(ProjectManager.getManager().getCurrentProject(),false,false);
			dirty.setDirty(false);
		}
	}
	
	public static ScrollPane getScrollPane() {
		return scrollPane;
	}

	class CanvasDropListener implements DropTargetListener{
		
		int x,y;

		@Override
		public void dragEnter(DropTargetEvent event) {
			// TODO Auto-generated method stub
//			Gdx.app.debug("DragEntered", Gdx.input.getX() + "");
			
		}

		@Override
		public void dragLeave(DropTargetEvent event) {
			// TODO Auto-generated method stub
//			System.err.println("drag leave .......");
		}

		@Override
		public void dragOperationChanged(DropTargetEvent event) {
			// TODO Auto-generated method stub
//			System.err.println("drag operation changed .......");
			
		}

		@Override
		public void dragOver(DropTargetEvent event) {
			// TODO Auto-generated method stub
			x = event.x;
			y = event.y;
			
		}

		@Override
		public void drop(DropTargetEvent event) {
			// TODO Auto-generated method stub
			Object obj=DnDHelper.transferedObject;
			WorldObject target=null;
			float xCoord = x - lwjglCanvas.getCanvas().getLocationOnScreen().x;
			float yCoord = Gdx.graphics.getHeight() -  (y - lwjglCanvas.getCanvas().getLocationOnScreen().y);
			if(event.data.equals("caisson_canvas3D") &&  Scene.game.getScreen() instanceof AbstractScreen) {
				if(obj instanceof MechanicDesign) {
					final DesignObject3D designObject ;
					try {
						MechanicDesign origin=(MechanicDesign) obj;
						MechanicDesign design= EcoreUtil.copy(origin);
						//
						if(ProjectManager.getManager().getCurrentKitchen()!=null) {
							Kitchen kitchen=ProjectManager.getManager().getCurrentKitchen();
							MechanicDesignCreator.getInstance().updateMaterialFromKitchen(kitchen, design);
						}
						//
						designObject = MechanicDesignCreator.getInstance().constructObject(ModelProvider.getModelroot(),
								null, null, design, MechanicDesignCreator.create,false);	
						ProjectManager.getManager().getCurrentKitchen().addElement(designObject);
					KitchenElement object = WorldObjectFactory.getFactory().createObjectFromDefinition(designObject);
					HashMap<String, Object> map = new HashMap<String, Object>();
					map.put("object", object);
					map.put("location", new Vector2(xCoord, yCoord));
					EventDriver.getDriver().deliverEvent(new Event(SceneEvent.OBJECT_DROP.name(), map));
					target=object;
					} catch ( Exception e) {
						Display.getDefault().asyncExec(new Runnable() {
							@Override
							public void run() {
								MessageBox dialog = new MessageBox(Display.getDefault().getActiveShell(), SWT.ICON_ERROR | SWT.OK | SWT.CANCEL);
								dialog.setText("Error");
								dialog.setMessage("un erreur est servenue lors de création du model à cause de :" + e.getMessage());
								dialog.open();
							}
						});
						
						e.printStackTrace();
					}
					
				}
				if(obj instanceof WorldObject) {
					WorldObject clone = ((WorldObject) obj).clone();
					HashMap<String, Object> map = new HashMap<String, Object>();
					map.put("object", clone);
					map.put("location", new Vector2(xCoord, yCoord));
					EventDriver.getDriver().deliverEvent(new Event(SceneEvent.OBJECT_DROP.name(), map));
					target=clone;
				}
				if(target!=null)
				{
					AddObjectCommand command=new AddObjectCommand("add "+(target!=null?target.getName():""), "", target, ProjectManager.getManager().getCurrentScene(), ProjectManager.getManager().getCurrentKitchen());
					if(((AbstractScreen) Scene.game.getScreen()).getController().getChangeCommandController()!=null)
					{
						((AbstractScreen) Scene.game.getScreen()).getController().getChangeCommandController().addCommand(command);
					}
				}
				
			}
			System.gc();
		}

		@Override
		public void dropAccept(DropTargetEvent event) {
		}

	}

}
