package dressing.ui;

import java.util.ArrayList;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

import dressing.config.persistence.ResourceManagers;
import dressing.model.elementsViewProviders.ElementProviderImp;
import dressing.ui.util.EditorWindow;
import dressing.ui.util.GestionLabelProvider;
import dressing.ui.util.ListEditorWindow;
import param.Finition;
import param.PanelSize;
import param.ParamFactory;

public class PanneauxComboSelect extends ElementComboSelect {

	public PanneauxComboSelect(Composite parent, int style) {
		super(parent, style);
		// TODO Auto-generated constructor stub
	}

	@Override
	public IContentProvider getContentProvider() {
		return ArrayContentProvider.getInstance();
	}

	@Override
	public IBaseLabelProvider getLabelProvider() {
		return GestionLabelProvider.getInstance();

	}

	@Override
	public Object getinput() {
		ArrayList<Object> input=new ArrayList<Object>();
		input.add(new Object());
		input.addAll(ResourceManagers.getIntance().getGestion().getPanelsizes().getPanelSizes());
		return input;
	}

	@Override
	public void addElement() {
		PanelSize panel=ParamFactory.eINSTANCE.createPanelSize();
		panel.setName("");
		PanneauxEditorWindow panelEditorWindow = new PanneauxEditorWindow(getShell(),panel,EditorWindow.create);
		panelEditorWindow.create();
		int ret=panelEditorWindow.open();
		if(ret==Window.OK) {
			getComboViewer().setInput(getinput());
			getComboViewer().refresh();
			
			getComboViewer().setSelection(new StructuredSelection(panel), true);
		}
	}

//	@Override
//	public void listElements() {
//		PanneauxListWindow panelListWindow = new PanneauxListWindow(getShell(),null);
//		panelListWindow.create();
//		int ret=panelListWindow.open();
//		getComboViewer().setInput(getinput());
//		getComboViewer().refresh();
//		
//	}

	@Override
	public void Modify() {
		Object selection=getComboViewer().getStructuredSelection().getFirstElement();
		if(selection!=null && selection instanceof PanelSize) {
			PanelSize panel=(PanelSize) selection;
			PanneauxEditorWindow finitionEditorWindow = new PanneauxEditorWindow(getShell(),panel,EditorWindow.update);
			finitionEditorWindow.create();
			int ret=finitionEditorWindow.open();
			if(ret==Window.OK) {
				getComboViewer().refresh();
			}
		}
		
	}
	@Override
	public ListEditorWindow getListEditorWindow() {
		return new PanneauxListWindow(getShell(),null);
	}
}
