/*
 * Decompiled with CFR 0.152.
 */
package com.sandmonkey.ttf_renderer.api;

import api.utils.RessourceLoader;
import com.mlomb.freetypejni.Face;
import com.mlomb.freetypejni.FreeType;
import com.mlomb.freetypejni.GlyphSlot;
import com.mlomb.freetypejni.Library;
import com.sandmonkey.ttf_renderer.api.FreeTypeFont;
import com.sandmonkey.ttf_renderer.api.Glyph;
import java.nio.ByteBuffer;
import java.util.HashMap;
import org.joml.Vector2i;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL45;

public class FreeTypeLoader {
    private static FreeTypeLoader loader;
    private HashMap<Character, Glyph> glyphMap = new HashMap();

    private FreeTypeLoader() {
    }

    public FreeTypeFont load(String path, int size) {
        Library library = FreeType.newLibrary();
        String fontPath = RessourceLoader.getFilePath((String)"com.sandmonkey.ttf_renderer", (String)path);
        Face font = library.newFace(fontPath.substring(1), 0);
        FreeType.FT_Set_Pixel_Sizes((long)font.getPointer(), (float)0.0f, (float)size);
        GL45.glPixelStorei((int)3317, (int)1);
        int textureArray = GL45.glGenTextures();
        GL45.glBindTexture((int)35866, (int)textureArray);
        GL45.glTexStorage3D((int)35866, (int)1, (int)33321, (int)size, (int)size, (int)128);
        int i = 0;
        while (i < 128) {
            if (FreeType.FT_Load_Char((long)font.getPointer(), (char)((char)i), (int)4)) {
                System.err.println("unable to load char:  " + (char)i);
            } else {
                int width = font.getGlyphSlot().getBitmap().getWidth();
                int height = font.getGlyphSlot().getBitmap().getRows();
                GL45.glTexSubImage3D((int)35866, (int)0, (int)0, (int)0, (int)i, (int)width, (int)height, (int)1, (int)6403, (int)5121, (ByteBuffer)font.getGlyphSlot().getBitmap().getBuffer());
                int bearingX = font.getGlyphSlot().getBitmapLeft();
                int bearingY = font.getGlyphSlot().getBitmapTop();
                GlyphSlot.Advance advance = font.getGlyphSlot().getAdvance();
                Vector3f region = new Vector3f((float)width / (float)size, (float)height / (float)size, (float)i);
                Glyph glyph = new Glyph(textureArray, new Vector2i(width, height), new Vector2i(bearingX, bearingY), advance.getX(), region);
                this.glyphMap.put(Character.valueOf((char)i), glyph);
            }
            ++i;
        }
        GL45.glTexParameteri((int)35866, (int)10242, (int)33071);
        GL45.glTexParameteri((int)35866, (int)10243, (int)33071);
        GL45.glTexParameteri((int)35866, (int)10241, (int)9729);
        GL45.glTexParameteri((int)35866, (int)10240, (int)9729);
        GL45.glBindTexture((int)35866, (int)0);
        font.delete();
        library.delete();
        return new FreeTypeFont(size, this.glyphMap, textureArray);
    }

    public static FreeTypeLoader getLoader() {
        if (loader == null) {
            loader = new FreeTypeLoader();
        }
        return loader;
    }
}

