	
package model.caisson;
import static org.junit.Assert.assertEquals;

import org.junit.Test;

import dressing.model.DesignException;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.CaissonMontageType;
import dressing.model.types.DosType;
import dressing.model.types.PortType;
import dressing.model.types.PositionCalculationType;
import dressing.model.types.PositionReferenceType;
import dressing.model.types.SeprationAxe;
import utils.ParametersUtils;

public class CaissonCreatorTestCases extends CheckCaisson {


	@Test
	public void test_create_2() {
    	    	Boolean withporte = false;
		ccreator.setWithporte(withporte);
                          
		assertEquals(withporte,ccreator.isWithporte());
                        
    	    	PortType porttype = PortType.COLISSANT;
		ccreator.setPorttype(porttype);
                          
		assertEquals(porttype,ccreator.getPorttype());
                        
    	    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_I;
		ccreator.setCaissonMontageType(caissonMontageType);
                          
		assertEquals(caissonMontageType,ccreator.getCaissonMontageType());
                        
    	    	DosType dostype = DosType.DOSINTERIEUR;
		ccreator.setDostype(dostype);
                          
		assertEquals(dostype,ccreator.getDostype());
                        
    	    	Boolean withseprator = true;
		ccreator.setWithseprator(withseprator);
                          
		assertEquals(withseprator,ccreator.isWithseprator());
                        
    	    	Boolean sepratortransversal = false;
		ccreator.setSepratortransversal(sepratortransversal);
                          
		assertEquals(sepratortransversal,ccreator.isSepratortransversal());
                        
    	    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		ccreator.setSeprationaxe(seprationaxe);
                          
		assertEquals(seprationaxe,ccreator.getSeprationaxe());
                        
    	    	PositionCalculationType positionCalculationtype = PositionCalculationType.FIX;
		ccreator.setPositiontype(positionCalculationtype);
                          
		assertEquals(positionCalculationtype,ccreator.getPositiontype());
                        
    	    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		ccreator.setSepPosRefType(sepPosRefType);
                          
		assertEquals(sepPosRefType,ccreator.getSepPosRefType());
                        
    	    	double sepRetrait = 50;
		ccreator.setSepRetrait(sepRetrait);
                          
		assertEquals(sepRetrait,ccreator.getSepRetrait(),ParametersUtils.epsilon);
                        
    	    	double sepretraitderiere = 50;
		ccreator.setSepretraitderiere(sepretraitderiere);
                          
		assertEquals(sepretraitderiere,ccreator.getSepretraitderiere(),ParametersUtils.epsilon);
                        
    	    	boolean isSepIsometrique = false;
		ccreator.setSeparatorisometrique(isSepIsometrique);
                          
		assertEquals(isSepIsometrique,ccreator.isSeparatorisometrique());
                        
    
		try {
		ccreator.create();

	
		} catch (DesignException e) {
			System.out.println(e.getMessage());
		} catch (GeometricEngineException e) {
			System.out.println(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_5() {
    	    	Boolean withporte = true;
		ccreator.setWithporte(withporte);
                          
		assertEquals(withporte,ccreator.isWithporte());
                        
    	    	PortType porttype = PortType.FRANCAISE;
		ccreator.setPorttype(porttype);
                          
		assertEquals(porttype,ccreator.getPorttype());
                        
    	    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		ccreator.setCaissonMontageType(caissonMontageType);
                          
		assertEquals(caissonMontageType,ccreator.getCaissonMontageType());
                        
    	    	DosType dostype = DosType.DOSEXTERIEUR;
		ccreator.setDostype(dostype);
                          
		assertEquals(dostype,ccreator.getDostype());
                        
    	    	Boolean withseprator = true;
		ccreator.setWithseprator(withseprator);
                          
		assertEquals(withseprator,ccreator.isWithseprator());
                        
    	    	Boolean sepratortransversal = false;
		ccreator.setSepratortransversal(sepratortransversal);
                          
		assertEquals(sepratortransversal,ccreator.isSepratortransversal());
                        
    	    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		ccreator.setSeprationaxe(seprationaxe);
                          
		assertEquals(seprationaxe,ccreator.getSeprationaxe());
                        
    	    	PositionCalculationType positionCalculationtype = PositionCalculationType.FIX;
		ccreator.setPositiontype(positionCalculationtype);
                          
		assertEquals(positionCalculationtype,ccreator.getPositiontype());
                        
    	    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		ccreator.setSepPosRefType(sepPosRefType);
                          
		assertEquals(sepPosRefType,ccreator.getSepPosRefType());
                        
    	    	double sepRetrait = 50;
		ccreator.setSepRetrait(sepRetrait);
                          
		assertEquals(sepRetrait,ccreator.getSepRetrait(),ParametersUtils.epsilon);
                        
    	    	double sepretraitderiere = 0;
		ccreator.setSepretraitderiere(sepretraitderiere);
                          
		assertEquals(sepretraitderiere,ccreator.getSepretraitderiere(),ParametersUtils.epsilon);
                        
    	    	boolean isSepIsometrique = true;
		ccreator.setSeparatorisometrique(isSepIsometrique);
                          
		assertEquals(isSepIsometrique,ccreator.isSeparatorisometrique());
                        
    
		try {
		ccreator.create();

	
		} catch (DesignException e) {
			System.out.println(e.getMessage());
		} catch (GeometricEngineException e) {
			System.out.println(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_7() {
    	    	Boolean withporte = false;
		ccreator.setWithporte(withporte);
                          
		assertEquals(withporte,ccreator.isWithporte());
                        
    	    	PortType porttype = PortType.FRANCAISE2V;
		ccreator.setPorttype(porttype);
                          
		assertEquals(porttype,ccreator.getPorttype());
                        
    	    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_I;
		ccreator.setCaissonMontageType(caissonMontageType);
                          
		assertEquals(caissonMontageType,ccreator.getCaissonMontageType());
                        
    	    	DosType dostype = DosType.DOSEXTERIEUR;
		ccreator.setDostype(dostype);
                          
		assertEquals(dostype,ccreator.getDostype());
                        
    	    	Boolean withseprator = true;
		ccreator.setWithseprator(withseprator);
                          
		assertEquals(withseprator,ccreator.isWithseprator());
                        
    	    	Boolean sepratortransversal = false;
		ccreator.setSepratortransversal(sepratortransversal);
                          
		assertEquals(sepratortransversal,ccreator.isSepratortransversal());
                        
    	    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		ccreator.setSeprationaxe(seprationaxe);
                          
		assertEquals(seprationaxe,ccreator.getSeprationaxe());
                        
    	    	PositionCalculationType positionCalculationtype = PositionCalculationType.FIX;
		ccreator.setPositiontype(positionCalculationtype);
                          
		assertEquals(positionCalculationtype,ccreator.getPositiontype());
                        
    	    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		ccreator.setSepPosRefType(sepPosRefType);
                          
		assertEquals(sepPosRefType,ccreator.getSepPosRefType());
                        
    	    	double sepRetrait = 0;
		ccreator.setSepRetrait(sepRetrait);
                          
		assertEquals(sepRetrait,ccreator.getSepRetrait(),ParametersUtils.epsilon);
                        
    	    	double sepretraitderiere = 50;
		ccreator.setSepretraitderiere(sepretraitderiere);
                          
		assertEquals(sepretraitderiere,ccreator.getSepretraitderiere(),ParametersUtils.epsilon);
                        
    	    	boolean isSepIsometrique = false;
		ccreator.setSeparatorisometrique(isSepIsometrique);
                          
		assertEquals(isSepIsometrique,ccreator.isSeparatorisometrique());
                        
    
		try {
		ccreator.create();

	
		} catch (DesignException e) {
			System.out.println(e.getMessage());
		} catch (GeometricEngineException e) {
			System.out.println(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_8() {
    	    	Boolean withporte = true;
		ccreator.setWithporte(withporte);
                          
		assertEquals(withporte,ccreator.isWithporte());
                        
    	    	PortType porttype = PortType.FRANCAISE;
		ccreator.setPorttype(porttype);
                          
		assertEquals(porttype,ccreator.getPorttype());
                        
    	    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		ccreator.setCaissonMontageType(caissonMontageType);
                          
		assertEquals(caissonMontageType,ccreator.getCaissonMontageType());
                        
    	    	DosType dostype = DosType.DOSINTERIEUR;
		ccreator.setDostype(dostype);
                          
		assertEquals(dostype,ccreator.getDostype());
                        
    	    	Boolean withseprator = true;
		ccreator.setWithseprator(withseprator);
                          
		assertEquals(withseprator,ccreator.isWithseprator());
                        
    	    	Boolean sepratortransversal = true;
		ccreator.setSepratortransversal(sepratortransversal);
                          
		assertEquals(sepratortransversal,ccreator.isSepratortransversal());
                        
    	    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		ccreator.setSeprationaxe(seprationaxe);
                          
		assertEquals(seprationaxe,ccreator.getSeprationaxe());
                        
    	    	PositionCalculationType positionCalculationtype = PositionCalculationType.POURCENT;
		ccreator.setPositiontype(positionCalculationtype);
                          
		assertEquals(positionCalculationtype,ccreator.getPositiontype());
                        
    	    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		ccreator.setSepPosRefType(sepPosRefType);
                          
		assertEquals(sepPosRefType,ccreator.getSepPosRefType());
                        
    	    	double sepRetrait = 0;
		ccreator.setSepRetrait(sepRetrait);
                          
		assertEquals(sepRetrait,ccreator.getSepRetrait(),ParametersUtils.epsilon);
                        
    	    	double sepretraitderiere = 0;
		ccreator.setSepretraitderiere(sepretraitderiere);
                          
		assertEquals(sepretraitderiere,ccreator.getSepretraitderiere(),ParametersUtils.epsilon);
                        
    	    	boolean isSepIsometrique = false;
		ccreator.setSeparatorisometrique(isSepIsometrique);
                          
		assertEquals(isSepIsometrique,ccreator.isSeparatorisometrique());
                        
    
		try {
		ccreator.create();

	
		} catch (DesignException e) {
			System.out.println(e.getMessage());
		} catch (GeometricEngineException e) {
			System.out.println(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_11() {
    	    	Boolean withporte = false;
		ccreator.setWithporte(withporte);
                          
		assertEquals(withporte,ccreator.isWithporte());
                        
    	    	PortType porttype = PortType.FRANCAISE2V;
		ccreator.setPorttype(porttype);
                          
		assertEquals(porttype,ccreator.getPorttype());
                        
    	    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		ccreator.setCaissonMontageType(caissonMontageType);
                          
		assertEquals(caissonMontageType,ccreator.getCaissonMontageType());
                        
    	    	DosType dostype = DosType.DOSEXTERIEUR;
		ccreator.setDostype(dostype);
                          
		assertEquals(dostype,ccreator.getDostype());
                        
    	    	Boolean withseprator = true;
		ccreator.setWithseprator(withseprator);
                          
		assertEquals(withseprator,ccreator.isWithseprator());
                        
    	    	Boolean sepratortransversal = false;
		ccreator.setSepratortransversal(sepratortransversal);
                          
		assertEquals(sepratortransversal,ccreator.isSepratortransversal());
                        
    	    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		ccreator.setSeprationaxe(seprationaxe);
                          
		assertEquals(seprationaxe,ccreator.getSeprationaxe());
                        
    	    	PositionCalculationType positionCalculationtype = PositionCalculationType.POURCENT;
		ccreator.setPositiontype(positionCalculationtype);
                          
		assertEquals(positionCalculationtype,ccreator.getPositiontype());
                        
    	    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		ccreator.setSepPosRefType(sepPosRefType);
                          
		assertEquals(sepPosRefType,ccreator.getSepPosRefType());
                        
    	    	double sepRetrait = 0;
		ccreator.setSepRetrait(sepRetrait);
                          
		assertEquals(sepRetrait,ccreator.getSepRetrait(),ParametersUtils.epsilon);
                        
    	    	double sepretraitderiere = 50;
		ccreator.setSepretraitderiere(sepretraitderiere);
                          
		assertEquals(sepretraitderiere,ccreator.getSepretraitderiere(),ParametersUtils.epsilon);
                        
    	    	boolean isSepIsometrique = true;
		ccreator.setSeparatorisometrique(isSepIsometrique);
                          
		assertEquals(isSepIsometrique,ccreator.isSeparatorisometrique());
                        
    
		try {
		ccreator.create();

	
		} catch (DesignException e) {
			System.out.println(e.getMessage());
		} catch (GeometricEngineException e) {
			System.out.println(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_14() {
    	    	Boolean withporte = true;
		ccreator.setWithporte(withporte);
                          
		assertEquals(withporte,ccreator.isWithporte());
                        
    	    	PortType porttype = PortType.FRANCAISE;
		ccreator.setPorttype(porttype);
                          
		assertEquals(porttype,ccreator.getPorttype());
                        
    	    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_I;
		ccreator.setCaissonMontageType(caissonMontageType);
                          
		assertEquals(caissonMontageType,ccreator.getCaissonMontageType());
                        
    	    	DosType dostype = DosType.DOSINTERIEUR;
		ccreator.setDostype(dostype);
                          
		assertEquals(dostype,ccreator.getDostype());
                        
    	    	Boolean withseprator = true;
		ccreator.setWithseprator(withseprator);
                          
		assertEquals(withseprator,ccreator.isWithseprator());
                        
    	    	Boolean sepratortransversal = false;
		ccreator.setSepratortransversal(sepratortransversal);
                          
		assertEquals(sepratortransversal,ccreator.isSepratortransversal());
                        
    	    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		ccreator.setSeprationaxe(seprationaxe);
                          
		assertEquals(seprationaxe,ccreator.getSeprationaxe());
                        
    	    	PositionCalculationType positionCalculationtype = PositionCalculationType.POURCENT;
		ccreator.setPositiontype(positionCalculationtype);
                          
		assertEquals(positionCalculationtype,ccreator.getPositiontype());
                        
    	    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		ccreator.setSepPosRefType(sepPosRefType);
                          
		assertEquals(sepPosRefType,ccreator.getSepPosRefType());
                        
    	    	double sepRetrait = 0;
		ccreator.setSepRetrait(sepRetrait);
                          
		assertEquals(sepRetrait,ccreator.getSepRetrait(),ParametersUtils.epsilon);
                        
    	    	double sepretraitderiere = 50;
		ccreator.setSepretraitderiere(sepretraitderiere);
                          
		assertEquals(sepretraitderiere,ccreator.getSepretraitderiere(),ParametersUtils.epsilon);
                        
    	    	boolean isSepIsometrique = true;
		ccreator.setSeparatorisometrique(isSepIsometrique);
                          
		assertEquals(isSepIsometrique,ccreator.isSeparatorisometrique());
                        
    
		try {
		ccreator.create();

	
		} catch (DesignException e) {
			System.out.println(e.getMessage());
		} catch (GeometricEngineException e) {
			System.out.println(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_15() {
    	    	Boolean withporte = true;
		ccreator.setWithporte(withporte);
                          
		assertEquals(withporte,ccreator.isWithporte());
                        
    	    	PortType porttype = PortType.FRANCAISE;
		ccreator.setPorttype(porttype);
                          
		assertEquals(porttype,ccreator.getPorttype());
                        
    	    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_I;
		ccreator.setCaissonMontageType(caissonMontageType);
                          
		assertEquals(caissonMontageType,ccreator.getCaissonMontageType());
                        
    	    	DosType dostype = DosType.DOSEXTERIEUR;
		ccreator.setDostype(dostype);
                          
		assertEquals(dostype,ccreator.getDostype());
                        
    	    	Boolean withseprator = true;
		ccreator.setWithseprator(withseprator);
                          
		assertEquals(withseprator,ccreator.isWithseprator());
                        
    	    	Boolean sepratortransversal = true;
		ccreator.setSepratortransversal(sepratortransversal);
                          
		assertEquals(sepratortransversal,ccreator.isSepratortransversal());
                        
    	    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		ccreator.setSeprationaxe(seprationaxe);
                          
		assertEquals(seprationaxe,ccreator.getSeprationaxe());
                        
    	    	PositionCalculationType positionCalculationtype = PositionCalculationType.POURCENT;
		ccreator.setPositiontype(positionCalculationtype);
                          
		assertEquals(positionCalculationtype,ccreator.getPositiontype());
                        
    	    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		ccreator.setSepPosRefType(sepPosRefType);
                          
		assertEquals(sepPosRefType,ccreator.getSepPosRefType());
                        
    	    	double sepRetrait = 50;
		ccreator.setSepRetrait(sepRetrait);
                          
		assertEquals(sepRetrait,ccreator.getSepRetrait(),ParametersUtils.epsilon);
                        
    	    	double sepretraitderiere = 50;
		ccreator.setSepretraitderiere(sepretraitderiere);
                          
		assertEquals(sepretraitderiere,ccreator.getSepretraitderiere(),ParametersUtils.epsilon);
                        
    	    	boolean isSepIsometrique = false;
		ccreator.setSeparatorisometrique(isSepIsometrique);
                          
		assertEquals(isSepIsometrique,ccreator.isSeparatorisometrique());
                        
    
		try {
		ccreator.create();

	
		} catch (DesignException e) {
			System.out.println(e.getMessage());
		} catch (GeometricEngineException e) {
			System.out.println(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_17() {
    	    	Boolean withporte = false;
		ccreator.setWithporte(withporte);
                          
		assertEquals(withporte,ccreator.isWithporte());
                        
    	    	PortType porttype = PortType.FRANCAISE;
		ccreator.setPorttype(porttype);
                          
		assertEquals(porttype,ccreator.getPorttype());
                        
    	    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		ccreator.setCaissonMontageType(caissonMontageType);
                          
		assertEquals(caissonMontageType,ccreator.getCaissonMontageType());
                        
    	    	DosType dostype = DosType.DOSINTERIEUR;
		ccreator.setDostype(dostype);
                          
		assertEquals(dostype,ccreator.getDostype());
                        
    	    	Boolean withseprator = true;
		ccreator.setWithseprator(withseprator);
                          
		assertEquals(withseprator,ccreator.isWithseprator());
                        
    	    	Boolean sepratortransversal = false;
		ccreator.setSepratortransversal(sepratortransversal);
                          
		assertEquals(sepratortransversal,ccreator.isSepratortransversal());
                        
    	    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		ccreator.setSeprationaxe(seprationaxe);
                          
		assertEquals(seprationaxe,ccreator.getSeprationaxe());
                        
    	    	PositionCalculationType positionCalculationtype = PositionCalculationType.POURCENT;
		ccreator.setPositiontype(positionCalculationtype);
                          
		assertEquals(positionCalculationtype,ccreator.getPositiontype());
                        
    	    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		ccreator.setSepPosRefType(sepPosRefType);
                          
		assertEquals(sepPosRefType,ccreator.getSepPosRefType());
                        
    	    	double sepRetrait = 0;
		ccreator.setSepRetrait(sepRetrait);
                          
		assertEquals(sepRetrait,ccreator.getSepRetrait(),ParametersUtils.epsilon);
                        
    	    	double sepretraitderiere = 0;
		ccreator.setSepretraitderiere(sepretraitderiere);
                          
		assertEquals(sepretraitderiere,ccreator.getSepretraitderiere(),ParametersUtils.epsilon);
                        
    	    	boolean isSepIsometrique = true;
		ccreator.setSeparatorisometrique(isSepIsometrique);
                          
		assertEquals(isSepIsometrique,ccreator.isSeparatorisometrique());
                        
    
		try {
		ccreator.create();

	
		} catch (DesignException e) {
			System.out.println(e.getMessage());
		} catch (GeometricEngineException e) {
			System.out.println(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_18() {
    	    	Boolean withporte = true;
		ccreator.setWithporte(withporte);
                          
		assertEquals(withporte,ccreator.isWithporte());
                        
    	    	PortType porttype = PortType.COLISSANT;
		ccreator.setPorttype(porttype);
                          
		assertEquals(porttype,ccreator.getPorttype());
                        
    	    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		ccreator.setCaissonMontageType(caissonMontageType);
                          
		assertEquals(caissonMontageType,ccreator.getCaissonMontageType());
                        
    	    	DosType dostype = DosType.DOSINTERIEUR;
		ccreator.setDostype(dostype);
                          
		assertEquals(dostype,ccreator.getDostype());
                        
    	    	Boolean withseprator = true;
		ccreator.setWithseprator(withseprator);
                          
		assertEquals(withseprator,ccreator.isWithseprator());
                        
    	    	Boolean sepratortransversal = false;
		ccreator.setSepratortransversal(sepratortransversal);
                          
		assertEquals(sepratortransversal,ccreator.isSepratortransversal());
                        
    	    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		ccreator.setSeprationaxe(seprationaxe);
                          
		assertEquals(seprationaxe,ccreator.getSeprationaxe());
                        
    	    	PositionCalculationType positionCalculationtype = PositionCalculationType.FIX;
		ccreator.setPositiontype(positionCalculationtype);
                          
		assertEquals(positionCalculationtype,ccreator.getPositiontype());
                        
    	    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		ccreator.setSepPosRefType(sepPosRefType);
                          
		assertEquals(sepPosRefType,ccreator.getSepPosRefType());
                        
    	    	double sepRetrait = 50;
		ccreator.setSepRetrait(sepRetrait);
                          
		assertEquals(sepRetrait,ccreator.getSepRetrait(),ParametersUtils.epsilon);
                        
    	    	double sepretraitderiere = 0;
		ccreator.setSepretraitderiere(sepretraitderiere);
                          
		assertEquals(sepretraitderiere,ccreator.getSepretraitderiere(),ParametersUtils.epsilon);
                        
    	    	boolean isSepIsometrique = false;
		ccreator.setSeparatorisometrique(isSepIsometrique);
                          
		assertEquals(isSepIsometrique,ccreator.isSeparatorisometrique());
                        
    
		try {
		ccreator.create();

	
		} catch (DesignException e) {
			System.out.println(e.getMessage());
		} catch (GeometricEngineException e) {
			System.out.println(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_20() {
    	    	Boolean withporte = true;
		ccreator.setWithporte(withporte);
                          
		assertEquals(withporte,ccreator.isWithporte());
                        
    	    	PortType porttype = PortType.FRANCAISE2V;
		ccreator.setPorttype(porttype);
                          
		assertEquals(porttype,ccreator.getPorttype());
                        
    	    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		ccreator.setCaissonMontageType(caissonMontageType);
                          
		assertEquals(caissonMontageType,ccreator.getCaissonMontageType());
                        
    	    	DosType dostype = DosType.DOSINTERIEUR;
		ccreator.setDostype(dostype);
                          
		assertEquals(dostype,ccreator.getDostype());
                        
    	    	Boolean withseprator = true;
		ccreator.setWithseprator(withseprator);
                          
		assertEquals(withseprator,ccreator.isWithseprator());
                        
    	    	Boolean sepratortransversal = false;
		ccreator.setSepratortransversal(sepratortransversal);
                          
		assertEquals(sepratortransversal,ccreator.isSepratortransversal());
                        
    	    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		ccreator.setSeprationaxe(seprationaxe);
                          
		assertEquals(seprationaxe,ccreator.getSeprationaxe());
                        
    	    	PositionCalculationType positionCalculationtype = PositionCalculationType.FIX;
		ccreator.setPositiontype(positionCalculationtype);
                          
		assertEquals(positionCalculationtype,ccreator.getPositiontype());
                        
    	    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		ccreator.setSepPosRefType(sepPosRefType);
                          
		assertEquals(sepPosRefType,ccreator.getSepPosRefType());
                        
    	    	double sepRetrait = 0;
		ccreator.setSepRetrait(sepRetrait);
                          
		assertEquals(sepRetrait,ccreator.getSepRetrait(),ParametersUtils.epsilon);
                        
    	    	double sepretraitderiere = 50;
		ccreator.setSepretraitderiere(sepretraitderiere);
                          
		assertEquals(sepretraitderiere,ccreator.getSepretraitderiere(),ParametersUtils.epsilon);
                        
    	    	boolean isSepIsometrique = true;
		ccreator.setSeparatorisometrique(isSepIsometrique);
                          
		assertEquals(isSepIsometrique,ccreator.isSeparatorisometrique());
                        
    
		try {
		ccreator.create();

	
		} catch (DesignException e) {
			System.out.println(e.getMessage());
		} catch (GeometricEngineException e) {
			System.out.println(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_21() {
    	    	Boolean withporte = false;
		ccreator.setWithporte(withporte);
                          
		assertEquals(withporte,ccreator.isWithporte());
                        
    	    	PortType porttype = PortType.COLISSANT;
		ccreator.setPorttype(porttype);
                          
		assertEquals(porttype,ccreator.getPorttype());
                        
    	    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		ccreator.setCaissonMontageType(caissonMontageType);
                          
		assertEquals(caissonMontageType,ccreator.getCaissonMontageType());
                        
    	    	DosType dostype = DosType.DOSEXTERIEUR;
		ccreator.setDostype(dostype);
                          
		assertEquals(dostype,ccreator.getDostype());
                        
    	    	Boolean withseprator = true;
		ccreator.setWithseprator(withseprator);
                          
		assertEquals(withseprator,ccreator.isWithseprator());
                        
    	    	Boolean sepratortransversal = true;
		ccreator.setSepratortransversal(sepratortransversal);
                          
		assertEquals(sepratortransversal,ccreator.isSepratortransversal());
                        
    	    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		ccreator.setSeprationaxe(seprationaxe);
                          
		assertEquals(seprationaxe,ccreator.getSeprationaxe());
                        
    	    	PositionCalculationType positionCalculationtype = PositionCalculationType.POURCENT;
		ccreator.setPositiontype(positionCalculationtype);
                          
		assertEquals(positionCalculationtype,ccreator.getPositiontype());
                        
    	    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		ccreator.setSepPosRefType(sepPosRefType);
                          
		assertEquals(sepPosRefType,ccreator.getSepPosRefType());
                        
    	    	double sepRetrait = 50;
		ccreator.setSepRetrait(sepRetrait);
                          
		assertEquals(sepRetrait,ccreator.getSepRetrait(),ParametersUtils.epsilon);
                        
    	    	double sepretraitderiere = 0;
		ccreator.setSepretraitderiere(sepretraitderiere);
                          
		assertEquals(sepretraitderiere,ccreator.getSepretraitderiere(),ParametersUtils.epsilon);
                        
    	    	boolean isSepIsometrique = false;
		ccreator.setSeparatorisometrique(isSepIsometrique);
                          
		assertEquals(isSepIsometrique,ccreator.isSeparatorisometrique());
                        
    
		try {
		ccreator.create();

	
		} catch (DesignException e) {
			System.out.println(e.getMessage());
		} catch (GeometricEngineException e) {
			System.out.println(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_24() {
    	    	Boolean withporte = true;
		ccreator.setWithporte(withporte);
                          
		assertEquals(withporte,ccreator.isWithporte());
                        
    	    	PortType porttype = PortType.FRANCAISE2V;
		ccreator.setPorttype(porttype);
                          
		assertEquals(porttype,ccreator.getPorttype());
                        
    	    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_I;
		ccreator.setCaissonMontageType(caissonMontageType);
                          
		assertEquals(caissonMontageType,ccreator.getCaissonMontageType());
                        
    	    	DosType dostype = DosType.DOSINTERIEUR;
		ccreator.setDostype(dostype);
                          
		assertEquals(dostype,ccreator.getDostype());
                        
    	    	Boolean withseprator = true;
		ccreator.setWithseprator(withseprator);
                          
		assertEquals(withseprator,ccreator.isWithseprator());
                        
    	    	Boolean sepratortransversal = true;
		ccreator.setSepratortransversal(sepratortransversal);
                          
		assertEquals(sepratortransversal,ccreator.isSepratortransversal());
                        
    	    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		ccreator.setSeprationaxe(seprationaxe);
                          
		assertEquals(seprationaxe,ccreator.getSeprationaxe());
                        
    	    	PositionCalculationType positionCalculationtype = PositionCalculationType.FIX;
		ccreator.setPositiontype(positionCalculationtype);
                          
		assertEquals(positionCalculationtype,ccreator.getPositiontype());
                        
    	    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		ccreator.setSepPosRefType(sepPosRefType);
                          
		assertEquals(sepPosRefType,ccreator.getSepPosRefType());
                        
    	    	double sepRetrait = 0;
		ccreator.setSepRetrait(sepRetrait);
                          
		assertEquals(sepRetrait,ccreator.getSepRetrait(),ParametersUtils.epsilon);
                        
    	    	double sepretraitderiere = 50;
		ccreator.setSepretraitderiere(sepretraitderiere);
                          
		assertEquals(sepretraitderiere,ccreator.getSepretraitderiere(),ParametersUtils.epsilon);
                        
    	    	boolean isSepIsometrique = true;
		ccreator.setSeparatorisometrique(isSepIsometrique);
                          
		assertEquals(isSepIsometrique,ccreator.isSeparatorisometrique());
                        
    
		try {
		ccreator.create();

	
		} catch (DesignException e) {
			System.out.println(e.getMessage());
		} catch (GeometricEngineException e) {
			System.out.println(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_26() {
    	    	Boolean withporte = false;
		ccreator.setWithporte(withporte);
                          
		assertEquals(withporte,ccreator.isWithporte());
                        
    	    	PortType porttype = PortType.COLISSANT;
		ccreator.setPorttype(porttype);
                          
		assertEquals(porttype,ccreator.getPorttype());
                        
    	    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_I;
		ccreator.setCaissonMontageType(caissonMontageType);
                          
		assertEquals(caissonMontageType,ccreator.getCaissonMontageType());
                        
    	    	DosType dostype = DosType.DOSINTERIEUR;
		ccreator.setDostype(dostype);
                          
		assertEquals(dostype,ccreator.getDostype());
                        
    	    	Boolean withseprator = true;
		ccreator.setWithseprator(withseprator);
                          
		assertEquals(withseprator,ccreator.isWithseprator());
                        
    	    	Boolean sepratortransversal = true;
		ccreator.setSepratortransversal(sepratortransversal);
                          
		assertEquals(sepratortransversal,ccreator.isSepratortransversal());
                        
    	    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		ccreator.setSeprationaxe(seprationaxe);
                          
		assertEquals(seprationaxe,ccreator.getSeprationaxe());
                        
    	    	PositionCalculationType positionCalculationtype = PositionCalculationType.POURCENT;
		ccreator.setPositiontype(positionCalculationtype);
                          
		assertEquals(positionCalculationtype,ccreator.getPositiontype());
                        
    	    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		ccreator.setSepPosRefType(sepPosRefType);
                          
		assertEquals(sepPosRefType,ccreator.getSepPosRefType());
                        
    	    	double sepRetrait = 0;
		ccreator.setSepRetrait(sepRetrait);
                          
		assertEquals(sepRetrait,ccreator.getSepRetrait(),ParametersUtils.epsilon);
                        
    	    	double sepretraitderiere = 50;
		ccreator.setSepretraitderiere(sepretraitderiere);
                          
		assertEquals(sepretraitderiere,ccreator.getSepretraitderiere(),ParametersUtils.epsilon);
                        
    	    	boolean isSepIsometrique = true;
		ccreator.setSeparatorisometrique(isSepIsometrique);
                          
		assertEquals(isSepIsometrique,ccreator.isSeparatorisometrique());
                        
    
		try {
		ccreator.create();

	
		} catch (DesignException e) {
			System.out.println(e.getMessage());
		} catch (GeometricEngineException e) {
			System.out.println(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_27() {
    	    	Boolean withporte = false;
		ccreator.setWithporte(withporte);
                          
		assertEquals(withporte,ccreator.isWithporte());
                        
    	    	PortType porttype = PortType.FRANCAISE2V;
		ccreator.setPorttype(porttype);
                          
		assertEquals(porttype,ccreator.getPorttype());
                        
    	    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_I;
		ccreator.setCaissonMontageType(caissonMontageType);
                          
		assertEquals(caissonMontageType,ccreator.getCaissonMontageType());
                        
    	    	DosType dostype = DosType.DOSINTERIEUR;
		ccreator.setDostype(dostype);
                          
		assertEquals(dostype,ccreator.getDostype());
                        
    	    	Boolean withseprator = true;
		ccreator.setWithseprator(withseprator);
                          
		assertEquals(withseprator,ccreator.isWithseprator());
                        
    	    	Boolean sepratortransversal = false;
		ccreator.setSepratortransversal(sepratortransversal);
                          
		assertEquals(sepratortransversal,ccreator.isSepratortransversal());
                        
    	    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		ccreator.setSeprationaxe(seprationaxe);
                          
		assertEquals(seprationaxe,ccreator.getSeprationaxe());
                        
    	    	PositionCalculationType positionCalculationtype = PositionCalculationType.FIX;
		ccreator.setPositiontype(positionCalculationtype);
                          
		assertEquals(positionCalculationtype,ccreator.getPositiontype());
                        
    	    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		ccreator.setSepPosRefType(sepPosRefType);
                          
		assertEquals(sepPosRefType,ccreator.getSepPosRefType());
                        
    	    	double sepRetrait = 50;
		ccreator.setSepRetrait(sepRetrait);
                          
		assertEquals(sepRetrait,ccreator.getSepRetrait(),ParametersUtils.epsilon);
                        
    	    	double sepretraitderiere = 0;
		ccreator.setSepretraitderiere(sepretraitderiere);
                          
		assertEquals(sepretraitderiere,ccreator.getSepretraitderiere(),ParametersUtils.epsilon);
                        
    	    	boolean isSepIsometrique = true;
		ccreator.setSeparatorisometrique(isSepIsometrique);
                          
		assertEquals(isSepIsometrique,ccreator.isSeparatorisometrique());
                        
    
		try {
		ccreator.create();

	
		} catch (DesignException e) {
			System.out.println(e.getMessage());
		} catch (GeometricEngineException e) {
			System.out.println(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_28() {
    	    	Boolean withporte = true;
		ccreator.setWithporte(withporte);
                          
		assertEquals(withporte,ccreator.isWithporte());
                        
    	    	PortType porttype = PortType.FRANCAISE2V;
		ccreator.setPorttype(porttype);
                          
		assertEquals(porttype,ccreator.getPorttype());
                        
    	    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_I;
		ccreator.setCaissonMontageType(caissonMontageType);
                          
		assertEquals(caissonMontageType,ccreator.getCaissonMontageType());
                        
    	    	DosType dostype = DosType.DOSINTERIEUR;
		ccreator.setDostype(dostype);
                          
		assertEquals(dostype,ccreator.getDostype());
                        
    	    	Boolean withseprator = true;
		ccreator.setWithseprator(withseprator);
                          
		assertEquals(withseprator,ccreator.isWithseprator());
                        
    	    	Boolean sepratortransversal = true;
		ccreator.setSepratortransversal(sepratortransversal);
                          
		assertEquals(sepratortransversal,ccreator.isSepratortransversal());
                        
    	    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		ccreator.setSeprationaxe(seprationaxe);
                          
		assertEquals(seprationaxe,ccreator.getSeprationaxe());
                        
    	    	PositionCalculationType positionCalculationtype = PositionCalculationType.FIX;
		ccreator.setPositiontype(positionCalculationtype);
                          
		assertEquals(positionCalculationtype,ccreator.getPositiontype());
                        
    	    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		ccreator.setSepPosRefType(sepPosRefType);
                          
		assertEquals(sepPosRefType,ccreator.getSepPosRefType());
                        
    	    	double sepRetrait = 50;
		ccreator.setSepRetrait(sepRetrait);
                          
		assertEquals(sepRetrait,ccreator.getSepRetrait(),ParametersUtils.epsilon);
                        
    	    	double sepretraitderiere = 0;
		ccreator.setSepretraitderiere(sepretraitderiere);
                          
		assertEquals(sepretraitderiere,ccreator.getSepretraitderiere(),ParametersUtils.epsilon);
                        
    	    	boolean isSepIsometrique = false;
		ccreator.setSeparatorisometrique(isSepIsometrique);
                          
		assertEquals(isSepIsometrique,ccreator.isSeparatorisometrique());
                        
    
		try {
		ccreator.create();

	
		} catch (DesignException e) {
			System.out.println(e.getMessage());
		} catch (GeometricEngineException e) {
			System.out.println(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_29() {
    	    	Boolean withporte = false;
		ccreator.setWithporte(withporte);
                          
		assertEquals(withporte,ccreator.isWithporte());
                        
    	    	PortType porttype = PortType.FRANCAISE2H;
		ccreator.setPorttype(porttype);
                          
		assertEquals(porttype,ccreator.getPorttype());
                        
    	    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_I;
		ccreator.setCaissonMontageType(caissonMontageType);
                          
		assertEquals(caissonMontageType,ccreator.getCaissonMontageType());
                        
    	    	DosType dostype = DosType.DOSEXTERIEUR;
		ccreator.setDostype(dostype);
                          
		assertEquals(dostype,ccreator.getDostype());
                        
    	    	Boolean withseprator = true;
		ccreator.setWithseprator(withseprator);
                          
		assertEquals(withseprator,ccreator.isWithseprator());
                        
    	    	Boolean sepratortransversal = false;
		ccreator.setSepratortransversal(sepratortransversal);
                          
		assertEquals(sepratortransversal,ccreator.isSepratortransversal());
                        
    	    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		ccreator.setSeprationaxe(seprationaxe);
                          
		assertEquals(seprationaxe,ccreator.getSeprationaxe());
                        
    	    	PositionCalculationType positionCalculationtype = PositionCalculationType.POURCENT;
		ccreator.setPositiontype(positionCalculationtype);
                          
		assertEquals(positionCalculationtype,ccreator.getPositiontype());
                        
    	    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		ccreator.setSepPosRefType(sepPosRefType);
                          
		assertEquals(sepPosRefType,ccreator.getSepPosRefType());
                        
    	    	double sepRetrait = 0;
		ccreator.setSepRetrait(sepRetrait);
                          
		assertEquals(sepRetrait,ccreator.getSepRetrait(),ParametersUtils.epsilon);
                        
    	    	double sepretraitderiere = 50;
		ccreator.setSepretraitderiere(sepretraitderiere);
                          
		assertEquals(sepretraitderiere,ccreator.getSepretraitderiere(),ParametersUtils.epsilon);
                        
    	    	boolean isSepIsometrique = true;
		ccreator.setSeparatorisometrique(isSepIsometrique);
                          
		assertEquals(isSepIsometrique,ccreator.isSeparatorisometrique());
                        
    
		try {
		ccreator.create();

	
		} catch (DesignException e) {
			System.out.println(e.getMessage());
		} catch (GeometricEngineException e) {
			System.out.println(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_30() {
    	    	Boolean withporte = false;
		ccreator.setWithporte(withporte);
                          
		assertEquals(withporte,ccreator.isWithporte());
                        
    	    	PortType porttype = PortType.FRANCAISE2H;
		ccreator.setPorttype(porttype);
                          
		assertEquals(porttype,ccreator.getPorttype());
                        
    	    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		ccreator.setCaissonMontageType(caissonMontageType);
                          
		assertEquals(caissonMontageType,ccreator.getCaissonMontageType());
                        
    	    	DosType dostype = DosType.DOSINTERIEUR;
		ccreator.setDostype(dostype);
                          
		assertEquals(dostype,ccreator.getDostype());
                        
    	    	Boolean withseprator = true;
		ccreator.setWithseprator(withseprator);
                          
		assertEquals(withseprator,ccreator.isWithseprator());
                        
    	    	Boolean sepratortransversal = true;
		ccreator.setSepratortransversal(sepratortransversal);
                          
		assertEquals(sepratortransversal,ccreator.isSepratortransversal());
                        
    	    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		ccreator.setSeprationaxe(seprationaxe);
                          
		assertEquals(seprationaxe,ccreator.getSeprationaxe());
                        
    	    	PositionCalculationType positionCalculationtype = PositionCalculationType.FIX;
		ccreator.setPositiontype(positionCalculationtype);
                          
		assertEquals(positionCalculationtype,ccreator.getPositiontype());
                        
    	    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		ccreator.setSepPosRefType(sepPosRefType);
                          
		assertEquals(sepPosRefType,ccreator.getSepPosRefType());
                        
    	    	double sepRetrait = 50;
		ccreator.setSepRetrait(sepRetrait);
                          
		assertEquals(sepRetrait,ccreator.getSepRetrait(),ParametersUtils.epsilon);
                        
    	    	double sepretraitderiere = 50;
		ccreator.setSepretraitderiere(sepretraitderiere);
                          
		assertEquals(sepretraitderiere,ccreator.getSepretraitderiere(),ParametersUtils.epsilon);
                        
    	    	boolean isSepIsometrique = false;
		ccreator.setSeparatorisometrique(isSepIsometrique);
                          
		assertEquals(isSepIsometrique,ccreator.isSeparatorisometrique());
                        
    
		try {
		ccreator.create();

	
		} catch (DesignException e) {
			System.out.println(e.getMessage());
		} catch (GeometricEngineException e) {
			System.out.println(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_31() {
    	    	Boolean withporte = true;
		ccreator.setWithporte(withporte);
                          
		assertEquals(withporte,ccreator.isWithporte());
                        
    	    	PortType porttype = PortType.COLISSANT;
		ccreator.setPorttype(porttype);
                          
		assertEquals(porttype,ccreator.getPorttype());
                        
    	    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		ccreator.setCaissonMontageType(caissonMontageType);
                          
		assertEquals(caissonMontageType,ccreator.getCaissonMontageType());
                        
    	    	DosType dostype = DosType.DOSEXTERIEUR;
		ccreator.setDostype(dostype);
                          
		assertEquals(dostype,ccreator.getDostype());
                        
    	    	Boolean withseprator = true;
		ccreator.setWithseprator(withseprator);
                          
		assertEquals(withseprator,ccreator.isWithseprator());
                        
    	    	Boolean sepratortransversal = false;
		ccreator.setSepratortransversal(sepratortransversal);
                          
		assertEquals(sepratortransversal,ccreator.isSepratortransversal());
                        
    	    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		ccreator.setSeprationaxe(seprationaxe);
                          
		assertEquals(seprationaxe,ccreator.getSeprationaxe());
                        
    	    	PositionCalculationType positionCalculationtype = PositionCalculationType.FIX;
		ccreator.setPositiontype(positionCalculationtype);
                          
		assertEquals(positionCalculationtype,ccreator.getPositiontype());
                        
    	    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		ccreator.setSepPosRefType(sepPosRefType);
                          
		assertEquals(sepPosRefType,ccreator.getSepPosRefType());
                        
    	    	double sepRetrait = 50;
		ccreator.setSepRetrait(sepRetrait);
                          
		assertEquals(sepRetrait,ccreator.getSepRetrait(),ParametersUtils.epsilon);
                        
    	    	double sepretraitderiere = 0;
		ccreator.setSepretraitderiere(sepretraitderiere);
                          
		assertEquals(sepretraitderiere,ccreator.getSepretraitderiere(),ParametersUtils.epsilon);
                        
    	    	boolean isSepIsometrique = true;
		ccreator.setSeparatorisometrique(isSepIsometrique);
                          
		assertEquals(isSepIsometrique,ccreator.isSeparatorisometrique());
                        
    
		try {
		ccreator.create();

	
		} catch (DesignException e) {
			System.out.println(e.getMessage());
		} catch (GeometricEngineException e) {
			System.out.println(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_32() {
    	    	Boolean withporte = true;
		ccreator.setWithporte(withporte);
                          
		assertEquals(withporte,ccreator.isWithporte());
                        
    	    	PortType porttype = PortType.FRANCAISE;
		ccreator.setPorttype(porttype);
                          
		assertEquals(porttype,ccreator.getPorttype());
                        
    	    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_I;
		ccreator.setCaissonMontageType(caissonMontageType);
                          
		assertEquals(caissonMontageType,ccreator.getCaissonMontageType());
                        
    	    	DosType dostype = DosType.DOSEXTERIEUR;
		ccreator.setDostype(dostype);
                          
		assertEquals(dostype,ccreator.getDostype());
                        
    	    	Boolean withseprator = true;
		ccreator.setWithseprator(withseprator);
                          
		assertEquals(withseprator,ccreator.isWithseprator());
                        
    	    	Boolean sepratortransversal = true;
		ccreator.setSepratortransversal(sepratortransversal);
                          
		assertEquals(sepratortransversal,ccreator.isSepratortransversal());
                        
    	    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		ccreator.setSeprationaxe(seprationaxe);
                          
		assertEquals(seprationaxe,ccreator.getSeprationaxe());
                        
    	    	PositionCalculationType positionCalculationtype = PositionCalculationType.FIX;
		ccreator.setPositiontype(positionCalculationtype);
                          
		assertEquals(positionCalculationtype,ccreator.getPositiontype());
                        
    	    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		ccreator.setSepPosRefType(sepPosRefType);
                          
		assertEquals(sepPosRefType,ccreator.getSepPosRefType());
                        
    	    	double sepRetrait = 50;
		ccreator.setSepRetrait(sepRetrait);
                          
		assertEquals(sepRetrait,ccreator.getSepRetrait(),ParametersUtils.epsilon);
                        
    	    	double sepretraitderiere = 0;
		ccreator.setSepretraitderiere(sepretraitderiere);
                          
		assertEquals(sepretraitderiere,ccreator.getSepretraitderiere(),ParametersUtils.epsilon);
                        
    	    	boolean isSepIsometrique = true;
		ccreator.setSeparatorisometrique(isSepIsometrique);
                          
		assertEquals(isSepIsometrique,ccreator.isSeparatorisometrique());
                        
    
		try {
		ccreator.create();

	
		} catch (DesignException e) {
			System.out.println(e.getMessage());
		} catch (GeometricEngineException e) {
			System.out.println(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_33() {
    	    	Boolean withporte = false;
		ccreator.setWithporte(withporte);
                          
		assertEquals(withporte,ccreator.isWithporte());
                        
    	    	PortType porttype = PortType.FRANCAISE;
		ccreator.setPorttype(porttype);
                          
		assertEquals(porttype,ccreator.getPorttype());
                        
    	    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		ccreator.setCaissonMontageType(caissonMontageType);
                          
		assertEquals(caissonMontageType,ccreator.getCaissonMontageType());
                        
    	    	DosType dostype = DosType.DOSINTERIEUR;
		ccreator.setDostype(dostype);
                          
		assertEquals(dostype,ccreator.getDostype());
                        
    	    	Boolean withseprator = true;
		ccreator.setWithseprator(withseprator);
                          
		assertEquals(withseprator,ccreator.isWithseprator());
                        
    	    	Boolean sepratortransversal = true;
		ccreator.setSepratortransversal(sepratortransversal);
                          
		assertEquals(sepratortransversal,ccreator.isSepratortransversal());
                        
    	    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		ccreator.setSeprationaxe(seprationaxe);
                          
		assertEquals(seprationaxe,ccreator.getSeprationaxe());
                        
    	    	PositionCalculationType positionCalculationtype = PositionCalculationType.FIX;
		ccreator.setPositiontype(positionCalculationtype);
                          
		assertEquals(positionCalculationtype,ccreator.getPositiontype());
                        
    	    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		ccreator.setSepPosRefType(sepPosRefType);
                          
		assertEquals(sepPosRefType,ccreator.getSepPosRefType());
                        
    	    	double sepRetrait = 50;
		ccreator.setSepRetrait(sepRetrait);
                          
		assertEquals(sepRetrait,ccreator.getSepRetrait(),ParametersUtils.epsilon);
                        
    	    	double sepretraitderiere = 50;
		ccreator.setSepretraitderiere(sepretraitderiere);
                          
		assertEquals(sepretraitderiere,ccreator.getSepretraitderiere(),ParametersUtils.epsilon);
                        
    	    	boolean isSepIsometrique = false;
		ccreator.setSeparatorisometrique(isSepIsometrique);
                          
		assertEquals(isSepIsometrique,ccreator.isSeparatorisometrique());
                        
    
		try {
		ccreator.create();

	
		} catch (DesignException e) {
			System.out.println(e.getMessage());
		} catch (GeometricEngineException e) {
			System.out.println(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_34() {
    	    	Boolean withporte = false;
		ccreator.setWithporte(withporte);
                          
		assertEquals(withporte,ccreator.isWithporte());
                        
    	    	PortType porttype = PortType.FRANCAISE2H;
		ccreator.setPorttype(porttype);
                          
		assertEquals(porttype,ccreator.getPorttype());
                        
    	    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		ccreator.setCaissonMontageType(caissonMontageType);
                          
		assertEquals(caissonMontageType,ccreator.getCaissonMontageType());
                        
    	    	DosType dostype = DosType.DOSEXTERIEUR;
		ccreator.setDostype(dostype);
                          
		assertEquals(dostype,ccreator.getDostype());
                        
    	    	Boolean withseprator = false;
		ccreator.setWithseprator(withseprator);
                          
		assertEquals(withseprator,ccreator.isWithseprator());
                        
    	    	    	    	    	    	    	    
		try {
		ccreator.create();

	
		} catch (DesignException e) {
			System.out.println(e.getMessage());
		} catch (GeometricEngineException e) {
			System.out.println(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_35() {
    	    	Boolean withporte = false;
		ccreator.setWithporte(withporte);
                          
		assertEquals(withporte,ccreator.isWithporte());
                        
    	    	PortType porttype = PortType.FRANCAISE;
		ccreator.setPorttype(porttype);
                          
		assertEquals(porttype,ccreator.getPorttype());
                        
    	    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_I;
		ccreator.setCaissonMontageType(caissonMontageType);
                          
		assertEquals(caissonMontageType,ccreator.getCaissonMontageType());
                        
    	    	DosType dostype = DosType.DOSEXTERIEUR;
		ccreator.setDostype(dostype);
                          
		assertEquals(dostype,ccreator.getDostype());
                        
    	    	Boolean withseprator = true;
		ccreator.setWithseprator(withseprator);
                          
		assertEquals(withseprator,ccreator.isWithseprator());
                        
    	    	Boolean sepratortransversal = true;
		ccreator.setSepratortransversal(sepratortransversal);
                          
		assertEquals(sepratortransversal,ccreator.isSepratortransversal());
                        
    	    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		ccreator.setSeprationaxe(seprationaxe);
                          
		assertEquals(seprationaxe,ccreator.getSeprationaxe());
                        
    	    	PositionCalculationType positionCalculationtype = PositionCalculationType.POURCENT;
		ccreator.setPositiontype(positionCalculationtype);
                          
		assertEquals(positionCalculationtype,ccreator.getPositiontype());
                        
    	    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		ccreator.setSepPosRefType(sepPosRefType);
                          
		assertEquals(sepPosRefType,ccreator.getSepPosRefType());
                        
    	    	double sepRetrait = 50;
		ccreator.setSepRetrait(sepRetrait);
                          
		assertEquals(sepRetrait,ccreator.getSepRetrait(),ParametersUtils.epsilon);
                        
    	    	double sepretraitderiere = 0;
		ccreator.setSepretraitderiere(sepretraitderiere);
                          
		assertEquals(sepretraitderiere,ccreator.getSepretraitderiere(),ParametersUtils.epsilon);
                        
    	    	boolean isSepIsometrique = false;
		ccreator.setSeparatorisometrique(isSepIsometrique);
                          
		assertEquals(isSepIsometrique,ccreator.isSeparatorisometrique());
                        
    
		try {
		ccreator.create();

	
		} catch (DesignException e) {
			System.out.println(e.getMessage());
		} catch (GeometricEngineException e) {
			System.out.println(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_36() {
    	    	Boolean withporte = true;
		ccreator.setWithporte(withporte);
                          
		assertEquals(withporte,ccreator.isWithporte());
                        
    	    	PortType porttype = PortType.FRANCAISE2H;
		ccreator.setPorttype(porttype);
                          
		assertEquals(porttype,ccreator.getPorttype());
                        
    	    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_I;
		ccreator.setCaissonMontageType(caissonMontageType);
                          
		assertEquals(caissonMontageType,ccreator.getCaissonMontageType());
                        
    	    	DosType dostype = DosType.DOSINTERIEUR;
		ccreator.setDostype(dostype);
                          
		assertEquals(dostype,ccreator.getDostype());
                        
    	    	Boolean withseprator = true;
		ccreator.setWithseprator(withseprator);
                          
		assertEquals(withseprator,ccreator.isWithseprator());
                        
    	    	Boolean sepratortransversal = true;
		ccreator.setSepratortransversal(sepratortransversal);
                          
		assertEquals(sepratortransversal,ccreator.isSepratortransversal());
                        
    	    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		ccreator.setSeprationaxe(seprationaxe);
                          
		assertEquals(seprationaxe,ccreator.getSeprationaxe());
                        
    	    	PositionCalculationType positionCalculationtype = PositionCalculationType.FIX;
		ccreator.setPositiontype(positionCalculationtype);
                          
		assertEquals(positionCalculationtype,ccreator.getPositiontype());
                        
    	    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		ccreator.setSepPosRefType(sepPosRefType);
                          
		assertEquals(sepPosRefType,ccreator.getSepPosRefType());
                        
    	    	double sepRetrait = 0;
		ccreator.setSepRetrait(sepRetrait);
                          
		assertEquals(sepRetrait,ccreator.getSepRetrait(),ParametersUtils.epsilon);
                        
    	    	double sepretraitderiere = 0;
		ccreator.setSepretraitderiere(sepretraitderiere);
                          
		assertEquals(sepretraitderiere,ccreator.getSepretraitderiere(),ParametersUtils.epsilon);
                        
    	    	boolean isSepIsometrique = true;
		ccreator.setSeparatorisometrique(isSepIsometrique);
                          
		assertEquals(isSepIsometrique,ccreator.isSeparatorisometrique());
                        
    
		try {
		ccreator.create();

	
		} catch (DesignException e) {
			System.out.println(e.getMessage());
		} catch (GeometricEngineException e) {
			System.out.println(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_37() {
    	    	Boolean withporte = true;
		ccreator.setWithporte(withporte);
                          
		assertEquals(withporte,ccreator.isWithporte());
                        
    	    	PortType porttype = PortType.COLISSANT;
		ccreator.setPorttype(porttype);
                          
		assertEquals(porttype,ccreator.getPorttype());
                        
    	    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_I;
		ccreator.setCaissonMontageType(caissonMontageType);
                          
		assertEquals(caissonMontageType,ccreator.getCaissonMontageType());
                        
    	    	DosType dostype = DosType.DOSINTERIEUR;
		ccreator.setDostype(dostype);
                          
		assertEquals(dostype,ccreator.getDostype());
                        
    	    	Boolean withseprator = false;
		ccreator.setWithseprator(withseprator);
                          
		assertEquals(withseprator,ccreator.isWithseprator());
                        
    	    	    	    	    	    	    	    
		try {
		ccreator.create();

	
		} catch (DesignException e) {
			System.out.println(e.getMessage());
		} catch (GeometricEngineException e) {
			System.out.println(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_38() {
    	    	Boolean withporte = false;
		ccreator.setWithporte(withporte);
                          
		assertEquals(withporte,ccreator.isWithporte());
                        
    	    	PortType porttype = PortType.FRANCAISE2H;
		ccreator.setPorttype(porttype);
                          
		assertEquals(porttype,ccreator.getPorttype());
                        
    	    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		ccreator.setCaissonMontageType(caissonMontageType);
                          
		assertEquals(caissonMontageType,ccreator.getCaissonMontageType());
                        
    	    	DosType dostype = DosType.DOSINTERIEUR;
		ccreator.setDostype(dostype);
                          
		assertEquals(dostype,ccreator.getDostype());
                        
    	    	Boolean withseprator = true;
		ccreator.setWithseprator(withseprator);
                          
		assertEquals(withseprator,ccreator.isWithseprator());
                        
    	    	Boolean sepratortransversal = true;
		ccreator.setSepratortransversal(sepratortransversal);
                          
		assertEquals(sepratortransversal,ccreator.isSepratortransversal());
                        
    	    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		ccreator.setSeprationaxe(seprationaxe);
                          
		assertEquals(seprationaxe,ccreator.getSeprationaxe());
                        
    	    	PositionCalculationType positionCalculationtype = PositionCalculationType.POURCENT;
		ccreator.setPositiontype(positionCalculationtype);
                          
		assertEquals(positionCalculationtype,ccreator.getPositiontype());
                        
    	    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		ccreator.setSepPosRefType(sepPosRefType);
                          
		assertEquals(sepPosRefType,ccreator.getSepPosRefType());
                        
    	    	double sepRetrait = 50;
		ccreator.setSepRetrait(sepRetrait);
                          
		assertEquals(sepRetrait,ccreator.getSepRetrait(),ParametersUtils.epsilon);
                        
    	    	double sepretraitderiere = 0;
		ccreator.setSepretraitderiere(sepretraitderiere);
                          
		assertEquals(sepretraitderiere,ccreator.getSepretraitderiere(),ParametersUtils.epsilon);
                        
    	    	boolean isSepIsometrique = true;
		ccreator.setSeparatorisometrique(isSepIsometrique);
                          
		assertEquals(isSepIsometrique,ccreator.isSeparatorisometrique());
                        
    
		try {
		ccreator.create();

	
		} catch (DesignException e) {
			System.out.println(e.getMessage());
		} catch (GeometricEngineException e) {
			System.out.println(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_39() {
    	    	Boolean withporte = false;
		ccreator.setWithporte(withporte);
                          
		assertEquals(withporte,ccreator.isWithporte());
                        
    	    	PortType porttype = PortType.COLISSANT;
		ccreator.setPorttype(porttype);
                          
		assertEquals(porttype,ccreator.getPorttype());
                        
    	    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_I;
		ccreator.setCaissonMontageType(caissonMontageType);
                          
		assertEquals(caissonMontageType,ccreator.getCaissonMontageType());
                        
    	    	DosType dostype = DosType.DOSEXTERIEUR;
		ccreator.setDostype(dostype);
                          
		assertEquals(dostype,ccreator.getDostype());
                        
    	    	Boolean withseprator = false;
		ccreator.setWithseprator(withseprator);
                          
		assertEquals(withseprator,ccreator.isWithseprator());
                        
    	    	    	    	    	    	    	    
		try {
		ccreator.create();

	
		} catch (DesignException e) {
			System.out.println(e.getMessage());
		} catch (GeometricEngineException e) {
			System.out.println(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_40() {
    	    	Boolean withporte = false;
		ccreator.setWithporte(withporte);
                          
		assertEquals(withporte,ccreator.isWithporte());
                        
    	    	PortType porttype = PortType.FRANCAISE2V;
		ccreator.setPorttype(porttype);
                          
		assertEquals(porttype,ccreator.getPorttype());
                        
    	    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		ccreator.setCaissonMontageType(caissonMontageType);
                          
		assertEquals(caissonMontageType,ccreator.getCaissonMontageType());
                        
    	    	DosType dostype = DosType.DOSEXTERIEUR;
		ccreator.setDostype(dostype);
                          
		assertEquals(dostype,ccreator.getDostype());
                        
    	    	Boolean withseprator = true;
		ccreator.setWithseprator(withseprator);
                          
		assertEquals(withseprator,ccreator.isWithseprator());
                        
    	    	Boolean sepratortransversal = true;
		ccreator.setSepratortransversal(sepratortransversal);
                          
		assertEquals(sepratortransversal,ccreator.isSepratortransversal());
                        
    	    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		ccreator.setSeprationaxe(seprationaxe);
                          
		assertEquals(seprationaxe,ccreator.getSeprationaxe());
                        
    	    	PositionCalculationType positionCalculationtype = PositionCalculationType.POURCENT;
		ccreator.setPositiontype(positionCalculationtype);
                          
		assertEquals(positionCalculationtype,ccreator.getPositiontype());
                        
    	    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		ccreator.setSepPosRefType(sepPosRefType);
                          
		assertEquals(sepPosRefType,ccreator.getSepPosRefType());
                        
    	    	double sepRetrait = 0;
		ccreator.setSepRetrait(sepRetrait);
                          
		assertEquals(sepRetrait,ccreator.getSepRetrait(),ParametersUtils.epsilon);
                        
    	    	double sepretraitderiere = 0;
		ccreator.setSepretraitderiere(sepretraitderiere);
                          
		assertEquals(sepretraitderiere,ccreator.getSepretraitderiere(),ParametersUtils.epsilon);
                        
    	    	boolean isSepIsometrique = false;
		ccreator.setSeparatorisometrique(isSepIsometrique);
                          
		assertEquals(isSepIsometrique,ccreator.isSeparatorisometrique());
                        
    
		try {
		ccreator.create();

	
		} catch (DesignException e) {
			System.out.println(e.getMessage());
		} catch (GeometricEngineException e) {
			System.out.println(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_41() {
    	    	Boolean withporte = false;
		ccreator.setWithporte(withporte);
                          
		assertEquals(withporte,ccreator.isWithporte());
                        
    	    	PortType porttype = PortType.FRANCAISE2V;
		ccreator.setPorttype(porttype);
                          
		assertEquals(porttype,ccreator.getPorttype());
                        
    	    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		ccreator.setCaissonMontageType(caissonMontageType);
                          
		assertEquals(caissonMontageType,ccreator.getCaissonMontageType());
                        
    	    	DosType dostype = DosType.DOSINTERIEUR;
		ccreator.setDostype(dostype);
                          
		assertEquals(dostype,ccreator.getDostype());
                        
    	    	Boolean withseprator = false;
		ccreator.setWithseprator(withseprator);
                          
		assertEquals(withseprator,ccreator.isWithseprator());
                        
    	    	    	    	    	    	    	    
		try {
		ccreator.create();

	
		} catch (DesignException e) {
			System.out.println(e.getMessage());
		} catch (GeometricEngineException e) {
			System.out.println(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_42() {
    	    	Boolean withporte = true;
		ccreator.setWithporte(withporte);
                          
		assertEquals(withporte,ccreator.isWithporte());
                        
    	    	PortType porttype = PortType.COLISSANT;
		ccreator.setPorttype(porttype);
                          
		assertEquals(porttype,ccreator.getPorttype());
                        
    	    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		ccreator.setCaissonMontageType(caissonMontageType);
                          
		assertEquals(caissonMontageType,ccreator.getCaissonMontageType());
                        
    	    	DosType dostype = DosType.DOSEXTERIEUR;
		ccreator.setDostype(dostype);
                          
		assertEquals(dostype,ccreator.getDostype());
                        
    	    	Boolean withseprator = true;
		ccreator.setWithseprator(withseprator);
                          
		assertEquals(withseprator,ccreator.isWithseprator());
                        
    	    	Boolean sepratortransversal = false;
		ccreator.setSepratortransversal(sepratortransversal);
                          
		assertEquals(sepratortransversal,ccreator.isSepratortransversal());
                        
    	    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		ccreator.setSeprationaxe(seprationaxe);
                          
		assertEquals(seprationaxe,ccreator.getSeprationaxe());
                        
    	    	PositionCalculationType positionCalculationtype = PositionCalculationType.POURCENT;
		ccreator.setPositiontype(positionCalculationtype);
                          
		assertEquals(positionCalculationtype,ccreator.getPositiontype());
                        
    	    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		ccreator.setSepPosRefType(sepPosRefType);
                          
		assertEquals(sepPosRefType,ccreator.getSepPosRefType());
                        
    	    	double sepRetrait = 0;
		ccreator.setSepRetrait(sepRetrait);
                          
		assertEquals(sepRetrait,ccreator.getSepRetrait(),ParametersUtils.epsilon);
                        
    	    	double sepretraitderiere = 50;
		ccreator.setSepretraitderiere(sepretraitderiere);
                          
		assertEquals(sepretraitderiere,ccreator.getSepretraitderiere(),ParametersUtils.epsilon);
                        
    	    	boolean isSepIsometrique = false;
		ccreator.setSeparatorisometrique(isSepIsometrique);
                          
		assertEquals(isSepIsometrique,ccreator.isSeparatorisometrique());
                        
    
		try {
		ccreator.create();

	
		} catch (DesignException e) {
			System.out.println(e.getMessage());
		} catch (GeometricEngineException e) {
			System.out.println(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_43() {
    	    	Boolean withporte = true;
		ccreator.setWithporte(withporte);
                          
		assertEquals(withporte,ccreator.isWithporte());
                        
    	    	PortType porttype = PortType.FRANCAISE2V;
		ccreator.setPorttype(porttype);
                          
		assertEquals(porttype,ccreator.getPorttype());
                        
    	    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_I;
		ccreator.setCaissonMontageType(caissonMontageType);
                          
		assertEquals(caissonMontageType,ccreator.getCaissonMontageType());
                        
    	    	DosType dostype = DosType.DOSEXTERIEUR;
		ccreator.setDostype(dostype);
                          
		assertEquals(dostype,ccreator.getDostype());
                        
    	    	Boolean withseprator = true;
		ccreator.setWithseprator(withseprator);
                          
		assertEquals(withseprator,ccreator.isWithseprator());
                        
    	    	Boolean sepratortransversal = false;
		ccreator.setSepratortransversal(sepratortransversal);
                          
		assertEquals(sepratortransversal,ccreator.isSepratortransversal());
                        
    	    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		ccreator.setSeprationaxe(seprationaxe);
                          
		assertEquals(seprationaxe,ccreator.getSeprationaxe());
                        
    	    	PositionCalculationType positionCalculationtype = PositionCalculationType.POURCENT;
		ccreator.setPositiontype(positionCalculationtype);
                          
		assertEquals(positionCalculationtype,ccreator.getPositiontype());
                        
    	    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		ccreator.setSepPosRefType(sepPosRefType);
                          
		assertEquals(sepPosRefType,ccreator.getSepPosRefType());
                        
    	    	double sepRetrait = 50;
		ccreator.setSepRetrait(sepRetrait);
                          
		assertEquals(sepRetrait,ccreator.getSepRetrait(),ParametersUtils.epsilon);
                        
    	    	double sepretraitderiere = 50;
		ccreator.setSepretraitderiere(sepretraitderiere);
                          
		assertEquals(sepretraitderiere,ccreator.getSepretraitderiere(),ParametersUtils.epsilon);
                        
    	    	boolean isSepIsometrique = false;
		ccreator.setSeparatorisometrique(isSepIsometrique);
                          
		assertEquals(isSepIsometrique,ccreator.isSeparatorisometrique());
                        
    
		try {
		ccreator.create();

	
		} catch (DesignException e) {
			System.out.println(e.getMessage());
		} catch (GeometricEngineException e) {
			System.out.println(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_44() {
    	    	Boolean withporte = true;
		ccreator.setWithporte(withporte);
                          
		assertEquals(withporte,ccreator.isWithporte());
                        
    	    	PortType porttype = PortType.FRANCAISE;
		ccreator.setPorttype(porttype);
                          
		assertEquals(porttype,ccreator.getPorttype());
                        
    	    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		ccreator.setCaissonMontageType(caissonMontageType);
                          
		assertEquals(caissonMontageType,ccreator.getCaissonMontageType());
                        
    	    	DosType dostype = DosType.DOSEXTERIEUR;
		ccreator.setDostype(dostype);
                          
		assertEquals(dostype,ccreator.getDostype());
                        
    	    	Boolean withseprator = false;
		ccreator.setWithseprator(withseprator);
                          
		assertEquals(withseprator,ccreator.isWithseprator());
                        
    	    	    	    	    	    	    	    
		try {
		ccreator.create();

	
		} catch (DesignException e) {
			System.out.println(e.getMessage());
		} catch (GeometricEngineException e) {
			System.out.println(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_45() {
    	    	Boolean withporte = false;
		ccreator.setWithporte(withporte);
                          
		assertEquals(withporte,ccreator.isWithporte());
                        
    	    	PortType porttype = PortType.COLISSANT;
		ccreator.setPorttype(porttype);
                          
		assertEquals(porttype,ccreator.getPorttype());
                        
    	    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_I;
		ccreator.setCaissonMontageType(caissonMontageType);
                          
		assertEquals(caissonMontageType,ccreator.getCaissonMontageType());
                        
    	    	DosType dostype = DosType.DOSINTERIEUR;
		ccreator.setDostype(dostype);
                          
		assertEquals(dostype,ccreator.getDostype());
                        
    	    	Boolean withseprator = true;
		ccreator.setWithseprator(withseprator);
                          
		assertEquals(withseprator,ccreator.isWithseprator());
                        
    	    	Boolean sepratortransversal = true;
		ccreator.setSepratortransversal(sepratortransversal);
                          
		assertEquals(sepratortransversal,ccreator.isSepratortransversal());
                        
    	    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		ccreator.setSeprationaxe(seprationaxe);
                          
		assertEquals(seprationaxe,ccreator.getSeprationaxe());
                        
    	    	PositionCalculationType positionCalculationtype = PositionCalculationType.FIX;
		ccreator.setPositiontype(positionCalculationtype);
                          
		assertEquals(positionCalculationtype,ccreator.getPositiontype());
                        
    	    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		ccreator.setSepPosRefType(sepPosRefType);
                          
		assertEquals(sepPosRefType,ccreator.getSepPosRefType());
                        
    	    	double sepRetrait = 0;
		ccreator.setSepRetrait(sepRetrait);
                          
		assertEquals(sepRetrait,ccreator.getSepRetrait(),ParametersUtils.epsilon);
                        
    	    	double sepretraitderiere = 0;
		ccreator.setSepretraitderiere(sepretraitderiere);
                          
		assertEquals(sepretraitderiere,ccreator.getSepretraitderiere(),ParametersUtils.epsilon);
                        
    	    	boolean isSepIsometrique = true;
		ccreator.setSeparatorisometrique(isSepIsometrique);
                          
		assertEquals(isSepIsometrique,ccreator.isSeparatorisometrique());
                        
    
		try {
		ccreator.create();

	
		} catch (DesignException e) {
			System.out.println(e.getMessage());
		} catch (GeometricEngineException e) {
			System.out.println(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_46() {
    	    	Boolean withporte = false;
		ccreator.setWithporte(withporte);
                          
		assertEquals(withporte,ccreator.isWithporte());
                        
    	    	PortType porttype = PortType.FRANCAISE;
		ccreator.setPorttype(porttype);
                          
		assertEquals(porttype,ccreator.getPorttype());
                        
    	    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		ccreator.setCaissonMontageType(caissonMontageType);
                          
		assertEquals(caissonMontageType,ccreator.getCaissonMontageType());
                        
    	    	DosType dostype = DosType.DOSEXTERIEUR;
		ccreator.setDostype(dostype);
                          
		assertEquals(dostype,ccreator.getDostype());
                        
    	    	Boolean withseprator = true;
		ccreator.setWithseprator(withseprator);
                          
		assertEquals(withseprator,ccreator.isWithseprator());
                        
    	    	Boolean sepratortransversal = false;
		ccreator.setSepratortransversal(sepratortransversal);
                          
		assertEquals(sepratortransversal,ccreator.isSepratortransversal());
                        
    	    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		ccreator.setSeprationaxe(seprationaxe);
                          
		assertEquals(seprationaxe,ccreator.getSeprationaxe());
                        
    	    	PositionCalculationType positionCalculationtype = PositionCalculationType.FIX;
		ccreator.setPositiontype(positionCalculationtype);
                          
		assertEquals(positionCalculationtype,ccreator.getPositiontype());
                        
    	    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		ccreator.setSepPosRefType(sepPosRefType);
                          
		assertEquals(sepPosRefType,ccreator.getSepPosRefType());
                        
    	    	double sepRetrait = 0;
		ccreator.setSepRetrait(sepRetrait);
                          
		assertEquals(sepRetrait,ccreator.getSepRetrait(),ParametersUtils.epsilon);
                        
    	    	double sepretraitderiere = 50;
		ccreator.setSepretraitderiere(sepretraitderiere);
                          
		assertEquals(sepretraitderiere,ccreator.getSepretraitderiere(),ParametersUtils.epsilon);
                        
    	    	boolean isSepIsometrique = false;
		ccreator.setSeparatorisometrique(isSepIsometrique);
                          
		assertEquals(isSepIsometrique,ccreator.isSeparatorisometrique());
                        
    
		try {
		ccreator.create();

	
		} catch (DesignException e) {
			System.out.println(e.getMessage());
		} catch (GeometricEngineException e) {
			System.out.println(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_47() {
    	    	Boolean withporte = true;
		ccreator.setWithporte(withporte);
                          
		assertEquals(withporte,ccreator.isWithporte());
                        
    	    	PortType porttype = PortType.FRANCAISE2H;
		ccreator.setPorttype(porttype);
                          
		assertEquals(porttype,ccreator.getPorttype());
                        
    	    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_I;
		ccreator.setCaissonMontageType(caissonMontageType);
                          
		assertEquals(caissonMontageType,ccreator.getCaissonMontageType());
                        
    	    	DosType dostype = DosType.DOSEXTERIEUR;
		ccreator.setDostype(dostype);
                          
		assertEquals(dostype,ccreator.getDostype());
                        
    	    	Boolean withseprator = true;
		ccreator.setWithseprator(withseprator);
                          
		assertEquals(withseprator,ccreator.isWithseprator());
                        
    	    	Boolean sepratortransversal = true;
		ccreator.setSepratortransversal(sepratortransversal);
                          
		assertEquals(sepratortransversal,ccreator.isSepratortransversal());
                        
    	    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		ccreator.setSeprationaxe(seprationaxe);
                          
		assertEquals(seprationaxe,ccreator.getSeprationaxe());
                        
    	    	PositionCalculationType positionCalculationtype = PositionCalculationType.POURCENT;
		ccreator.setPositiontype(positionCalculationtype);
                          
		assertEquals(positionCalculationtype,ccreator.getPositiontype());
                        
    	    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		ccreator.setSepPosRefType(sepPosRefType);
                          
		assertEquals(sepPosRefType,ccreator.getSepPosRefType());
                        
    	    	double sepRetrait = 50;
		ccreator.setSepRetrait(sepRetrait);
                          
		assertEquals(sepRetrait,ccreator.getSepRetrait(),ParametersUtils.epsilon);
                        
    	    	double sepretraitderiere = 0;
		ccreator.setSepretraitderiere(sepretraitderiere);
                          
		assertEquals(sepretraitderiere,ccreator.getSepretraitderiere(),ParametersUtils.epsilon);
                        
    	    	boolean isSepIsometrique = false;
		ccreator.setSeparatorisometrique(isSepIsometrique);
                          
		assertEquals(isSepIsometrique,ccreator.isSeparatorisometrique());
                        
    
		try {
		ccreator.create();

	
		} catch (DesignException e) {
			System.out.println(e.getMessage());
		} catch (GeometricEngineException e) {
			System.out.println(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_48() {
    	    	Boolean withporte = true;
		ccreator.setWithporte(withporte);
                          
		assertEquals(withporte,ccreator.isWithporte());
                        
    	    	PortType porttype = PortType.FRANCAISE2H;
		ccreator.setPorttype(porttype);
                          
		assertEquals(porttype,ccreator.getPorttype());
                        
    	    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_I;
		ccreator.setCaissonMontageType(caissonMontageType);
                          
		assertEquals(caissonMontageType,ccreator.getCaissonMontageType());
                        
    	    	DosType dostype = DosType.DOSINTERIEUR;
		ccreator.setDostype(dostype);
                          
		assertEquals(dostype,ccreator.getDostype());
                        
    	    	Boolean withseprator = false;
		ccreator.setWithseprator(withseprator);
                          
		assertEquals(withseprator,ccreator.isWithseprator());
                        
    	    	    	    	    	    	    	    
		try {
		ccreator.create();

	
		} catch (DesignException e) {
			System.out.println(e.getMessage());
		} catch (GeometricEngineException e) {
			System.out.println(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_49() {
    	    	Boolean withporte = true;
		ccreator.setWithporte(withporte);
                          
		assertEquals(withporte,ccreator.isWithporte());
                        
    	    	PortType porttype = PortType.FRANCAISE2V;
		ccreator.setPorttype(porttype);
                          
		assertEquals(porttype,ccreator.getPorttype());
                        
    	    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		ccreator.setCaissonMontageType(caissonMontageType);
                          
		assertEquals(caissonMontageType,ccreator.getCaissonMontageType());
                        
    	    	DosType dostype = DosType.DOSINTERIEUR;
		ccreator.setDostype(dostype);
                          
		assertEquals(dostype,ccreator.getDostype());
                        
    	    	Boolean withseprator = true;
		ccreator.setWithseprator(withseprator);
                          
		assertEquals(withseprator,ccreator.isWithseprator());
                        
    	    	Boolean sepratortransversal = true;
		ccreator.setSepratortransversal(sepratortransversal);
                          
		assertEquals(sepratortransversal,ccreator.isSepratortransversal());
                        
    	    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		ccreator.setSeprationaxe(seprationaxe);
                          
		assertEquals(seprationaxe,ccreator.getSeprationaxe());
                        
    	    	PositionCalculationType positionCalculationtype = PositionCalculationType.POURCENT;
		ccreator.setPositiontype(positionCalculationtype);
                          
		assertEquals(positionCalculationtype,ccreator.getPositiontype());
                        
    	    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		ccreator.setSepPosRefType(sepPosRefType);
                          
		assertEquals(sepPosRefType,ccreator.getSepPosRefType());
                        
    	    	double sepRetrait = 50;
		ccreator.setSepRetrait(sepRetrait);
                          
		assertEquals(sepRetrait,ccreator.getSepRetrait(),ParametersUtils.epsilon);
                        
    	    	double sepretraitderiere = 0;
		ccreator.setSepretraitderiere(sepretraitderiere);
                          
		assertEquals(sepretraitderiere,ccreator.getSepretraitderiere(),ParametersUtils.epsilon);
                        
    	    	boolean isSepIsometrique = false;
		ccreator.setSeparatorisometrique(isSepIsometrique);
                          
		assertEquals(isSepIsometrique,ccreator.isSeparatorisometrique());
                        
    
		try {
		ccreator.create();

	
		} catch (DesignException e) {
			System.out.println(e.getMessage());
		} catch (GeometricEngineException e) {
			System.out.println(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_50() {
    	    	Boolean withporte = true;
		ccreator.setWithporte(withporte);
                          
		assertEquals(withporte,ccreator.isWithporte());
                        
    	    	PortType porttype = PortType.FRANCAISE2H;
		ccreator.setPorttype(porttype);
                          
		assertEquals(porttype,ccreator.getPorttype());
                        
    	    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		ccreator.setCaissonMontageType(caissonMontageType);
                          
		assertEquals(caissonMontageType,ccreator.getCaissonMontageType());
                        
    	    	DosType dostype = DosType.DOSINTERIEUR;
		ccreator.setDostype(dostype);
                          
		assertEquals(dostype,ccreator.getDostype());
                        
    	    	Boolean withseprator = true;
		ccreator.setWithseprator(withseprator);
                          
		assertEquals(withseprator,ccreator.isWithseprator());
                        
    	    	Boolean sepratortransversal = false;
		ccreator.setSepratortransversal(sepratortransversal);
                          
		assertEquals(sepratortransversal,ccreator.isSepratortransversal());
                        
    	    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		ccreator.setSeprationaxe(seprationaxe);
                          
		assertEquals(seprationaxe,ccreator.getSeprationaxe());
                        
    	    	PositionCalculationType positionCalculationtype = PositionCalculationType.FIX;
		ccreator.setPositiontype(positionCalculationtype);
                          
		assertEquals(positionCalculationtype,ccreator.getPositiontype());
                        
    	    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		ccreator.setSepPosRefType(sepPosRefType);
                          
		assertEquals(sepPosRefType,ccreator.getSepPosRefType());
                        
    	    	double sepRetrait = 0;
		ccreator.setSepRetrait(sepRetrait);
                          
		assertEquals(sepRetrait,ccreator.getSepRetrait(),ParametersUtils.epsilon);
                        
    	    	double sepretraitderiere = 0;
		ccreator.setSepretraitderiere(sepretraitderiere);
                          
		assertEquals(sepretraitderiere,ccreator.getSepretraitderiere(),ParametersUtils.epsilon);
                        
    	    	boolean isSepIsometrique = false;
		ccreator.setSeparatorisometrique(isSepIsometrique);
                          
		assertEquals(isSepIsometrique,ccreator.isSeparatorisometrique());
                        
    
		try {
		ccreator.create();

	
		} catch (DesignException e) {
			System.out.println(e.getMessage());
		} catch (GeometricEngineException e) {
			System.out.println(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_51() {
    	    	Boolean withporte = false;
		ccreator.setWithporte(withporte);
                          
		assertEquals(withporte,ccreator.isWithporte());
                        
    	    	PortType porttype = PortType.FRANCAISE2H;
		ccreator.setPorttype(porttype);
                          
		assertEquals(porttype,ccreator.getPorttype());
                        
    	    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		ccreator.setCaissonMontageType(caissonMontageType);
                          
		assertEquals(caissonMontageType,ccreator.getCaissonMontageType());
                        
    	    	DosType dostype = DosType.DOSINTERIEUR;
		ccreator.setDostype(dostype);
                          
		assertEquals(dostype,ccreator.getDostype());
                        
    	    	Boolean withseprator = true;
		ccreator.setWithseprator(withseprator);
                          
		assertEquals(withseprator,ccreator.isWithseprator());
                        
    	    	Boolean sepratortransversal = true;
		ccreator.setSepratortransversal(sepratortransversal);
                          
		assertEquals(sepratortransversal,ccreator.isSepratortransversal());
                        
    	    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		ccreator.setSeprationaxe(seprationaxe);
                          
		assertEquals(seprationaxe,ccreator.getSeprationaxe());
                        
    	    	PositionCalculationType positionCalculationtype = PositionCalculationType.FIX;
		ccreator.setPositiontype(positionCalculationtype);
                          
		assertEquals(positionCalculationtype,ccreator.getPositiontype());
                        
    	    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		ccreator.setSepPosRefType(sepPosRefType);
                          
		assertEquals(sepPosRefType,ccreator.getSepPosRefType());
                        
    	    	double sepRetrait = 50;
		ccreator.setSepRetrait(sepRetrait);
                          
		assertEquals(sepRetrait,ccreator.getSepRetrait(),ParametersUtils.epsilon);
                        
    	    	double sepretraitderiere = 50;
		ccreator.setSepretraitderiere(sepretraitderiere);
                          
		assertEquals(sepretraitderiere,ccreator.getSepretraitderiere(),ParametersUtils.epsilon);
                        
    	    	boolean isSepIsometrique = true;
		ccreator.setSeparatorisometrique(isSepIsometrique);
                          
		assertEquals(isSepIsometrique,ccreator.isSeparatorisometrique());
                        
    
		try {
		ccreator.create();

	
		} catch (DesignException e) {
			System.out.println(e.getMessage());
		} catch (GeometricEngineException e) {
			System.out.println(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_52() {
    	    	Boolean withporte = true;
		ccreator.setWithporte(withporte);
                          
		assertEquals(withporte,ccreator.isWithporte());
                        
    	    	PortType porttype = PortType.FRANCAISE2H;
		ccreator.setPorttype(porttype);
                          
		assertEquals(porttype,ccreator.getPorttype());
                        
    	    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_I;
		ccreator.setCaissonMontageType(caissonMontageType);
                          
		assertEquals(caissonMontageType,ccreator.getCaissonMontageType());
                        
    	    	DosType dostype = DosType.DOSEXTERIEUR;
		ccreator.setDostype(dostype);
                          
		assertEquals(dostype,ccreator.getDostype());
                        
    	    	Boolean withseprator = true;
		ccreator.setWithseprator(withseprator);
                          
		assertEquals(withseprator,ccreator.isWithseprator());
                        
    	    	Boolean sepratortransversal = false;
		ccreator.setSepratortransversal(sepratortransversal);
                          
		assertEquals(sepratortransversal,ccreator.isSepratortransversal());
                        
    	    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		ccreator.setSeprationaxe(seprationaxe);
                          
		assertEquals(seprationaxe,ccreator.getSeprationaxe());
                        
    	    	PositionCalculationType positionCalculationtype = PositionCalculationType.POURCENT;
		ccreator.setPositiontype(positionCalculationtype);
                          
		assertEquals(positionCalculationtype,ccreator.getPositiontype());
                        
    	    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		ccreator.setSepPosRefType(sepPosRefType);
                          
		assertEquals(sepPosRefType,ccreator.getSepPosRefType());
                        
    	    	double sepRetrait = 0;
		ccreator.setSepRetrait(sepRetrait);
                          
		assertEquals(sepRetrait,ccreator.getSepRetrait(),ParametersUtils.epsilon);
                        
    	    	double sepretraitderiere = 50;
		ccreator.setSepretraitderiere(sepretraitderiere);
                          
		assertEquals(sepretraitderiere,ccreator.getSepretraitderiere(),ParametersUtils.epsilon);
                        
    	    	boolean isSepIsometrique = false;
		ccreator.setSeparatorisometrique(isSepIsometrique);
                          
		assertEquals(isSepIsometrique,ccreator.isSeparatorisometrique());
                        
    
		try {
		ccreator.create();

	
		} catch (DesignException e) {
			System.out.println(e.getMessage());
		} catch (GeometricEngineException e) {
			System.out.println(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_53() {
    	    	Boolean withporte = false;
		ccreator.setWithporte(withporte);
                          
		assertEquals(withporte,ccreator.isWithporte());
                        
    	    	PortType porttype = PortType.FRANCAISE;
		ccreator.setPorttype(porttype);
                          
		assertEquals(porttype,ccreator.getPorttype());
                        
    	    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_I;
		ccreator.setCaissonMontageType(caissonMontageType);
                          
		assertEquals(caissonMontageType,ccreator.getCaissonMontageType());
                        
    	    	DosType dostype = DosType.DOSINTERIEUR;
		ccreator.setDostype(dostype);
                          
		assertEquals(dostype,ccreator.getDostype());
                        
    	    	Boolean withseprator = true;
		ccreator.setWithseprator(withseprator);
                          
		assertEquals(withseprator,ccreator.isWithseprator());
                        
    	    	Boolean sepratortransversal = false;
		ccreator.setSepratortransversal(sepratortransversal);
                          
		assertEquals(sepratortransversal,ccreator.isSepratortransversal());
                        
    	    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		ccreator.setSeprationaxe(seprationaxe);
                          
		assertEquals(seprationaxe,ccreator.getSeprationaxe());
                        
    	    	PositionCalculationType positionCalculationtype = PositionCalculationType.FIX;
		ccreator.setPositiontype(positionCalculationtype);
                          
		assertEquals(positionCalculationtype,ccreator.getPositiontype());
                        
    	    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		ccreator.setSepPosRefType(sepPosRefType);
                          
		assertEquals(sepPosRefType,ccreator.getSepPosRefType());
                        
    	    	double sepRetrait = 0;
		ccreator.setSepRetrait(sepRetrait);
                          
		assertEquals(sepRetrait,ccreator.getSepRetrait(),ParametersUtils.epsilon);
                        
    	    	double sepretraitderiere = 50;
		ccreator.setSepretraitderiere(sepretraitderiere);
                          
		assertEquals(sepretraitderiere,ccreator.getSepretraitderiere(),ParametersUtils.epsilon);
                        
    	    	boolean isSepIsometrique = true;
		ccreator.setSeparatorisometrique(isSepIsometrique);
                          
		assertEquals(isSepIsometrique,ccreator.isSeparatorisometrique());
                        
    
		try {
		ccreator.create();

	
		} catch (DesignException e) {
			System.out.println(e.getMessage());
		} catch (GeometricEngineException e) {
			System.out.println(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_54() {
    	    	Boolean withporte = false;
		ccreator.setWithporte(withporte);
                          
		assertEquals(withporte,ccreator.isWithporte());
                        
    	    	PortType porttype = PortType.COLISSANT;
		ccreator.setPorttype(porttype);
                          
		assertEquals(porttype,ccreator.getPorttype());
                        
    	    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		ccreator.setCaissonMontageType(caissonMontageType);
                          
		assertEquals(caissonMontageType,ccreator.getCaissonMontageType());
                        
    	    	DosType dostype = DosType.DOSINTERIEUR;
		ccreator.setDostype(dostype);
                          
		assertEquals(dostype,ccreator.getDostype());
                        
    	    	Boolean withseprator = false;
		ccreator.setWithseprator(withseprator);
                          
		assertEquals(withseprator,ccreator.isWithseprator());
                        
    	    	    	    	    	    	    	    
		try {
		ccreator.create();

	
		} catch (DesignException e) {
			System.out.println(e.getMessage());
		} catch (GeometricEngineException e) {
			System.out.println(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_55() {
    	    	Boolean withporte = false;
		ccreator.setWithporte(withporte);
                          
		assertEquals(withporte,ccreator.isWithporte());
                        
    	    	PortType porttype = PortType.FRANCAISE2H;
		ccreator.setPorttype(porttype);
                          
		assertEquals(porttype,ccreator.getPorttype());
                        
    	    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		ccreator.setCaissonMontageType(caissonMontageType);
                          
		assertEquals(caissonMontageType,ccreator.getCaissonMontageType());
                        
    	    	DosType dostype = DosType.DOSEXTERIEUR;
		ccreator.setDostype(dostype);
                          
		assertEquals(dostype,ccreator.getDostype());
                        
    	    	Boolean withseprator = true;
		ccreator.setWithseprator(withseprator);
                          
		assertEquals(withseprator,ccreator.isWithseprator());
                        
    	    	Boolean sepratortransversal = false;
		ccreator.setSepratortransversal(sepratortransversal);
                          
		assertEquals(sepratortransversal,ccreator.isSepratortransversal());
                        
    	    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		ccreator.setSeprationaxe(seprationaxe);
                          
		assertEquals(seprationaxe,ccreator.getSeprationaxe());
                        
    	    	PositionCalculationType positionCalculationtype = PositionCalculationType.FIX;
		ccreator.setPositiontype(positionCalculationtype);
                          
		assertEquals(positionCalculationtype,ccreator.getPositiontype());
                        
    	    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		ccreator.setSepPosRefType(sepPosRefType);
                          
		assertEquals(sepPosRefType,ccreator.getSepPosRefType());
                        
    	    	double sepRetrait = 50;
		ccreator.setSepRetrait(sepRetrait);
                          
		assertEquals(sepRetrait,ccreator.getSepRetrait(),ParametersUtils.epsilon);
                        
    	    	double sepretraitderiere = 50;
		ccreator.setSepretraitderiere(sepretraitderiere);
                          
		assertEquals(sepretraitderiere,ccreator.getSepretraitderiere(),ParametersUtils.epsilon);
                        
    	    	boolean isSepIsometrique = false;
		ccreator.setSeparatorisometrique(isSepIsometrique);
                          
		assertEquals(isSepIsometrique,ccreator.isSeparatorisometrique());
                        
    
		try {
		ccreator.create();

	
		} catch (DesignException e) {
			System.out.println(e.getMessage());
		} catch (GeometricEngineException e) {
			System.out.println(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_56() {
    	    	Boolean withporte = true;
		ccreator.setWithporte(withporte);
                          
		assertEquals(withporte,ccreator.isWithporte());
                        
    	    	PortType porttype = PortType.FRANCAISE2V;
		ccreator.setPorttype(porttype);
                          
		assertEquals(porttype,ccreator.getPorttype());
                        
    	    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		ccreator.setCaissonMontageType(caissonMontageType);
                          
		assertEquals(caissonMontageType,ccreator.getCaissonMontageType());
                        
    	    	DosType dostype = DosType.DOSEXTERIEUR;
		ccreator.setDostype(dostype);
                          
		assertEquals(dostype,ccreator.getDostype());
                        
    	    	Boolean withseprator = true;
		ccreator.setWithseprator(withseprator);
                          
		assertEquals(withseprator,ccreator.isWithseprator());
                        
    	    	Boolean sepratortransversal = true;
		ccreator.setSepratortransversal(sepratortransversal);
                          
		assertEquals(sepratortransversal,ccreator.isSepratortransversal());
                        
    	    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		ccreator.setSeprationaxe(seprationaxe);
                          
		assertEquals(seprationaxe,ccreator.getSeprationaxe());
                        
    	    	PositionCalculationType positionCalculationtype = PositionCalculationType.FIX;
		ccreator.setPositiontype(positionCalculationtype);
                          
		assertEquals(positionCalculationtype,ccreator.getPositiontype());
                        
    	    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		ccreator.setSepPosRefType(sepPosRefType);
                          
		assertEquals(sepPosRefType,ccreator.getSepPosRefType());
                        
    	    	double sepRetrait = 0;
		ccreator.setSepRetrait(sepRetrait);
                          
		assertEquals(sepRetrait,ccreator.getSepRetrait(),ParametersUtils.epsilon);
                        
    	    	double sepretraitderiere = 50;
		ccreator.setSepretraitderiere(sepretraitderiere);
                          
		assertEquals(sepretraitderiere,ccreator.getSepretraitderiere(),ParametersUtils.epsilon);
                        
    	    	boolean isSepIsometrique = true;
		ccreator.setSeparatorisometrique(isSepIsometrique);
                          
		assertEquals(isSepIsometrique,ccreator.isSeparatorisometrique());
                        
    
		try {
		ccreator.create();

	
		} catch (DesignException e) {
			System.out.println(e.getMessage());
		} catch (GeometricEngineException e) {
			System.out.println(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_57() {
    	    	Boolean withporte = true;
		ccreator.setWithporte(withporte);
                          
		assertEquals(withporte,ccreator.isWithporte());
                        
    	    	PortType porttype = PortType.FRANCAISE2V;
		ccreator.setPorttype(porttype);
                          
		assertEquals(porttype,ccreator.getPorttype());
                        
    	    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_I;
		ccreator.setCaissonMontageType(caissonMontageType);
                          
		assertEquals(caissonMontageType,ccreator.getCaissonMontageType());
                        
    	    	DosType dostype = DosType.DOSEXTERIEUR;
		ccreator.setDostype(dostype);
                          
		assertEquals(dostype,ccreator.getDostype());
                        
    	    	Boolean withseprator = false;
		ccreator.setWithseprator(withseprator);
                          
		assertEquals(withseprator,ccreator.isWithseprator());
                        
    	    	    	    	    	    	    	    
		try {
		ccreator.create();

	
		} catch (DesignException e) {
			System.out.println(e.getMessage());
		} catch (GeometricEngineException e) {
			System.out.println(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_58() {
    	    	Boolean withporte = true;
		ccreator.setWithporte(withporte);
                          
		assertEquals(withporte,ccreator.isWithporte());
                        
    	    	PortType porttype = PortType.COLISSANT;
		ccreator.setPorttype(porttype);
                          
		assertEquals(porttype,ccreator.getPorttype());
                        
    	    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_I;
		ccreator.setCaissonMontageType(caissonMontageType);
                          
		assertEquals(caissonMontageType,ccreator.getCaissonMontageType());
                        
    	    	DosType dostype = DosType.DOSINTERIEUR;
		ccreator.setDostype(dostype);
                          
		assertEquals(dostype,ccreator.getDostype());
                        
    	    	Boolean withseprator = true;
		ccreator.setWithseprator(withseprator);
                          
		assertEquals(withseprator,ccreator.isWithseprator());
                        
    	    	Boolean sepratortransversal = true;
		ccreator.setSepratortransversal(sepratortransversal);
                          
		assertEquals(sepratortransversal,ccreator.isSepratortransversal());
                        
    	    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		ccreator.setSeprationaxe(seprationaxe);
                          
		assertEquals(seprationaxe,ccreator.getSeprationaxe());
                        
    	    	PositionCalculationType positionCalculationtype = PositionCalculationType.POURCENT;
		ccreator.setPositiontype(positionCalculationtype);
                          
		assertEquals(positionCalculationtype,ccreator.getPositiontype());
                        
    	    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		ccreator.setSepPosRefType(sepPosRefType);
                          
		assertEquals(sepPosRefType,ccreator.getSepPosRefType());
                        
    	    	double sepRetrait = 50;
		ccreator.setSepRetrait(sepRetrait);
                          
		assertEquals(sepRetrait,ccreator.getSepRetrait(),ParametersUtils.epsilon);
                        
    	    	double sepretraitderiere = 50;
		ccreator.setSepretraitderiere(sepretraitderiere);
                          
		assertEquals(sepretraitderiere,ccreator.getSepretraitderiere(),ParametersUtils.epsilon);
                        
    	    	boolean isSepIsometrique = true;
		ccreator.setSeparatorisometrique(isSepIsometrique);
                          
		assertEquals(isSepIsometrique,ccreator.isSeparatorisometrique());
                        
    
		try {
		ccreator.create();

	
		} catch (DesignException e) {
			System.out.println(e.getMessage());
		} catch (GeometricEngineException e) {
			System.out.println(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_59() {
    	    	Boolean withporte = false;
		ccreator.setWithporte(withporte);
                          
		assertEquals(withporte,ccreator.isWithporte());
                        
    	    	PortType porttype = PortType.COLISSANT;
		ccreator.setPorttype(porttype);
                          
		assertEquals(porttype,ccreator.getPorttype());
                        
    	    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_I;
		ccreator.setCaissonMontageType(caissonMontageType);
                          
		assertEquals(caissonMontageType,ccreator.getCaissonMontageType());
                        
    	    	DosType dostype = DosType.DOSEXTERIEUR;
		ccreator.setDostype(dostype);
                          
		assertEquals(dostype,ccreator.getDostype());
                        
    	    	Boolean withseprator = true;
		ccreator.setWithseprator(withseprator);
                          
		assertEquals(withseprator,ccreator.isWithseprator());
                        
    	    	Boolean sepratortransversal = false;
		ccreator.setSepratortransversal(sepratortransversal);
                          
		assertEquals(sepratortransversal,ccreator.isSepratortransversal());
                        
    	    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		ccreator.setSeprationaxe(seprationaxe);
                          
		assertEquals(seprationaxe,ccreator.getSeprationaxe());
                        
    	    	PositionCalculationType positionCalculationtype = PositionCalculationType.POURCENT;
		ccreator.setPositiontype(positionCalculationtype);
                          
		assertEquals(positionCalculationtype,ccreator.getPositiontype());
                        
    	    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		ccreator.setSepPosRefType(sepPosRefType);
                          
		assertEquals(sepPosRefType,ccreator.getSepPosRefType());
                        
    	    	double sepRetrait = 0;
		ccreator.setSepRetrait(sepRetrait);
                          
		assertEquals(sepRetrait,ccreator.getSepRetrait(),ParametersUtils.epsilon);
                        
    	    	double sepretraitderiere = 50;
		ccreator.setSepretraitderiere(sepretraitderiere);
                          
		assertEquals(sepretraitderiere,ccreator.getSepretraitderiere(),ParametersUtils.epsilon);
                        
    	    	boolean isSepIsometrique = false;
		ccreator.setSeparatorisometrique(isSepIsometrique);
                          
		assertEquals(isSepIsometrique,ccreator.isSeparatorisometrique());
                        
    
		try {
		ccreator.create();

	
		} catch (DesignException e) {
			System.out.println(e.getMessage());
		} catch (GeometricEngineException e) {
			System.out.println(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_60() {
    	    	Boolean withporte = false;
		ccreator.setWithporte(withporte);
                          
		assertEquals(withporte,ccreator.isWithporte());
                        
    	    	PortType porttype = PortType.FRANCAISE;
		ccreator.setPorttype(porttype);
                          
		assertEquals(porttype,ccreator.getPorttype());
                        
    	    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_I;
		ccreator.setCaissonMontageType(caissonMontageType);
                          
		assertEquals(caissonMontageType,ccreator.getCaissonMontageType());
                        
    	    	DosType dostype = DosType.DOSINTERIEUR;
		ccreator.setDostype(dostype);
                          
		assertEquals(dostype,ccreator.getDostype());
                        
    	    	Boolean withseprator = false;
		ccreator.setWithseprator(withseprator);
                          
		assertEquals(withseprator,ccreator.isWithseprator());
                        
    	    	    	    	    	    	    	    
		try {
		ccreator.create();

	
		} catch (DesignException e) {
			System.out.println(e.getMessage());
		} catch (GeometricEngineException e) {
			System.out.println(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_61() {
    	    	Boolean withporte = false;
		ccreator.setWithporte(withporte);
                          
		assertEquals(withporte,ccreator.isWithporte());
                        
    	    	PortType porttype = PortType.COLISSANT;
		ccreator.setPorttype(porttype);
                          
		assertEquals(porttype,ccreator.getPorttype());
                        
    	    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		ccreator.setCaissonMontageType(caissonMontageType);
                          
		assertEquals(caissonMontageType,ccreator.getCaissonMontageType());
                        
    	    	DosType dostype = DosType.DOSINTERIEUR;
		ccreator.setDostype(dostype);
                          
		assertEquals(dostype,ccreator.getDostype());
                        
    	    	Boolean withseprator = true;
		ccreator.setWithseprator(withseprator);
                          
		assertEquals(withseprator,ccreator.isWithseprator());
                        
    	    	Boolean sepratortransversal = true;
		ccreator.setSepratortransversal(sepratortransversal);
                          
		assertEquals(sepratortransversal,ccreator.isSepratortransversal());
                        
    	    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		ccreator.setSeprationaxe(seprationaxe);
                          
		assertEquals(seprationaxe,ccreator.getSeprationaxe());
                        
    	    	PositionCalculationType positionCalculationtype = PositionCalculationType.FIX;
		ccreator.setPositiontype(positionCalculationtype);
                          
		assertEquals(positionCalculationtype,ccreator.getPositiontype());
                        
    	    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		ccreator.setSepPosRefType(sepPosRefType);
                          
		assertEquals(sepPosRefType,ccreator.getSepPosRefType());
                        
    	    	double sepRetrait = 0;
		ccreator.setSepRetrait(sepRetrait);
                          
		assertEquals(sepRetrait,ccreator.getSepRetrait(),ParametersUtils.epsilon);
                        
    	    	double sepretraitderiere = 50;
		ccreator.setSepretraitderiere(sepretraitderiere);
                          
		assertEquals(sepretraitderiere,ccreator.getSepretraitderiere(),ParametersUtils.epsilon);
                        
    	    	boolean isSepIsometrique = false;
		ccreator.setSeparatorisometrique(isSepIsometrique);
                          
		assertEquals(isSepIsometrique,ccreator.isSeparatorisometrique());
                        
    
		try {
		ccreator.create();

	
		} catch (DesignException e) {
			System.out.println(e.getMessage());
		} catch (GeometricEngineException e) {
			System.out.println(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_62() {
    	    	Boolean withporte = true;
		ccreator.setWithporte(withporte);
                          
		assertEquals(withporte,ccreator.isWithporte());
                        
    	    	PortType porttype = PortType.FRANCAISE2H;
		ccreator.setPorttype(porttype);
                          
		assertEquals(porttype,ccreator.getPorttype());
                        
    	    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		ccreator.setCaissonMontageType(caissonMontageType);
                          
		assertEquals(caissonMontageType,ccreator.getCaissonMontageType());
                        
    	    	DosType dostype = DosType.DOSEXTERIEUR;
		ccreator.setDostype(dostype);
                          
		assertEquals(dostype,ccreator.getDostype());
                        
    	    	Boolean withseprator = true;
		ccreator.setWithseprator(withseprator);
                          
		assertEquals(withseprator,ccreator.isWithseprator());
                        
    	    	Boolean sepratortransversal = false;
		ccreator.setSepratortransversal(sepratortransversal);
                          
		assertEquals(sepratortransversal,ccreator.isSepratortransversal());
                        
    	    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		ccreator.setSeprationaxe(seprationaxe);
                          
		assertEquals(seprationaxe,ccreator.getSeprationaxe());
                        
    	    	PositionCalculationType positionCalculationtype = PositionCalculationType.POURCENT;
		ccreator.setPositiontype(positionCalculationtype);
                          
		assertEquals(positionCalculationtype,ccreator.getPositiontype());
                        
    	    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		ccreator.setSepPosRefType(sepPosRefType);
                          
		assertEquals(sepPosRefType,ccreator.getSepPosRefType());
                        
    	    	double sepRetrait = 0;
		ccreator.setSepRetrait(sepRetrait);
                          
		assertEquals(sepRetrait,ccreator.getSepRetrait(),ParametersUtils.epsilon);
                        
    	    	double sepretraitderiere = 50;
		ccreator.setSepretraitderiere(sepretraitderiere);
                          
		assertEquals(sepretraitderiere,ccreator.getSepretraitderiere(),ParametersUtils.epsilon);
                        
    	    	boolean isSepIsometrique = true;
		ccreator.setSeparatorisometrique(isSepIsometrique);
                          
		assertEquals(isSepIsometrique,ccreator.isSeparatorisometrique());
                        
    
		try {
		ccreator.create();

	
		} catch (DesignException e) {
			System.out.println(e.getMessage());
		} catch (GeometricEngineException e) {
			System.out.println(e.getMessage());
		}
	  
	  
	}
}
