package utils;
public abstract class CompleatbleRunnable implements Runnable{
	
	private volatile boolean locked = true;
	
	@Override
	abstract public void run();

	
	public void waitForComplete() {
		synchronized (this) {
            while (locked) {
                try {
                    wait();
                } catch (InterruptedException e) {
                    Thread.currentThread().interrupt(); // restore interrupt status
                }
            }
        }
	}
	
	public void unlock() {
		synchronized (this) {
			this.locked = false;
			notifyAll();
		}
		

	}

}
