package supercad.graphics;


import com.badlogic.gdx.math.Vector3;
import com.frs.supercad.parametric_model.model.Primitive;

import dressing.mathutils.MathUtilities;
import com.badlogic.gdx.graphics.g3d.utils.MeshPartBuilder;
import com.badlogic.gdx.graphics.g3d.utils.MeshPartBuilder.VertexInfo;
import com.badlogic.gdx.math.Matrix4;

public class Simplex3D implements Primitive {
	

	private Vector3[] positions;
	private Vector3 normal;
	private Matrix4 TBN;
	private final Vertex[] vertices = new Vertex[3];

	
	public Simplex3D(Vertex...vertices) {
		this.vertices[0] = vertices[0];
		this.vertices[1] = vertices[1];
		this.vertices[2] = vertices[2];
	}
	
	public Simplex3D(Vector3...positions) {
		this.positions[0] = positions[0];
		this.positions[1] = positions[1];
		this.positions[2] = positions[2];
	}
	
	public Vector3 getNormal() {
		return normal;
	}

	public void setNormal(Vector3 normal) {
		this.normal = normal;
	}

	public Vertex[] getVertices() {
		return vertices;
	}

	private void calculateVerticesData() {
		calculateNormal();
		calculateTBN();
		int c = 0;
		for(Vector3 position: this.positions) {
			Vertex v = new Vertex();
			v.setPosition(position);
			v.setNormal(normal);
			Vector3 uvw = position.cpy().mul(TBN);
			v.setTextureCoords(uvw.x, uvw.y);
			vertices[c++] = v;
		}
	}


	private void calculateTBN() {
		this.TBN = MathUtilities.calculateTBN(positions[0], positions[0], positions[0], new Vector3());
	}

	private void calculateNormal() {
		this.normal = positions[1].cpy().sub(positions[0]).crs(positions[2].cpy().sub(positions[0])).nor();
	}

	@Override
	public Vertex[] toVertices() {
		if(vertices == null)
			calculateVerticesData();
		return vertices;
	}

	@Override
	public void build(MeshPartBuilder partBuilder) {
		VertexInfo i0 = vertices[0].toVertexInfo();
		VertexInfo i1 = vertices[1].toVertexInfo();
		VertexInfo i2 = vertices[2].toVertexInfo();
		partBuilder.triangle(i0, i1, i2);
	}
	
}
