package gdxapp.screens.wall;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.utils.Array;
import dressing.mathutils.Surface;
import gdxapp.object3d.Object2D;
import gdxapp.object3d.WorldObject;

//this class is responsible for placing actors on the wall
public class SurfaceManager {
	
	// the surface managed by this instance
	private Surface surface;
	//the actors placed on this wall
	private Array<Object2D> actors = new Array<Object2D>();
	//the scale of the stage
	float scaleX, scaleY;
	
	
	public SurfaceManager(SurfaceController controller) {
		update(controller);
	}
	
	public void update(SurfaceController controller) {
		setActors(controller.getAttachedActors());
		this.surface = controller.getSurface();
		this.scaleX = controller.getScales()[0];
		this.scaleY = controller.getScales()[1];
	}
	
	
	public Object2D getNearestActor(Actor actor) {
		Object2D nearest = null;
		for(Object2D actorX : this.actors) {
			if(nearest == null) {
				nearest = actorX;
				continue;
			}
			if(distance(new Vector2(actor.getX(),actor.getY()), new Vector2(actorX.getX(),actorX.getY())) <
					distance(new Vector2(actor.getX(),actor.getY()), new Vector2(nearest.getX(),nearest.getY()))) {
				nearest = actorX;
			}	
		}
		return nearest;
	}
	
	public boolean setArticlePosition(Object2D actor, Vector2 point) {
		float xCoord, yCoord;
		yCoord = point.y;
		xCoord = point.x;
		WorldObject object=actor.getWorldObject();
		if(object.getRealWorldPosition()!=null)
		{
			yCoord=(object.getRealWorldPosition().y - object.getRealWorldDimension().y/2) * scaleY;
		}
		
		actor.setPosition(xCoord,yCoord);
		return true;
	}
	
	public static float distance(Vector2 a, Vector2 b) {
		return (float) Math.sqrt(Math.pow(a.x - b.x, 2) + Math.pow(a.y - b.y, 2));
	}
	
	public boolean willOverlap(Object2D actor) {
		boolean overlap = false;
		for(Object2D actorX : actors) {
			if(actor.overlap(actorX))
				overlap = true;
		}
		return overlap;
	}

	public void addActor(Object2D actor) {
		this.actors.add(actor);
	}
	
	public boolean removeActor(Object2D actor) {
		return actors.removeValue(actor, true);
	}
	
	public Surface getSurface() {
		return surface;
	}

	public void setSurface(Surface surface) {
		this.surface = surface;
	}
	
	

	public void setActors(Array<Object2D> actors) {
		this.actors = actors;
	}

	public Array<Object2D> getActors() {return actors;}


	
}
