package gdxapp.screens.room;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Touchable;

import dressing.mathutils.Edge;
import dressing.mathutils.MathUtilities;
import dressing.mathutils.Surface;
import dressing.model.ProjectManager;
import gdxapp.fabs3d.Quad;
import gdxapp.object3d.Wall;
import gdxapp.screens.wall.WallFragment;
import geometry.Box;

import com.badlogic.gdx.math.Quaternion;

import com.badlogic.gdx.graphics.glutils.ShapeRenderer.ShapeType;

public class SurfaceSelector extends Actor{
	
	private Surface selection;
	private final ArrayList<Surface> surfaces = new ArrayList<Surface>();
	private static SurfaceSelector instance;
	private SurfaceSelectorInputProcessor inputProcessor;
	private ShapeRenderer shapeRenderer;
	
	private SurfaceSelector(){
		setWidth(Gdx.graphics.getWidth());
		setHeight(Gdx.graphics.getHeight());
		setX(0);
		setY(0);
		setTouchable(Touchable.enabled);
		setZIndex(1000);
		inputProcessor = new SurfaceSelectorInputProcessor();
		addListener(inputProcessor);
		setColor(new Color(0,0.5f,0.5f,0.3f));
	}
	
	public static SurfaceSelector getInstance() {
		if(instance == null)
			instance = new SurfaceSelector();
		return instance;
	}
	
	@Override
	public void draw(Batch batch, float parentAlpha) {
		if(shapeRenderer == null)
			shapeRenderer = new ShapeRenderer();
		batch.end();
		shapeRenderer.setProjectionMatrix(batch.getProjectionMatrix());
		shapeRenderer.setColor(getColor());
		shapeRenderer.begin(ShapeType.Filled);
		if(selection != null) {
			Vector3 v0 = selection.getStart().cpy().mul(RoomController.getInstance().getWorldToSceneTransform());
			Vector3 v1 = selection.getEnd().cpy().mul(RoomController.getInstance().getWorldToSceneTransform());
			shapeRenderer.rectLine(v0.x, v0.y, v1.x, v1.y, 10);
		}
			
		shapeRenderer.end();
		batch.begin();
	}


	public Surface selectSurface(Vector2 location) {
		surfaces.clear();
		ArrayList<Wall> walls = ProjectManager.getManager().getCurrentScene().getWalls();
		Vector3 mouse = new Vector3(location, 1).mul(RoomController.getInstance().getSceneToWorldTransform());
		Surface closest = null;
		for(Wall wall: walls) {
			ArrayList<Edge> edges =  wall.getPerimeter().getEdges();
			for(Edge edge: edges) {
				float height = wall.getHeight(), thickness = wall.getThickness();
				WallFragment fragment = ProjectManager.getManager().getCurrentScene().getFragments().get(edge);
				if(fragment != null) {
					height = fragment.getHeight();
					thickness = fragment.getThickness();
				}
				Vector3 start = new Vector3(edge.getV0(),0).mul(RoomController.getInstance().getSceneToWorldTransform());
				Vector3 end = new Vector3(edge.getV1(),0).mul(RoomController.getInstance().getSceneToWorldTransform());
				Vector3 n = end.cpy().sub(start).nor().scl(thickness);
				Quaternion q = new Quaternion(Vector3.Y.cpy(), -90);
				n.mul(q);
				Vector3 v = end.cpy().add(Vector3.Y.cpy().scl(height)).add(n);
				Vector3 center = start.cpy().add(v).scl(0.5f);
				Vector3 dims = new Vector3(end.cpy().sub(start).len(),height,thickness);
				Box box = new Box(center, dims);
				box.setRotation(new Quaternion(Vector3.Y.cpy(), edge.getRotation()));
				box.calculateCorners();
				Surface left = new Surface(box.getCorner000(), box.getCorner011());
				left.setWall(wall);
				Surface right = new Surface(box.getCorner101(), box.getCorner110());
				right.setWall(wall);
				Surface front = new Surface(box.getCorner001(), box.getCorner111());
				front.setWall(wall);
				Surface back = new Surface(box.getCorner100(), box.getCorner010());
				back.setWall(wall);
				surfaces.add(left);
				surfaces.add(right);
				surfaces.add(front);
				surfaces.add(back);
			}
		}
		if(!surfaces.isEmpty()) {
			float closestDistance = Float.POSITIVE_INFINITY;
			for(int i = 0; i < surfaces.size(); i++) {
				Surface surface = surfaces.get(i);
				Vector3 p =  mouse.cpy().mul(surface.getWorldToSurfaceTransform());
				if(p.z < 0 || p.x > surface.getLength() || p.x < 0)
					continue;
				float distance = p.z;
				if(distance < closestDistance) {
					closest = surface;
					closestDistance = distance;
				}
				
			}
		}
		return closest;
	}
	
	



	public Surface getSelection() {
		return selection;
	}

	public void setSelection(Surface selection) {
		this.selection = selection;
	}





	public class SurfaceSelectorInputProcessor extends InputListener{
		final Vector2 location = new Vector2();
		
		@Override
		public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
			location.set(x,y);
			return true;
		}

		@Override
		public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
			selection = selectSurface(location);
		}
	}
}
