package dressing.ui.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;

import com.badlogic.gdx.math.Vector3;

import dressing.model.ModelProvider;
import dressing.model.ProjectManager;
import dressing.ui.engine3d.SceneTexture.CATEGORY;
import dressing.ui.shapedrawer.FinalPage;
import gdxapp.object3d.GeometryObject;
import geometry.CompoundObject;

public class MarbreConfigWizardFormPage extends WizardPage implements PropertyChangeListener , FinalPage {
	
	private FloorSettingFormComposite composite;
	private String description;
	private GeometryObject worldobject;
	

	
	public FloorSettingFormComposite getComposite() {
		return composite;
	}

	public void setComposite(FloorSettingFormComposite composite) {
		this.composite = composite;
	}

	protected MarbreConfigWizardFormPage(String title, CompoundObject geometry) {
		super("");
		setTitle("Créer un Plan de Travail");
		this.worldobject = new GeometryObject();
		geometry.getBorder().setMaterial(ProjectManager.getManager().getCurrentScene().getPreferences().getFloorMtl());
		this.worldobject.setRealWorldDimension(geometry.getRealWorldDimension(0.03f));
		this.worldobject.setRealWorldPosition(new Vector3(0, 0.885f,0));
		this.worldobject.setGeometry(geometry);
		this.worldobject.addPropertyChangeListener(this);
		this.worldobject.setUserData("MARBLE");
	}

	@Override
	public void createControl(Composite parent) {
		composite = new FloorSettingFormComposite(parent, SWT.EMBEDDED,(GeometryObject) worldobject,ModelProvider.getMaterialsByCategory(CATEGORY.MARBLE));
		setControl(composite);
		getWizard().getContainer().updateButtons();

	}
	public void clearlistners() {
		worldobject.removePropertyChangeListener(this);

	}

	@Override
	public boolean isPageComplete() {
		return worldobject.getGeometry().getBorder().getMaterial() != null ;
		
	}

	@Override
	public void propertyChange(PropertyChangeEvent evt) {
		if(isCurrentPage())
		{
			if (MarbreConfigWizardFormPage.this != null) {
				setPageComplete(isPageComplete());
				if (getWizard().getContainer() != null)
					getContainer().updateButtons();
			}
		}
	}

	@Override
	public void onHide() {
		clearlistners();	
		ProjectManager.getManager().getCurrentScene().addActor(worldobject, true);
	}
	

}

