 
package dressing.handlers;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.swt.widgets.Display;

import dressing.ui.preferences.DynamicPreferencesDialog;

public class DynamicPreferencesDialogHandler {
	@Execute
	public void execute() {
		Map<String,String> labels = new HashMap<>();
		// Group labels
		labels.put("superoupe", "Superoupe");
		labels.put("report", "Rapport");
		labels.put("DXF", "DXF");

		// Property labels - superoupe
		labels.put("superoupe.SenseFilInverse", "Sens du fil inversé");
		labels.put("superoupe.VueRainureLine", "Afficher la ligne de rainure");
		labels.put("superoupe.SenseFil", "Sens du fil");
		labels.put("superoupe.addModuleNameToPieceName", "Ajouter le nom du module au nom de la pièce");
		labels.put("superoupe.addelementNameToPieceName", "Ajouter le nom de l’élément au nom de la pièce");
		labels.put("superoupe.isABVName", "Utiliser l’abréviation pour le nom");
		labels.put("superoupe.caissonNameReplacers", "Remplacer les noms de caisson (clé→valeur)");
		labels.put("superoupe.isABVCaissonName", "Utiliser l’abréviation pour les noms de caisson");
		labels.put("superoupe.addappartmentNameToPieceName", "Ajouter le nom d’appartement au nom de la pièce");
		labels.put("superoupe.addCaissonNameToPieceName", "Ajouter le nom du caisson au nom de la pièce");
		labels.put("superoupe.rainureDepassement", "Dépassement de la rainure (en mm)");
		labels.put("superoupe.predebitchant", "Pré-débit chant");
		labels.put("superoupe.AddArticleIndex", "Ajouter caisson index");

		// Property labels - report
		labels.put("report.showcost", "Afficher le coût");
		labels.put("report.predebitchant", "Pré-débit chant (rapport)");
		labels.put("report.showFakeFaces", "Afficher les fausses façades");
		labels.put("report.quicaillerie", "Afficher les quincailleries");
		labels.put("report.SenseFil", "Sens du fil (rapport)");
		labels.put("report.showFacades", "Afficher les façades");
		labels.put("report.showPieces", "Afficher les pièces");
		labels.put("report.accessoire", "Afficher les accessoires");
		labels.put("report.showSVGPiece", "Afficher la pièce SVG");
		labels.put("report.SenseFilInverse", "Sens du fil inversé (rapport)");

		// Property labels - DXF
		labels.put("DXF.AssembleRainure", "Assembler les rainures");
		labels.put("DXF.VueRainureLine", "Afficher la ligne de rainure (DXF)");
		labels.put("DXF.RotatepiecetoFeetMachine", "Rotation pièce selon la machine");
		labels.put("DXF.showLateral", "Afficher les côtés latéraux");
		labels.put("DXF.oriented", "Appliquer l’orientation");
		labels.put("DXF.TrouLateraleRectangle", "Trou latéral rectangulaire");
		labels.put("DXF.reducefaces", "Réduire le nombre de faces");

		DynamicPreferencesDialog dlg =
		    new DynamicPreferencesDialog(Display.getDefault().getActiveShell(), labels);
		dlg.open();
	}
		
}