package org.frs.svg;

import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.GdxNativesLoader;

public class Plane {
		
	private Vector3 point;
	private Vector3 normal;
	
	public Plane(Vector3 point, Vector3 normal) {
		super();
		this.point = point;
		this.normal = normal;
	}
	
	public Plane(Vector3 v0, Vector3 v1, Vector3 v2) {
		this(v0, v1.cpy().sub(v0).crs(v2.cpy().sub(v0)));
	}
	
	public boolean contains(Vector3 point) {
		return Math.abs(point.cpy().sub(this.point).dot(this.normal)) < 0.0001f; 
	}
	

	public Object intersects(Plane other) {
		// planes are parallel
		if(other.getNormal().cpy().crs(normal).len() < 0.001f ) {
			//same plane
			if(other.contains(point))
				return other;
			return null;
		}
		Vector3 N1 = getNormal().nor();
		Vector3 N2 = other.getNormal().nor();
		Vector3 director = N1.cpy().crs(N2);
		Vector3 thirdEquation = new Vector3();
		if(Math.abs(director.dot(Vector3.Z)) > 0.01) {
			thirdEquation.set(0,0,1);
		}else if(Math.abs(director.dot(Vector3.Y)) > 0.01) {
			thirdEquation.set(0,1,0);
		}else {
			thirdEquation.set(1,0,0);
		}
		float[] values = new float[] {
				N1.x, N2.x, thirdEquation.x,
				N1.y, N2.y, thirdEquation.y,
				N1.z, N2.z, thirdEquation.z
		};
		Line intersectionLine = null;
		try {
			Matrix3 M = new Matrix3(values);
			Vector3 R = new Vector3(N1.dot(point), N2.dot(other.getPoint()), 0);
			if (Math.abs(M.det()) < 0.0001f) {
			    return null; // matrix is not invertible, skip
			}
			Vector3 I = R.mul(M.inv());
			intersectionLine = new Line(I, director);
		}catch (Exception e) {
			e.printStackTrace();
		}
		return intersectionLine;
		
	}
	
	
	public boolean equals(Plane other) {
		if(!normal.epsilonEquals(other.normal, 0.0001f) && !normal.epsilonEquals(other.getNormal().cpy().scl(-1), 0.0001f))
			return false;
		return contains(other.getPoint());
	}

	public Vector3 getPoint() {
		return point;
	}

	public void setPoint(Vector3 point) {
		this.point = point;
	}

	public Vector3 getNormal() {
		return normal;
	}

	public void setNormal(Vector3 normal) {
		this.normal = normal;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((normal == null) ? 0 : normal.hashCode());
		result = prime * result + ((point == null) ? 0 : point.hashCode());
		return result;
	}
	
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Plane other = (Plane) obj;
		if (normal == null) {
			if (other.normal != null)
				return false;
		} else if (!normal.equals(other.normal))
			return false;
		if (point == null) {
			if (other.point != null)
				return false;
		} else if (!point.equals(other.point))
			return false;
		return true;
	}

	@Override
	public String toString() {
		return "Plane [point=" + point + ", normal=" + normal + "]";
	}
	
	public static void main(String...strings) {
		Plane p0 = new Plane(new Vector3(5,5,0), new Vector3(0,0,1));
		Plane p1 = new Plane(new Vector3(2,5,5), new Vector3(1,0,0));
		System.out.println(p0.intersects(p1));

	}
	
	
	
}
