package gdxapp.screens.wall;

import java.util.ArrayList;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.Input.Keys;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.math.Vector3;

import dressing.controller.tools.ToolController;
import dressing.mathutils.Vector4;
import dressing.ui.ChangeCommand;
import dressing.ui.CommandStack;
import dressing.ui.MoveCommand;
import dressing.ui.RotateCommand;
import dressing.ui.ScaleCommand;
import gdxapp.Commun.AbstractScreen;
import gdxapp.Commun.GroupSelection;
import gdxapp.object3d.Object2D;
import gdxapp.scenes.Scene;

public class WallActionController implements InputProcessor {
	
	    private final String TAG = WallActionController.class.getName();
	    
	    SurfaceController controller;
	    
	    public WallActionController(SurfaceController controller) {
			super();
			this.controller = controller;
		}
	    
		@Override
		public boolean keyDown(int keycode) {
			// TODO Auto-generated method stub
			return false;
		}


		@Override
		public boolean keyUp(int keycode) {
			boolean isprocessed=false;
	        Object2D selectedActor = null;
	    	try {
	        	selectedActor = (Object2D) GroupSelection.getInstance().getFirstElement();
	    	}catch(Exception e) {
	    		selectedActor = null;
	    	}
	        if(selectedActor != null) {
	        	if(keycode == Input.Keys.Z | keycode == Input.Keys.Q | keycode == Input.Keys.S | keycode == Input.Keys.D){
		        
		        }
		        if(keycode == 11 | keycode == 13 | keycode == 15 | keycode == 9){
		            
		        }
		        if(keycode==Keys.F7) {
	            	 OrthographicCamera camera=	((OrthographicCamera)controller.getUIStage().getCamera());
	         		camera.zoom=1;
	         		camera.setToOrtho(false);
	             }
		        if(Gdx.input.isKeyPressed(Input.Keys.CONTROL_LEFT)||Gdx.input.isKeyPressed(Input.Keys.CONTROL_RIGHT)) {
		        	float oldRotation =selectedActor.getWorldObject().getRotation();
					Vector3 oldPosition=selectedActor.getWorldObject().getRealWorldPosition();
					Vector4 oldDimention=selectedActor.getWorldObject().getObjectDimention();
		    		if(keycode == Keys.F) {
		    			
		    			controller.fitToPlacebySides(selectedActor, controller.getAttachedActors());

		    		}
		    		if(keycode == Keys.G) {
		    			controller.findPlaceByPushSelfX(selectedActor, controller.getAttachedActors());

		    		}
		    		if(keycode == Keys.L) {
		    			controller.fitToPlacebySidesCousins(selectedActor, controller.getAttachedActors(),true,false);

		    		}
		    		if(keycode == Keys.R) {
		    			controller.fitToPlacebySidesCousins(selectedActor, controller.getAttachedActors(),false,false);

		    		}
		    		if(keycode == Keys.L &&(Gdx.input.isKeyPressed(Input.Keys.SHIFT_LEFT)||Gdx.input.isKeyPressed(Input.Keys.SHIFT_RIGHT))) {
		    			controller.fitToPlacebySidesCousins(selectedActor, controller.getAttachedActors(),true,true);

		    		}
		    		if(keycode == Keys.R&&(Gdx.input.isKeyPressed(Input.Keys.SHIFT_LEFT)||Gdx.input.isKeyPressed(Input.Keys.SHIFT_RIGHT))) {
		    			controller.fitToPlacebySidesCousins(selectedActor, controller.getAttachedActors(),false,true);

		    		}
		    		if(keycode == Keys.C) {
		    			controller.fitToPlacebyCousin(selectedActor, controller.getAttachedActors());

		    		}if(keycode == Keys.P) {
		    			controller.findPlaceByPushBrothers(selectedActor, controller.getAttachedActors());

		    		}
		    		CommandStack command =new CommandStack("change from wall assist", "change from window", new ArrayList<ChangeCommand>());
		    		float newRotation =selectedActor.getWorldObject().getRotation();
					Vector3 newPosition=selectedActor.getWorldObject().getRealWorldPosition();
					Vector4 newDimention=selectedActor.getWorldObject().getObjectDimention();
		    		if(newRotation!=oldRotation) {
		    			RotateCommand rotate =new RotateCommand("rotate "+ selectedActor.getWorldObject().getName(), "rotate", selectedActor.getWorldObject(), oldRotation, newRotation);
		    			command.addCommand(rotate);
		    		}
		    		if(!newPosition.epsilonEquals(oldPosition, 0.0000001f))
		    		{
		    			MoveCommand move =new MoveCommand("move "+selectedActor.getWorldObject(), "move",  oldPosition, newPosition,selectedActor.getWorldObject());
		    			command.addCommand(move);
		    		}
		    		if(!newDimention.epsilonEquals(oldDimention, 0.0000001f))
		    		{
		    			ScaleCommand scale= new ScaleCommand("move "+selectedActor.getWorldObject().getName(), "move",  oldDimention, newDimention,selectedActor.getWorldObject());
		    			command.addCommand(scale);
		    		}
		    		if( command.getStack()!=null && command.getStack().size()>0)
					{
						if(((AbstractScreen) Scene.game.getScreen()).getController().getChangeCommandController()!=null)
						{
							((AbstractScreen) Scene.game.getScreen()).getController().getChangeCommandController().addCommand(command);
						}
						isprocessed = true;
					}
		    	}
//		        if(keycode == Keys.FORWARD_DEL){
//		        	CommandStack stack =new CommandStack("remove elements", "remove elements", new ArrayList<ChangeCommand>());
//	    			ArrayList<Object> selection=GroupSelection.getInstance().getSelection();
//			    	if(GroupSelection.getInstance()!=null &&selection!=null && selection.size()>0)
//			    	{
//			    		Scene scene= ProjectManager.instance.getCurrentScene();
//
//			    		for(int i=selection.size()-1;i>=0;i--) {
//		    				Object object=selection.get(i);
//			    			if(object !=null && object instanceof Object2D) {
//			    				Object2D object2d=(Object2D)object;
//			    				ProjectManager.instance.getCurrentScene().removeWorldObject(object2d.getWorldObject());
//					            controller.actorsLayer.removeActor(object2d,true);
//					            controller.stage.getActors().removeValue(object2d, true);
//					            controller.attachedActors.removeValue(object2d, true);
//					            boolean result = controller.wallSpaceManager.getActors().removeValue(object2d, true);
//					            result &= result;
//					            RemoveObjectCommand command=new RemoveObjectCommand("supprimer "+(object2d.getWorldObject()!=null?object2d.getWorldObject().getName():""), "", object2d.getWorldObject(), scene, ProjectManager.getManager().getCurrentKitchen());
//								GroupSelection.getInstance().removeObject(object2d);
//								stack.addCommand(command);
//			    			}
//			    		}	
//			    	}
//		        	if(((AbstractScreen) Scene.game.getScreen()).getController().getChangeCommandController()!=null&& stack.getStack()!=null && stack.getStack().size()>0)
//		            {
//						((AbstractScreen) Scene.game.getScreen()).getController().getChangeCommandController().addCommand(stack);
//		            }
//					isprocessed = true;
//		        }
		     
	        }
	    	if((Gdx.input.isKeyPressed(Input.Keys.CONTROL_LEFT)||Gdx.input.isKeyPressed(Input.Keys.CONTROL_RIGHT)) && keycode == Keys.Z) {
    			((AbstractScreen) Scene.game.getScreen()).getController().getChangeCommandController().undo();
		        
    			isprocessed = true;
    		}
    		if((Gdx.input.isKeyPressed(Input.Keys.CONTROL_LEFT)||Gdx.input.isKeyPressed(Input.Keys.CONTROL_RIGHT)) && keycode == Keys.Y) {
    			((AbstractScreen) Scene.game.getScreen()).getController().getChangeCommandController().redo();
    			
		        isprocessed = true;
    		}
	        return isprocessed;
		}


		@Override
		public boolean keyTyped(char character) {
			// TODO Auto-generated method stub
			return false;
		}


		@Override
		public boolean touchDown(int screenX, int screenY, int pointer, int button) {
			if(ToolController.getInstance().isZOOM()) {
	    		OrthographicCamera camera=	((OrthographicCamera)controller.getUIStage().getCamera());
	    		float zoom=camera.zoom;
	    		Vector3 tp = new Vector3();
	    		int amount=1;
	    		if(button == Input.Buttons.LEFT) {
	    			amount=1;
	    		}else if(button == Input.Buttons.RIGHT) {
	    			amount=-1;
	    		}
	    		if(zoom<=0.22f ) {
	    			camera.zoom=0.2f;
	    			if(amount<0) {
	    				amount=0;
	    			}
				}
	    		if(zoom>=4.9f ) {
	    			camera.zoom=5.0f;
	    			if(amount>0) {
	    				amount=0;
	    			}
				}
	    		camera.unproject(tp.set(Gdx.input.getX(), Gdx.input.getY(), 0));
				float px = tp.x;
				float py = tp.y;
				camera.zoom +=amount*  0.2f;
				camera.update();
	    		camera.unproject(tp.set(Gdx.input.getX(), Gdx.input.getY(), 0));
				camera.position.add(px - tp.x, py - tp.y, 0);
//				camera.position.set(tp);
				camera.update();
				return true;
	    	}
	        return false;
		}


		@Override
		public boolean touchUp(int screenX, int screenY, int pointer, int button) {
			// TODO Auto-generated method stub
			return false;
		}


		@Override
		public boolean touchDragged(int screenX, int screenY, int pointer) {
			// TODO Auto-generated method stub
			return false;
		}


		@Override
		public boolean mouseMoved(int screenX, int screenY) {
			// TODO Auto-generated method stub
			return false;
		}


		@Override
		public boolean scrolled(int amount) {
			if(Gdx.input.isKeyPressed(Input.Keys.CONTROL_LEFT)||ToolController.getInstance().isZOOM()) {
	    		OrthographicCamera camera=	((OrthographicCamera)controller.getUIStage().getCamera());
	    		float zoom=camera.zoom;
	    		Vector3 tp = new Vector3();
	    		if(zoom<=0.2f ) {
	    			camera.zoom=0.2f;
	    			if(amount<0) {
	    				amount=0;
	    			}
				}
	    		if(zoom>=5.0f ) {
	    			camera.zoom=5.0f;
	    			if(amount>0) {
	    				amount=0;
	    			}
				}
	    		if(zoom>=0.2f && zoom<=5.0f )
	    		{   			

					//
					camera.unproject(tp.set(Gdx.input.getX(), Gdx.input.getY(), 0));
					float px = tp.x;
					float py = tp.y;
					camera.zoom += amount * 0.2f;
					camera.update();

					camera.unproject(tp.set(Gdx.input.getX(), Gdx.input.getY(), 0));
					camera.position.add(px - tp.x, py - tp.y, 0);
					camera.update();
					return true;
					//

	    		}
	    		return true;
	    	}
	        return false;
		}

}
