package gdxapp.screens.wall;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.math.Vector3;

import dressing.mathutils.Surface;
import dressing.model.ProjectManager;
import gdxapp.Commun.AbstractScreen;
import gdxapp.Commun.GroupSelection;
import gdxapp.Commun.ScreenController;
import gdxapp.object3d.Wall;
import gdxapp.scenes.Scene;
import gdxapp.scenes.SceneEvent;
import gdxapp.screens.room.RoomController;

public class SurfaceScreen extends AbstractScreen {

	SurfaceController controller;
	


	public SurfaceScreen(Surface surface) {
		super();
		ProjectManager.instance.getCurrentScene().getSurfaceScreens().add(this);
		controller = new SurfaceController(surface);
	}

	@Override
	public void show() {
		Gdx.input.setInputProcessor(controller.getInputMultiplexer());
		GroupSelection.getInstance().clearSelection();
		controller.reloadActors();
		controller.getChangeCommandController().clear();
		controller.setHandleEvent(true);
	}

	@Override
	public void render(float delta) {
		try {
			Gdx.gl20.glClearColor(1f, 1f, 1f, 1);
			Gdx.gl.glClear(GL20.GL_COLOR_BUFFER_BIT | GL20.GL_DEPTH_BUFFER_BIT
					| (Gdx.graphics.getBufferFormat().coverageSampling ? GL20.GL_COVERAGE_BUFFER_BIT_NV : 0));
			controller.getUIStage().act();
			Gdx.gl.glActiveTexture(GL20.GL_TEXTURE0);// This is required by the SpriteBatch!!
			controller.getUIStage().draw();
			controller.drawPipes();
		}catch (Exception e) {
			e.printStackTrace();
			if(controller.getUIStage().getBatch().isDrawing())
				controller.getUIStage().getBatch().end();
			controller.init();
			controller.reloadActors();
		}
	}

	@Override
	public void resize(int width, int height) {
		controller.getUIStage().getViewport().update(width, height, true);
		controller.resize();
	}

	@Override
	public void pause() {
		// TODO Auto-generated method stub

	}

	@Override
	public void resume() {
		// TODO Auto-generated method stub

	}

	@Override
	public void hide() {
		this.controller.setActorsRealWorldPosition();
		controller.getAttachedActors().clear();
		controller.getChangeCommandController().clear();
		controller.setHandleEvent(false);
	}

	@Override
	public void dispose() {
		controller.dispose();
	}

	@Override
	public ScreenController getController() {
		return controller;
	}

	@Override
	public Vector3 toWorldCoordiantes(Vector3 screenCoords) {
		return controller.getSurface().toWorldCoords(screenCoords);
	}

}
