package gdxapp.object3d;

import java.util.ArrayList;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer.ShapeType;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;

import dressing.mathutils.EarClipper;
import dressing.mathutils.Edge;
import dressing.mathutils.MathUtilities;
import dressing.mathutils.Triangle;
import gdxapp.Commun.GroupSelection;
import gdxapp.assets.DrawingHelper;
import gdxapp.screens.room.RoomController;
import geometry.CompoundShape;

//this actor only exists in RoomScreen
public class Plinth extends Object2D{
	
	private CompoundShape geomtery;
	private float height;
	private float thickness;
	private ArrayList<Vector2> vertices;
	private ArrayList<Vector2> borderVertices;
	private transient ArrayList<Triangle> triangles;
	
	
	long time = 0;
	private PlinthObject plinthObject;
	
	
	public Plinth(PlinthObject plinthObject) {
		super();
		this.plinthObject = plinthObject;
		transformPlinth2D();
	   
	   this.eventListener = new Object2DEventProcessor(this);
	   addListener(eventListener);
	}
	private void transformPlinth2D() {
		Vector3 albedo = plinthObject.getGeometry().getBorder().getMaterial().getAlbedo();
		if(albedo == null)
			albedo = new Vector3();
	    float[] color = new float[] {albedo.x, albedo.y, albedo.z};
	    setColor(color[0], color[1], color[2],1);
	    this.thickness = RoomController.getInstance().getScaleX() * plinthObject.getThickness();
	    
	   ArrayList<Vector2> vertices = new ArrayList<Vector2>();
	   Matrix4 worldTransform = plinthObject.getGeometry().getWorldTransform();
	   for(Vector2 vertex: plinthObject.getGeometry().getBorder().getVertices()) {
		   Vector3 vertex3D = new Vector3(vertex,0).mul(worldTransform.cpy()).mul(RoomController.getInstance().getWorldToSceneTransform());
		   vertices.add(new Vector2(vertex3D.x, vertex3D.y));
	   }
	   
	   borderVertices = MathUtilities.calculateRectangulairLine(vertices, this.thickness/2);
	   Vector2[] boundaries = MathUtilities.getBoundariesPlane(borderVertices);
	   setX(boundaries[0].x);
	   setY(boundaries[0].y);
	   setWidth(boundaries[1].cpy().sub(boundaries[0]).x);
	   setHeight(boundaries[1].cpy().sub(boundaries[0]).y);
	   triangles = EarClipper.triangulate(borderVertices, new ArrayList<Vector2>());
	}
	public void geometryChanged() {
		plinthObject.getGeometry().getBorder().calculateProperties();
		transformPlinth2D();
		getWorldObject().setRequireRefrech(true);
	}
	
	@Override
	public ArrayList<Edge> calculateEdges() {
		edges.clear();
		edges.addAll(plinthObject.getGeometry().getBorder().getEdges());		
		return edges;
	}
	
	@Override
	public void draw(Batch batch, float parentAlpha) {
		time += parentAlpha;
		batch.end();
		DrawingHelper.getDebugRenderer().setProjectionMatrix(batch.getProjectionMatrix());
		float color = 0;
		if(GroupSelection.getInstance().getSelection().contains(this)) {
			color = (float) Math.abs(Math.sin(0.1f * time));
		}
		getColor().set(color, color ,0, 1.0f);
		DrawingHelper.getDebugRenderer().setColor(getColor());
		DrawingHelper.getDebugRenderer().begin(ShapeType.Filled);
		for(int i = 0; i < borderVertices.size(); i++) {
			DrawingHelper.getDebugRenderer().rectLine(borderVertices.get(i), borderVertices.get((i+1)%borderVertices.size()), 1);
		}
		DrawingHelper.getDebugRenderer().end();
		batch.begin();
	}
	
	@Override
	public Actor hit(float x, float y, boolean touchable) {

		if (touchable && this.getTouchable() != Touchable.enabled) return null;
		if (!isVisible()) return null;
		Actor hit = null;
		Vector2 point = new Vector2(x,y).add(getX(), getY());
		for(Triangle triangle: triangles) {
			if(triangle.contains(point)) {
				hit = this;
				break;
			}
		}
		return hit;
	}
	
	

	@Override
	protected void positionChanged() {
		
	}


	public CompoundShape getGeomtery() {
		return geomtery;
	}

	public void setGeomtery(CompoundShape geomtery) {
		this.geomtery = geomtery;
	}

	public float getHeight() {
		return height;
	}

	public void setHeight(float height) {
		this.height = height;
	}

	public PlinthObject getPlinthObject() {
		return plinthObject;
	}

	public void setPlinthObject(PlinthObject plinthObject) {
		this.plinthObject = plinthObject;
	}

	public float getThickness() {
		return thickness;
	}

	public void setThickness(float thickness) {
		this.thickness = thickness;
	}

	@Override
	public <T extends WorldObject> T getWorldObject() {
		return (T) this.plinthObject;
	}
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
}
