package dressing.ui.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;

import com.badlogic.gdx.math.Vector3;

import dressing.events.Event;
import dressing.events.EventDriver;
import dressing.ui.util.ColorComposite;
import gdxapp.object3d.PlinthObject;
import gdxapp.scenes.SceneEvent;

import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;

public class SocleSettingComposite extends Composite{

	private PlinthObject plinthObject;
	private float initialHeight;
	private float initialThickness;
	private Vector3 initialColor;
	private Runnable onFinish;
	
	
	PropertyChangeListener colorListener = new PropertyChangeListener() {
		
		@Override
		public void propertyChange(PropertyChangeEvent evt) {
				RGB rgb = (RGB) evt.getNewValue();
				Vector3 albedo = new Vector3(rgb.red / 255.0f, rgb.green/255.0f,rgb.blue / 255.0f);
				if(plinthObject != null) {
					plinthObject.getGeometry().getBorder().getMaterial().setAlbedo(albedo);
					EventDriver.getDriver().deliverEvent(new Event(SceneEvent.OBJECT_CHANGED.name(), plinthObject));
				}
				
		}
	};

	public SocleSettingComposite(Composite parent, int style, PlinthObject plinthObject, Runnable onFinish) {
		super(parent, style);
		this.plinthObject = plinthObject;
		this.onFinish = onFinish;
		saveInitialValue();
		setLayout(new GridLayout(2, false));
		
		Label lblHauteur = new Label(this, SWT.NONE);
		lblHauteur.setText("Hauteur: ");
		
		Spinner spinner = new Spinner(this, SWT.BORDER);
		spinner.setMaximum(2500);
		spinner.setMinimum(10);
		spinner.setSelection(Math.round(plinthObject.getHeight() * 1000));
		spinner.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				float height = spinner.getSelection()/1000.0f;
				plinthObject.setHeight(height);
				EventDriver.getDriver().deliverEvent(new Event(SceneEvent.OBJECT_CHANGED.name(), plinthObject));
			}
		});
		spinner.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Label lblEpaisseur = new Label(this, SWT.NONE);
		lblEpaisseur.setText("Épaisseur: ");
		
		Spinner spinner_1 = new Spinner(this, SWT.BORDER);
		spinner_1.setMinimum(10);
		spinner_1.setMaximum(2500);
		spinner_1.setSelection(Math.round(plinthObject.getThickness() * 1000));
		spinner_1.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				plinthObject.setThickness(spinner_1.getSelection() / 1000.0f);
				EventDriver.getDriver().deliverEvent(new Event(SceneEvent.OBJECT_CHANGED.name(), plinthObject));
			}
		});
		spinner_1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Label lblCouleur = new Label(this, SWT.NONE);
		lblCouleur.setText("Couleur: ");
		
		ColorComposite colorComposite = new ColorComposite(this, SWT.NONE);
		colorComposite.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		colorComposite.addColorListener(this.colorListener);
		
		colorComposite.setColor(plinthObject.getGeometry().getBorder().getMaterial().getAlbedo());
		
		Composite composite = new Composite(this, SWT.NONE);
		composite.setLayout(new GridLayout(2, false));
		composite.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
		
		Button btnAnnuler = new Button(composite, SWT.NONE);
		btnAnnuler.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				cancel();
			}
		});
		btnAnnuler.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, true, false, 1, 1));
		btnAnnuler.setBounds(0, 0, 90, 30);
		btnAnnuler.setText("Annuler");
		
		Button btnModifier = new Button(composite, SWT.NONE);
		btnModifier.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				modify();
			}
		});
		btnModifier.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, true, false, 1, 1));
		btnModifier.setText("Modifier");
	}
	
	public void saveInitialValue() {
		this.initialHeight = plinthObject.getHeight();
		this.initialThickness = plinthObject.getThickness();
		this.initialColor = plinthObject.getGeometry().getBorder().getMaterial().getAlbedo();
	}
	
	void cancel() {
		if(changed()) {
			plinthObject.setHeight(initialHeight);
			plinthObject.setThickness(initialThickness);
			plinthObject.getGeometry().getBorder().getMaterial().setAlbedo(initialColor);
			plinthObject.setRequireRefrech(true);
			EventDriver.getDriver().deliverEvent(new Event(SceneEvent.OBJECT_CHANGED.name(), plinthObject));
		}
		if(onFinish != null)
			onFinish.run();
	}
	
	void modify() {
		if(changed()) {
			plinthObject.setRequireRefrech(true);
			EventDriver.getDriver().deliverEvent(new Event(SceneEvent.OBJECT_CHANGED.name(), plinthObject));
		}
		if(onFinish != null)
			onFinish.run();
	}
	
	public boolean changed() {
		boolean changed = Math.abs(initialHeight - plinthObject.getHeight())> 0.001;
		changed |= Math.abs(initialHeight - plinthObject.getHeight())> 0.001;
		changed |= !initialColor.epsilonEquals(plinthObject.getColor(), 0.001f);
		return changed;
	}
}
