package gdxapp.screens.room;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

import org.apache.lucene.search.TopScoreDocCollector;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.Input.Keys;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.box2d.BodyDef.BodyType;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.utils.BufferUtils;

import dressing.controller.tools.ToolController;
import dressing.events.EventDriver;
import dressing.mathutils.Edge;
import dressing.model.ProjectManager;
import dressing.ui.AddObjectCommand;
import dressing.ui.ChangeCommand;
import dressing.ui.ChangeCommandController;
import dressing.ui.CommandStack;
import dressing.ui.RemoveObjectCommand;
import dressing.ui.util.MesureWidow;
import gdxapp.DressingRoomApp;
import gdxapp.Commun.AbstractScreen;
import gdxapp.Commun.ActionProcessor;
import gdxapp.Commun.GroupSelection;
import gdxapp.Commun.MeasuresTaker;
import gdxapp.Commun.Preferences;
import gdxapp.assets.DrawingHelper;
import gdxapp.assets.ModelExporter;
import gdxapp.object3d.WorldObject;
import gdxapp.quotation.Quotation.QuotationDisplayMode;
import gdxapp.object3d.DesignModelFactory;
import gdxapp.object3d.GeometryObject;
import gdxapp.object3d.KitchenElement;
import gdxapp.object3d.Object2D;
import gdxapp.object3d.PolygonBuilder;
import gdxapp.object3d.Wall;
import gdxapp.scenes.Scene;
import gdxapp.scenes.SceneEvent;
import gdxapp.screens.modelviewer.ViewerScreen;
import gdxapp.screens.room3d.Room3DController;
import gdxapp.tests.TestScreen;
import gdxapp.zoneselector.ZoneSelector;



public class ActionController implements InputProcessor{
	
	private static final String TAG = ActionController.class.getName();

    public static Wall selectedWall = null;
    private Object2D selectedActor = null;
    private ArrayList<Vector3> points = new ArrayList<Vector3>();
    public static Edge measurement = null;
    Vector2 temporaryVertice;
    ArrayList<Vector2> vertices;
    
    @Override
    public boolean keyDown(int keycode) {
    	if(Gdx.input.isKeyPressed(Input.Keys.CONTROL_LEFT)) {
//    		if(keycode == Keys.T) {
//    			Scene.game.setScreen(new TestScreen());
//    		}
    	}
    	if(Gdx.input.isKeyPressed(Input.Keys.CONTROL_LEFT)||Gdx.input.isKeyPressed(Input.Keys.CONTROL_RIGHT)) {
    		if(keycode == Input.Keys.Z) {
    			((AbstractScreen) Scene.game.getScreen()).getController().getChangeCommandController().undo();
    		}
        }
        if(Gdx.input.isKeyPressed(Input.Keys.CONTROL_LEFT)||Gdx.input.isKeyPressed(Input.Keys.CONTROL_RIGHT)) {
        	if(keycode == Input.Keys.Y) {
        		((AbstractScreen) Scene.game.getScreen()).getController().getChangeCommandController().redo();	
        	}
        }
     
        return false;
    }

    @Override
    public boolean keyUp(int keycode) {
    	Gdx.app.debug(TAG, "key up");
    	try {
        	selectedActor = (Object2D) GroupSelection.getInstance().getFirstElement();
    	}catch(Exception e) {
    		selectedActor = null;
    	}
    	if (selectedActor!=null && (Gdx.input.isKeyPressed(Keys.SHIFT_LEFT) || Gdx.input.isKeyPressed(Keys.SHIFT_RIGHT))) {
			if (keycode == Keys.R) {
				selectedActor.adjustRotation();
				return true;
			}else if (keycode == Keys.P) {
				selectedActor.adjustPosition();
				return true;
			}
		}
    	
         if(keycode == Keys.CONTROL_LEFT && ToolController.getInstance().isDRAW_ROOM_POLYGONE()) {
        	 if(RoomController.getInstance().polygon != null) {
 //       		RoomController.getInstance().polygon.setTempVertex(null);
        	 }
        	 if(GroupSelection.getInstance().getSelection() != null)
        		 GroupSelection.getInstance().clearSelection();
        		return true;
         }

         if(keycode == Keys.F1) {
			ActionProcessor.getProcessor().setShowTop(!ActionProcessor.getProcessor().isShowTop());
			return true;
         }
         if(keycode == Keys.F2) {
        	 ActionProcessor.getProcessor().setShowBottom(!ActionProcessor.getProcessor().isShowBottom());
        	 return true;
         }
         if(keycode == Keys.F3) {
        	 ActionProcessor.getProcessor().setShowColonne(!ActionProcessor.getProcessor().isShowColonne());
        	 return true;
         }
         if(keycode == Keys.F12) {
        	 ActionProcessor.getProcessor().setShowInnerQuotations(!ActionProcessor.isShowInnerQuotations());
        	 return true;
         }
         if(keycode == Keys.F11) {
        	 ActionProcessor.getProcessor().setShowOuterQuotations(!ActionProcessor.isShowOuterQuotations());
        	 return true;
         }
         if(keycode == Keys.D) {
        	 RoomController.getInstance().setDebugEdges(false);
         }
         if(keycode==Keys.F7) {
        	 OrthographicCamera camera=	((OrthographicCamera)RoomController.getInstance().stage.getCamera());
     		camera.zoom=1;
     		camera.setToOrtho(false);
         }
   
    	return false;
    }

    @Override
    public boolean keyTyped(char character) {
        return false;
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
    	
    	if(ToolController.getInstance().isZOOM()) {
    		OrthographicCamera camera=	((OrthographicCamera)RoomController.getInstance().stage.getCamera());
    		float zoom=camera.zoom;
    		Vector3 tp = new Vector3();
    		int amount=1;
    		if(button == Input.Buttons.LEFT) {
    			amount=1;
    		}else if(button == Input.Buttons.RIGHT) {
    			amount=-1;
    		}
    		if(zoom<=0.22f ) {
    			camera.zoom=0.5f;
    			if(amount<0) {
    				amount=0;
    			}
			}
    		if(zoom>=4.9f ) {
    			camera.zoom=5.0f;
    			if(amount>0) {
    				amount=0;
    			}
			}
    		Vector3 pointOnScreen = camera.unproject(tp.set(Gdx.input.getX(), Gdx.input.getY(), 0));
			float px = tp.x;
			float py = tp.y;
			camera.zoom +=amount*  0.2f;
			camera.update();
    		camera.unproject(tp.set(Gdx.input.getX(), Gdx.input.getY(), 0));
			camera.position.add(px - tp.x, py - tp.y, 0);
//			camera.position.set(tp);
			camera.update();
			return true;
    	}
    	
    	if(button == Input.Buttons.RIGHT) {
			HashMap<String, Object> eventData = new HashMap<>();
			eventData.put("location", new Vector3(screenX ,RoomController.getInstance().getUIStage().getHeight() - screenY, 0));
			eventData.put("source", RoomController.TOP_VIEW);
			dressing.events.Event sceneEvent = new dressing.events.Event(SceneEvent.OBJECT_RIGHT_CLICK.name(), eventData);
			EventDriver.getDriver().deliverEvent(sceneEvent);
			return true;
		}else {
			dressing.events.Event sceneEvent = new dressing.events.Event(SceneEvent.VOID_CLICK.name(), "");
			EventDriver.getDriver().deliverEvent(sceneEvent);
		}
        return false;
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, int button) {

        return false;
    }

    @Override
    public boolean touchDragged(int screenX, int screenY, int pointer) {
//    	Vector2 stageCoords = RoomController.getInstance().stage.screenToStageCoordinates(new Vector2(screenX, screenY));
//    	ZoneSelector.getSelector().setTemporaryZoneEnd(stageCoords);
//    	ZoneSelector.getSelector().update();
        return false;
    }

    @Override
    public boolean mouseMoved(int screenX, int screenY) {
    
        return false;
    }

    @Override
    public boolean scrolled(int amount) {
    	if(Gdx.input.isKeyPressed(Input.Keys.CONTROL_LEFT)||ToolController.getInstance().isZOOM()) {
    		OrthographicCamera camera=	((OrthographicCamera)RoomController.getInstance().stage.getCamera());
    		float zoom=camera.zoom;
    		Vector3 tp = new Vector3();
    		if(zoom<=0.2f ) {
    			camera.zoom=0.2f;
    			if(amount<0) {
    				amount=0;
    			}
			}
    		if(zoom>=5.0f ) {
    			camera.zoom=5.0f;
    			if(amount>0) {
    				amount=0;
    			}
			}
    		if(zoom>=0.2f && zoom<=5.0f )
    		{   			
				//
				camera.unproject(tp.set(Gdx.input.getX(), Gdx.input.getY(), 0));
				float px = tp.x;
				float py = tp.y;
				camera.zoom += amount * 0.2f;
				camera.update();
				camera.unproject(tp.set(Gdx.input.getX(), Gdx.input.getY(), 0));
				camera.position.add(px - tp.x, py - tp.y, 0);
				camera.update();
				return true;
				//
    		}
    		return true;
    	}
        return false;
    }
}
