package gdxapp.object3d;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.frs.svg.LineSegment;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.collision.BoundingBox;
import gdxapp.fabs3d.Quad;
import groovyjarjarantlr.collections.impl.Vector;

public class RotatedBoundingBox extends BoundingBox {
	
	private static final long serialVersionUID = 1L;
	
	private Matrix4 transform = new Matrix4();

	public RotatedBoundingBox() {
		super();
	}
	
	public RotatedBoundingBox(BoundingBox boundingBox) {
		super(boundingBox);
	}

	@Override
	public Vector3 getCorner000(Vector3 out) {
		return super.getCorner000(out).mul(transform);
	}

	@Override
	public Vector3 getCorner001(Vector3 out) {
		return super.getCorner001(out).mul(transform);
	}

	@Override
	public Vector3 getCorner010(Vector3 out) {
		return super.getCorner010(out).mul(transform);
	}

	@Override
	public Vector3 getCorner011(Vector3 out) {
		return super.getCorner011(out).mul(transform);
	}

	@Override
	public Vector3 getCorner100(Vector3 out) {
		return super.getCorner100(out).mul(transform);
	}

	@Override
	public Vector3 getCorner101(Vector3 out) {
		return super.getCorner101(out).mul(transform);
	}

	@Override
	public Vector3 getCorner110(Vector3 out) {
		return super.getCorner110(out).mul(transform);
	}

	@Override
	public Vector3 getCorner111(Vector3 out) {
		return super.getCorner111(out).mul(transform);
	}

	public Matrix4 getTransform() {
		return transform;
	}

	public void setTransform(Matrix4 transform) {
		this.transform = transform;
	}

	public List<LineSegment> getEdges() {
		ArrayList<LineSegment> edges = new ArrayList<LineSegment>();
		//height cots
		edges.add(new LineSegment(getCorner000(new Vector3()), getCorner010(new Vector3())));
		edges.add(new LineSegment(getCorner100(new Vector3()), getCorner110(new Vector3())));
		edges.add(new LineSegment(getCorner001(new Vector3()), getCorner011(new Vector3())));
		edges.add(new LineSegment(getCorner101(new Vector3()), getCorner111(new Vector3())));
		//width edges
		edges.add(new LineSegment(getCorner000(new Vector3()), getCorner100(new Vector3())));
		edges.add(new LineSegment(getCorner010(new Vector3()), getCorner110(new Vector3())));
		edges.add(new LineSegment(getCorner001(new Vector3()), getCorner101(new Vector3())));
		edges.add(new LineSegment(getCorner011(new Vector3()), getCorner111(new Vector3())));
		////depth edges
		edges.add(new LineSegment(getCorner000(new Vector3()), getCorner001(new Vector3())));
		edges.add(new LineSegment(getCorner010(new Vector3()), getCorner011(new Vector3())));
		edges.add(new LineSegment(getCorner100(new Vector3()), getCorner101(new Vector3())));
		edges.add(new LineSegment(getCorner110(new Vector3()), getCorner111(new Vector3())));
		
		return edges;
	}

	
	public void debug(PrintStream out) {
		out.println("000:" + getCorner000(new Vector3()).toString() );
		out.println("001:" + getCorner001(new Vector3()).toString() );
		out.println("010:" + getCorner010(new Vector3()).toString() );
		out.println("011:" + getCorner011(new Vector3()).toString() );

		out.println("100:" + getCorner100(new Vector3()).toString() );
		out.println("101:" + getCorner101(new Vector3()).toString() );
		out.println("110:" + getCorner110(new Vector3()).toString() );
		out.println("111:" + getCorner111(new Vector3()).toString() );
	}
	
	public List<Vector3> getCorners() {
		ArrayList<Vector3> corners = new ArrayList<Vector3>();
		corners.add(getCorner000(new Vector3()));
		corners.add(getCorner001(new Vector3()));
		corners.add(getCorner010(new Vector3()));
		corners.add(getCorner011(new Vector3()));

		corners.add(getCorner100(new Vector3()));
		corners.add(getCorner101(new Vector3()));
		corners.add(getCorner110(new Vector3()));
		corners.add(getCorner111(new Vector3()));
		return corners;
	}

	public List<Quad> getSides() {
		ArrayList<Quad> sides = new ArrayList<Quad>();
		//left
		sides.add(new Quad("left", getCorner000(new Vector3()), getCorner001(new Vector3()),
				getCorner010(new Vector3()), getCorner011(new Vector3())));
		//right
		sides.add(new Quad("right", getCorner100(new Vector3()), getCorner101(new Vector3()),
				getCorner110(new Vector3()), getCorner111(new Vector3())));
		//top
		sides.add(new Quad("top", getCorner010(new Vector3()), getCorner011(new Vector3()),
				getCorner110(new Vector3()), getCorner111(new Vector3())));
		//bottom
		sides.add( new Quad("bottom",getCorner000(new Vector3()), getCorner001(new Vector3()),
				getCorner100(new Vector3()), getCorner101(new Vector3())));
		//front
		sides.add(new Quad("front", getCorner001(new Vector3()), getCorner011(new Vector3()),
				getCorner101(new Vector3()), getCorner111(new Vector3())));
		//back
		sides.add(new Quad("back",getCorner000(new Vector3()), getCorner010(new Vector3()),
				getCorner100(new Vector3()), getCorner110(new Vector3())));
		
		for(Quad quad: sides)
			System.err.println(quad);
		return sides;
	}
	
	public boolean intersects(RotatedBoundingBox other) {
		debug(System.out);
		for(Quad quad: this.getSides()) {
			for(Quad quadX: other.getSides()) {
				if(quad.scaledCopy(1.7f).intersect(quadX.scaledCopy(1.5f)))
					return true;
			}
		}
		return false;
	}
	
	public static void main(String...strings) {
		float x = -0.01f;
		Quad q0 = new Quad(new Vector3(), new Vector3(1,0,0), new Vector3(1,0,1), new Vector3(0,0,1));
		Quad q1 = new Quad(new Vector3(0,0,x), new Vector3(1,0,x), new Vector3(1,1,x), new Vector3(0,1,x));
		System.out.println(q0.intersect(q1));
	}
	
}
