package gdxapp.ui;

import org.eclipse.swt.widgets.Display;

import com.badlogic.gdx.Input;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Event;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import dressing.controller.tools.ToolController;
import dressing.mathutils.Surface;
import dressing.model.ProjectManager;
import dressing.ui.util.NoteEditorWidow;
import gdxapp.Commun.GroupSelection;
import gdxapp.assets.AssetFont;
import gdxapp.scenes.Scene;
public class Note extends Actor {
	
	private String content;
	private float size;
	private Surface context;
	private transient NoteInputProcessor inputProcessor;
    private static BitmapFont font = AssetFont.getInstance().getSmallFont();
    private boolean isShowContour=true;
	public Note() {
		super();
		inputProcessor = new NoteInputProcessor(this);
		addListener(inputProcessor);
	}
	

	public static Note getDefault() {
		Note note=new Note();
		note.setColor(Color.BLACK);
		note.setContent("");
		note.setSize(18/32f);
		note.calculateSize();

		return note;
	}
	@Override
	public void draw(Batch batch, float parentAlpha) {
		if(content != null) {
			setDebug(isShowContour);		
			AssetFont.getInstance().getLargeFont() .setColor(getColor());
			AssetFont.getInstance().getLargeFont().getData().setScale(size);
			AssetFont.getInstance().getLargeFont().draw(batch, content, getX(), getY() + getHeight());
		}
		
	}
	
	public void setkeyboardFocus() {
		if (getStage() != null){
					getStage().setKeyboardFocus(this);
		}
	}
	
	public void calculateSize() {
		float x=getX();
		float y=getY();
		float h=getHeight();
		float w=getWidth();
		float fontsize=font.getData().scaleX;
		Color fontcolor=font.getColor();
		font.setColor(getColor());
		font.getData().setScale(size);
        GlyphLayout layout = new GlyphLayout(font, content);
        float width = layout.width;
        float height = layout.height;
        setSize(width>15?width:15, height>15?height:15);
        font.setColor(fontcolor);
		font.getData().setScale(fontsize);
	}
	
	
	public String getContent() {
		return content;
	}
	public void setContent(String content) {
		this.content = content;
	}
	public float getSize() {
		return size;
	}
	public void setSize(float size) {
		this.size = size;
	}
	public Surface getContext() {
		return context;
	}
	public void setContext(Surface context) {
		this.context = context;
	}
	
	
	class NoteInputProcessor extends InputListener{
		
		private Note note;
		private final String TAG = NoteInputProcessor.class.getName();
		float tempX, tempY;
		private long lastClickDate = System.currentTimeMillis();

		public NoteInputProcessor(Note note) {
			super();
			this.note = note;
		}

		@Override
		public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
			GroupSelection.getInstance().clearSelection();
			if (note!=null && note.getStage() != null) {
				note.setkeyboardFocus();
			}
			tempX = x;
			tempY = y;
			long newClickDate = System.currentTimeMillis();
			if (newClickDate - lastClickDate < 300 && note != null) {
				Display.getDefault().asyncExec(new Runnable() {
					public void run() {
						NoteEditorWidow window = NoteEditorWidow.getInstance();
						window.setNote(note);
						window.show();
					}
				});
			}
			lastClickDate = newClickDate;
		
			return true;
		}

		@Override
		public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
			
		}

		@Override
		public void touchDragged(InputEvent event, float x, float y, int pointer) {
			note.setX(note.getX() + x - tempX);
			note.setY(note.getY() + y - tempY);

			super.touchDragged(event, x, y, pointer);
		}


		
		
		

		@Override
		public boolean mouseMoved(InputEvent event, float x, float y) {
			
			return true;
		}

		@Override
		public void exit(InputEvent event, float x, float y, int pointer, Actor toActor) {
			System.err.println("zelensky is syn cyka! exit!");
			super.exit(event, x, y, pointer, toActor);
		}

		@Override
		public boolean keyUp(InputEvent event, int keycode) {
			if(keycode == Input.Keys.FORWARD_DEL) {
	    		Scene scene= ProjectManager.instance.getCurrentScene();
				scene.removeNote(note);
				return true;
			}
//			if(keycode == Input.Keys.A) {
//				note.setX(note.getX() - 100);
//				return true;
//			}
			return super.keyUp(event, keycode);
		}

		@Override
		public boolean handle(Event e) {
			if(ToolController.getInstance().isSELECT_Objects()) {
				return super.handle(e);
			}else {
				return false;
			}
		}
		
		
	}
	
	
}
