package gdxapp.screens.ObjectEditor;

import java.nio.FloatBuffer;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.BufferUtils;

public class ScreenUtilities {

	public static float getDepthFromBuffer(int x, int y) {
		FloatBuffer depth = BufferUtils.newFloatBuffer(1);
        Gdx.gl20.glReadPixels(x,  y, 1, 1 , GL20.GL_DEPTH_COMPONENT, GL20.GL_FLOAT, depth);
        return  depth.get(0);
	}
	
	public static Vector3 getRealWorldPoint(int x, int y, Camera camera) {
		float z = ScreenUtilities.getDepthFromBuffer(x, Gdx.graphics.getHeight() - y);
		return camera.unproject(new Vector3(x, y , z));
	}
	
}
