package gdxapp.scenes;


import java.io.File;
import java.util.ArrayList;
import dressing.model.ProjectManager;
import dressing.model.persistence.dpos.Object3D;
import dressing.model.persistence.mappers.MapperProvider;
import gdxapp.Commun.AbstractScreen;
import gdxapp.Commun.Fleche;
import gdxapp.Commun.Measure;
import gdxapp.object3d.WorldObject;

public class SceneManager {
	
	public static SceneManager instance = new SceneManager();
	
	private final ArrayList<Scene> scenes = new ArrayList<>();
	
	private SceneManager() {

	}

	public Scene loadScene(String path) {
		File file = new File(path);
		Scene scene = null;
		if(file.exists()) {
			scene = MapperProvider.getXmlMapper().fromXml(file, Scene.class);
			scene.initAfterRead();
		}
		return scene;
	}
	
	public void loadActors() {
		Scene scene = ProjectManager.getManager().getCurrentScene();
		if(scene.getSceneObjects()==null) {
			scene.setSceneObjects(new ArrayList<WorldObject>());
		}
		ArrayList<Object3D> objects= scene.getObjects();
		for(int i = 0; i < objects.size(); i++) {
			System.err.println(objects.size());
			Object3D object3d=(Object3D) objects.get(i);
			WorldObject wOject= object3d.getWorldActor();
			if(wOject!=null) {
				scene.addActor(wOject,false);
			}
		}

		for( Measure measure:scene.getMeasures()) {
			measure.readObject();
		}
		for( Fleche fleche:scene.getFleches()) {
			fleche.readObject();
		}
		
		scene.update();
		ProjectManager.getManager().getCurrentProject().setLoaded(true);
	}
	
	public void saveScene(Scene scene, String path) {
		File file = new File(path);
		MapperProvider.getXmlMapper().write(scene, file);
	}
	
	public void addSceneInstance(Scene scene) {
		this.scenes.add(scene);
	}
	
	public void clean() {
		
		ArrayList<Scene> sceneToNullify = new ArrayList<Scene>();
		boolean restart;
		do {
			restart = false;
			int c = scenes.size();
			for(int i = 0; i < c; i++) {
				if(scenes.get(i) != ProjectManager.getManager().getCurrentScene()) {
					sceneToNullify.add(scenes.get(i));
					scenes.remove(i);
					restart = true;
					break;
				}
			}
		}while(restart);
		
		for(int i = 0; i < sceneToNullify.size(); i++) {
			sceneToNullify.get(i).clear();
		}
	}
	
	
	public void clearStage() {
		try {
			((AbstractScreen) Scene.game.getScreen()).getController().clear();
		}catch (Exception e) {
			e.printStackTrace();
		}
	}
}
