package gdxapp.fabs3d;

import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.graphics.g3d.utils.ModelBuilder;

public class FacadeCreator {
	
	
	public static  void createFacade(Planche planche,ModelBuilder modelBuilder) {
		
	}

	public static void createSimpleRusticFacade(Planche facade,float horizontalBandHeight, float verticalBandWidth, float innerHeight,
			float innerWidth, Vector3 extrusionDims) {
		//create face side
		Vector3 halfDims = facade.getHalfExtents();
		Vector3[] vertices = new Vector3[16];
		int index = 0;
		//l0
		vertices[index++] = halfDims.cpy().scl(-1,1,0);
		vertices[index++] =halfDims.cpy().scl(-1,-1,0);
		vertices[index++] = halfDims.cpy().scl(1,-1,0);
		vertices[index++] = halfDims.cpy().scl(1,1,0);
		//l1
		Vector3 innerFrame = halfDims.cpy().sub(verticalBandWidth,  horizontalBandHeight,0);
		vertices[index++] = innerFrame.cpy().scl(-1,1,0);
		vertices[index++] =innerFrame.cpy().scl(-1,-1,0);
		vertices[index++] = innerFrame.cpy().scl(1,-1,0);
		vertices[index++] = innerFrame.cpy().scl(1,1,0);
		//l2
		Vector3 extrusionHalfDims = extrusionDims.cpy().scl(0.5f, 0.5f, -1).add(0,0,halfDims.z);
		vertices[index++] = extrusionHalfDims.cpy().scl(-1,1,0);
		vertices[index++] =extrusionHalfDims.cpy().scl(-1,-1,0);
		vertices[index++] = extrusionHalfDims.cpy().scl(1,-1,0);
		vertices[index++] = extrusionHalfDims.cpy().scl(1,1,0);
		//l3
		Vector3 innerDims = new Vector3(innerWidth, innerHeight,0).scl(0.5f);
		vertices[index++] = innerDims.cpy().scl(-1,1,0);
		vertices[index++] =innerDims.cpy().scl(-1,-1,0);
		vertices[index++] = innerDims.cpy().scl(1,-1,0);
		vertices[index++] = innerDims.cpy().scl(1,1,0);		
		//Quads
		Quad[] quads = new Quad[13];
		int counter = 0;
		for(int i =0; i < 3; i++) {
			quads[counter++] = new Quad(vertices[4 * i], vertices[4 * i + 1], vertices[4 * (i + 1) + 1], vertices[4 * (i+1)]);
			quads[counter++] = new Quad(vertices[4 * i + 1], vertices[4 * i + 2], vertices[4 * (i + 1) + 2], vertices[4 * (i+1) + 1]);
			quads[counter++] = new Quad(vertices[4 * i + 2], vertices[4 * i + 3], vertices[4 * (i + 1) + 3], vertices[4 * (i+1) + 2]);
			quads[counter++] = new Quad(vertices[4 * i], vertices[4 * (i + 1)], vertices[4 * (i + 1) + 3], vertices[4 * i + 3]);
		}
		
		
		
	}
}
