package gdxapp.Commun;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import com.badlogic.gdx.graphics.g2d.Batch;
import dressing.mathutils.Surface;
import gdxapp.shapes.FlecheSegment;

public class Fleche implements Serializable{

	public enum Direction {
		START, END,DOUBLE
	}
	public static final int START=0;
	public static final int END=1;
	public static final int DOUBLE=2;
	private static final long serialVersionUID = 1L;
	private transient FlecheSegment flecheSegment;
	private Surface context;
	private int direction;
	private float size=0.0f;
	private LineObject line;
	private transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
	/**
	 * Initializes new dimension line transient fields and reads its properties from
	 * <code>in</code> stream with default reading method.
	 */
	public void readObject(){
		this.propertyChangeSupport = new PropertyChangeSupport(this);
		line.readObject();
		flecheSegment = new FlecheSegment(this.line);
		flecheSegment.setDirection(getDirection());
	}
	public Fleche() {
		super();
		line=new LineObject();
		flecheSegment = new FlecheSegment(this.line);
	}
	/**
	 * Adds the property change <code>listener</code> in parameter to this dimension
	 * line.
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		this.propertyChangeSupport.addPropertyChangeListener(listener);
	}

	/**
	 * Removes the property change <code>listener</code> in parameter from this
	 * dimension line.
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		getPropertyChangeSupport().removePropertyChangeListener(listener);
	}
	public PropertyChangeSupport getPropertyChangeSupport() {
		if(propertyChangeSupport==null) {
			this.propertyChangeSupport = new PropertyChangeSupport(this);
		}
		return propertyChangeSupport;
	}

	public void setPropertyChangeSupport(PropertyChangeSupport propertyChangeSupport) {
		this.propertyChangeSupport = propertyChangeSupport;
	}

	public void addPropertyChangeListener(String propertyName,PropertyChangeListener listener) {
		getPropertyChangeSupport().addPropertyChangeListener(propertyName,
				listener);
	}

	public void removePropertyChangeListener(String propertyName,PropertyChangeListener listener) {
		getPropertyChangeSupport().removePropertyChangeListener(propertyName,listener);
	}

	protected void firePropertyChange(String propertyName, Object oldValue,	Object newValue) {
			getPropertyChangeSupport().firePropertyChange(propertyName, oldValue,
					newValue);
					
	}
	public PropertyChangeListener[] getListeners() {
		
		return	getPropertyChangeSupport().getPropertyChangeListeners();
	}
	public void removeAllLsteners() {
		PropertyChangeListener[] listeners=getListeners();
		if(listeners==null) {
			return;
		}
		for(PropertyChangeListener listener:listeners) {
			getPropertyChangeSupport().removePropertyChangeListener(listener);
		}
	}
	public void updateScale() {
		getFlecheSegment().updateScale();
	}
	
	public FlecheSegment getFlecheSegment() {
		if(flecheSegment == null)
		{
			flecheSegment = new FlecheSegment(this.line);
		}
		return flecheSegment;
	}


	public void setFlecheSegment(FlecheSegment lineSegment) {
		FlecheSegment oldValue =this.flecheSegment;
		this.flecheSegment = lineSegment;
		firePropertyChange("lineSegment", oldValue, this.flecheSegment);
	}


	public int getDirection() {
		return direction;
	}
	public void setDirection(int direction) {
		int oldValue =this.direction;
		this.direction = direction;
		getFlecheSegment().setDirection(direction);
		firePropertyChange("direction", oldValue, this.direction);
	}

	public void draw(Batch batch, float parentAlpha) {
	
		if(getFlecheSegment() != null) {
			updateScale();
			getFlecheSegment().draw(batch, parentAlpha);
		}
	}

	public void setScale(float scale) {
		firePropertyChange("scale", getFlecheSegment().getScale(), scale);
		getFlecheSegment().setScale(scale);

	}

	public Surface getContext() {
		return context;
	}

	public void setContext(Surface context) {
		Surface oldValue =this.context;
		this.context = context;
		firePropertyChange("context", oldValue, this.context);
	}

	public float getSize() {
		return size;
	}

	public void setSize(float size) {
		float oldValue =this.size;
		this.size = size;
		firePropertyChange("size", oldValue, this.size);
	}

	public LineObject getLine() {
		return line;
	}

	public void setLine(LineObject line) {
		LineObject oldValue =this.line;
		this.line = line;
		firePropertyChange("line", oldValue, this.line);
	}
	public Fleche copy() {
		Fleche copy=new Fleche();
		copy.setContext(getContext());
		copy.setFlecheSegment(getFlecheSegment().cpy());
		copy.setLine(getLine().cpy());
		copy.getFlecheSegment().setLine(copy.getLine());
		copy.setDirection(getDirection());
		copy.getFlecheSegment().setDirection(copy.getDirection());
		copy.setSize(getSize());
		return copy;
	}
	
}
