package dressing.config;
import java.io.OutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TimestampedOutputStream extends OutputStream {

    private final OutputStream delegate;
    private final boolean isError;
    private final StringBuilder buffer = new StringBuilder();
    private final SimpleDateFormat timestampFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public TimestampedOutputStream(OutputStream delegate, boolean isError) {
        this.delegate = delegate;
        this.isError = isError;
    }

    @Override
    public void write(int b) throws IOException {
        if (b == '\n') {
            flush();
        } else {
            buffer.append((char) b);
        }
    }

    @Override
    public void flush() throws IOException {
        if (buffer.length() > 0) {
            String timestamp = timestampFormat.format(new Date());
            String prefix = isError ? "[ERROR]" : "[INFO]";
            String line = "[" + timestamp + "] " + prefix + " " + buffer.toString() + "\n";
            delegate.write(line.getBytes());
            buffer.setLength(0);
        }
    }
}