package model.dressing;


import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;

import dressing.controller.DressingCreator;
import dressing.model.Materiaux;
import dressing.model.ModelProvider;
import dressing.model.Project3D;
import dressing.model.ProjectParent;
import utils.ParametersProvider;
import utils.TestModelProvider;

public class CommonDressing {

	ProjectParent parent=null;
	Project3D project3d = null;
	public DressingCreator drcreator = null;
	Materiaux mdf18;
	Materiaux mdf5;
	public final static  double LONGEUR = 3000;
	public final static  double HAUTEUR = 2500;
	public final static  double PROFONDEUR = 650;	
	
	@BeforeClass
	public static void setUpBeforeClass() throws Exception {

	}

	@AfterClass
	public static void tearDownAfterClass() throws Exception {
	}

	@Before
	public void setUp() throws Exception {
		
		TestModelProvider modelprovider=new TestModelProvider();
		mdf18=(Materiaux) modelprovider.getMateriallist().get(0);
		mdf5=(Materiaux) modelprovider.getMateriallist().get(1);
		ParametersProvider paramsprovider=new ParametersProvider();
		paramsprovider.fillparamList();
		 parent  = ModelProvider.RootInstance();
		 parent.getProjects().clear();
		 project3d= new Project3D();
		 parent.addProject(project3d, false);
		 assertNotNull(project3d);
		 assertNotNull(parent);
		 assertNull(project3d.getParentdesign());
		 assertEquals(1, parent.getProjects().size());
		 assertEquals(project3d, parent.getProjects().get(0));
		 
            drcreator=new DressingCreator();
			drcreator.setAppartement("appartement");
			drcreator.setEtage("etage");
			drcreator.setName("dressing");
			drcreator.setParent(project3d);
			drcreator.setChantier(project3d.getName());
			drcreator.setHauteur(HAUTEUR);
			drcreator.setLongeur(LONGEUR);
			drcreator.setProfondeur(PROFONDEUR);
			drcreator.setBasematerial(mdf18);
			drcreator.setBackmaterial(mdf5);
			drcreator.setSeparationposition(500);
			////les valeurs par defaut
	
			
			
			
			
		
	}

	@After
	public void tearDown() throws Exception {
	}

}
