package dressing.cam.model;

import java.util.List;

import org.frs.debitage.cam.dxf.model.Rotationangle;
import org.frs.debitage.engine.core.evalutor.Couple;
import org.frs.debitage.engine.core.evalutor.Equation;
import org.frs.debitage.engine.core.evalutor.GeometricEngineException;

import com.badlogic.gdx.math.Vector3;

import dressing.model.DesignException;
import dressing.model.Point3D;
import dressing.model.types.ParentDirection;
import dressing.model.types.ParentType;
import param.UsinageTrou;

/**
 * @Bug 0001217: ajouter le calcul des rainure et les trous d'usinage
 * @author Imed
 *
 */
public class Trou extends Usinage{

	public Trou(double xcenter, double ycenter, double depth, double diameter) {
		super();
		this.xcenter = xcenter;
		this.ycenter = ycenter;
		this.depth = depth;
		this.diameter = diameter;
	}
	double xcenter,ycenter,zcenter;	
	double depth;	
	double oppositeTrouDepth;
	double diameter;
	double oppositeDiameter;
	
	  String visualisationTrouLateralREctangle = "";
	  Rotationangle angRotation;
	Direction direction;
	ParentType motherType;
	ParentType fatherType;
	ParentDirection parentDirection;
	public Trou(Direction direction) {
		this.direction = direction;
	}
	
	public Trou() {
	}
	
	
	
	public Vector3 getStart() {
		Vector3 start = new Vector3();
		start.set((float)xcenter, (float)ycenter, (float)zcenter);
		return start;
	}

	public Vector3 getEnd() {
		Vector3 end = new Vector3();
		
		switch (direction) {
		case XMINUS:
			end.set((float) -getDepth(), 0 , 0);
			break;
		case XPLUS:
			end.set((float) getDepth(), 0 , 0);
			break;
		case YMINUS:
			end.set(0 ,(float) -getDepth(),  0);
			break;
		case YPLUS:
			end.set(0 ,(float) getDepth(),  0);
			break;
		case ZMINUS:
			end.set(0 ,0 ,(float) -getDepth());
			break;
		case ZPLUS:
			end.set(0 ,0 ,(float) getDepth());
			break;
		default:
			break;
		}
		end.add(getStart());
		return end;
	}

	public double getXcenter() {
		return xcenter;
	}
	public double getYcenter() {
		return ycenter;
	}
	public double getZcenter() {
		return zcenter;
	}
	public double getDepth() {
		return depth;
	}
	public double getDiameter() {
		return diameter;
	}
	public void setXcenter(double xcenter) {		
		double oldValue = this.xcenter;
		this.xcenter = xcenter;
		firePropertyChange("xcenter", oldValue, xcenter);
	}
	public void setYcenter(double ycenter) {
		double oldValue = this.ycenter;
		this.ycenter = ycenter;
		firePropertyChange("ycenter", oldValue, ycenter);
	}
	public void setZcenter(double zcenter) {		
		double oldValue = this.zcenter;
		this.zcenter = zcenter;
		firePropertyChange("zcenter", oldValue, zcenter);
	}
	public void setDepth(double depth) {
		double oldValue = this.depth;
		this.depth = depth;
		firePropertyChange("depth", oldValue, depth);
	}
	
	public double getOppositeTrouDepth() {
		return oppositeTrouDepth;
	}

	public void setOppositeTrouDepth(double oppositeTrouDepth) {
		double oldValue = this.oppositeTrouDepth;
		this.oppositeTrouDepth = oppositeTrouDepth;
		firePropertyChange("oppositeTrouDepth", oldValue, oppositeTrouDepth);
	}

	public void setDiameter(double diameter) {
		double oldValue = this.diameter;
		this.diameter = diameter;
		firePropertyChange("diameter", oldValue, diameter);
	}
	
	public double getOppositeDiameter() {
		return oppositeDiameter;
	}

	public void setOppositeDiameter(double oppositeDiameter) {
		double oldValue = this.oppositeDiameter;
		this.oppositeDiameter = oppositeDiameter;
		firePropertyChange("oppositeDiameter", oldValue, oppositeDiameter);
	}

	public void setDirection(Direction direction) {
		Direction oldValue = this.direction;
		this.direction = direction;
		firePropertyChange("direction", oldValue, direction);
	}
	public Direction getDirection() {
		return direction;
	}
	
	public ParentType getMotherType() {
		return motherType;
	}
	public void setMotherType(ParentType motherType) {
		ParentType oldValue = this.motherType;
		this.motherType = motherType;
		firePropertyChange("motherType", oldValue, motherType);
	}
	public ParentType getFatherType() {
		return fatherType;
	}
	public void setFatherType(ParentType fatherType) {
		ParentType oldValue = this.fatherType;
		this.fatherType = fatherType;
		firePropertyChange("fatherType", oldValue, fatherType);
	}
	public ParentDirection getParentDirection() {
		return parentDirection;
	}
	public void setParentDirection(ParentDirection parentDirection) {
		ParentDirection oldValue = this.parentDirection;
		this.parentDirection = parentDirection;
		firePropertyChange("parentDirection", oldValue, parentDirection);
	}
	@Override
	public Trou clone() {
		// TODO Auto-generated method stub

		Trou tr=new Trou(getDirection());
		tr.setXcenter(getXcenter());
		tr.setYcenter(getYcenter());
		tr.setZcenter(getZcenter());
		tr.setDepth(getDepth());
		tr.setDiameter(getDiameter());
		tr.setFatherType(getFatherType());
		tr.setMotherType(getMotherType());
		tr.setParentDirection(getParentDirection());		
		try {
			tr=(Trou) super.copy(tr);
		} catch (DesignException | GeometricEngineException | CloneNotSupportedException e) {
			e.printStackTrace();
		}
		return tr;
	}

	@Override
	public boolean isdrawable() {
		// TODO Auto-generated method stub
		return false;
	}
	
	@Override
	protected void updateproperties() throws GeometricEngineException {
		// TODO Auto-generated method stub
		setNotificationon(false);
		Equation eq = null;
		try {
			if (debitage != null) {
				eq = Equation.FIND_EQUATION("@this.troudiametre@", debitage.getEquations());
				if (eq != null) {
					setDiameter(eq.getEvaluation(null));
				} else {
					throw new GeometricEngineException("@this.troudiametre@ not found to update");
				}
				eq = Equation.FIND_EQUATION("@this.troudepth@", debitage.getEquations());
				if (eq != null) {
					setDepth(eq.getEvaluation(null));
				} else {
					throw new GeometricEngineException("@this.troudepth@ not found to update");
				}
				eq = Equation.FIND_EQUATION("@opposite.troudepth@", debitage.getEquations());
				if (eq != null) {
					setOppositeTrouDepth(eq.getEvaluation(null));
				} else {
//					throw new GeometricEngineException("@opposite.troudepth@ not found to update");
					System.err.println("@opposite.troudepth@ not found to update");
					setOppositeTrouDepth(this.depth);
				}
				//
				eq = Equation.FIND_EQUATION("@opposite.troudiametre@", debitage.getEquations());
				if (eq != null) {
					setOppositeDiameter(eq.getEvaluation(null));
				} else {
//					throw new GeometricEngineException("@opposite.troudiametre@ not found to update");
					System.err.println("@opposite.troudiametre@ not found to update");
					setOppositeDiameter(this.diameter);
				}
				//
				eq  = Equation.FIND_EQUATION("@this.posx@", debitage.getEquations());
				if(eq!=null)
				{
					setXcenter(eq.getEvaluation(null));
					setXpos(eq.getEvaluation(null));
				}
				else
				{
					throw new GeometricEngineException("@this.posx@ not found to update");
				}
				
				eq  = Equation.FIND_EQUATION("@this.posy@", debitage.getEquations());
				if(eq!=null)
				{
					setYcenter(eq.getEvaluation(null));
					setYpos(eq.getEvaluation(null));
				}
				else
				{
					throw new GeometricEngineException("@this.posy@ not found to update");
				}
				
				eq  = Equation.FIND_EQUATION("@this.posz@", debitage.getEquations());
				if(eq!=null)
				{
					setZcenter(eq.getEvaluation(null));
					setZpos(eq.getEvaluation(null));

				}
				else
				{
					throw new GeometricEngineException("@this.posz@ not found to update");
				}
				
			}
		} catch (GeometricEngineException e) {
			// TODO: handle exception
			e.printStackTrace();
			throw e;
		} finally {
			setNotificationon(true);
		}
	}
	@Override
	public String toString() {
		return "Trou"+ getName()+"[xcenter=" + xcenter + ", ycenter=" + ycenter + ", zcenter=" + zcenter + ", depth=" + depth
				+ ", diameter=" + diameter + ", direction=" + direction + "]";
	}
	
	@Override
	public boolean isSolid(PlanUsinage pl) {
		switch (pl) {
		case FRONT:
			return getDirection() == Direction.ZMINUS;
		case BACK:
			return getDirection() == Direction.ZPLUS;
		case RIGHT:
			return getDirection() == Direction.XMINUS;
		case LEFT:
			return getDirection() == Direction.XPLUS;
		case DOWN:
			return getDirection() == Direction.YPLUS;
		case TOP:
			return getDirection() == Direction.YMINUS;
		default:
			break;
		}

		return false;
	}
	
	@Override
	public PlanUsinage getprimaryPlan() {
		switch (getDirection()) {
		case XMINUS:
			return PlanUsinage.RIGHT;
		case XPLUS:
			return PlanUsinage.LEFT;
		case YMINUS:
			return PlanUsinage.TOP;
		case YPLUS:
			return PlanUsinage.DOWN;
		case ZMINUS:
			return PlanUsinage.FRONT;			
		case ZPLUS:
			return PlanUsinage.BACK;			
		default:
			return PlanUsinage.FRONT;
		}
		
		
	}
	
	public List<Couple> getSystemEquation(Object emf) {
		// TODO Auto-generated method stub
		systemesequations.clear();
		if(emf instanceof UsinageTrou && emf != null )
		{					
			UsinageTrou utr = (UsinageTrou)emf;
			systemesequations.add(new Couple("@this.posx@", utr.getX()));
			systemesequations.add(new Couple("@this.posy@", utr.getY()));
			systemesequations.add(new Couple("@this.posz@", utr.getZ()));
			systemesequations.add(new Couple("@this.troudiametre@", utr.getDiameter()));
			systemesequations.add(new Couple("@this.troudepth@", utr.getProfondeur()));
			systemesequations.add(new Couple("@opposite.troudepth@", utr.getOppositeProfondeur()));
			systemesequations.add(new Couple("@opposite.troudiametre@", utr.getOppositeDiameter()));

			return systemesequations;
		}
		return systemesequations;
	}

	public Point3D getEndPoint() {
		Point3D point=new Point3D();
		double x=getXPosABS();
		double y=getYPosABS();
		double z=getZPosABS();
		
		Direction direction =getDirection();
		switch (direction) {
		case XMINUS:
			x=getXPosABS() -getDepth();
			break;
		case XPLUS:
			x=getXPosABS()+getDepth();
			break;
		case YMINUS:
			y=getYPosABS()-getDepth();
			break;
		case YPLUS:
			y=getYPosABS()+getDepth();
			break;
		case ZMINUS:
			z=getZPosABS()-getDepth();
			break;
		case ZPLUS:
			z=getZPosABS()+getDepth();
			break;
		default:
			break;
		}
			point.setX(x);
			point.setY(y);
			point.setZ(z);
			
		return point;
	}
	/**
	 * transformer le position de cette trou depuis la repert de mother vers la repert de parentDisign
	 */
	@Override
	public void transformtoParentCords() {
		super.transformtoParentCords();
		this.xcenter=this.getXpos();
		this.ycenter=this.getYpos();
		this.zcenter=this.getZpos();

	}
	
	public Direction getOppositeDirection() {
		
		Direction direction =getDirection();
		switch (direction) {
		case XMINUS:
			return Direction.XPLUS;
		case XPLUS:
			return Direction.XMINUS;
		case YMINUS:
			return Direction.YPLUS;
		case YPLUS:
			return Direction.YMINUS;
		case ZMINUS:
			return Direction.ZPLUS;			
		case ZPLUS:
			return Direction.ZMINUS;			
		default:
			return Direction.XPLUS;
		}
			
			
		 
	}
	
	public boolean isLateral(PlanUsinage pl) {
		switch (pl) {
		case FRONT:
			return getDirection() == Direction.XMINUS ||getDirection() == Direction.XPLUS
			||getDirection() == Direction.YPLUS ||getDirection() == Direction.YMINUS;
		case BACK:
			return getDirection() == Direction.XMINUS ||getDirection() == Direction.XPLUS
			||getDirection() == Direction.YPLUS ||getDirection() == Direction.YMINUS;
		case RIGHT:
			return getDirection() == Direction.ZMINUS ||getDirection() == Direction.ZPLUS
			||getDirection() == Direction.YPLUS ||getDirection() == Direction.YMINUS;
		case LEFT:
			return getDirection() == Direction.ZMINUS ||getDirection() == Direction.ZPLUS
			||getDirection() == Direction.YPLUS ||getDirection() == Direction.YMINUS;
		case DOWN:
			return getDirection() == Direction.ZMINUS ||getDirection() == Direction.ZPLUS
				|| getDirection() == Direction.XMINUS ||getDirection() == Direction.XPLUS;
		case TOP:
			return getDirection() == Direction.ZMINUS ||getDirection() == Direction.ZPLUS
			|| getDirection() == Direction.XMINUS ||getDirection() == Direction.XPLUS;
		default:
			break;
		}
		return false;
	}
}
