package org.frs.html;

import java.util.HashMap;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;

import org.mozilla.javascript.engine.RhinoScriptEngineFactory;



public class JavaCodeEvaluator {

	private ScriptEngine engine;
	Bindings bindings;
	private static JavaCodeEvaluator instance;
	
	
	private JavaCodeEvaluator() {
		super();
		init();
	}

	public Object evaluate(String expr,  HashMap<String, Object> binding, boolean stringify) {
		bindings.clear();
		bindings.putAll(binding);
		Object result = null;
		try {
			result = engine.eval(expr, bindings);
		} catch (ScriptException e) {
			e.printStackTrace();
			System.err.println("expression: " + expr);
			return "null";
		}
		if(result == null)
			return "";
		return stringify?result.toString():result;
	}
	
	private void init() {
		engine = new RhinoScriptEngineFactory().getScriptEngine();
		bindings = engine.createBindings();
	}

	

	
	public static JavaCodeEvaluator getInstance() {
		if(instance == null)
			instance = new JavaCodeEvaluator();
		return instance;
	}


}
