package gdxapp.quotation;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer.ShapeType;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Align;

import dressing.mathutils.Edge;
import dressing.mathutils.MathUtilities;
import dressing.mathutils.Matrix23;
import gdxapp.assets.AssetFont;
import gdxapp.assets.SDFFont;
import gdxapp.object3d.Object2D;

public class Quotation {

	public enum QuotationDisplayMode  {
			INNER,OUTER
	}
	private Edge edge;
	private String value;
	private static ShapeRenderer shapeRenderer;
	private static SDFFont font = AssetFont.getInstance().getFont();
	private SpriteBatch fontBatch;
	private float distance;
	private float length;
	private Matrix4 fontMatrix;
	
	public final static Matrix23 projection = new Matrix23(new float[] {
			1,0,0,
			0,1,0
	});

	Vector2 v0, v1, v2;

	public Quotation(Edge edge, String value) {
		this.edge = edge;
		this.value = value;
		this.distance = 25;
		calculatePoints();
	}
	
	
	public void calculatePoints() {
		v0 = new Vector2(edge.getV0().x, edge.getV0().y);
		v1 = new Vector2(edge.getV1().x, edge.getV1().y);
		v0.add(edge.getNormal().cpy().scl(distance));
		v1.add(edge.getNormal().cpy().scl(distance));
		v2 = new Vector2();
		v2.set(v0.cpy().add(edge.getDirector().cpy().scl(edge.getLength() * .5f)).
				add(edge.getNormal().cpy().scl(distance)));
	}

	public void draw(Batch batch , Color color,boolean withLines, float thickness){
		  calculatePoints();   
		  if(shapeRenderer == null){
	            shapeRenderer = new ShapeRenderer();
	        }
		  shapeRenderer.setProjectionMatrix(batch.getProjectionMatrix());
		  if(withLines) {
		        shapeRenderer.setColor(color);
		        shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
		        shapeRenderer.rectLine(v0,v1,thickness);
		        shapeRenderer.setColor(Color.BROWN);
		        shapeRenderer.rectLine(edge.getV0(),v0,1);
		        shapeRenderer.rectLine(edge.getV1(),v1,1);
		        shapeRenderer.end();
				batch.getProjectionMatrix().translate(v2.x, v2.y, 0);
				float edgeRotation = edge.getRotation();
				if (Math.abs(180 - edgeRotation) > 10) {
					batch.getProjectionMatrix().rotate(Vector3.Z, -edgeRotation);
				}
				batch.begin();
				font.draw(batch, value, 0, 0, 0, Align.center, false, Color.RED);
				batch.end();
				if (Math.abs(180 - edgeRotation) > 10) {
					batch.getProjectionMatrix().rotate(Vector3.Z, edgeRotation);
				}
				batch.getProjectionMatrix().translate(-v2.x, -v2.y, 0);
	      }
	}
	
	public boolean equivalentTo(Quotation other) {
		if(other.getEdge().equals(getEdge()))
			return true;
		if(Math.abs(other.getLength() - getLength()) >= 0.001f)
			return false;
		if(!other.getEdge().getDirector().isCollinear(getEdge().getDirector()))
			return false;
		Vector2 v = new Vector2(other.getV2().cpy().sub(getV2()));
		if(!(v.isCollinear(other.getEdge().getNormal()) || v.isCollinearOpposite(other.getEdge().getNormal())))
			return false;
		return true;
	}

	public Edge getEdge() {
		return edge;
	}

	public void setEdge(Edge edge) {
		this.edge = edge;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}

	public float getDistance() {
		return distance;
	}

	public void setDistance(float distance) {
		this.distance = distance;
	}

	public float getLength() {
		return edge.getLength();
	}

	public void setLength(float length) {
		this.length = length;
	}

	public Vector2 getV0() {
		return v0;
	}

	public void setV0(Vector2 v0) {
		this.v0 = v0;
	}

	public Vector2 getV1() {
		return v1;
	}

	public void setV1(Vector2 v1) {
		this.v1 = v1;
	}

	public Vector2 getV2() {
		return v2;
	}

	public void setV2(Vector2 v2) {
		this.v2 = v2;
	}
	
}
	