package dressing.ui.util;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.UserDefinedFileAttributeView;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

import dressing.config.WorkspaceConfiguration;
import dressing.model.ModelProvider;
import dressing.ui.engine3d.SceneTexture;
import gdxapp.shaders.PbrMaterial;
import param.Chant;
import param.Material;
import param.MaterialType;
import param.impl.MaterialImpl;

public class SingleImageItemLabelProvider extends LabelProvider implements ITableLabelProvider {

	public final static String LABEL_PROPERTY = "user.title";
	public final static String DEFAULT_TITLE = "Unknown Title";
	private static SingleImageItemLabelProvider instance;
	
	public static SingleImageItemLabelProvider getInstance() {
		synchronized(SingleImageItemLabelProvider.class) {
			if (instance == null) {
				instance = new SingleImageItemLabelProvider();
			}
			return instance;
		}
	}	
	public SingleImageItemLabelProvider() {
		super();
	}

	public Image getColumnImage(Object element, int columnIndex) {
		String path="";
		
		if(element instanceof MaterialImpl) {
			MaterialImpl item = (MaterialImpl) element;
			if (columnIndex == 0) {
				SceneTexture texture=ModelProvider.getMaterialSceneTexture(item);
				if(texture!=null) {
					return texture.getLabelImage();
				}else 
				if (item != null && item.getImage() != null&& !item.getImage().isEmpty()) {
					path = WorkspaceConfiguration.TEXTURES_FOLDER + File.separator + item.getImage();
				}
			}
			
		}
		else if(element instanceof SceneTexture ) {
			SceneTexture texture = (SceneTexture) element;
				if (texture != null && texture.getPath() != null) 
					{
					return texture.getLabelImage();
					}	
		}else if (element instanceof PbrMaterial) {
			PbrMaterial mtl = (PbrMaterial) element;
			path =  mtl.getAlbedoMapPath();
		}
		
		if (path != null && !path.isEmpty()) {
			try {
				SceneTexture sceneTexture  = ModelProvider.getTexture(path);
				if(sceneTexture != null)
					return sceneTexture.getLabelImage();
				
			} catch (Exception e) {
				System.err.println("failed to get image label " + path);
				e.printStackTrace();
				return null;
			}
		}
		return null;
	}

	public String getPbrMaterialImageLabelPath(PbrMaterial element) {
		String albedoFileName = element.getAlbedoMapPath();
		String path = albedoFileName;
		if(albedoFileName != null) {
			File file = new File(albedoFileName);
			if(!file.exists()) {
				String altPath = WorkspaceConfiguration.TEXTURES_FOLDER + File.separator + file.getName();
				file = new File(altPath);
				if(file.exists()) {
					path = file.getAbsolutePath();
				}
			}
		}else {
			path = element.getNormalMapPath();
			if(path == null)
				return null;
			File file = new File(path);
			if(!file.exists()) {
				String altPath = WorkspaceConfiguration.TEXTURES_FOLDER + File.separator + file.getName();
				file = new File(altPath);
				if(file.exists())
					path = altPath;
			}
		}
		return path;
	}

	public String getColumnText(Object element, int columnIndex) {
		if(element instanceof Material) {
			Material item = (Material) element;
			switch (columnIndex) {
			case 0:
				return item.getName();
			case 1:
				return String.valueOf(item.getEpaisseur());
			case 2:
				return String.valueOf(item.getPrice());
			case 3:
				return item.getFabricant()!=null ? item.getFabricant().getName():"";
			}
		} else if (element instanceof SceneTexture) {
			SceneTexture item = (SceneTexture) element;
			return readFileLabelProperty(Paths.get(item.getPath()));
		} else if (element instanceof MaterialType) {
			MaterialType item = (MaterialType) element;
			return item.getName();
		}else if( element instanceof Chant) {
			Chant item = (Chant) element;

			switch (columnIndex) {
			case 0:
				return item.getName();
			case 1:
				return String.valueOf(item.getEpaisseur());
			case 2:
				return String.valueOf(item.getPrice());
			case 3:
				return item.getFabricant()!=null ? item.getFabricant().getName():"";
			
			}
		}
		return element.toString();
	}

	public String readFileLabelProperty(Path path) {
		return readFileProperties(path, LABEL_PROPERTY);
	}

	private String readFileProperties(Path path, String property) {

		if (path == null) {
			return DEFAULT_TITLE;
		}
		UserDefinedFileAttributeView view = Files.getFileAttributeView(path, UserDefinedFileAttributeView.class);
		try {
			if (view.list().contains(property)) {
				int size = view.size(property);
				ByteBuffer buffer = ByteBuffer.allocate(size);
				view.read(property, buffer);
				buffer.flip();
				return StandardCharsets.UTF_8.decode(buffer).toString();
			}
		} catch (IOException e) {
			e.printStackTrace();

		}
		return path.getFileName() != null ? path.getFileName().toString() : DEFAULT_TITLE;
	}

	private void setFileProperty(Path path, String key, String value) throws IOException {
		UserDefinedFileAttributeView view = Files.getFileAttributeView(path, UserDefinedFileAttributeView.class);
		view.write(key, ByteBuffer.wrap(value.getBytes()));

	}

	public void setFileLabelProperty(Path path, String lable) throws IOException {
		setFileProperty(path, LABEL_PROPERTY, lable);
	}

}
