package dressing.ui.Control;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.Window;
import org.eclipse.nebula.jface.tablecomboviewer.TableComboViewer;
import org.eclipse.nebula.widgets.tablecombo.TableCombo;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;

import com.badlogic.gdx.math.Vector3;

import dressing.config.WorkspaceConfiguration;
import dressing.config.persistence.ResourceManagers;
import dressing.mathutils.Vector4;
import dressing.model.ModelProvider;
import dressing.model.Space3DFree;
import dressing.model.types.Orientation;
import dressing.model.types.PoigneePosition;
import dressing.model.types.PoigneeType;
import dressing.model.types.PortType;
import dressing.model.types.PorteDirection;
import dressing.ui.ChangeCommand;
import dressing.ui.ChangeTextureCommand;
import dressing.ui.ChantListWindow;
import dressing.ui.CommandStack;
import dressing.ui.DesignChangeParamCommand;
import dressing.ui.MaterialListWindow;
import dressing.ui.MoveCommand;
import dressing.ui.RotateCommand;
import dressing.ui.ScaleCommand;
import dressing.ui.SuperCadMessageDialog;
import dressing.ui.components.TableComboViewerSearch;
import dressing.ui.engine3d.SceneTexture;
import dressing.ui.parts.GdxPart;
import dressing.ui.util.EditorWindow;
import dressing.ui.util.ImageLoaderCache;
import dressing.ui.util.ListEditorWindow;
import dressing.ui.util.MaterialTypeInstanceComposite;
import dressing.ui.util.SingleImageItemLabelProvider;
import dressing.ui.util.StaticUiObjects;
import gdxapp.Commun.AbstractScreen;
import gdxapp.object3d.KitchenElement;
import gdxapp.object3d.Wall;
import gdxapp.object3d.WorldObject;
import gdxapp.object3d.WorldObject.ObjectType;
import gdxapp.object3d.WorldObjectFactory;
import gdxapp.scenes.Scene;
import gdxapp.screens.room.RoomController;
import modeljtree.Object2D;
import param.Chant;
import param.Material;
import param.MaterialTypeInstance;
import param.MechanicDesign;
import param.MechanicPublicParam;
import param.TypeDef;
import param.TypeDefElement;

public class MultiObjectActionWidow extends org.eclipse.jface.window.Window{
	private static final String LONGEUR="Longeur";
	private static final String HAUTEUR="Hauteur";
	private static final String PROFONDEUR="Profondeur";
	private static final String LARGEUR="Largeur";
	
	private static final String X="Position X";
	private static final String Y="Position Y";
	private static final String Z="Position Z";
	
	private static final String ROTATION="Rotation";
	private static final String CACHE_BAS="Socle Hauteur";//

	private static final String POIGNEE="Poignée";
	private static final String PORTE="Porte";
	
	private static final String WALL_TEXTURE="Mur Texture";
	private static final String FACADE_TEXTURE="Façade Texture";
	private static final String MARBLE_TEXTURE="Marble Texture";
	private static final String BOX_TEXTURE="Élément Texture";
	private static final String CACHE_BAS_TEXTURE="Socle Texture";//
	private static final String MATERIAL_fACADE="Modèle du Façades";
	private static final String MATERIAL_ELEMENT="Modèle d'élements";
	private static final String MATERIAL_DOS="Modèle des dos";
	private static final String CHANT_FACADE="Chant du Façades";
	private static final String CHANT_ELEMENT="Chant d'élements";
	private static final String MATERIAL_NICHE="Modèle des Niches";
	private static final String MATERIAL_FAUSSE_fACADE="Modèle des Fausse Façades";
	private boolean isAllObjects=false;
	List<String> values=new ArrayList<String>();

	
	public MultiObjectActionWidow(Shell parentShell) {
		super(parentShell);
		setShellStyle(SWT.SHELL_TRIM| SWT.APPLICATION_MODAL);
		setBlockOnOpen(true);
	}
	public Shell shell;
	Spinner spnz;
	Spinner spny;
	Spinner spnX;
	Spinner spnlongeur;
	Spinner spnHauteur;
	Spinner spnProfondeur;
	Spinner spnLargeur;

	
	Label lblLargeur;
	Object2D object2d;
	Spinner spnRotation;
	Label lblRotation;
	ComboViewer comboViewer_PoigneeType;
	ComboViewer comboViewerOrient;
	ComboViewer comboViewerPos; 

	ComboViewer comboViewer_PorteType;
	ComboViewer comboViewer_PorteDirection;
	
	ArrayList<KitchenElement> targets;
	
	CTabFolder tabFolder;
	CTabItem tbtmLongeur;
	CTabItem tbtmHauteur;
	CTabItem tbtmProfondeur;
	CTabItem tbtmLargeur;
	CTabItem tbtmRotation;
	CTabItem tbtmPoignee;
	CTabItem tbtmPorte;
	CTabItem tbtmXpos;
	CTabItem tbtmYpos;
	CTabItem tbtmZpos;
	ComboViewer comboViewer;

	CTabItem tbtmElementTexture;
	TableComboViewer tcvBoxTexture;
	
	CTabItem tbtmMarbleTexture;	
	TableComboViewer tcvMarbleTexture;
	
	CTabItem tbtmFacadeTexture;
	TableComboViewer tcvFacadeTexture;
	
	CTabItem tbtmMurTexture;
	TableComboViewer tcvWallTexture;
	
	CTabItem tbtmCacheBasHauteur;
	Spinner spnCacheBas;
	
	CTabItem tbtmCacheBasTexture;
	TableComboViewer tcvCacheTexture;
	
	CTabItem tbtmFacadeChant;
	CTabItem tbtmElementChant;

	ISelectionChangedListener selectionListener=	new ISelectionChangedListener() {
		public void selectionChanged(SelectionChangedEvent event) {
			if(!validate(event.getSource())) {
				
			}

		}
	};
	private static MultiObjectActionWidow instance;
	private CTabItem tbtmNull;
	private TableComboViewer tableComboVwr_Mat;
	private CTabItem tbtmMateriel;
	private MaterialTypeInstanceComposite materialType;
	private TableComboViewerSearch tableComboVwr_ChantFacade;

	public static MultiObjectActionWidow getInstance() {
	 		synchronized(MultiObjectActionWidow.class) {
	 			if (instance == null) {
	 				instance = new MultiObjectActionWidow(GdxPart.parentShell);
	 				instance.create();
	 				instance.constrainShellSize();
	 			}
	 			return instance;
	 		}
	 }
	/**
	 * Launch the application.
	 * @param args
	 */
	public static void main(String[] args) {
		try {
			Shell shell=new Shell();

			MultiObjectActionWidow window = new MultiObjectActionWidow(shell);
			window.open();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	@Override
	protected boolean canHandleShellCloseEvent() {
		return true;
	}
	@Override
	protected void handleShellCloseEvent() {
		setReturnCode(CANCEL);
		hide();
	}
	

	public ArrayList<KitchenElement> getTargets() {
		return targets;
	}
	public void setTargets(ArrayList<KitchenElement> targets) {
		this.targets = targets;
		CreateControl();
		
	}
	
	public boolean isAllObjects() {
		return isAllObjects;
	}
	public void setAllObjects(boolean isAllObjects) {
		this.isAllObjects = isAllObjects;
	}
	/**  
	 * Create contents of the window.
	 * @return 
	 */
	protected Control createContents(Composite parent) {
		parent.setTouchEnabled(true);
		this.shell=parent.getShell();
		parent.getShell().setText("Modifier tous les Objets");
		shell.addShellListener(getShellListener());

		Composite composite = new Composite(parent, SWT.FILL);
		composite.setTouchEnabled(true);
		composite.setLayout(new GridLayout(1, false));
		
		Composite composite_1 = new Composite(composite, SWT.FILL);
		GridData gd_composite_1 = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1);
		gd_composite_1.widthHint = 572;
		gd_composite_1.heightHint = 362;
		composite_1.setLayoutData(gd_composite_1);
		composite_1.setLayout(new GridLayout(2, false));
		
		Label lblModifier = new Label(composite_1, SWT.NONE);
		lblModifier.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
		lblModifier.setText("Modifier");
		
		comboViewer = new ComboViewer(composite_1, SWT.READ_ONLY);
		Combo combo = comboViewer.getCombo();
		combo.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1));
		comboViewer.setLabelProvider(new ViewerLabelProvider());
		comboViewer.setContentProvider(new ContentProvider());
		comboViewer.setInput(values);
		tabFolder = new CTabFolder(composite_1, SWT.FLAT);
		tabFolder.setTabHeight(0);
		tabFolder.setMinimumCharacters(0);
		tabFolder.setHighlightEnabled(false);
		GridData gd_tabFolder = new GridData(SWT.FILL, SWT.FILL, false, true, 2, 1);
		gd_tabFolder.widthHint = 387;
		gd_tabFolder.heightHint = 78;
		tabFolder.setLayoutData(gd_tabFolder);
		tabFolder.setSelectionBackground(Display.getCurrent().getSystemColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT));
		
		tbtmLongeur = new CTabItem(tabFolder, SWT.NONE);
		tbtmLongeur.setText("Longeur");
		
		Composite composite_5 = new Composite(tabFolder, SWT.NONE);
		tbtmLongeur.setControl(composite_5);
		composite_5.setLayout(new GridLayout(2, false));
		
		Label lblL = new Label(composite_5, SWT.NONE);
		lblL.setLayoutData(new GridData(SWT.LEFT, SWT.TOP, false, false, 1, 1));
		lblL.setText("Longeur");
		
		spnlongeur = new Spinner(composite_5, SWT.BORDER);
		spnlongeur.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false, 1, 1));
		spnlongeur.setMaximum(1000000000);
		
		tbtmHauteur = new CTabItem(tabFolder, SWT.NONE);
		tbtmHauteur.setText("Hauteur");
		
		Composite composite_6 = new Composite(tabFolder, SWT.NONE);
		tbtmHauteur.setControl(composite_6);
		composite_6.setLayout(new GridLayout(2, false));
		
		Label lblH = new Label(composite_6, SWT.NONE);
		lblH.setLayoutData(new GridData(SWT.LEFT, SWT.TOP, false, false, 1, 1));
		lblH.setText("Hauteur");
		
		spnHauteur = new Spinner(composite_6, SWT.BORDER);
		spnHauteur.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false, 1, 1));
		spnHauteur.setMaximum(10000000);
		
		tbtmProfondeur = new CTabItem(tabFolder, SWT.NONE);
		tbtmProfondeur.setText("Profondeur");
		
		Composite composite_7 = new Composite(tabFolder, SWT.NONE);
		tbtmProfondeur.setControl(composite_7);
		composite_7.setLayout(new GridLayout(2, false));
		
		Label lblNewLabel = new Label(composite_7, SWT.NONE);
		lblNewLabel.setLayoutData(new GridData(SWT.LEFT, SWT.TOP, false, false, 1, 1));
		lblNewLabel.setText("Profondeur");
		
		spnProfondeur = new Spinner(composite_7, SWT.BORDER);
		spnProfondeur.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false, 1, 1));
		spnProfondeur.setMaximum(10000000);
		
		tbtmLargeur = new CTabItem(tabFolder, SWT.NONE);
		tbtmLargeur.setText("Largeur");
		
		Composite composite_8 = new Composite(tabFolder, SWT.NONE);
		tbtmLargeur.setControl(composite_8);
		composite_8.setLayout(new GridLayout(2, false));
		
		lblLargeur = new Label(composite_8, SWT.NONE);
		lblLargeur.setLayoutData(new GridData(SWT.LEFT, SWT.TOP, false, false, 1, 1));
		lblLargeur.setText("Largeur");
		
		spnLargeur = new Spinner(composite_8, SWT.BORDER);
		spnLargeur.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false, 1, 1));
		spnLargeur.setMaximum(100000000);
		
		tbtmRotation = new CTabItem(tabFolder, SWT.NONE);
		tbtmRotation.setText("Rotation");
		
		Composite composite_9 = new Composite(tabFolder, SWT.NONE);
		tbtmRotation.setControl(composite_9);
		composite_9.setLayout(new GridLayout(2, false));
		
		lblRotation = new Label(composite_9, SWT.NONE);
		lblRotation.setLayoutData(new GridData(SWT.LEFT, SWT.TOP, false, false, 1, 1));
		lblRotation.setText("Rotation");
		
		spnRotation = new Spinner(composite_9, SWT.BORDER);
		spnRotation.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false, 1, 1));
		spnRotation.setMinimum(-180);
		spnRotation.setMaximum(180);
		spnRotation.setTextLimit(4);
		
		tbtmPoignee = new CTabItem(tabFolder, SWT.NONE);
		tbtmPoignee.setText("Poignée");
		
		Composite composite_3 = new Composite(tabFolder, SWT.NONE);
		tbtmPoignee.setControl(composite_3);
		composite_3.setLayout(new GridLayout(2, false));
		
		Label lblType = new Label(composite_3, SWT.NONE);
		lblType.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
		lblType.setText("Type");
		
		comboViewer_PoigneeType = new ComboViewer(composite_3, SWT.READ_ONLY);
		Combo combo_typePoignee = comboViewer_PoigneeType.getCombo();
		combo_typePoignee.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1));

		comboViewer_PoigneeType.setLabelProvider(new TypeDefElementLabelProvider());
		comboViewer_PoigneeType.setContentProvider(new TypeDefContentProvider());
		
//		Label lblPoigneePos = new Label(composite_3, SWT.NONE);
//		lblPoigneePos.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
//		lblPoigneePos.setText("Position");
		
//		comboViewerPos = new ComboViewer(composite_3, SWT.READ_ONLY);
//		Combo comboPos = comboViewerPos.getCombo();
//		comboPos.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1));
//		
//		comboViewerPos.setLabelProvider(new TypeDefElementLabelProvider());
//		comboViewerPos.setContentProvider(new TypeDefContentProvider());
		
		Label lblOrientation = new Label(composite_3, SWT.NONE);
		lblOrientation.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
		lblOrientation.setText("Orientation");
		
		comboViewerOrient = new ComboViewer(composite_3, SWT.READ_ONLY);
		
		Combo combo_Orient = comboViewerOrient.getCombo();
		combo_Orient.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1));
		composite_3.setTabList(new Control[]{combo_typePoignee, combo_Orient});
		
		comboViewerOrient.setLabelProvider(new TypeDefElementLabelProvider());
		comboViewerOrient.setContentProvider(new TypeDefContentProvider());
		
		tbtmPorte = new CTabItem(tabFolder, SWT.NONE);
		tbtmPorte.setText("Porte");
		
		Composite composite_4 = new Composite(tabFolder, SWT.NONE);
		tbtmPorte.setControl(composite_4);
		composite_4.setLayout(new GridLayout(2, false));
		
		Label lblTypePorte = new Label(composite_4, SWT.NONE);
		GridData gd_lblTypePorte = new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1);
		gd_lblTypePorte.widthHint = 60;
		lblTypePorte.setLayoutData(gd_lblTypePorte);
		lblTypePorte.setText("Type");
		
		comboViewer_PorteType = new ComboViewer(composite_4, SWT.READ_ONLY);
		Combo combo_PorteType = comboViewer_PorteType.getCombo();
		combo_PorteType.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1));
		
		comboViewer_PorteType.setLabelProvider(new TypeDefElementLabelProvider());
		comboViewer_PorteType.setContentProvider(new TypeDefContentProvider());
		
		Label lblDirection = new Label(composite_4, SWT.NONE);
		lblDirection.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
		lblDirection.setText("Direction");
		
		comboViewer_PorteDirection = new ComboViewer(composite_4, SWT.READ_ONLY);
		Combo combo_PorteDirection = comboViewer_PorteDirection.getCombo();
		combo_PorteDirection.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		comboViewer_PorteDirection.setLabelProvider(new TypeDefElementLabelProvider());
		comboViewer_PorteDirection.setContentProvider(new TypeDefContentProvider());
		
		tbtmXpos = new CTabItem(tabFolder, SWT.NONE);
		tbtmXpos.setText("Xpos");
		
		Composite composite_10 = new Composite(tabFolder, SWT.NONE);
		tbtmXpos.setControl(composite_10);
		composite_10.setLayout(new GridLayout(2, false));
		
		Label lblX = new Label(composite_10, SWT.NONE);
		GridData gd_lblX = new GridData(SWT.FILL, SWT.TOP, false, false, 1, 1);
		gd_lblX.widthHint = 33;
		lblX.setLayoutData(gd_lblX);
		lblX.setText("X");
		
		spnX = new Spinner(composite_10, SWT.BORDER);
		spnX.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		spnX.setMaximum(100000000);
		
		tbtmYpos = new CTabItem(tabFolder, SWT.NONE);
		tbtmYpos.setText("Ypos");
		
		Composite composite_11 = new Composite(tabFolder, SWT.NONE);
		tbtmYpos.setControl(composite_11);
		composite_11.setLayout(new GridLayout(2, false));
		
		Label lblY = new Label(composite_11, SWT.NONE);
		GridData gd_lblY = new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1);
		gd_lblY.widthHint = 20;
		lblY.setLayoutData(gd_lblY);
		lblY.setText("Y");
		
		spny = new Spinner(composite_11, SWT.BORDER);
		spny.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		spny.setMaximum(1000000000);
		
		tbtmZpos = new CTabItem(tabFolder, SWT.NONE);
		tbtmZpos.setText("ZPos");
		
		Composite composite_12 = new Composite(tabFolder, SWT.NONE);
		tbtmZpos.setControl(composite_12);
		composite_12.setLayout(new GridLayout(2, false));
		
		Label lblZ = new Label(composite_12, SWT.NONE);
		GridData gd_lblZ = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
		gd_lblZ.widthHint = 26;
		lblZ.setLayoutData(gd_lblZ);
		lblZ.setText("Z");
		
		spnz = new Spinner(composite_12, SWT.BORDER);
		spnz.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		spnz.setSize(3, 22);
		spnz.setMaximum(100000000);
		spnRotation.addKeyListener(new KeyListener() {
			
			@Override
			public void keyReleased(KeyEvent e) {
				String text=spnRotation.getText();
//				int rotation=spnRotation.getSelection();
				try {
					int rotation=Integer.valueOf(text);
					if(rotation>180) {
						spnRotation.setSelection(180);
//					spnRotation.setValues(180, -180, 180, 4, 1, 1);

					}
					if(rotation<-180) {
						spnRotation.setSelection(-180);
//					spnRotation.setValues(-180, -180, 180, 4, 1, 1);

					}
				} catch (NumberFormatException e1) {
					e.doit=false;
				}
			}
			
			@Override
			public void keyPressed(KeyEvent e) {
				
			}
		});
		Composite composite_2 = new Composite(composite, SWT.NONE);
		GridData gd_composite_2 = new GridData(SWT.FILL, SWT.BOTTOM, true, false, 1, 1);
		gd_composite_2.heightHint = 40;
		composite_2.setLayoutData(gd_composite_2);
		GridLayout gl_composite_2 = new GridLayout(3, false);
		gl_composite_2.horizontalSpacing = 0;
		composite_2.setLayout(gl_composite_2);
		
//		Button btnRun = new Button(composite_2, SWT.NONE);
//		btnRun.setImage(ResourceManager.getPluginImage("Dressing", "icons/Calculer.png"));
//		GridData gd_btnRun = new GridData(SWT.FILL, SWT.BOTTOM, true, false, 1, 1);
//		gd_btnRun.heightHint = 35;
//		btnRun.setLayoutData(gd_btnRun);
//		btnRun.setText("Terminer");
		
		Button btnModifier = new Button(composite_2, SWT.NONE);
		btnModifier.setImage(ResourceManager.getPluginImage("Dressing", "icons/Calculer.png"));
		GridData gd_btnModifier = new GridData(SWT.FILL, SWT.BOTTOM, true, false, 1, 1);
		gd_btnModifier.heightHint = 35;
		btnModifier.setLayoutData(gd_btnModifier);
		btnModifier.setText("Modifier");
		
		Button btnFermer = new Button(composite_2, SWT.NONE);
		GridData gd_btnFermer = new GridData(SWT.FILL, SWT.BOTTOM, true, false, 1, 1);
		gd_btnFermer.heightHint = 35;
		btnFermer.setLayoutData(gd_btnFermer);
		btnFermer.setText("Fermer");
		new Label(composite_2, SWT.NONE);
		composite.setTabList(new Control[]{composite_1, composite_2});
		
		btnFermer.addSelectionListener(new SelectionAdapter() {
		
					@Override
					public void widgetSelected(SelectionEvent e) {
						// TODO Auto-generated method stub
						MultiObjectActionWidow.this.close();
					}
					
				});
		btnModifier.addSelectionListener(new SelectionAdapter() {

					@Override
					public void widgetSelected(SelectionEvent e) {
						Display.getDefault().asyncExec(() -> {
						    shell.setCursor(shell.getDisplay().getSystemCursor(SWT.CURSOR_WAIT));
						    try {
						    	CommandStack command=updateObject();
								
								
								if(targets!=null && command!=null && command.getStack()!=null && command.getStack().size()>0 ) {
												
										if(((AbstractScreen) Scene.game.getScreen()).getController().getChangeCommandController()!=null)
										{
											((AbstractScreen) Scene.game.getScreen()).getController().getChangeCommandController().addCommand(command);
										}
				
										System.gc();
										
									
								}
						    } finally {
						        shell.setCursor(null); // restore default
						    }
						});
						
						
						
					}
					
				});
		btnFermer.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				// TODO Auto-generated method stub
				MultiObjectActionWidow.this.close();
			}
		});
		
		tbtmCacheBasHauteur = new CTabItem(tabFolder, SWT.NONE);
		tbtmCacheBasHauteur.setText("Socle hauteur");
		
		Composite composite_17 = new Composite(tabFolder, SWT.NONE);
		tbtmCacheBasHauteur.setControl(composite_17);
		composite_17.setLayout(new GridLayout(2, false));
		
		Label lblCacheBasCaisson = new Label(composite_17, SWT.NONE);
		lblCacheBasCaisson.setText("Socle hauteur");
		
		spnCacheBas = new Spinner(composite_17, SWT.BORDER);
		spnCacheBas.setMaximum(1000000000);
		spnCacheBas.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
					
		tbtmMurTexture = new CTabItem(tabFolder, SWT.NONE);
		tbtmMurTexture.setText("Mur Texture");
		
		Composite composite_13 = new Composite(tabFolder, SWT.NONE);
		tbtmMurTexture.setControl(composite_13);
		composite_13.setLayout(new GridLayout(2, false));
		
		Label lblTextureMur = new Label(composite_13, SWT.NONE);
		lblTextureMur.setText("Texture Mur");
		
		tcvWallTexture = new TableComboViewer(composite_13, SWT.NONE);
		TableCombo tableCombo_WallTexture = tcvWallTexture.getTableCombo();
		tableCombo_WallTexture.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1));
		tcvWallTexture.getTableCombo().defineColumns(new String[] {"texture"});
		tcvWallTexture.getTableCombo().getTextControl().setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.NORMAL));
		// do not allow editable
		tcvWallTexture.getTableCombo().setEditable(false);
		// set the content provider
		tcvWallTexture.setContentProvider(ArrayContentProvider.getInstance());
		// set the label provider
		tcvWallTexture.setLabelProvider(SingleImageItemLabelProvider.getInstance());
		// load the data
		tcvWallTexture.setInput(ModelProvider.getTextures());
		
		//
		tbtmFacadeTexture = new CTabItem(tabFolder, SWT.NONE);
		tbtmFacadeTexture.setText("Façade Texture");
		
		Composite composite_14 = new Composite(tabFolder, SWT.NONE);
		tbtmFacadeTexture.setControl(composite_14);
		composite_14.setLayout(new GridLayout(2, false));
		
		Label lblFacadeTexture = new Label(composite_14, SWT.NONE);
		lblFacadeTexture.setText("Façade Texture");
		
		tcvFacadeTexture = new TableComboViewer(composite_14, SWT.NONE);
		TableCombo tableCombo_FacadeTexture = tcvFacadeTexture.getTableCombo();
		tableCombo_FacadeTexture.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1));
		tcvFacadeTexture.getTableCombo().defineColumns(new String[] {"texture"});
		tcvFacadeTexture.getTableCombo().getTextControl().setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.NORMAL));
		// do not allow editable
		tcvFacadeTexture.getTableCombo().setEditable(false);
		// set the content provider
		tcvFacadeTexture.setContentProvider(ArrayContentProvider.getInstance());
		// set the label provider
		tcvFacadeTexture.setLabelProvider(SingleImageItemLabelProvider.getInstance());
		// load the data
		tcvFacadeTexture.setInput(ModelProvider.getTextures());
		
		tbtmMarbleTexture = new CTabItem(tabFolder, SWT.NONE);
		tbtmMarbleTexture.setText("Marble Texture");
		
		Composite composite_15 = new Composite(tabFolder, SWT.NONE);
		tbtmMarbleTexture.setControl(composite_15);
		composite_15.setLayout(new GridLayout(2, false));
		
		Label lblMarbleTexture = new Label(composite_15, SWT.NONE);
		lblMarbleTexture.setText("Marble Texture");
		
		tcvMarbleTexture = new TableComboViewer(composite_15, SWT.NONE);
		TableCombo tableCombo_MarbleTexture = tcvMarbleTexture.getTableCombo();
		tableCombo_MarbleTexture.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		tcvMarbleTexture.getTableCombo().defineColumns(new String[] {"texture"});
		tcvMarbleTexture.getTableCombo().getTextControl().setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.NORMAL));
		// do not allow editable
		tcvMarbleTexture.getTableCombo().setEditable(false);
		// set the content provider
		tcvMarbleTexture.setContentProvider(ArrayContentProvider.getInstance());
		// set the label provider
		tcvMarbleTexture.setLabelProvider(SingleImageItemLabelProvider.getInstance());
		// load the data
		tcvMarbleTexture.setInput(ModelProvider.getTextures());
		
		tbtmElementTexture = new CTabItem(tabFolder, SWT.NONE);
		tbtmElementTexture.setText("Élément Texture");
		
		Composite composite_16 = new Composite(tabFolder, SWT.NONE);
		tbtmElementTexture.setControl(composite_16);
		composite_16.setLayout(new GridLayout(2, false));
		
		Label lblElementTexture = new Label(composite_16, SWT.NONE);
		lblElementTexture.setText("Élément Texture");
		
		tcvBoxTexture = new TableComboViewer(composite_16, SWT.NONE);
		TableCombo tableCombo_BoxTexture = tcvBoxTexture.getTableCombo();
		tableCombo_BoxTexture.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1));
		tcvBoxTexture.getTableCombo().defineColumns(new String[] {"texture"});
		tcvBoxTexture.getTableCombo().getTextControl().setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.NORMAL));
		// do not allow editable
		tcvBoxTexture.getTableCombo().setEditable(false);
		// set the content provider
		tcvBoxTexture.setContentProvider(ArrayContentProvider.getInstance());
		// set the label provider
		tcvBoxTexture.setLabelProvider(SingleImageItemLabelProvider.getInstance());
		// load the data
		tcvBoxTexture.setInput(ModelProvider.getTextures());
		
		tbtmCacheBasTexture = new CTabItem(tabFolder, SWT.NONE);
		tbtmCacheBasTexture.setText("Cache Bas Texture");
		
		Composite composite_18 = new Composite(tabFolder, SWT.NONE);
		tbtmCacheBasTexture.setControl(composite_18);
		composite_18.setLayout(new GridLayout(2, false));
		
		Label lblCacheBasCaisson_1 = new Label(composite_18, SWT.NONE);
		lblCacheBasCaisson_1.setText("Cache bas caisson Texture");
		
		tcvCacheTexture = new TableComboViewer(composite_18, SWT.NONE);
		TableCombo tableCombo_CacheTexture = tcvCacheTexture.getTableCombo();
		tableCombo_CacheTexture.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1));
		tcvCacheTexture.getTableCombo().defineColumns(new String[] {"texture"});
		tcvCacheTexture.getTableCombo().getTextControl().setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.NORMAL));
		// do not allow editable
		tcvCacheTexture.getTableCombo().setEditable(false);
		// set the content provider
		tcvCacheTexture.setContentProvider(ArrayContentProvider.getInstance());
		// set the label provider
		tcvCacheTexture.setLabelProvider(SingleImageItemLabelProvider.getInstance());
		// load the data
		tcvCacheTexture.setInput(ModelProvider.getTextures());
		
		tbtmNull = new CTabItem(tabFolder, SWT.NONE);
		tbtmNull.setText("New Item");
	
		tabFolder.setSelection(tbtmNull);
		
		tbtmMateriel = new CTabItem(tabFolder, SWT.NONE);
		tbtmMateriel.setText("Matériel");
		
		Composite composite_19 = new Composite(tabFolder, SWT.NONE);
		tbtmMateriel.setControl(composite_19);
		composite_19.setLayout(new GridLayout(8, false));
		Label lblmaterial = new Label(composite_19, SWT.NONE);
		lblmaterial.setText("Materiaux");
		
		tableComboVwr_Mat = new TableComboViewerSearch(composite_19, SWT.NONE);
		TableCombo tableCombo = tableComboVwr_Mat.getTableCombo();
		tableCombo.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 6, 1));
		tableCombo.setEditable(true);
		tableCombo.setUpdateSelectionOnEnter(true);
		tableCombo.defineColumns(StaticUiObjects.MaterialColumns);
		tableCombo.setShowTableHeader(true);
		tableComboVwr_Mat.setContentProvider(ArrayContentProvider.getInstance());
		tableComboVwr_Mat.setLabelProvider(SingleImageItemLabelProvider.getInstance());
		tableComboVwr_Mat.setInput(ResourceManagers.getIntance().getMaterials());
		Button btnList = new Button(composite_19, SWT.CENTER);
		GridData gd_btnList = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
		gd_btnList.widthHint = 30;
		gd_btnList.heightHint = 30;
		btnList.setLayoutData(gd_btnList);
		btnList.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				ListEditorWindow listWindow = new MaterialListWindow(shell, null);
				listWindow.create();
				listWindow.setSelect(true);
				int ret = listWindow.open();
				tableComboVwr_Mat.setInput(ResourceManagers.getIntance().getMaterials());
				tableComboVwr_Mat.refresh();
				if (ret == Window.OK) {
					tableComboVwr_Mat.setSelection(new StructuredSelection(listWindow.getSelection()), true);
				}
			}
		});
		btnList.setImage(ResourceManager.getPluginImage("Dressing", "icons/list24.png"));

		Label lblFacade_2 = new Label(composite_19, SWT.NONE);
		lblFacade_2.setText("Materiaux Type");

		materialType = new MaterialTypeInstanceComposite(composite_19,SWT.NONE);
		materialType.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 7, 1));
		materialType.setSize(materialType.computeSize(SWT.DEFAULT, SWT.DEFAULT));
		tableComboVwr_Mat.addSelectionChangedListener(new ISelectionChangedListener() {

			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				IStructuredSelection selection2 = tableComboVwr_Mat.getStructuredSelection();
				Object se2 = selection2.getFirstElement();
				if (se2 != null && se2 instanceof Material) {
					Material mat = (Material) se2;
					if (mat.isApplyTexture() && mat.getImage() != null && !mat.getImage().isEmpty()) {
						String imagePath = mat.getImage();
						SceneTexture texture = null;
						if (ImageLoaderCache.isValidImagePath(imagePath)) {
							texture = ModelProvider.getTexture(imagePath);
						} else {
							imagePath = WorkspaceConfiguration.TEXTURES_FOLDER + File.separator + imagePath;
							texture = ModelProvider.getTexture(imagePath);
						}
						if (texture != null) {
							materialType.getTableComboViewerTexture()
									.setSelection(new StructuredSelection(texture), true);
						}

					}
				}
			}
		});
		//
		tbtmFacadeChant = new CTabItem(tabFolder, SWT.NONE);
		tbtmFacadeChant.setText("Chant d'élements");
		
		Composite composite_20 = new Composite(tabFolder, SWT.NONE);
		tbtmFacadeChant.setControl(composite_20);
		composite_20.setLayout(new GridLayout(2, false));
		

		tableComboVwr_ChantFacade = new TableComboViewerSearch(composite_20, SWT.READ_ONLY);
		TableCombo tableComboChantFacade = tableComboVwr_ChantFacade.getTableCombo();
		tableComboChantFacade.setEditable(true);
		GridData chntFacadeData=new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1);
		chntFacadeData.widthHint=200;
		tableComboChantFacade.setLayoutData(chntFacadeData);
		tableComboChantFacade.defineColumns(StaticUiObjects.ChantColumns);
		tableComboVwr_ChantFacade.setContentProvider(ArrayContentProvider.getInstance());
		tableComboVwr_ChantFacade.setLabelProvider(SingleImageItemLabelProvider.getInstance());
		tableComboVwr_ChantFacade.getTableCombo().setShowTableHeader(true);
		tableComboVwr_ChantFacade.setInput(ResourceManagers.getIntance().getChants().getChant());
		//
		Button btnList4 = new Button(composite_20, SWT.CENTER);
		GridData gd_btnList4 = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
		gd_btnList4.widthHint = 30;
		gd_btnList4.heightHint = 30;
		btnList4.setLayoutData(gd_btnList4);
		btnList4.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				ListEditorWindow listWindow = new ChantListWindow(shell, null);
				listWindow.create();
				listWindow.setSelect(true);
				int ret = listWindow.open();
				tableComboVwr_ChantFacade.setInput(ResourceManagers.getIntance().getChants().getChant());
				tableComboVwr_ChantFacade.refresh();
				if (ret == Window.OK) {
					tableComboVwr_ChantFacade.setSelection(new StructuredSelection(listWindow.getSelection()), true);
				}
			}
		});
		btnList4.setImage(ResourceManager.getPluginImage("Dressing", "icons/list24.png"));
		//
		//
		comboViewer.addSelectionChangedListener(new ISelectionChangedListener() {
			
			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				if(!event.getStructuredSelection().isEmpty()&& event.getStructuredSelection()!=null
						&&event.getStructuredSelection().getFirstElement()!=null &&event.getStructuredSelection().getFirstElement() instanceof String) {
					String value=(String) event.getStructuredSelection().getFirstElement();
					
					switch (value) {
					case LONGEUR:
						tabFolder.setSelection(tbtmLongeur);

						break;
					case HAUTEUR:
						tabFolder.setSelection(tbtmHauteur);

						break;
					case PROFONDEUR:
						tabFolder.setSelection(tbtmProfondeur);

						break;
					case LARGEUR:
						tabFolder.setSelection(tbtmLargeur);

						break;
					case X:
						tabFolder.setSelection(tbtmXpos);

						break;
					case Y:
						tabFolder.setSelection(tbtmYpos);

						break;
					case Z:
						tabFolder.setSelection(tbtmZpos);

						break;
					case ROTATION:
						tabFolder.setSelection(tbtmRotation);

						break;
					case POIGNEE:
						tabFolder.setSelection(tbtmPoignee);

						break;
					case PORTE:
						tabFolder.setSelection(tbtmPorte);

						break;
					case WALL_TEXTURE:
						tabFolder.setSelection(tbtmMurTexture);

						break;
					case FACADE_TEXTURE:
						tabFolder.setSelection(tbtmFacadeTexture);

						break;
					case MARBLE_TEXTURE:
						tabFolder.setSelection(tbtmMarbleTexture);

						break;
					case BOX_TEXTURE:
						tabFolder.setSelection(tbtmElementTexture);

						break;
					case CACHE_BAS_TEXTURE:
						tabFolder.setSelection(tbtmCacheBasTexture);

						break;
					case CACHE_BAS:
						tabFolder.setSelection(tbtmCacheBasHauteur);

						break;	
					case MATERIAL_fACADE:
						tabFolder.setSelection(tbtmMateriel);
						Material mat=getFacadeMaterieau();
						tableComboVwr_Mat.setSelection(new StructuredSelection(mat),true);
						//
						MaterialTypeInstance material=getFacadeMaterielType();
						if(material!=null) {
							materialType.setMaterial(material);
							materialType.setEnabled(true);
						}else {
							materialType.setEnabled(false);
						}
						break;	
					case MATERIAL_FAUSSE_fACADE:
						tabFolder.setSelection(tbtmMateriel);
						Material mat1=getFausseFacadeMaterieau();
						tableComboVwr_Mat.setSelection(new StructuredSelection(mat1),true);
						//
						MaterialTypeInstance materialtype=getFausseFacadeMaterielType();
						if(materialtype!=null) {
							materialType.setMaterial(materialtype);
							materialType.setEnabled(true);
						}else {
							materialType.setEnabled(false);
						}
						break;	
					case MATERIAL_ELEMENT:
						tabFolder.setSelection(tbtmMateriel);
						Material mat2=getElementMaterieau();
						tableComboVwr_Mat.setSelection(new StructuredSelection(mat2),true);
						//
						MaterialTypeInstance materialtype1=getElementMaterielType();
						if(materialtype1!=null) {
							materialType.setMaterial(materialtype1);
							materialType.setEnabled(true);
						}else {
							materialType.setEnabled(false);
						}
						break;	
					case MATERIAL_DOS:
						tabFolder.setSelection(tbtmMateriel);
						Material mat3=getDosMaterieau();
						tableComboVwr_Mat.setSelection(new StructuredSelection(mat3),true);
						//
						MaterialTypeInstance materialtype2=getDosMaterielType();
						if(materialtype2!=null) {
							materialType.setMaterial(materialtype2);
							materialType.setEnabled(true);
						}else {
							materialType.setEnabled(false);
						}
						break;	
					case MATERIAL_NICHE:
						tabFolder.setSelection(tbtmMateriel);
						Material mat4=getNicheMaterieau();
						tableComboVwr_Mat.setSelection(new StructuredSelection(mat4),true);
						//
						MaterialTypeInstance materialtype3=getNicheMaterielType();
						if(materialtype3!=null) {
							materialType.setMaterial(materialtype3);
							materialType.setEnabled(true);
						}else {
							materialType.setEnabled(false);
						}
						break;	
					case CHANT_FACADE:
						tabFolder.setSelection(tbtmFacadeChant);
						Chant chntFacade=getFacadeChant();
						tableComboVwr_ChantFacade.setSelection(new StructuredSelection(chntFacade),true);
						//
						
						break;
					case CHANT_ELEMENT:
						tabFolder.setSelection(tbtmFacadeChant);
						Chant chntElement=getElementChant();
						tableComboVwr_ChantFacade.setSelection(new StructuredSelection(chntElement),true);
						//
						
						break;
					default:
						tabFolder.setSelection(tbtmNull);
						break;
					}
				}
				
			}
		});
		ControlAdapter adaptor=new ControlAdapter() {

			@Override
			public void controlResized(ControlEvent e) {
				 Rectangle area2= MultiObjectActionWidow.this.getShell().getClientArea();
			     composite.setBounds(area2);
			}
			
		};
		parent.addControlListener(adaptor);
		composite.addControlListener(adaptor);
		getShell().addControlListener(adaptor);	
		getShell().setSize(800, 600);
		return composite;

	}
	public synchronized void  show() {
		if(!shell.isDisposed())
		{
			MultiObjectActionWidow.this.shell.setVisible(true);
			MultiObjectActionWidow.this.shell.setActive();

		}

	}
	public synchronized void hide() {
		if(!shell.isDisposed())
		{
			MultiObjectActionWidow.this.shell.setVisible(false);
		}

	}

	public CommandStack updateObject(){
		CommandStack stack=null;
		String value=(String) comboViewer.getStructuredSelection().getFirstElement();
		
		switch (value) {
		case LONGEUR:
			stack =new CommandStack("change from window", "change from window", new ArrayList<ChangeCommand>());
			for(WorldObject object:targets) {
				KitchenElement kitchenElement = (KitchenElement) object;
				try {
					Vector4 oldDimention=kitchenElement.getObjectDimention();
					Vector4 newDimention=kitchenElement.getObjectDimention();
					int spnl=spnlongeur.getSelection();

					if(object.getType().equals(ObjectType.DEFINED) && kitchenElement.getDesignObject()!=null) {
						MechanicPublicParam paramL = kitchenElement.getMechanicDesign().getPublicParam("global.l");
						if (paramL != null) {
							String l = paramL.getDefaultvalue();
							int longeur = Integer.valueOf(l);
							if(longeur!=spnl) {
								paramL.setDefaultvalue(String.valueOf(spnl));
								((Space3DFree)kitchenElement.getDesignObject()).update();
							}
							newDimention.x=spnl/1000f;
							
						}
					}else {
						newDimention.x=spnl/1000f;	
					}
					
					
					if(!newDimention.epsilonEquals(oldDimention, 0.0000001f))
					{
						object.setRealWorldDimension(new Vector4(newDimention.x,newDimention.y,newDimention.z,0));
						ScaleCommand scale= new ScaleCommand("move"+object.getName(), "move",  oldDimention, newDimention,object);
						stack.addCommand(scale);
						
						object.firePropertyChange("dimension", oldDimention, newDimention);
						((AbstractScreen) Scene.game.getScreen()).getController().updateObject2D(object);	
						object.setRequireRefrech(true);
					}
					
				} catch (NumberFormatException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (Exception e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
			break;
		case HAUTEUR:
			stack =new CommandStack("change from window", "change from window", new ArrayList<ChangeCommand>());
			for(WorldObject object:targets) {
				KitchenElement kitchenElement = (KitchenElement) object;
				try {
					Vector4 oldDimention=kitchenElement.getObjectDimention();
					Vector4 newDimention=kitchenElement.getObjectDimention();
					int spnh=spnHauteur.getSelection();

					if( kitchenElement.getDesignObject()!=null) {
						MechanicPublicParam paramH = kitchenElement.getMechanicDesign().getPublicParam("global.h");
						if (paramH != null) {
							String h = paramH.getDefaultvalue();
							int hauteur = Integer.valueOf(h);
							if(hauteur!=spnh) {
								paramH.setDefaultvalue(String.valueOf(spnh));
								((Space3DFree)kitchenElement.getDesignObject()).update();

							}
							newDimention.y=spnh/1000f;
						}
					}else {
						newDimention.y=spnh/1000f;	
					}
					
					
					if(!newDimention.epsilonEquals(oldDimention, 0.0000001f))
					{
						object.setRealWorldDimension(new Vector4(newDimention.x,newDimention.y,newDimention.z,0));
						ScaleCommand scale= new ScaleCommand("move"+object.getName(), "move",  oldDimention, newDimention,object);
						stack.addCommand(scale);
						
						object.firePropertyChange("dimension", oldDimention, newDimention);
						((AbstractScreen) Scene.game.getScreen()).getController().updateObject2D(object);	
						object.setRequireRefrech(true);
					}
				

				} catch (NumberFormatException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (Exception e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
			break;
		case PROFONDEUR:
			stack =new CommandStack("change from window", "change from window", new ArrayList<ChangeCommand>());
			for(WorldObject object:targets) {
				KitchenElement kitchenElement = (KitchenElement) object;
				try {
					Vector4 oldDimention = kitchenElement.getObjectDimention();
					Vector4 newDimention = kitchenElement.getObjectDimention();
					int spnp=spnProfondeur.getSelection();
					if(object.getType().equals(ObjectType.DEFINED) && kitchenElement.getDesignObject()!=null) {
						MechanicPublicParam paramP = kitchenElement.getMechanicDesign().getPublicParam("global.p");
						if (paramP != null) {
							String p = paramP.getDefaultvalue();
							int profondeur = Integer.valueOf(p);
							if(profondeur!=spnp) {
								paramP.setDefaultvalue(String.valueOf(spnp));
								((Space3DFree)kitchenElement.getDesignObject()).update();

							}
							newDimention.z=spnp/1000f;
						}
					}else {
						newDimention.z=spnp/1000f;	
					}
					
					
					if(!newDimention.epsilonEquals(oldDimention, 0.0000001f))
					{
						object.setRealWorldDimension(new Vector3(newDimention.x,newDimention.y,newDimention.z));
						ScaleCommand scale= new ScaleCommand("move"+object.getName(), "move",  oldDimention, newDimention,object);
						stack.addCommand(scale);
						object.firePropertyChange("dimension", oldDimention, newDimention);
						((AbstractScreen) Scene.game.getScreen()).getController().updateObject2D(object);	
						object.setRequireRefrech(true);

					}

				} catch (NumberFormatException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (Exception e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
			break;
		case LARGEUR:
			stack =new CommandStack("change from window", "change from window", new ArrayList<ChangeCommand>());
			for(WorldObject object:targets) {
				KitchenElement kitchenElement = (KitchenElement) object;
				try {
					Vector4 oldDimention = kitchenElement.getObjectDimention();
					Vector4 newDimention = kitchenElement.getObjectDimention();
					int spnlargeur=spnLargeur.getSelection();
					if(object.getType().equals(ObjectType.DEFINED) && kitchenElement.getDesignObject()!=null) {
						MechanicPublicParam paramLargeur = kitchenElement.getMechanicDesign().getPublicParam("global.largeur");
						if (paramLargeur != null) {
							String largeur = paramLargeur.getDefaultvalue();
							int large = Integer.valueOf(largeur);
							if(large!=spnlargeur) {
								paramLargeur.setDefaultvalue(String.valueOf(spnlargeur));	
								((Space3DFree)kitchenElement.getDesignObject()).update();
							}
							newDimention.w=spnlargeur/1000f;
						}
					}
					
					
					if(!newDimention.epsilonEquals(oldDimention, 0.0000001f))
					{
						ScaleCommand scale= new ScaleCommand("move"+object.getName(), "move",  oldDimention, newDimention,object);
						stack.addCommand(scale);
						
						object.firePropertyChange("dimension", oldDimention, newDimention);
						((AbstractScreen) Scene.game.getScreen()).getController().updateObject2D(object);	
						object.setRequireRefrech(true);
					}

				} catch (NumberFormatException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (Exception e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
			break;
		case X:
			stack =new CommandStack("change from window", "change from window", new ArrayList<ChangeCommand>());
			for(WorldObject object:targets) {
				Vector3 oldPosition=object.getRealWorldPosition();
				Vector3 newPosition=object.getRealWorldPosition();
				Vector4 dim=object.getRealWorldDimension();
				newPosition.x = spnX.getSelection()/1000f ;
				if(targets.get(0).getRotation()==90 || targets.get(0).getRotation()==-90) {
					newPosition.x+=dim.z/2f;
				}else {
					newPosition.x+=dim.x/2f;
				}
				if (!newPosition.epsilonEquals(oldPosition, 0.0000001f)) {
					object.setRealWorldPosition(newPosition);
					MoveCommand move = new MoveCommand("move " + object.getName(), "move", oldPosition, newPosition,
							object);
					stack.addCommand(move);
					object.firePropertyChange("position", oldPosition, newPosition);
					((AbstractScreen) Scene.game.getScreen()).getController().updateObject2D(object);	
					object.setRequireRefrech(true);
				}

			}
			break;
		case Y:
			stack =new CommandStack("change from window", "change from window", new ArrayList<ChangeCommand>());
			for(WorldObject object:targets) {
				Vector3 oldPosition=object.getRealWorldPosition();
				Vector3 newPosition=object.getRealWorldPosition();
				Vector4 dim=object.getRealWorldDimension();
				newPosition.y = spny.getSelection()/1000f + dim.y/2;

				if (!newPosition.epsilonEquals(oldPosition, 0.0000001f)) {
					object.setRealWorldPosition(newPosition);
					MoveCommand move = new MoveCommand("move " + object.getName(), "move", oldPosition, newPosition,
							object);
					stack.addCommand(move);
					
					object.firePropertyChange("position", oldPosition, newPosition);
					((AbstractScreen) Scene.game.getScreen()).getController().updateObject2D(object);	
					object.setRequireRefrech(true);
				}

			}
			break;
		case Z:
			stack =new CommandStack("change from window", "change from window", new ArrayList<ChangeCommand>());
			for(WorldObject object:targets) {
				Vector3 oldPosition=object.getRealWorldPosition();
				Vector3 newPosition=object.getRealWorldPosition();
				Vector4 dim=object.getRealWorldDimension();
				newPosition.z = spnz.getSelection()/1000f ;
				if(targets.get(0).getRotation()==90 || targets.get(0).getRotation()==-90) {
					newPosition.z+=dim.x/2f;
				}else {
					newPosition.z+=dim.z/2f;
				}
				if (!newPosition.epsilonEquals(oldPosition, 0.0000001f)) {
					object.setRealWorldPosition(newPosition);
					MoveCommand move = new MoveCommand("move " + object.getName(), "move", oldPosition, newPosition,
							object);
					stack.addCommand(move);
					object.firePropertyChange("position", oldPosition, newPosition);
					((AbstractScreen) Scene.game.getScreen()).getController().updateObject2D(object);	
					object.setRequireRefrech(true);
				}

			}
			break;
		case ROTATION:
			stack =new CommandStack("change from window", "change from window", new ArrayList<ChangeCommand>());
			for(WorldObject object:targets) {
				float newRotation =spnRotation.getSelection();
				float oldRotation =object.getRotation();

				if(oldRotation!=newRotation) {
					object.setRotation(newRotation);
					RotateCommand rotate =new RotateCommand("rotate "+object.getName(), "rotate", object, oldRotation, newRotation);
					stack.addCommand(rotate);
					
					object.firePropertyChange("Rotation", oldRotation, newRotation);
					((AbstractScreen) Scene.game.getScreen()).getController().updateObject2D(object);	
					object.setRequireRefrech(true);

				}

			}
			
			break;
		case POIGNEE:
			stack= updatePoignee();
			break;
		case PORTE:
			stack= updatePorte();

			break;
			
		case WALL_TEXTURE:
			stack =new CommandStack("change from window", "change from window", new ArrayList<ChangeCommand>());

			if(targets!=null && targets.size()>0) {
				for(WorldObject object:targets) {
					if(object!=null && object instanceof Wall) {
					}
				}
			}
			break;
		case FACADE_TEXTURE:
			stack =new CommandStack("change from window", "change from window", new ArrayList<ChangeCommand>());

			if(targets!=null && targets.size()>0) {
				for(WorldObject object:targets) {
					if(object!=null && object.getType().equals(ObjectType.DEFINED)) {
						KitchenElement kitchenElement = (KitchenElement) object;
						IStructuredSelection facadeselection=tcvFacadeTexture.getStructuredSelection();
						SceneTexture facadetexture=(SceneTexture) facadeselection.getFirstElement();
						SceneTexture objectfacadeTexture= kitchenElement.getFacadeTexture();
						if(!facadetexture.equals( kitchenElement.getFacadeTexture())) {
							kitchenElement.setFacadeTexture(facadetexture);
							 ChangeTextureCommand changeTexture=new ChangeTextureCommand("Modifier facade texture", "Modifier facade texture", ChangeTextureCommand.TEXTURE_FACADE, objectfacadeTexture, facadetexture, object);
							 stack.addCommand(changeTexture);
							 object.setRequireRefrech(true);
						}
					}
				}
			}	
			break;
		case MARBLE_TEXTURE:
			stack =new CommandStack("change from window", "change from window", new ArrayList<ChangeCommand>());
			if(targets!=null && targets.size()>0) {
				for(KitchenElement object:targets) {
					if(object!=null && object.getType().equals(ObjectType.DEFINED)) {
						IStructuredSelection marbleSelection=tcvMarbleTexture.getStructuredSelection();
						SceneTexture marbletexture=(SceneTexture) marbleSelection.getFirstElement();
						if(object.getType().equals(ObjectType.DEFINED)) {

						}
						if(object.getType().equals(ObjectType.POLY)) {
							if(!marbletexture.getPath().equals( object.getProperties().get("texture"))) {
								 object.setRequireRefrech(true);
							}
						}

						
					}
				}
			}
			break;
		case BOX_TEXTURE:
			stack =new CommandStack("change from window", "change from window", new ArrayList<ChangeCommand>());
			if(targets!=null && targets.size()>0) {
				for(KitchenElement object:targets) {
					if(object!=null && object.getType().equals(ObjectType.DEFINED)) {
						IStructuredSelection elementselection=tcvBoxTexture.getStructuredSelection();
						SceneTexture boxTexture=(SceneTexture) elementselection.getFirstElement();
						SceneTexture objectelementTexture= object.getBoxTexture();

						if(!boxTexture.equals( object.getBoxTexture())) {
							 object.setBoxTexture(boxTexture);
							 ChangeTextureCommand changeTexture=new ChangeTextureCommand("Modifier box texture", "Modifier box texture", ChangeTextureCommand.TEXTURE_BOX, objectelementTexture, boxTexture, object);
							 stack.addCommand(changeTexture);
							 object.setRequireRefrech(true);
						}	
					}
				}
			}
			break;
		case MATERIAL_fACADE:
			stack= updateFacadeMateriel();
			break;
		case MATERIAL_ELEMENT:
			stack= updateElmentMateriel();
			break;
		case MATERIAL_DOS:
			stack= updateDosMateriel();
			break;
		case MATERIAL_NICHE:
			stack= updateNicheMateriel();
			break;
		case MATERIAL_FAUSSE_fACADE:
			stack= updateFausseFacadeMateriel();
			break;
		case CHANT_FACADE:
			stack= updateFacadeChant(true);			
			break;
		case CHANT_ELEMENT:
			stack= updateFacadeChant(false);		
			break;	
		default:
			
			break;
		}
		if(stack!=null) {
			RoomController.refresh=true;

		}
		SuperCadMessageDialog.openMessage(MessageDialog.INFORMATION, getShell(), "Success", "Modifications appliquer avec succèes");
		return stack;
	}

	private CommandStack updatePorte() {
		CommandStack stack =new CommandStack("change from window", "change from window", new ArrayList<ChangeCommand>());

		for(KitchenElement object:targets) {
			if(object.getType().equals(ObjectType.DEFINED) && object.getDesignObject()!=null) {
				try {
					String caissonTypes=object.getDesignObject().getDesignCaissonType();
					boolean changed=false;
					//
					MechanicPublicParam paramPorteType = object.getDesignObject().getElementPorteType();
					if(paramPorteType !=null) {
						TypeDefElement porteType = paramPorteType.getTypedefelement();
						IStructuredSelection selection=comboViewer_PorteType.getStructuredSelection();
						Object se=selection.getFirstElement();
						if(se!=null && se instanceof TypeDefElement) {
							PortType typePort=PortType.valueOf(((TypeDefElement)se).getKey());
							if(!((typePort.equals(PortType.BASCULANT) ||typePort.equals(PortType.BASCULANT2H)||typePort.equals(PortType.BASCULANT2H2P))&& caissonTypes.contentEquals("HAUT")) ) {
								TypeDefElement sporteType=(TypeDefElement) se;
								if(sporteType!=porteType) {
									paramPorteType.setTypedefelement(sporteType);
									//
									DesignChangeParamCommand poignerChange= new DesignChangeParamCommand("Changer le Type du porte "+object.getName(), "move",object,"PORT_TYPE",true,porteType,sporteType);
									stack.addCommand(poignerChange);
									changed=true;
									//
								}
							}							
						}
					}
					//
					//
					MechanicPublicParam paramPorteDirection = object.getDesignObject().getElementPorteDirection();
					if(paramPorteDirection !=null) {
						TypeDefElement porteDirection = paramPorteDirection.getTypedefelement();
						IStructuredSelection selection=comboViewer_PorteDirection.getStructuredSelection();
						Object se=selection.getFirstElement();
						if(se!=null && se instanceof TypeDefElement) {
							TypeDefElement sporteDirection=(TypeDefElement) se;
							if(sporteDirection!=porteDirection) {
								paramPorteDirection.setTypedefelement(sporteDirection);
								//
								DesignChangeParamCommand poignerChange= new DesignChangeParamCommand("Changer le direction du porte "+object.getName(), "move",object,"PORT_TYPE",true,porteDirection,sporteDirection);
								stack.addCommand(poignerChange);
								changed=true;
								//
							}
						}
					}
					
					//
					if(changed) {
						((Space3DFree)object.getDesignObject()).update();
						object.firePropertyChange("dimension", null, "update");
						((AbstractScreen) Scene.game.getScreen()).getController().updateObject2D(object);					
						object.setRequireRefrech(true);
					}
					//
				} catch (ClassCastException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (Exception e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		
			
		}
		
		if(stack.getStack()!=null && stack.getStack().size()>0) {
			return stack;
		}
		
		return null;
	}
	private CommandStack updatePoignee() {
		CommandStack stack =new CommandStack("change from window", "change from window", new ArrayList<ChangeCommand>());

		for(KitchenElement object:targets) {
			
			if(object.getType().equals(ObjectType.DEFINED) && object.getDesignObject()!=null) {
				try {
					String caissonType=object.getDesignObject().getDesignCaissonType();
					PortType porteType=object.getDesignObject().getPorteType();
					boolean changed=false;
//					MechanicPublicParam paramPoigneePos = object.getDesignObject().getElementPoigneePosition();
//					if(paramPoigneePos !=null) {
//						TypeDefElement pos = paramPoigneePos.getTypedefelement();
//						IStructuredSelection selection=comboViewerPos.getStructuredSelection();
//						Object se=selection.getFirstElement();
//						if(se!=null && se instanceof TypeDefElement) {
//							TypeDefElement spos=(TypeDefElement) se;
//							if(spos!=pos) {
//								
//								paramPoigneePos.setTypedefelement(spos);
//								
//								//
//								DesignChangeParamCommand poignerChange= new DesignChangeParamCommand("Changer la position du poigner "+object.getDesignObject().getName(), "move",object,"POIGNEE_POSITION",true,pos,spos);
//								stack.addCommand(poignerChange);
//								
//								//
//							}
//							
//						}
//					}
					//
					
					MechanicPublicParam paramPoigneeOrient = object.getDesignObject().getElementPoigneeOrientation();
					if(paramPoigneeOrient !=null) {
						if(!caissonType.contentEquals("BLOCK_TIROIR")&& !caissonType.contentEquals("PORTE_BOTEILLE")
									&& !(caissonType.contentEquals("HAUT") && (porteType.equals(PortType.BASCULANT)||porteType.equals(PortType.BASCULANT)))) {
							
							TypeDefElement orient = paramPoigneeOrient.getTypedefelement();
							IStructuredSelection selection=comboViewerOrient.getStructuredSelection();
							PoigneePosition poigneePosition=object.getDesignObject().getPoigneePosition();
							
							Object se=selection.getFirstElement();
							if(se!=null && se instanceof TypeDefElement) {
								TypeDefElement sorient=(TypeDefElement) se;
								Orientation poigneeOrientation=Orientation.valueOf(sorient.getKey());
								if(sorient!=orient) {
									boolean valide=true;
									if (poigneeOrientation.equals(Orientation.HORIZONTAL) && (poigneePosition.equals(PoigneePosition.LEFT_MIDDLE)
											|| poigneePosition.equals(PoigneePosition.RIGHT_MIDDLE))) {

										valide = false;

									}
									if (poigneeOrientation.equals(Orientation.VERTICAL) && (poigneePosition.equals(PoigneePosition.BOTTOM_MIDDLE)
											|| poigneePosition.equals(PoigneePosition.TOP_MIDDLE))) {

										valide = false;

									}
									if(valide)
									{
										paramPoigneeOrient.setTypedefelement(sorient);
										//
										DesignChangeParamCommand poignerChange= new DesignChangeParamCommand("Changer l'orentation du poigner "+object.getName(), "move",object,"POIGNEE_ORIENTATION",true,orient,sorient);
										stack.addCommand(poignerChange);
										changed=true;
										//
									}
									
								}
							}
						}else {
							if(!object.getDesignObject().getPoigneeOrientation().equals(Orientation.HORIZONTAL)) {
								object.getDesignObject().setPoigneeOrientation(Orientation.HORIZONTAL);
							}
						}
					}
					
					//
					MechanicPublicParam paramPoigneeType = object.getDesignObject().getElementPoigneeType();
					if(paramPoigneeType !=null) {
						TypeDefElement poigneeType = paramPoigneeType.getTypedefelement();
						IStructuredSelection selection=comboViewer_PoigneeType.getStructuredSelection();
						Object se=selection.getFirstElement();
						if(se!=null && se instanceof TypeDefElement) {
							TypeDefElement spoigneeType=(TypeDefElement) se;
							if(spoigneeType!=poigneeType) {
								paramPoigneeType.setTypedefelement(spoigneeType);
								//
								DesignChangeParamCommand poignerChange= new DesignChangeParamCommand("Changer le Type du poigner "+object.getDesignObject().getName(), "move",object,"POIGNEE_TYPE",true,poigneeType,spoigneeType);
								stack.addCommand(poignerChange);
								
								//
								changed=true;
							}
						}
					}
					//
					if(changed) {
						((Space3DFree)object.getDesignObject()).update();
						object.firePropertyChange("dimension", null, "update");
						((AbstractScreen) Scene.game.getScreen()).getController().updateObject2D(object);					
						object.setRequireRefrech(true);
					}
					
					//
				} catch (ClassCastException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (Exception e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		
		}
		
		if(stack.getStack()!=null && stack.getStack().size()>0) {
			return stack;
		}
		
		return null;
	}
	private CommandStack updateFacadeMateriel() {
		CommandStack stack =new CommandStack("change from window", "change from window", new ArrayList<ChangeCommand>());

		for(KitchenElement object:targets) {
			
			if( object.getDesignObject()!=null) {
				try {
					String caissonType=object.getDesignObject().getDesignCaissonType();
					boolean changed=false;
					if(!caissonType.contentEquals("FAUSSE_FACADE")) {
						MechanicDesign design =((MechanicDesign)object.getDesignObject().getMechanicDesignDefinition());
						Object mat= tableComboVwr_Mat.getStructuredSelection().getFirstElement();
						Material material=(Material) mat;
						Material eltmat=((MechanicDesign)object.getDesignObject().getMechanicDesignDefinition()).getFacadeMaterial();
						if(mat!=null && !material.equals(eltmat)) {
							changed=true;
							((MechanicDesign)object.getDesignObject().getMechanicDesignDefinition()).setFacadeMaterial(material);
						}
						if(this.materialType.isDirty()) {
							MaterialTypeInstance materialtype=this.materialType.getMaterial();
							MaterialTypeInstance facadeMaterialType =design.getFacadeMaterialType();
							facadeMaterialType.setIsColor(materialtype.isIsColor());
							facadeMaterialType.setMaterial(materialtype.getMaterial());
							facadeMaterialType.setTexture(this.materialType.getSelectedTexture());
							if(this.materialType.getColorComposite().isDirty())
							{
								facadeMaterialType.setColor(this.materialType.getColorComposite().getEmfColor());
							}
							changed=true;
						}
					}
					//
					if(changed) {
						((Space3DFree)object.getDesignObject()).updateMaterials();
						object.firePropertyChange("dimension", null, "update");
						((AbstractScreen) Scene.game.getScreen()).getController().updateObject2D(object);					
						object.setRequireRefrech(true);
					}
					
					//
				} catch (ClassCastException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (Exception e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		
		}
		
		if(stack.getStack()!=null && stack.getStack().size()>0) {
			return stack;
		}
		
		return null;
	}
	
	private CommandStack updateFacadeChant(boolean isfacade) {
		CommandStack stack =new CommandStack("change from window", "change from window", new ArrayList<ChangeCommand>());

		for(KitchenElement object:targets) {
			
			if( object.getDesignObject()!=null) {
				try {
					boolean changed = false;
					MechanicDesign design = ((MechanicDesign) object.getDesignObject().getMechanicDesignDefinition());
					Object mat = tableComboVwr_ChantFacade.getStructuredSelection().getFirstElement();
					Chant material = (Chant) mat;
					Chant eltmat = isfacade?design.getChantFacade():design.getChantElement();
					if (mat != null && !material.equals(eltmat)) {
						changed = true;
						if(isfacade)
						{
							design.setChantFacade(material);
						}else {
							design.setChantElement(material);
						}
					}
					//
					if(changed) {
						((Space3DFree)object.getDesignObject()).updateMaterials();
						object.firePropertyChange("dimension", null, "update");
						object.setRequireRefrech(true);
					}
					
					//
				} catch (ClassCastException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (Exception e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		
		}
		
		if(stack.getStack()!=null && stack.getStack().size()>0) {
			return stack;
		}
		
		return null;
	}
	
	private CommandStack updateElmentMateriel() {
		CommandStack stack =new CommandStack("change from window", "change from window", new ArrayList<ChangeCommand>());

		for(KitchenElement object:targets) {
			
			if( object.getDesignObject()!=null) {
				try {
					String caissonType=object.getDesignObject().getDesignCaissonType();
					boolean changed=false;
					if(!caissonType.contentEquals("FAUSSE_FACADE")
							&& !caissonType.contentEquals("BAS_NICHE_H")&&!caissonType.contentEquals("BAS_NICHE_V")
							&&!caissonType.contentEquals("HAUT_NICHE_H")&&!caissonType.contentEquals("HAUT_NICHE_V")) {
						MechanicDesign design =((MechanicDesign)object.getDesignObject().getMechanicDesignDefinition());
						Object mat= tableComboVwr_Mat.getStructuredSelection().getFirstElement();
						Material material=(Material) mat;
						Material eltmat=((MechanicDesign)object.getDesignObject().getMechanicDesignDefinition()).getPrincipalmaterial();
						if(mat!=null && !material.equals(eltmat)) {
							changed=true;
							((MechanicDesign)object.getDesignObject().getMechanicDesignDefinition()).setPrincipalmaterial(material);
						}
						if(this.materialType.isDirty()) {
							MaterialTypeInstance materialtype=this.materialType.getMaterial();
							MaterialTypeInstance facadeMaterialType =design.getPrincipalMaterialType();
							facadeMaterialType.setIsColor(materialtype.isIsColor());
							facadeMaterialType.setMaterial(materialtype.getMaterial());
							facadeMaterialType.setTexture(this.materialType.getSelectedTexture());
							if(this.materialType.getColorComposite().isDirty())
							{
								facadeMaterialType.setColor(this.materialType.getColorComposite().getEmfColor());
							}
							changed=true;
						}
					}
					//
					if(changed) {
						((Space3DFree)object.getDesignObject()).updateMaterials();
						object.firePropertyChange("dimension", null, "update");
						((AbstractScreen) Scene.game.getScreen()).getController().updateObject2D(object);					
						object.setRequireRefrech(true);
					}
					
					//
				} catch (ClassCastException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (Exception e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		
		}
		
		if(stack.getStack()!=null && stack.getStack().size()>0) {
			return stack;
		}
		
		return null;
	}
	private CommandStack updateDosMateriel() {
		CommandStack stack =new CommandStack("change from window", "change from window", new ArrayList<ChangeCommand>());

		for(KitchenElement object:targets) {
			
			if(object.getDesignObject()!=null) {
				try {
					String caissonType=object.getDesignObject().getDesignCaissonType();
					boolean changed=false;
					if(!caissonType.contentEquals("FAUSSE_FACADE")) {
						MechanicDesign design =((MechanicDesign)object.getDesignObject().getMechanicDesignDefinition());
						Object mat= tableComboVwr_Mat.getStructuredSelection().getFirstElement();
						Material material=(Material) mat;
						Material eltmat=((MechanicDesign)object.getDesignObject().getMechanicDesignDefinition()).getSecondmaterial();
						if(mat!=null && !material.equals(eltmat)) {
							changed=true;
							((MechanicDesign)object.getDesignObject().getMechanicDesignDefinition()).setSecondmaterial(material);
						}
						if(this.materialType.isDirty()) {
							MaterialTypeInstance materialtype=this.materialType.getMaterial();
							MaterialTypeInstance facadeMaterialType =design.getSecondMaterialType();
							facadeMaterialType.setIsColor(materialtype.isIsColor());
							facadeMaterialType.setMaterial(materialtype.getMaterial());
							facadeMaterialType.setTexture(this.materialType.getSelectedTexture());
							if(this.materialType.getColorComposite().isDirty())
							{
								facadeMaterialType.setColor(this.materialType.getColorComposite().getEmfColor());
							}
							changed=true;
						}
					}
					//
					if(changed) {
						((Space3DFree)object.getDesignObject()).updateMaterials();
						object.firePropertyChange("dimension", null, "update");
						((AbstractScreen) Scene.game.getScreen()).getController().updateObject2D(object);					
						object.setRequireRefrech(true);
					}
					
					//
				} catch (ClassCastException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (Exception e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		
		}
		
		if(stack.getStack()!=null && stack.getStack().size()>0) {
			return stack;
		}
		
		return null;
	}
	private CommandStack updateNicheMateriel() {
		CommandStack stack =new CommandStack("change from window", "change from window", new ArrayList<ChangeCommand>());

		for(KitchenElement object:targets) {
			
			if(object.getDesignObject()!=null) {
				try {
					String caissonType=object.getDesignObject().getDesignCaissonType();
					boolean changed=false;
					if(caissonType.contentEquals("BAS_NICHE_H")||caissonType.contentEquals("BAS_NICHE_V")
							||caissonType.contentEquals("HAUT_NICHE_H")||caissonType.contentEquals("HAUT_NICHE_V"))
					{
						MechanicDesign design =((MechanicDesign)object.getDesignObject().getMechanicDesignDefinition());
						Object mat= tableComboVwr_Mat.getStructuredSelection().getFirstElement();
						Material material=(Material) mat;
						Material eltmat=((MechanicDesign)object.getDesignObject().getMechanicDesignDefinition()).getPrincipalmaterial();
						if(mat!=null && !material.equals(eltmat)) {
							changed=true;
							((MechanicDesign)object.getDesignObject().getMechanicDesignDefinition()).setPrincipalmaterial(material);
						}
						if(this.materialType.isDirty()) {
							MaterialTypeInstance materialtype=this.materialType.getMaterial();
							MaterialTypeInstance facadeMaterialType =design.getPrincipalMaterialType();
							facadeMaterialType.setIsColor(materialtype.isIsColor());
							facadeMaterialType.setMaterial(materialtype.getMaterial());
							facadeMaterialType.setTexture(this.materialType.getSelectedTexture());
							if(this.materialType.getColorComposite().isDirty())
							{
								facadeMaterialType.setColor(this.materialType.getColorComposite().getEmfColor());
							}
							changed=true;
						}
					}
					//
					if(changed) {
						((Space3DFree)object.getDesignObject()).update();
						object.firePropertyChange("dimension", null, "update");
						((AbstractScreen) Scene.game.getScreen()).getController().updateObject2D(object);					
						object.setRequireRefrech(true);
					}
					
					//
				} catch (ClassCastException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (Exception e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		
		}
		
		if(stack.getStack()!=null && stack.getStack().size()>0) {
			return stack;
		}
		
		return null;
	}
	private CommandStack updateFausseFacadeMateriel() {
		CommandStack stack =new CommandStack("change from window", "change from window", new ArrayList<ChangeCommand>());

		for(KitchenElement object:targets) {
			
			if(object.getType().equals(ObjectType.DEFINED) && object.getDesignObject()!=null) {
				try {
					String caissonType=object.getDesignObject().getDesignCaissonType();
					boolean changed=false;
					if(caissonType.contentEquals("FAUSSE_FACADE")) {
						MechanicDesign design =((MechanicDesign)object.getDesignObject().getMechanicDesignDefinition());
						Object mat= tableComboVwr_Mat.getStructuredSelection().getFirstElement();
						Material material=(Material) mat;
						Material eltmat=((MechanicDesign)object.getDesignObject().getMechanicDesignDefinition()).getFacadeMaterial();
						if(mat!=null && !material.equals(eltmat)) {
							changed=true;
							((MechanicDesign)object.getDesignObject().getMechanicDesignDefinition()).setFacadeMaterial(material);
						}
						if(this.materialType.isDirty()) {
							MaterialTypeInstance materialtype=this.materialType.getMaterial();
							MaterialTypeInstance facadeMaterialType =design.getFacadeMaterialType();
							facadeMaterialType.setIsColor(materialtype.isIsColor());
							facadeMaterialType.setMaterial(materialtype.getMaterial());
							facadeMaterialType.setTexture(this.materialType.getSelectedTexture());
							if(this.materialType.getColorComposite().isDirty())
							{
								facadeMaterialType.setColor(this.materialType.getColorComposite().getEmfColor());
							}
							changed=true;
						}
					}
					//
					if(changed) {
						((Space3DFree)object.getDesignObject()).updateMaterials();
						object.firePropertyChange("dimension", null, "update");
						((AbstractScreen) Scene.game.getScreen()).getController().updateObject2D(object);					
						object.setRequireRefrech(true);
					}
					
					//
				} catch (ClassCastException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (Exception e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		
		}
		
		if(stack.getStack()!=null && stack.getStack().size()>0) {
			return stack;
		}
		
		return null;
	}
	public boolean isContainDesign() {
		for(KitchenElement object:targets) {
			if(object!=null && object.getType().equals(ObjectType.DEFINED)&& object.getDesignObject()!=null) {
				return true;
			}
		}
		
		return false;
	}
	public boolean isContainFausseFacade() {
		for(KitchenElement object:targets) {
			if(object!=null && object.getType().equals(ObjectType.DEFINED)&& object.getDesignObject()!=null
				& object.getDesignObject().getMechanicDesignDefinition() instanceof MechanicDesign) {
					String caissonType=object.getDesignObject().getDesignCaissonType();
					if(caissonType.contentEquals("FAUSSE_FACADE"))
					{
						return true;
					}
			}
		}
		
		return false;
	}
	public boolean isContainNiche() {
		for(KitchenElement object:targets) {
			if(object!=null && object.getType().equals(ObjectType.DEFINED)&& object.getDesignObject()!=null
					& object.getDesignObject().getMechanicDesignDefinition() instanceof MechanicDesign) {
				String caissonType=object.getDesignObject().getDesignCaissonType();
				if(caissonType.contentEquals("BAS_NICHE_H")||caissonType.contentEquals("BAS_NICHE_V")
						||caissonType.contentEquals("HAUT_NICHE_H")||caissonType.contentEquals("HAUT_NICHE_V"))
				{
						return true;
				}
			}
		}
		
		return false;
	}
	public KitchenElement getFirstDesign() {
		for(KitchenElement object:targets) {
			if(object!=null && object.getType().equals(ObjectType.DEFINED)&& object.getDesignObject()!=null) {
				return object;
			}
		}
		
		return null;
	}
	public KitchenElement getFirstNonNullObject() {
		for(KitchenElement object:targets) {
			if(object!=null ) {
				return object;
			}
		}
		
		return null;
	}
	
	public SceneTexture getFacadeTexture() {
		if(targets!=null && targets.size()>0) {
			for(KitchenElement object:targets) {
				if(object!=null && object.getType().equals(ObjectType.DEFINED)&& object.getDesignObject()!=null) {
					return  object.getFacadeTexture();
				}
			}
		}
		return null;
	}
	public Material getFacadeMaterieau() {
		if(targets!=null && targets.size()>0) {
			for(KitchenElement object:targets) {
				if(object!=null && object.getType().equals(ObjectType.DEFINED)&& object.getDesignObject()!=null 
						& object.getDesignObject().getMechanicDesignDefinition() instanceof MechanicDesign) {
					String caissonType=object.getDesignObject().getDesignCaissonType();
					if(!caissonType.contentEquals("FAUSSE_FACADE"))
					{
						return  ((MechanicDesign)object.getDesignObject().getMechanicDesignDefinition()).getFacadeMaterial();
					}
				}
			}
		}
		
		
		return null;
	}
	public MaterialTypeInstance getFacadeMaterielType() {
		if(targets!=null && targets.size()>0) {
			for(KitchenElement object:targets) {
				if(object!=null && object.getType().equals(ObjectType.DEFINED)&& object.getDesignObject()!=null 
						& object.getDesignObject().getMechanicDesignDefinition() instanceof MechanicDesign) {
					String caissonType=object.getDesignObject().getDesignCaissonType();
					if(!caissonType.contentEquals("FAUSSE_FACADE"))
					{
						return  ((MechanicDesign)object.getDesignObject().getMechanicDesignDefinition()).getFacadeMaterialType();
					}
				}
			}
		}
		
		
		return null;
	}
	public Material getElementMaterieau() {
		if(targets!=null && targets.size()>0) {
			for(KitchenElement object:targets) {
				if(object!=null && object.getType().equals(ObjectType.DEFINED)&& object.getDesignObject()!=null 
						& object.getDesignObject().getMechanicDesignDefinition() instanceof MechanicDesign) {
					String caissonType=object.getDesignObject().getDesignCaissonType();
					if(!caissonType.contentEquals("FAUSSE_FACADE"))
					{
						return  ((MechanicDesign)object.getDesignObject().getMechanicDesignDefinition()).getPrincipalmaterial();
					}
				}
			}
		}
		
		
		return null;
	}
	
	public Chant getElementChant() {
		if(targets!=null && targets.size()>0) {
			for(KitchenElement object:targets) {
				if(object!=null && object.getType().equals(ObjectType.DEFINED)&& object.getDesignObject()!=null 
						& object.getDesignObject().getMechanicDesignDefinition() instanceof MechanicDesign) {
					String caissonType=object.getDesignObject().getDesignCaissonType();
					if(!caissonType.contentEquals("FAUSSE_FACADE"))
					{
						return  ((MechanicDesign)object.getDesignObject().getMechanicDesignDefinition()).getChantElement();
					}
				}
			}
		}
		
		
		return null;
	}
	public Chant getFacadeChant() {
		if(targets!=null && targets.size()>0) {
			for(KitchenElement object:targets) {
				if(object!=null && object.getType().equals(ObjectType.DEFINED)&& object.getDesignObject()!=null 
						& object.getDesignObject().getMechanicDesignDefinition() instanceof MechanicDesign) {
					String caissonType=object.getDesignObject().getDesignCaissonType();
					if(!caissonType.contentEquals("FAUSSE_FACADE"))
					{
						return  ((MechanicDesign)object.getDesignObject().getMechanicDesignDefinition()).getChantFacade();
					}
				}
			}
		}
		
		
		return null;
	}
	
	public MaterialTypeInstance getElementMaterielType() {
		if(targets!=null && targets.size()>0) {
			for(KitchenElement object:targets) {
				if(object!=null && object.getType().equals(ObjectType.DEFINED)&& object.getDesignObject()!=null 
						& object.getDesignObject().getMechanicDesignDefinition() instanceof MechanicDesign) {
					String caissonType=object.getDesignObject().getDesignCaissonType();
					if(!caissonType.contentEquals("FAUSSE_FACADE"))
					{
						return  ((MechanicDesign)object.getDesignObject().getMechanicDesignDefinition()).getPrincipalMaterialType();
					}
				}
			}
		}
		
		
		return null;
	}
	public Material getDosMaterieau() {
		if(targets!=null && targets.size()>0) {
			for(KitchenElement object:targets) {
				if(object!=null && object.getType().equals(ObjectType.DEFINED)&& object.getDesignObject()!=null 
						& object.getDesignObject().getMechanicDesignDefinition() instanceof MechanicDesign) {
					String caissonType=object.getDesignObject().getDesignCaissonType();
					if(!caissonType.contentEquals("FAUSSE_FACADE"))
					{
						return  ((MechanicDesign)object.getDesignObject().getMechanicDesignDefinition()).getSecondmaterial();
					}
				}
			}
		}
		
		
		return null;
	}
	public MaterialTypeInstance getDosMaterielType() {
		if(targets!=null && targets.size()>0) {
			for(KitchenElement object:targets) {
				if(object!=null && object.getType().equals(ObjectType.DEFINED)&& object.getDesignObject()!=null 
						& object.getDesignObject().getMechanicDesignDefinition() instanceof MechanicDesign) {
					String caissonType=object.getDesignObject().getDesignCaissonType();
					if(!caissonType.contentEquals("FAUSSE_FACADE"))
					{
						return  ((MechanicDesign)object.getDesignObject().getMechanicDesignDefinition()).getSecondMaterialType();
					}
				}
			}
		}
		
		
		return null;
	}
	public Material getNicheMaterieau() {
		if(targets!=null && targets.size()>0) {
			for(KitchenElement object:targets) {
				if(object!=null && object.getType().equals(ObjectType.DEFINED)&& object.getDesignObject()!=null 
						& object.getDesignObject().getMechanicDesignDefinition() instanceof MechanicDesign) {
					String caissonType=object.getDesignObject().getDesignCaissonType();
					if(caissonType.contentEquals("BAS_NICHE_H")||caissonType.contentEquals("BAS_NICHE_V")
							||caissonType.contentEquals("HAUT_NICHE_H")||caissonType.contentEquals("HAUT_NICHE_V"))
					{
						return  ((MechanicDesign)object.getDesignObject().getMechanicDesignDefinition()).getPrincipalmaterial();
					}
				}
			}
		}
		
		
		return null;
	}
	public MaterialTypeInstance getNicheMaterielType() {
		if(targets!=null && targets.size()>0) {
			for(KitchenElement object:targets) {
				if(object!=null && object.getType().equals(ObjectType.DEFINED)&& object.getDesignObject()!=null 
						& object.getDesignObject().getMechanicDesignDefinition() instanceof MechanicDesign) {
					String caissonType=object.getDesignObject().getDesignCaissonType();
					if(caissonType.contentEquals("BAS_NICHE_H")||caissonType.contentEquals("BAS_NICHE_V")
							||caissonType.contentEquals("HAUT_NICHE_H")||caissonType.contentEquals("HAUT_NICHE_V"))
					{
						return  ((MechanicDesign)object.getDesignObject().getMechanicDesignDefinition()).getPrincipalMaterialType();
					}
				}
			}
		}
		
		
		return null;
	}
	public Material getFausseFacadeMaterieau() {
		if(targets!=null && targets.size()>0) {
			for(KitchenElement object:targets) {
				if(object!=null && object.getType().equals(ObjectType.DEFINED)&& object.getDesignObject()!=null 
						& object.getDesignObject().getMechanicDesignDefinition() instanceof MechanicDesign) {
					String caissonType=object.getDesignObject().getDesignCaissonType();
					if(caissonType.contentEquals("FAUSSE_FACADE"))
					{
						return  ((MechanicDesign)object.getDesignObject().getMechanicDesignDefinition()).getFacadeMaterial();
					}
				}
			}
		}
		
		
		return null;
	}
	public MaterialTypeInstance getFausseFacadeMaterielType() {
		if(targets!=null && targets.size()>0) {
			for(KitchenElement object:targets) {
				if(object!=null && object.getType().equals(ObjectType.DEFINED)&& object.getDesignObject()!=null 
						& object.getDesignObject().getMechanicDesignDefinition() instanceof MechanicDesign) {
					String caissonType=object.getDesignObject().getDesignCaissonType();
					if(caissonType.contentEquals("FAUSSE_FACADE"))
					{
						return  ((MechanicDesign)object.getDesignObject().getMechanicDesignDefinition()).getFacadeMaterialType();
					}
				}
			}
		}
		
		
		return null;
	}
	
	public SceneTexture getBoxTexture() {
		if(targets!=null && targets.size()>0) {
			for(KitchenElement object:targets) {
				if(object!=null && object.getType().equals(ObjectType.DEFINED)&& object.getDesignObject()!=null) {
					return  object.getBoxTexture();
				}
			}
		}
		
		
		return null;
	}

	public void CreateControl() {
		this.values.clear();
		if(targets!=null && targets.size()>0 && targets.get(0)!=null){
			KitchenElement firstDesign=getFirstDesign();
			KitchenElement firstNonNullObject=getFirstNonNullObject();
			if(isContainDesign()&& firstDesign!=null)
			{
				//
				try {
					MechanicPublicParam paramL = firstDesign.getMechanicDesign().getPublicParam("global.l");
					if (paramL != null) {
						String l = paramL.getDefaultvalue();
						int longeur = Integer.valueOf(l);
						spnlongeur.setSelection(longeur);
						this.values.add(LONGEUR);

					}
				} catch (NumberFormatException e3) {
					// TODO Auto-generated catch block
					e3.printStackTrace();
				} catch (Exception e3) {
					// TODO Auto-generated catch block
					e3.printStackTrace();
				}
				try {
					MechanicPublicParam paramH = firstDesign.getMechanicDesign().getPublicParam("global.h");
					if (paramH != null) {

						String h = paramH.getDefaultvalue();
						int hauteur = Integer.valueOf(h);
						spnHauteur.setSelection(hauteur);
						this.values.add(HAUTEUR);	

					}
					
				} catch (NumberFormatException e2) {
					// TODO Auto-generated catch block
					e2.printStackTrace();
				} catch (Exception e2) {
					// TODO Auto-generated catch block
					e2.printStackTrace();
				}
				try {
					MechanicPublicParam paramP = firstDesign.getMechanicDesign().getPublicParam("global.p");
					if (paramP != null) {

						String p = paramP.getDefaultvalue();
						int profondeur = Integer.valueOf(p);
						spnProfondeur.setSelection(profondeur);
						this.values.add(PROFONDEUR);

					}
				} catch (NumberFormatException e1) {
					// TODO Auto-generated catch block
					e1.printStackTrace();
				} catch (Exception e1) {
					// TODO Auto-generated catch block
					e1.printStackTrace();
				} 
				try {
					MechanicPublicParam paramlargeur = firstDesign.getMechanicDesign().getPublicParam("global.largeur");
					if (paramlargeur != null) {
						String largeur = paramlargeur.getDefaultvalue();
						int iLargeur = Integer.valueOf(largeur);
						spnLargeur.setSelection(iLargeur);
						
						this.values.add(LARGEUR);

					} 
				}catch (Exception e) {
					e.printStackTrace();
				}
//				//
//				try {
//					MechanicPublicParam paramPoigneeType = firstDesign.getDesignObject().getElementPoigneeType();
//					if (paramPoigneeType != null) {
//						TypeDefElement poigneeType = paramPoigneeType.getTypedefelement();
//						TypeDef type =paramPoigneeType.getTypedef();
//					
//						comboViewer_PoigneeType.setInput(type);
//						comboViewer_PoigneeType.setSelection(new StructuredSelection(poigneeType), true);						
//
//					}
//					MechanicPublicParam paramPoigneePos = firstDesign.getDesignObject().getElementPoigneeOrientation();
//					if (paramPoigneePos != null) {
//						TypeDefElement poigneePos = paramPoigneePos.getTypedefelement();
//						TypeDef type =paramPoigneePos.getTypedef();
//					
//						comboViewerOrient.setInput(type);
//						comboViewerOrient.setSelection(new StructuredSelection(poigneePos), true);						
//
//					}
////					MechanicPublicParam paramPoigneeOrientation = firstDesign.getDesignObject().getElementPoigneePosition();
////					if (paramPoigneePos != null) {
////						TypeDefElement poigneeOrientation = paramPoigneeOrientation.getTypedefelement();
////						TypeDef type =paramPoigneeOrientation.getTypedef();
////					
////						comboViewerPos.setInput(type);
////						comboViewerPos.setSelection(new StructuredSelection(poigneeOrientation), true);						
////
////					}
//					this.values.add(POIGNEE);				
//				} catch (Exception e) {
//					// TODO Auto-generated catch block
//					e.printStackTrace();
//				}
//				try {
//					MechanicPublicParam paramPorteType = firstDesign.getDesignObject().getElementPorteType();
//					if (paramPorteType != null) {
//						TypeDefElement porteType = paramPorteType.getTypedefelement();
//						TypeDef type =paramPorteType.getTypedef();
//					
//						comboViewer_PorteType.setInput(type);
//						comboViewer_PorteType.setSelection(new StructuredSelection(porteType), true);						
//
//					}
//					MechanicPublicParam paramPorteDirection = firstDesign.getDesignObject().getElementPorteDirection();
//					if (paramPorteDirection != null) {
//						TypeDefElement porteDirection = paramPorteDirection.getTypedefelement();
//						TypeDef type =paramPorteDirection.getTypedef();
//					
//						comboViewer_PorteDirection.setInput(type);
//						comboViewer_PorteDirection.setSelection(new StructuredSelection(porteDirection), true);						
//
//					}
//				
//					this.values.add(PORTE);
//				} catch (Exception e) {
//					// TODO Auto-generated catch block
//					e.printStackTrace();
//				}
				this.values.add(MATERIAL_fACADE);
				this.values.add(MATERIAL_ELEMENT);
				this.values.add(MATERIAL_DOS);
				this.values.add(CHANT_FACADE);
				this.values.add(CHANT_ELEMENT);
				if(isContainFausseFacade())
				{
					this.values.add(MATERIAL_FAUSSE_fACADE);
				}
				if(isContainNiche())
				{
					this.values.add(MATERIAL_NICHE);
				}
			}else {
				if (firstNonNullObject.getRealWorldDimension() != null) {
					Vector4 dim = targets.get(0).getRealWorldDimension();
					//
					spnlongeur.setSelection((int) (dim.x * 1000));
					spnHauteur.setSelection((int) (dim.y * 1000));
					spnProfondeur.setSelection((int) (dim.z * 1000));
					this.values.add(LONGEUR);
					this.values.add(HAUTEUR);	
					this.values.add(PROFONDEUR);
				}
			}
			if (firstNonNullObject.getRealWorldPosition() != null) {
				Vector3 pos = targets.get(0).getRealWorldPosition();
				int x=(int)(pos.x*1000);
				int y=(int)(pos.y*1000);
				int z=(int)(pos.z*1000);
				if(targets.get(0).getRealWorldDimension()!=null) {
					Vector4 dim = targets.get(0).getRealWorldDimension();
					
					if(targets.get(0).getRotation()==90 || targets.get(0).getRotation()==-90) {
						x-=(int)(dim.z*500);
						z-=(int)(dim.x*500);
					}else {
						x-=(int)(dim.x*500);
						z-=(int)(dim.z*500);
					}
					
					y-=(int)(dim.y*500);

				}
//				spnX.setSelection(x);

				spny.setSelection(y);

//				spnz.setSelection(z);
				//
//				this.values.add(X);
				this.values.add(Y);
//				this.values.add(Z);
				//
			}
//			//
//			spnRotation.setSelection((int) firstNonNullObject.getRotation());
//			
//			this.values.add(ROTATION);
			
//			SceneTexture facade=getFacadeTexture();
//			if(facade!=null) {
//				this.tcvFacadeTexture.setSelection(new StructuredSelection(facade),true);
//				this.values.add(FACADE_TEXTURE);
//				
//			}
//			SceneTexture boxTexture=getBoxTexture();
//			if(boxTexture!=null) {
//				this.tcvBoxTexture.setSelection(new StructuredSelection(boxTexture),true);
//				this.values.add(BOX_TEXTURE);
//				
//			}

			
		}
		comboViewer.setInput(values);
		comboViewer.refresh();

	}
	
	
	public boolean validate(Object object2) {
		boolean valide=true;
		
		PoigneePosition pos=null;
		Orientation orient=null;
		PortType portType=null;
		PoigneeType  poigneeType=null;
		PorteDirection porteDirection=null;
		
		
		//
		IStructuredSelection selection=comboViewerPos.getStructuredSelection();
		Object se=selection.getFirstElement();
		
		if(se!=null && se instanceof TypeDefElement) {
			TypeDefElement spos=(TypeDefElement) se;
			pos=PoigneePosition.valueOf(spos.getKey());
			
		}
		//
		IStructuredSelection selectionorient=comboViewerOrient.getStructuredSelection();
		Object sorient=selectionorient.getFirstElement();
		
		if(sorient!=null && sorient instanceof TypeDefElement) {
			TypeDefElement sorients=(TypeDefElement) sorient;
			orient=Orientation.valueOf(sorients.getKey());
			
		}
		//
		IStructuredSelection selectionpoigneeType=comboViewer_PoigneeType.getStructuredSelection();
		Object spoigneeType=selectionpoigneeType.getFirstElement();
		
		if(spoigneeType!=null && spoigneeType instanceof TypeDefElement) {
			TypeDefElement spoigneeTypes=(TypeDefElement) spoigneeType;
			poigneeType=PoigneeType.valueOf(spoigneeTypes.getKey());
			
		}
		//
		IStructuredSelection selectionPorteType=comboViewer_PorteType.getStructuredSelection();
		Object sPorteType=selectionPorteType.getFirstElement();
		
		if(sPorteType!=null && sPorteType instanceof TypeDefElement) {
			TypeDefElement sPorteTypes=(TypeDefElement) sPorteType;
			portType=PortType.valueOf(sPorteTypes.getKey());
			
		}
		//
		IStructuredSelection selectionPorteDirction=comboViewer_PorteDirection.getStructuredSelection();
		Object sPorteDirection=selectionPorteDirction.getFirstElement();
		
		if(sPorteDirection!=null && sPorteDirection instanceof TypeDefElement) {
			TypeDefElement sPorteDirections=(TypeDefElement) sPorteDirection;
			porteDirection=PorteDirection.valueOf(sPorteDirections.getKey());
			
		}
		//
		if(pos!=null && orient !=null) {
			if (orient.equals(Orientation.HORIZONTAL) && (pos.equals(PoigneePosition.LEFT_MIDDLE)
					|| pos.equals(PoigneePosition.RIGHT_MIDDLE))) {

				valide = false;

			}
			if (orient.equals(Orientation.VERTICAL) && (pos.equals(PoigneePosition.BOTTOM_MIDDLE)
					|| pos.equals(PoigneePosition.TOP_MIDDLE))) {

				valide = false;

			}
			if(orient.equals(Orientation.VERTICAL) && pos.equals(PoigneePosition.CENTER)) {
				valide = false;
			}
			if(!valide) {
				MessageBox dialog = new MessageBox(MultiObjectActionWidow.this.getShell(), SWT.ICON_ERROR | SWT.OK | SWT.CANCEL);
				dialog.setText("Error");
				dialog.setMessage("impossible de faire la combination de poignee "+pos.toString()+" avec l'orientation "+orient.toString() );
				// open dialog and await user selection
				dialog.open();
			}
		}
		if (object2 != null && object2.equals(comboViewer_PorteDirection)) {
			if (porteDirection != null && pos != null) {
				if (portType != null && targets!=null && targets.size()>0 && portType.equals(PortType.FRANCAISE) && targets.get(0).getDesignObject().getLongeurext() <= 600) {
					switch (pos) {
					case BOTTOM_LEFT:
					case TOP_LEFT:
					case LEFT_MIDDLE:
						if (porteDirection.equals(PorteDirection.RIGHT)) {
							valide = false;
						}

						break;
					case BOTTOM_RIGHT:
					case TOP_RIGHT:
					case RIGHT_MIDDLE:
						if (porteDirection.equals(PorteDirection.LEFT)) {
							valide = false;
						}
						break;

					default:
						break;
					}

				
					if (!valide) {
						MessageBox dialog = new MessageBox(MultiObjectActionWidow.this.getShell(),SWT.ICON_ERROR | SWT.OK | SWT.CANCEL);
						dialog.setText("Error");
						dialog.setMessage("impossible de faire la combination de poignee " + pos.toString()+ " avec la porte en direction " + porteDirection.toString());
						// open dialog and await user selection
						dialog.open();
					}
				}
			}
		}
		
		
		return valide;
	}
	
	private static class ViewerLabelProvider extends LabelProvider {
		public Image getImage(Object element) {
			return super.getImage(element);
		}
		public String getText(Object element) {
			return (String) element;
		}
	}
	private static class ContentProvider implements IStructuredContentProvider {
		public Object[] getElements(Object inputElement) {
			if(inputElement instanceof Collection) {
				return ((Collection)inputElement).toArray();
			}
			return (Object[]) inputElement;
		}
		public void dispose() {
		}
		public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		}
	}
	
	//
	private static class TypeDefElementLabelProvider extends LabelProvider {
		@Override
		public String getText(Object element) {
			if(element!=null && element instanceof TypeDefElement)
			{
				TypeDefElement value=(TypeDefElement) element;
				return value.getName();

			}else {
				return "";
			}
		}
	}
	private static class TypeDefContentProvider implements IStructuredContentProvider {

		@Override
		public Object[] getElements(Object inputElement) {
			if(inputElement !=null && inputElement instanceof TypeDef ) {
				return ((TypeDef) inputElement).getTypedefelement().toArray();
			}
			return null;
		}
		
	}
}
