/*
 * Decompiled with CFR 0.152.
 */
package internal;

import api.backend.SWTGLApplication;
import api.graphics.PbrMaterial;
import api.graphics.Scene;
import api.graphics.geometry.Box;
import java.nio.ByteBuffer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.opengl.GLCanvas;
import org.eclipse.swt.opengl.GLData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.joml.Vector3f;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL40;
import org.lwjgl.opengl.GL45;
import org.lwjgl.stb.STBImageWrite;

public class CanavsTest {
    private Box box;
    private GLCanvas canvas;
    private SWTGLApplication application;

    public void createBox() {
        PbrMaterial material = new PbrMaterial();
        material.setAlbedo(new Vector3f(0.0f, 1.0f, 0.0f));
        material.setMetalness(0.9f);
        material.setRoughness(0.8f);
        material.setOpacity(1.0f);
        this.box = new Box(material);
        this.box.setupMesh();
        this.box.setMtl(material);
    }

    public void run() {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        GLData data = new GLData();
        data.doubleBuffer = true;
        this.canvas = new GLCanvas((Composite)shell, 0, data);
        this.canvas.setCurrent();
        GL.createCapabilities();
        this.printGLInfo();
        final Scene scene = new Scene();
        this.createBox();
        this.box.setupMesh();
        scene.addDrawable(this.box);
        this.application = new SWTGLApplication(this.canvas, scene);
        shell.open();
        this.canvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                float[] colorValue = new float[4];
                GL45.glGetTextureSubImage((int)CanavsTest.this.application.getBlitFrameBuffer().getDepthSampler().getHandle(), (int)0, (int)e.x, (int)(CanavsTest.this.canvas.getSize().y - e.y), (int)0, (int)1, (int)1, (int)1, (int)6408, (int)5126, (float[])colorValue);
                float[] viewport = new float[]{0.0f, 0.0f, CanavsTest.this.canvas.getSize().x, CanavsTest.this.canvas.getSize().y};
                Vector3f realWorldPoint = scene.getCamera().unproject(new Vector3f((float)e.x, (float)(CanavsTest.this.canvas.getSize().y - e.y), colorValue[0]), viewport);
                System.out.println("screen point: " + String.format("X: %d  Y: %d", e.x, e.y));
                System.out.println("wolrdPoint: " + String.format("X: %f  Y: %f Z: %f", Float.valueOf(realWorldPoint.x), Float.valueOf(realWorldPoint.y), Float.valueOf(realWorldPoint.z)));
            }
        });
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
        System.exit(0);
    }

    public void saveFrameBufferToFile(int framebuffer, int width, int height, String filename) {
        GL40.glBindFramebuffer((int)36160, (int)framebuffer);
        ByteBuffer buffer = BufferUtils.createByteBuffer((int)(width * height * 4));
        GL11.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (ByteBuffer)buffer);
        ByteBuffer flippedBuffer = BufferUtils.createByteBuffer((int)buffer.capacity());
        int y = 0;
        while (y < height) {
            int srcPos = (height - y - 1) * width * 4;
            int dstPos = y * width * 4;
            int x = 0;
            while (x < width * 4) {
                flippedBuffer.put(dstPos + x, buffer.get(srcPos + x));
                ++x;
            }
            ++y;
        }
        if (!STBImageWrite.stbi_write_png((CharSequence)filename, (int)width, (int)height, (int)4, (ByteBuffer)flippedBuffer, (int)(width * 4))) {
            System.err.println("Failed to save framebuffer texture to file: " + filename);
        }
        GL40.glBindFramebuffer((int)36160, (int)0);
    }

    public void printGLInfo() {
        String version = GL40.glGetString((int)7938);
        System.out.println("OpenGL Version: " + version);
        String renderer = GL40.glGetString((int)7937);
        System.out.println("Renderer: " + renderer);
        String vendor = GL40.glGetString((int)7936);
        System.out.println("Vendor: " + vendor);
        String shadingLanguageVersion = GL40.glGetString((int)35724);
        System.out.println("Shading Language Version: " + shadingLanguageVersion);
        String extensions = GL40.glGetString((int)7939);
        System.out.println("Extensions: " + extensions);
    }
}

