package supercad.graphics.quotations;

import java.awt.Desktop;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

import org.apache.lucene.util.MathUtil;
import org.frs.svg.Line;
import org.frs.svg.LineSegment;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer.ShapeType;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.utils.viewport.FitViewport;

import dressing.config.WorkspaceConfiguration;
import dressing.mathutils.MathUtilities;
import dressing.model.Kitchen;
import gdxapp.assets.AssetFont;
import gdxapp.object3d.KitchenElement;
import gdxapp.object3d.Object3D;
import gdxapp.object3d.WorldObject.ObjectType;
import gdxapp.quotation.Object3DQuotation;
import gdxapp.scenes.SceneManager;

public class OrthogonalQuotationManager {

	public List<Object3D> sources;
	public Camera camera;
	public List<Object3DQuotation> quots = new ArrayList<Object3DQuotation>();
	public ShapeRenderer shapeRenderer;
	public Vector3[] boundaries;
	private FrameBuffer buffer;
	private List<Vector3> points = new ArrayList<Vector3>();
	private String imageURL;

	private int interline = 10;

	public void generateQuotations() {
		points.clear();
		quots.clear();
		for (Object3D source : sources) {
			if (!(source.getWorldObject().getType() == ObjectType.MODELED && !source.getWorldObject().isConstraint()))
				quots.addAll(source.getQuotations());
		}

		ArrayList<Object3DQuotation> toRemove = new ArrayList<Object3DQuotation>();

		for (Object3DQuotation quot : quots) {
			quot.transformToCameraSpace(camera, buffer.getWidth(), buffer.getHeight());
			System.out.println("quotation length " + quot.getLength());
			if (quot.getLength() < 10) {
				toRemove.add(quot);
			} else {
				points.add(quot.getO0());
				points.add(quot.getO1());
			}
			System.out.println("quotation length " + quot.getLength());
		}
		quots.removeAll(toRemove);
		this.boundaries = MathUtilities.getBoundaries(points);
		System.out.println("boundaries: " + this.boundaries);

		ArrayList<Object3DQuotation> hQuots = new ArrayList<Object3DQuotation>();
		ArrayList<Object3DQuotation> vQuots = new ArrayList<Object3DQuotation>();
		for (var quot : quots) {
			Vector3 dir = quot.getDirection(false);
			if (Math.abs(dir.x) > Math.abs(dir.y)) {
				hQuots.add(quot);
			} else {
				vQuots.add(quot);
			}
		}
		// split v quots
		ArrayList<Object3DQuotation> leftQuots = new ArrayList<Object3DQuotation>();
		ArrayList<Object3DQuotation> rightQuots = new ArrayList<Object3DQuotation>();
		Vector3 center = this.boundaries[0].cpy().add(this.boundaries[1]).scl(0.5f);
		for (var quot : vQuots) {
			if (quot.getCenter().x < center.x) {
				leftQuots.add(quot);
			} else {
				rightQuots.add(quot);
			}
		}
		// split h quots
		ArrayList<Object3DQuotation> topQuots = new ArrayList<Object3DQuotation>();
		ArrayList<Object3DQuotation> bottomQuots = new ArrayList<Object3DQuotation>();
		for (var quot : hQuots) {
			if (quot.getCenter().y < center.y) {
				bottomQuots.add(quot);
			} else {
				topQuots.add(quot);
			}
		}

		// rearrange top quots
		Line topLine = new Line(boundaries[1].cpy(), Vector3.X);
		rearrange(topQuots, topLine, new Vector3(0, 1, 0));
		// rearrange top quots
		Line bottomLine = new Line(boundaries[0].cpy(), Vector3.X);
		rearrange(bottomQuots, bottomLine, new Vector3(0, -1, 0));
		// rearrange top quots
		Line leftLine = new Line(boundaries[0].cpy(), Vector3.Y);
		rearrange(leftQuots, leftLine, new Vector3(-1, 0, 0));// rearrange top quots
		Line rightLine = new Line(boundaries[1].cpy(), Vector3.Y);
		rearrange(rightQuots, rightLine, new Vector3(1, 0, 0));
		quots.clear();
		float textSpacing = 5;
		leftQuots.forEach(quot -> {
			quot.setTextRotation(-90);
			quot.setTextTranslation(new Vector3(-textSpacing, 0, 0));
		});
		rightQuots.forEach(quot -> {
			quot.setTextRotation(90);
			quot.setTextTranslation(new Vector3(textSpacing, 0, 0));

		});
		topQuots.forEach(quot -> {
			quot.setTextTranslation(new Vector3(0, -textSpacing, 0));

		});

		bottomQuots.forEach(quot -> {
			quot.setTextTranslation(new Vector3(0, -textSpacing, 0));

		});

		quots.addAll(topQuots);
		quots.addAll(bottomQuots);
		quots.addAll(leftQuots);
		quots.addAll(rightQuots);

	}

	void rearrange(ArrayList<Object3DQuotation> regionGrp, Line referenceLine, Vector3 sortingDirection) {

		ArrayList<Object3DQuotation> tmpList = new ArrayList<Object3DQuotation>();
		for (var quot : regionGrp) {
			Vector3 p0 = referenceLine.prj(quot.getO0());
			Vector3 p1 = referenceLine.prj(quot.getO1());
			var q = new Object3DQuotation(p0, p1, quot.getSource(), quot.getValue());
			tmpList.add(q);
		}
		if (tmpList.size() > 1) {

			// remove equals
			boolean noMoreEquals = false;
			do {
				noMoreEquals = true;
				for (int i = 0; i < tmpList.size() - 1; i++) {
					Object3DQuotation current = tmpList.get(i);
					boolean hasEqual = false;
					for (int j = i + 1; j < tmpList.size(); j++) {
						Object3DQuotation other = tmpList.get(j);
						if (Math.abs(current.getValue() - other.getValue()) < 0.1f) {
							if (other.getCenter().dst(current.getCenter()) < 1) {
								if (Math.abs(other.getLength() - current.getLength()) < 1) {
									hasEqual = true;
									break;
								}
							}
						}
					}
					if (hasEqual) {
						noMoreEquals = false;
						tmpList.remove(i);
						break;
					}
				}
			} while (tmpList.size() > 0 && !noMoreEquals);
			tmpList.sort(new Comparator<Object3DQuotation>() {
				@Override
				public int compare(Object3DQuotation o1, Object3DQuotation o2) {
					return (int) Math.signum(o2.getLength() - o1.getLength());
				}

			});
			ArrayList<List<Object3DQuotation>> levels = new ArrayList<List<Object3DQuotation>>();
			boolean stop = true;
			do {
				stop = true;
				for (int c = 0; c < tmpList.size() - 1; c++) {
					var current = tmpList.get(c);
					boolean overlaps = false;
					for (int i = c + 1; i < tmpList.size(); i++) {
						if (overlapOnScreen(current, tmpList.get(i))) {
							List<Object3DQuotation> grp = null;
							for (var level : levels) {
								if (!overlapOnScreen(current, level)) {
									grp = level;
									break;
								}
							}
							if (grp == null) {
								grp = new ArrayList<Object3DQuotation>();
								levels.add(grp);
							}
							grp.add(current);
							tmpList.remove(current);
							overlaps = true;
							break;
						}
					}
					if (overlaps) {
						stop = false;
						break;
					}
				}
			} while (tmpList.size() > 1 && !stop);

			int h = 20 * levels.size();
			regionGrp.clear();
			for (var level : levels) {
				for (var quot : level) {
					quot.translate(sortingDirection.cpy().scl(h));
				}
				regionGrp.addAll(level);
				h -= 20;
			}
			regionGrp.addAll(tmpList);
		}

	}

	boolean overlapOnScreen(Object3DQuotation q0, Object3DQuotation q1) {
		LineSegment seg0 = new LineSegment(q0.getO0(), q0.getO1());
		LineSegment seg1 = new LineSegment(q0.getO0(), q1.getO1());
		Vector3 dir = q0.getDirection(true);
		var points = new ArrayList<Float>();
		points.add(seg0.getV0().dot(dir));
		points.add(seg0.getV1().dot(dir));
		points.add(seg1.getV0().dot(dir));
		points.add(seg1.getV1().dot(dir));
		points.sort(new Comparator<Float>() {
			@Override
			public int compare(Float o1, Float o2) {
				return (int) Math.signum(o1 - o2);
			}
		});
		float min = points.get(0), max = points.get(3);
		float sumOfLength = q0.getLength() + q1.getLength();
		float range = max - min;
		System.out.println("range: " + range + "sum of length" + sumOfLength);
		return range - sumOfLength < -5;
	}

	boolean overlapOnScreen(Object3DQuotation quot, List<Object3DQuotation> list) {
		for (var quotX : list) {
			if (overlapOnScreen(quot, quotX))
				return true;
		}
		return false;
	}

	public void sort(LineSegment key, ArrayList<Object3DQuotation> quots) {
		quots.sort((o1, o2) -> {
			return Math.round(o1.getLength() - o2.getLength());
		});
		for (var quotation : quots) {
			Vector3 translation = key.getCenter().cpy().sub(quotation.getCenter());
			quotation.translate(translation);
			System.err.println("translation: " + translation);
		}
		this.quots.addAll(quots);

	}

	public String exportSVG() {
		String bgID = Base64.getUrlEncoder().encodeToString(UUID.randomUUID().toString().getBytes());
		StringBuilder stringBuilder = new StringBuilder();
		stringBuilder.append(String.format(
				"<svg width=\"%d\" height=\"%d\" xmlns=\"http://www.w3.org/2000/svg\" style=\"border:1px solid black\">\r\n",
				buffer.getWidth(), buffer.getHeight()));
		String imageLink = """
						<defs>
						  <pattern id="%s" patternUnits="userSpaceOnUse" width="%d" height="%d">
								  <image href="%s" x="0" y="0" width="%d" height="%d" />
						  </pattern>
						</defs>
				""";
		stringBuilder.append(String.format(imageLink, bgID, buffer.getWidth(), buffer.getHeight(),
				imageURL.replace("\\", "/"), buffer.getWidth(), buffer.getHeight()));
		String background = "<rect xmlns=\"http://www.w3.org/2000/svg\" width=\"%d\" height=\"%d\" fill=\"url(#%s)\"/>";
		stringBuilder.append(String.format(background, buffer.getWidth(), buffer.getHeight(), bgID));
		for (var quot : quots) {
			stringBuilder.append(quot.drawSVG() + "\r\n");
		}
		
		for(Object3D source: sources) {
			var worldObject = source.getWorldObject();
			if(worldObject instanceof KitchenElement) {
				boolean fausseFacade = ((KitchenElement) worldObject).getDesignObject().isFausseFacade();
				String color = fausseFacade?"red":"gray";
				Vector3 position = worldObject.getRealWorldPosition().cpy();
				camera.project(position, 0, 0, buffer.getWidth(), buffer.getHeight()).scl(1,-1,0).add(0, buffer.getHeight(), 0);
				String svg = """
								<circle cx="$x" cy="$y" r="18" fill="$color" stroke="none" />
								<circle cx="$x" cy="$y" r="13" fill="white" stroke="none" />  
								<text x="$x" y="$y" fill="black" text-anchor="middle" dominant-baseline="central">$d</text>
							"""
							.replace("$color", color)
							.replace("$x", String.format("%.0f", position.x))
							.replace("$y", String.format("%.0f", position.y))
							.replace("$d",String.format("%d", ((KitchenElement) worldObject).getDesignObjectSceneIndex()));
				stringBuilder.append(svg + "\r\n");
			}
		}
		stringBuilder.append("</svg>");
		return stringBuilder.toString();

//		String fileName = Base64.getUrlEncoder().encodeToString(UUID.randomUUID().toString().getBytes()) + ".svg";
//		File file = new File(WorkspaceConfiguration.APP_DATA + File.separator + "tmp" + File.separator + fileName);
//		try {
//			file.getParentFile().mkdirs();
//			file.createNewFile();
//			FileOutputStream fos = new FileOutputStream(file);
//			fos.write(stringBuilder.toString().getBytes());
//			fos.close();
//		} catch (IOException e) {
//			// TODO Auto-generated catch block
//			e.printStackTrace();
//		}
//		return file.getPath();

	}

	public List<Object3D> getSources() {
		return sources;
	}

	public void setSources(List<Object3D> sources) {
		this.sources = sources;
	}

	public Camera getCamera() {
		return camera;
	}

	public void setCamera(Camera camera) {
		this.camera = camera;
	}

	public FrameBuffer getBuffer() {
		return buffer;
	}

	public void setBuffer(FrameBuffer buffer) {
		this.buffer = buffer;
	}

	public String getImageURL() {
		return imageURL;
	}

	public void setImageURL(String imageURL) {
		this.imageURL = imageURL;
	}

}
