package gdxapp.screens.wall;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer.ShapeType;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.viewport.FitViewport;

import dressing.events.Event;
import dressing.events.EventDriver;
import dressing.events.EventHandler;
import dressing.mathutils.Surface;
import dressing.mathutils.Vector4;
import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.Intervale;
import dressing.model.ProjectManager;
import dressing.model.Space3DFree;
import dressing.model.SuperCadClipBoard;
import dressing.ui.ChangeCommandController;
import dressing.ui.RemoveObjectCommand;
import dressing.ui.usinage.HabillageCreator;
import gdxapp.Commun.Fleche;
import gdxapp.Commun.GroupSelection;
import gdxapp.Commun.Measure;
import gdxapp.Commun.ScreenController;
import gdxapp.assets.AssetsTextures;
import gdxapp.assets.DrawingHelper;
import gdxapp.object3d.KitchenElement;
import gdxapp.object3d.ModeledObject;
import gdxapp.object3d.Object2D;
import gdxapp.object3d.Wall;
import gdxapp.object3d.WorldObject;
import gdxapp.object3d.WorldObject.ObjectType;
import gdxapp.scenes.SceneEvent;
import gdxapp.screens.ObjectEditor.PlumbingEditor;
import gdxapp.screens.room.RoomController;
import gdxapp.ui.ActionItem;
import gdxapp.ui.Note;
import gdxapp.ui.ObjectMenuList;
import param.MechanicPublicParam;
import resources.IconsResource;

public class SurfaceController implements ScreenController, EventHandler {

	private Surface surface;
	private Array<Object2D> attachedActors;
	private Stack stack;
	private Table background, actorsLayer;
	private Stage stage;
	private InputMultiplexer inputMultiplexer;
	private SurfaceManager wallSpaceManager;
	private float scaleX, scaleY;
	private Object2D reference = null;
	private ArrayList<ArrayList<Vector3>> pipes;
	private boolean handleEvent;

	ChangeCommandController changeCommandController = new ChangeCommandController();

	SurfaceController(Surface surface) {
		this.surface = surface;
		attachedActors = new Array<Object2D>();
		init();
		wallSpaceManager = new SurfaceManager(this, scaleX, scaleY);
		subscribe(SceneEvent.REMOVE_OBJECT_REQUEST.name(),SceneEvent.OBJECT_SELECTED.name(),
				SceneEvent.OBJECT_CHANGED.name(), SceneEvent.OBJECT_RIGHT_CLICK.name(),
				SceneEvent.OBJECT_DROP.name());
	}

	public void init() {
		prepareStage();
		buildLayers();
	}

	void prepareStage() {
		if (stage == null) {
			surface.setSurfaceDimension();
			float width, height;
			if (surface.getLength() > surface.getHeight()) {
				width = Gdx.graphics.getWidth();
				height = surface.getHeight() / surface.getLength() * width;
			} else {
				height = Gdx.graphics.getHeight();
				width = surface.getLength() / surface.getHeight() * height;
			}

			stage = new Stage(new FitViewport(width, height));
			surface.calculateTransform(width, height);
			setInputMultiplexer(new InputMultiplexer());
			getInputMultiplexer().addProcessor(stage);
			getInputMultiplexer().addProcessor(new WallActionController(this));
			Gdx.input.setInputProcessor(getInputMultiplexer());
			setStageScales();
		}
	}

	void buildLayers() {
		stack = new Stack();
		stack.setFillParent(true);
		stage.addActor(stack);
		buildBackgroundLayer();
		buildActorLayer();
	}

	public void buildBackgroundLayer() {
		background = new Table();
		ProjectManager.instance.getCurrentScene().getPreferences().getWallMtl().prepare();
		Image image = new Image(ProjectManager.instance.getCurrentScene().getPreferences().getWallMtl().getAlbedoMap());
		background.add(image).grow();
		stack.add(background);
	}

	public void rebuildBackgroundLayer() {
		background.clear();
		Image image = new Image(ProjectManager.instance.getCurrentScene().getPreferences().getWallMtl().getAlbedoMap());
		background.add(image).grow();
	}

	private void buildActorLayer() {
		actorsLayer = new Table();
		stack.add(actorsLayer);
	}

	@Override
	public void dropActor(Object actor, float x, float y) {
		if (actor instanceof WorldObject) {
			Object2D article = new Object2D((WorldObject) actor);
			article.setTopView(false);
			actorsLayer.addActor(article);
			setStageDimension(article);
			float z = article.getWorldObject().getRealWorldDimension().z * 0.5f;
			if (article.getWorldObject().isConstraint()) {
				z *= -1;
			}
			article.setZ(z);

			if (!placeActor(article, x, y)) {
				actorsLayer.removeActor(article);
				ProjectManager.getManager().getCurrentScene().removeWorldObject((WorldObject) actor);
			} else {
				attachedActors.add(article);
				this.wallSpaceManager.addActor(article);
				//
				surfaceAssist(article);
				WorldObject object = (WorldObject) actor;
				if (object instanceof KitchenElement) {
					DesignObject3D design = ((KitchenElement) object).getDesignObject();
					if (design != null && design.getDesignCaissonType() != null) {
						String caissonType = design.getDesignCaissonType();
//						if(caissonType!=null && !caissonType.contentEquals("FAUSSE_FACADE"))
//						{
//							fitToPlacebySides(article, attachedActors);
//						}
					}
				}
				object.setRotation(surface.getyRotation());
				ProjectManager.getManager().getCurrentScene().addActor((WorldObject) actor, false);

			}
		}
	}

	boolean placeActor(Object2D actor, float x, float y) {
		float stageHeight, gHeight;
		stageHeight = this.stage.getHeight();
		gHeight = Gdx.graphics.getHeight();
		y -= 0.5f * (gHeight - stageHeight);
		return this.wallSpaceManager.setArticlePosition(actor, new Vector2(x, y));
	}

	private void setStageScales() {
		scaleX = stage.getWidth() / surface.getLength();
		scaleY = stage.getHeight() / surface.getHeight();
	}

	private void setStageDimension(Object2D actor) {
		setStageScales();
		float stageWidth, stageHeight;
		stageWidth = actor.getWorldObject().getActiveWidth() * scaleX;
		stageHeight = actor.getWorldObject().getRealWorldDimension().y * scaleY;
		actor.setSize(stageWidth, stageHeight);
	}

	public void setActorsRealWorldPosition() {
		for (Object2D actor : attachedActors) {
			float x = (actor.getX() + actor.getWidth() / 2);
			float y = (actor.getY() + actor.getHeight() / 2);
			Vector3 realPosition = surface.toWorldCoords(new Vector3(x, y, actor.getZ()));
			actor.getWorldObject().setRealWorldPosition(realPosition);
			actor.getWorldObject().setActiveWidth(false);
		}
	}

	public void adjustPosition(Object2D object2d) {
		Vector4 dimension = object2d.getWorldObject().getRealWorldDimension();
		if (surface.getNormal().equals(new Vector3(0, 0, 1))) {
			object2d.getWorldObject().getRealWorldPosition().add(0, 0, 0.5f * dimension.z);
		}
		if (surface.getNormal().equals(new Vector3(0, 0, -1))) {
			object2d.getWorldObject().getRealWorldPosition().add(0, 0, -0.5f * dimension.z);
		}
		if (surface.getNormal().equals(new Vector3(-1, 0, 0))) {
			object2d.getWorldObject().getRealWorldPosition().add(-0.5f * dimension.z, 0, 0);
		}
		if (surface.getNormal().equals(new Vector3(1, 0, 0))) {
			object2d.getWorldObject().getRealWorldPosition().add(0.5f * dimension.z, 0, 0);
		}
	}

	private void fitToStage(Object2D object2d) {
		float height = object2d.getWorldObject().getRealWorldDimension().y * scaleY;
		float width = object2d.getWorldObject().getActiveWidth() * scaleX;
		object2d.setWidth(width);
		object2d.setHeight(height);
		Vector3 positionSurface = surface.toSurfaceCoords(object2d.getWorldObject().getRealWorldPosition());
		Vector2 position = new Vector2(positionSurface.x, positionSurface.y);
		position.x -= width / 2;
		position.y -= height / 2;
		object2d.setPosition(position.x, position.y);
		object2d.setZ(positionSurface.z);
		if (object2d.getWorldObject() instanceof KitchenElement && !object2d.getWorldObject().isConstraint())
			object2d.setZ(((KitchenElement) object2d.getWorldObject()).getActiveDepth() * 0.5f);
	}

	private Vector3 getSurfacePosition(Object2D object2d) {
		float height = object2d.getWorldObject().getRealWorldDimension().y * scaleY;
		float width = object2d.getWorldObject().getActiveWidth() * scaleX;
		Vector3 position = surface.toSurfaceCoords(object2d.getWorldObject().getRealWorldPosition().cpy());
		position.x -= width / 2;
		position.y -= height / 2;
		return position;
	}

	private Vector2 getSurfaceDimension(Object2D object2d) {
		float height = object2d.getWorldObject().getRealWorldDimension().y * scaleY;
		float width = object2d.getWorldObject().getActiveWidth() * scaleX;

		return new Vector2(width, height);
	}

	public void resize() {
		for (Object2D actor : attachedActors) {
			setStageDimension(actor);
		}
	}

	Object2D getSelectedActor() {
		for (Object2D actor : attachedActors) {
			if (actor.getWorldObject().isSelected())
				return actor;
		}
		return null;
	}

	@Override
	public void reloadActors() {
		attachedActors.clear();
		actorsLayer.clear();
		for (WorldObject wObject : ProjectManager.instance.getCurrentScene().getSceneObjects()) {
			if (!(wObject instanceof Wall) && !wObject.getType().equals(ObjectType.POLY)) {
				Object2D object2D = new Object2D(wObject);
				object2D.setTopView(false);
				float rot = wObject.getRotation();
				if ((Math.abs((Math.abs(rot - surface.getyRotation()) - 90) % 180) < 1)) {
					wObject.setActiveWidth(true);
				} else {
					wObject.setActiveWidth(false);
				}
				Vector2 dimension = getSurfaceDimension(object2D);
				Vector3 position = getSurfacePosition(object2D);
				if (!(position.z < -object2D.getWorldObject().getRealWorldDimension().z
						|| position.z > object2D.getWorldObject().getRealWorldDimension().z
						|| position.x + dimension.x < 0 || position.x / scaleX > surface.getLength())) {
					fitToStage(object2D);
					actorsLayer.addActor(object2D);
					attachedActors.add(object2D);
				}
			}
		}
		addPlumbingPipes();
		for (Note note : ProjectManager.instance.getCurrentScene().getNotes()) {
			if (note.getContext() != null && note.getContext().equals(this.surface))
				stage.addActor(note);
		}
		for (Measure measure : ProjectManager.instance.getCurrentScene().getMeasures()) {
			if (measure.getContext() != null && measure.getContext().equals(this.surface))
				stage.addActor(measure.getLineSegment());
		}
		for (Fleche fleche : ProjectManager.instance.getCurrentScene().getFleches()) {
			if (fleche.getContext() != null && fleche.getContext().equals(this.surface)) {
				stage.addActor(fleche.getFlecheSegment());
			}
		}
		if (!stage.getActors().contains(ObjectPositioner.getPositioner(), true)) {
			stage.addActor(ObjectPositioner.getPositioner());
		}
		if (!getInputMultiplexer().getProcessors().contains(ObjectPositioner.getPositioner(), true)) {
			getInputMultiplexer().addProcessor(ObjectPositioner.getPositioner());
			Gdx.input.setInputProcessor(getInputMultiplexer());
		}

		RoomController.refresh = false;
	}

	private void addPlumbingPipes() {
		if (pipes == null) {
			pipes = new ArrayList<ArrayList<Vector3>>();
		} else {
			pipes.clear();
		}
		for (ArrayList<Vector3> pipe : PlumbingEditor.getEditor().getLines()) {
			ArrayList<Vector3> line = new ArrayList<Vector3>();
			for (Vector3 vertex : pipe) {
				line.add(surface.toSurfaceCoords(vertex));
			}
			pipes.add(line);
		}
	}

	public void drawPipes() {
		DrawingHelper.getDebugRenderer().setProjectionMatrix(stage.getBatch().getProjectionMatrix());
		DrawingHelper.getDebugRenderer().begin(ShapeType.Line);
		DrawingHelper.getDebugRenderer().setColor(Color.RED);
		for (ArrayList<Vector3> pipe : pipes) {
			if (pipe.size() > 0) {
				for (int i = 0; i < pipe.size() - 1; i++) {
					DrawingHelper.getDebugRenderer().rectLine(pipe.get(i).x, pipe.get(i).y, pipe.get(i + 1).x,
							pipe.get(i + 1).y, 5);
				}
			}
		}
		DrawingHelper.getDebugRenderer().end();

	}

	public Array<Object2D> getAttachedActors() {
		return attachedActors;
	}

	@Override
	public void updateWorldObject(Object2D object2d) {
		float x = (object2d.getX() + object2d.getWidth() / 2);
		float y = (object2d.getY() + object2d.getHeight() / 2);
		float z = object2d.getZ();
		Vector3 realPosition = surface.toWorldCoords(new Vector3(x, y, z));
		object2d.getWorldObject().setRealWorldPosition(realPosition);
		object2d.getWorldObject().firePropertyChange("position", null, 5);
		object2d.getWorldObject().firePropertyChange("dimension", null, 5);
		object2d.adjustTextureAndColors();
		object2d.setTopView(false);

	}

	public void updateWorldObjectDimention(Object2D object2d) {
		float x = object2d.getWidth() / stage.getWidth();
		float y = object2d.getHeight() / stage.getHeight();
		object2d.getWorldObject().getRealWorldDimension().x = x;
		object2d.getWorldObject().getRealWorldDimension().y = y;
	}

	@Override
	public void updateObject2D(Object2D object2D) {
		if (attachedActors != null && attachedActors.contains(object2D, false)) {
			setStageScales();
			fitToStage(object2D);
			object2D.adjustTextureAndColors();
			object2D.setTopView(false);
		}
	}

	@Override
	public void updateObject2D(WorldObject object) {
		Object2D object2D = null;
		for (Object2D objectX : attachedActors) {
			if (objectX.getWorldObject() == object) {
				object2D = objectX;
				break;
			}
		}
		if (object2D != null)
			updateObject2D(object2D);
	}

	public void surfaceAssist(Object2D object2D) {
		ArrayList<Vector2> criticalPoints = new ArrayList<Vector2>();
		ArrayList<Vector2> corners = object2D.getRotatedVertices();
		for (Object2D other : attachedActors) {
			if (other == object2D)
				continue;
			criticalPoints.addAll(other.getRotatedVertices());
		}
		Vector2 translation = null;
		for (Vector2 corner : corners) {
			for (Vector2 otherCorner : criticalPoints) {
				Vector2 tmp = otherCorner.cpy().sub(corner);
				if (translation == null || tmp.len2() < translation.len2())
					translation = tmp;
			}
		}
		if(translation != null) {
			if(translation.len2() > 10000) {
				Vector2 transX = translation.cpy().scl(1,0);
				Vector2 transY = translation.cpy().scl(0,1);
				translation.set(transX.len2()<transY.len2()?transX: transY);
			}
			if(translation.len2() <10000) {
				object2D.setPosition(object2D.getX() + translation.x, object2D.getY() + translation.y);
				updateWorldObject(object2D);
			}
			
			
		}
		

	}

	public void fitToPlacebySides(Object2D object2D, Array<Object2D> brothers) {
		Object2D leftbrother = getClosestBySides(object2D, brothers, true);
		Object2D rightbrother = getClosestBySides(object2D, brothers, false);
		float start = leftbrother != null ? leftbrother.getX() + leftbrother.getWidth() : 0;
		float end = rightbrother != null ? rightbrother.getX() : stage.getWidth();
		float width = ((float) (Math.round(((end - start) / scaleX) * 1000))) / 1000;
		if (width > 0.017 && width < 1.5) {
			if (updateworldObject(object2D, width)) {
				object2D.setWidth(end - start);
			}
			object2D.setX(start);
		}
		updateWorldObject(object2D);
	}

	public void fitToPlacebySidesCousins(Object2D object2D, Array<Object2D> brothers, boolean isleft,
			boolean updateWidth) {
		float start = 0;
		float end = stage.getWidth();
		if (isleft) {
			Object2D leftbrother = getClosestBySides(object2D, brothers, true);
			Object2D rightcousin = null;
			if (getReference() != null && object2D != getReference()) {
				rightcousin = getReference();
			} else {
				rightcousin = getClosestCousinBySides(object2D, brothers, false);
			}
			start = leftbrother != null ? leftbrother.getX() + leftbrother.getWidth() : 0;
			end = rightcousin != null ? rightcousin.getX() : stage.getWidth();
		} else {

			//
			Object2D leftcousin = null;
			if (getReference() != null && object2D != getReference()) {
				leftcousin = getReference();
			} else {
				leftcousin = getClosestCousinBySides(object2D, brothers, true);
			}
			Object2D rightbrother = getClosestBySides(object2D, brothers, false);
			start = leftcousin != null ? leftcousin.getX() + leftcousin.getWidth() : 0;
			end = rightbrother != null ? rightbrother.getX() : stage.getWidth();
		}

		float width = ((float) (Math.round(((end - start) / scaleX) * 1000))) / 1000;
		if (width > 0.017 && width < 1.5 && updateWidth) {
			if (updateworldObject(object2D, width)) {
				object2D.setWidth(end - start);
			}
			object2D.setX(start);
		} else {
			if (!isleft) {
				object2D.setX(start);
			} else {
				object2D.setX(end - object2D.getWidth());
			}

		}

	}

	public void fitToPlacebyCousin(Object2D object2D, Array<Object2D> brothers) {
		float start = 0;
		float end = stage.getWidth();
		Object2D cousin = null;
		if (getReference() != null && object2D != getReference()) {
			cousin = getReference();
		} else {
			cousin = getClosestCousin(object2D, brothers);
		}

		start = cousin != null ? cousin.getX() : 0;
		end = cousin != null ? cousin.getX() + cousin.getWidth() : stage.getWidth();

		float width = cousin != null ? cousin.getWorldObject().getRealWorldDimension().x
				: ((float) (Math.round(((end - start) / scaleX) * 1000))) / 1000;

		if (width > 0.017 && width < 1.5) {
			if (updateworldObject(object2D, width)) {
				object2D.setWidth(end - start);
			}
			object2D.setX(start);
		}
		updateWorldObject(object2D);

	}

	public void fitToPlace(Object2D object2D, Array<Object2D> brothers) {
		for (Object2D objectX : brothers) {
			if (objectX.equals(object2D)) {
				continue;
			}
			//
			float xStart = object2D.getX();
			float xEnd = object2D.getX() + object2D.getWidth();

			float yStart = object2D.getY();
			float yEnd = object2D.getY() + object2D.getHeight();

			float xObjstart = objectX.getX();
			float xObjend = objectX.getX() + objectX.getWidth();

			float yObjstart = objectX.getY();
			float yObjend = objectX.getY() + objectX.getHeight();

			//
			Intervale yint = new Intervale(yStart, true, yEnd, true);
			Intervale yintObj = new Intervale(yObjstart, true, yObjend, true);
			Intervale Yintersection = yint.getintersection(yintObj);
			//
			if (Yintersection == null || Yintersection.isPoint()) {
				continue;
			}

			//
			Intervale xint = new Intervale(xStart, true, xEnd, true);
			Intervale xintObj = new Intervale(xObjstart, true, xObjend, true);
			Intervale Xintersection = xint.getintersection(xintObj);
			//
			//
			if (Xintersection == null || Xintersection.isPoint()) {
				continue;
			} else {
				float width = ((float) (Math
						.round(((float) (object2D.getWidth() - Xintersection.getlong()) / scaleX) * 1000))) / 1000;

				if (updateworldObject(object2D, width)) {
					object2D.setWidth((float) (object2D.getWidth() - Xintersection.getlong()));
				}

				if (xStart == Xintersection.getMininter()) {
					object2D.setX(xObjend);

				}
				break;
			}

		}
		if (object2D.getX() + object2D.getWidth() > stage.getWidth()) {
			float width = ((float) (Math.round(((float) (stage.getWidth() - object2D.getX()) / scaleX) * 1000))) / 1000;

			if (updateworldObject(object2D, width)) {
				object2D.setWidth((float) (stage.getWidth() - object2D.getX()));
			}
		}
		if (object2D.getX() < 0) {
			float width = ((float) (Math.round(((float) (object2D.getWidth() + object2D.getX()) / scaleX) * 1000)))
					/ 1000;

			if (updateworldObject(object2D, width)) {
				object2D.setWidth((float) (object2D.getWidth() + object2D.getX()));
			}

			object2D.setX(0);
		}
		updateWorldObject(object2D);

	}

	public boolean updateworldObject(Object2D object2D, float width) {
		if (width < 0.005) {
			return false;
		}
		if (object2D.getWorldObject().getType().equals(ObjectType.DEFINED)) {
			KitchenElement element = (KitchenElement) object2D.getWorldObject();
			MechanicPublicParam paramL;
			try {
				paramL = element.getMechanicDesign().getPublicParam("global.l");
				if (object2D.getWorldObject().activeWidth == true) {
					String caissonType = element.getDesignObject().getDesignCaissonType();
					if (caissonType.contentEquals("BAS_COINS_L") || caissonType.contentEquals("HAUT_COINS_L")) {
						paramL = element.getMechanicDesign().getPublicParam("global.largeur");

					} else {
						paramL = element.getMechanicDesign().getPublicParam("global.p");
					}
				}
				if (paramL != null) {
					paramL.setDefaultvalue(String.valueOf((int) (width * 1000)));
					Space3DFree space = ((Space3DFree) element.getDesignObject());
					space.update();
					element.setRequireRefrech(true);
					return true;
				}
			} catch (Exception e) {

				e.printStackTrace();
				return false;

			}
		} else {
			object2D.getWorldObject().getRealWorldDimension().x = width;

			return true;

		}
		return false;
	}

	public void findPlaceByPushSelfX(Object2D object2D, Array<Object2D> brothers) {
		boolean valid = false;
		boolean isleft = true;
		whil: while (!valid) {
			valid = true;
			for (Object2D objectX : brothers) {
				if (objectX.equals(object2D)) {
					continue;
				}
				//
				float xStart = object2D.getX();
				float xEnd = object2D.getX() + object2D.getWidth();

				float yStart = object2D.getY();
				float yEnd = object2D.getY() + object2D.getHeight();

				float xObjstart = objectX.getX();
				float xObjend = objectX.getX() + objectX.getWidth();

				float yObjstart = objectX.getY();
				float yObjend = objectX.getY() + objectX.getHeight();

				//
				Intervale yint = new Intervale(yStart, true, yEnd, true);
				Intervale yintObj = new Intervale(yObjstart, true, yObjend, true);
				Intervale Yintersection = yint.getintersection(yintObj);
				//
				if (Yintersection == null || Yintersection.isPoint()) {
					continue;
				}

				//
				Intervale xint = new Intervale(xStart, true, xEnd, true);
				Intervale xintObj = new Intervale(xObjstart, true, xObjend, true);
				Intervale Xintersection = xint.getintersection(xintObj);
				//
				//
				if (Xintersection == null || Xintersection.isPoint()) {
					continue;
				} else {
					valid = false;
					if (isleft) {
						object2D.setX(xObjend);
					} else {
						object2D.setX(xObjstart - object2D.getWidth());
					}
				}
				if (object2D.getX() + object2D.getWidth() > stage.getWidth()) {
					isleft = false;
					object2D.setX(stage.getWidth() - object2D.getWidth());
					valid = false;

				}
				if (object2D.getX() < 0) {
					valid = false;
					object2D.setX(0);
					break whil;
				}
			}
		}

		updateWorldObject(object2D);
	}

	public void findPlaceByPushBrothers(Object2D object2D, Array<Object2D> brothers) {
		for (int i = 0; i < brothers.size; i++) {
			Object2D objectX = brothers.get(i);
			if (objectX.equals(object2D)) {
				continue;
			}
			//
			float xStart = object2D.getX();
			float xEnd = object2D.getX() + object2D.getWidth();

			float yStart = object2D.getY();
			float yEnd = object2D.getY() + object2D.getHeight();

			float xObjstart = objectX.getX();
			float xObjend = objectX.getX() + objectX.getWidth();

			float yObjstart = objectX.getY();
			float yObjend = objectX.getY() + objectX.getHeight();

			//
			Intervale yint = new Intervale(yStart, true, yEnd, true);
			Intervale yintObj = new Intervale(yObjstart, true, yObjend, true);
			Intervale Yintersection = yint.getintersection(yintObj);
			//
			if (Yintersection == null || Yintersection.isPoint()) {
				continue;
			}

			//
			Intervale xint = new Intervale(xStart, true, xEnd, true);
			Intervale xintObj = new Intervale(xObjstart, true, xObjend, true);
			Intervale Xintersection = xint.getintersection(xintObj);
			//
			//
			if (Xintersection == null || Xintersection.isPoint()) {
				continue;
			} else {

				if (Xintersection.getMininter() == xStart) {
					objectX.setX(xStart - objectX.getWidth());
				} else {
					objectX.setX(xEnd);
				}
				try {
					findPlaceByPushBrothers(objectX, brothers);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}

		}
		if (object2D.getX() + object2D.getWidth() > stage.getWidth()) {
			object2D.setX(stage.getWidth() - object2D.getWidth());
			fitToPlacebySides(object2D, brothers);
		}
		if (object2D.getX() < 0) {
			object2D.setX(0);
			fitToPlacebySides(object2D, brothers);
		}
	}

	public Object2D getClosest(Object2D object2D, Array<Object2D> brothers) {
		if (object2D == null || brothers == null || brothers.size < 1) {
			return null;
		}
		float xstart = object2D.getX();
		float xend = object2D.getX() + object2D.getWidth();
		float ystart = object2D.getY();
		float yend = object2D.getY() + object2D.getHeight();
		//
		float xOrigin = object2D.getX() + object2D.getWidth() / 2;
		float YOrigin = object2D.getY() + object2D.getHeight() / 2;
		//
		Object2D closest = null;
		float distance = 10000000;
		double longXinter = 0;
		double longYinter = 0;
		for (Object2D objectX : brothers) {
			if (objectX.equals(object2D)) {
				continue;
			}
			float xObjstart = objectX.getX();
			float xObjend = objectX.getX() + objectX.getWidth();
			float yObjstart = objectX.getY();
			float yObjend = objectX.getY() + objectX.getHeight();
			//
			float xObjOrigin = objectX.getX() + objectX.getWidth() / 2;
			float YObjOrigin = objectX.getY() + objectX.getHeight() / 2;
			//
			Intervale yint = new Intervale(ystart, true, yend, true);
			Intervale yintObj = new Intervale(yObjstart, true, yObjend, true);
			Intervale intersection = yint.getintersection(yintObj);
			if (intersection == null || intersection.isPoint()) {
				continue;
			}
			Intervale xint = new Intervale(xstart, true, xend, true);
			Intervale xintObj = new Intervale(xObjstart, true, xObjend, true);
			Intervale xIntersection = xint.getintersection(xintObj);
			double longXinterx = xIntersection == null ? 0 : xIntersection.getlong();
			final float a = xstart - xObjend;
			final float b = ystart - yObjstart;

			final float c = xend - xObjstart;
			final float d = ystart - yObjstart;

			final float e = xOrigin - xObjOrigin;
			final float f = YOrigin - YObjOrigin;

			final float g = xstart - xObjstart;

//			double disttoLeft =Math.sqrt(a * a + b * b );
//			double disttoright =Math.sqrt(c * c + d * d );
			double distbyOrigin = Math.sqrt(e * e + f * f);
//			double distbystart =Math.sqrt(g * g + b * b );

//			if(disttoLeft <distance) {
//				closest=objectX;
//				distance=(float) disttoLeft;
//			}
//			if( disttoright<distance) {
//				closest=objectX;
//				distance=(float) disttoright;
//			}
			if (distbyOrigin <= distance && longXinter == 0) {
				closest = objectX;
				distance = (float) distbyOrigin;
			}
			float distbyX = Math.abs(Math.abs(e) - object2D.getWidth() / 2 - objectX.getWidth() / 2);
			if (distbyX < distance && longXinter == 0) {
				closest = objectX;
				distance = distbyX;
			}
			if (longXinterx > longXinter) {
				closest = objectX;
				longXinter = longXinterx;
				distance = (float) longXinterx;

			}

		}
		return closest;
	}

	public Object2D getClosestCousin(Object2D object2D, Array<Object2D> brothers) {
		if (object2D == null || brothers == null || brothers.size < 1) {
			return null;
		}

		float ystart = object2D.getY();
		float yend = object2D.getY() + object2D.getHeight();
		//
		float xOrigin = object2D.getX() + object2D.getWidth() / 2;
		float YOrigin = object2D.getY() + object2D.getHeight() / 2;
		//
		Object2D closest = null;
		float distance = 10000000;
		for (Object2D objectX : brothers) {
			if (objectX.equals(object2D)) {
				continue;
			}

			float yObjstart = objectX.getY();
			float yObjend = objectX.getY() + objectX.getHeight();
			//
			float xObjOrigin = objectX.getX() + objectX.getWidth() / 2;
			float YObjOrigin = objectX.getY() + objectX.getHeight() / 2;
			//
			Intervale yint = new Intervale(ystart, true, yend, true);
			Intervale yintObj = new Intervale(yObjstart, true, yObjend, true);
			Intervale intersection = yint.getintersection(yintObj);
			if (intersection != null && !intersection.isPoint()) {
				continue;
			}

			final float e = xOrigin - xObjOrigin;
			final float f = YOrigin - YObjOrigin;

			double distbyOrigin = Math.sqrt(e * e + f * f);

			if (distbyOrigin <= distance) {
				closest = objectX;
				distance = (float) distbyOrigin;
			}

		}
		return closest;
	}

	public Object2D getClosestBySides(Object2D object2D, Array<Object2D> brothers, boolean isleft) {
		if (object2D == null || brothers == null || brothers.size < 1) {
			return null;
		}
		float ystart = object2D.getY();
		float yend = object2D.getY() + object2D.getHeight();
		//
		float xstart = object2D.getX();
		float xend = object2D.getX() + object2D.getWidth();
		//
		float xOrigin = object2D.getX() + object2D.getWidth() / 2;
		float YOrigin = object2D.getY() + object2D.getHeight() / 2;
		//
		Object2D closest = null;
		float distance = 10000000;
		for (Object2D objectX : brothers) {
			if (objectX.equals(object2D)) {
				continue;
			}

			float yObjstart = objectX.getY();
			float yObjend = objectX.getY() + objectX.getHeight();
			//
			float xObjstart = objectX.getX();
			float xObjend = objectX.getX() + objectX.getWidth();
			//
			float xObjOrigin = objectX.getX() + objectX.getWidth() / 2;
			float YObjOrigin = objectX.getY() + objectX.getHeight() / 2;
			//
			Intervale yint = new Intervale(ystart, true, yend, true);
			Intervale yintObj = new Intervale(yObjstart, true, yObjend, true);
			Intervale intersection = yint.getintersection(yintObj);
			if (intersection == null || intersection.isPoint()) {
				continue;
			}

			final float e = xOrigin - xObjOrigin;
			final float f = YOrigin - YObjOrigin;

			double distbyOrigin = Math.sqrt(e * e + f * f);

			if (((isleft && xOrigin > xObjOrigin) || (!isleft && xOrigin < xObjOrigin)) && (distbyOrigin <= distance)) {
				closest = objectX;
				distance = (float) distbyOrigin;
			}

		}
		return closest;
	}

	public Object2D getClosestCousinBySides(Object2D object2D, Array<Object2D> brothers, boolean isleft) {
		if (object2D == null || brothers == null || brothers.size < 1) {
			return null;
		}
		float ystart = object2D.getY();
		float yend = object2D.getY() + object2D.getHeight();
		//
		float xstart = object2D.getX();
		float xend = object2D.getX() + object2D.getWidth();
		//
		float xOrigin = object2D.getX() + object2D.getWidth() / 2;
		float YOrigin = object2D.getY() + object2D.getHeight() / 2;
		//
		Object2D closest = null;
		float distance = 10000000;
		for (Object2D objectX : brothers) {
			if (objectX.equals(object2D)) {
				continue;
			}

			float yObjstart = objectX.getY();
			float yObjend = objectX.getY() + objectX.getHeight();
			//
			float xObjstart = objectX.getX();
			float xObjend = objectX.getX() + objectX.getWidth();
			//
			float xObjOrigin = objectX.getX() + objectX.getWidth() / 2;
			float YObjOrigin = objectX.getY() + objectX.getHeight() / 2;
			//
			Intervale yint = new Intervale(ystart, true, yend, true);
			Intervale yintObj = new Intervale(yObjstart, true, yObjend, true);
			Intervale intersection = yint.getintersection(yintObj);
			if (intersection != null && !intersection.isPoint()) {
				continue;
			}

			final float e = xOrigin - xObjOrigin;
			final float f = YOrigin - YObjOrigin;

			double distbyOrigin = Math.sqrt(e * e + f * f);

			if (((isleft && xOrigin >= xObjOrigin) || (!isleft && xOrigin <= xObjOrigin))
					&& (distbyOrigin <= distance)) {
				closest = objectX;
				distance = (float) distbyOrigin;
			}

		}
		return closest;
	}

	public float min(float... vars) {
		if (vars == null || vars.length < 1) {
			return -1;
		}
		float min = vars[0];
		for (int i = 0; i < vars.length; i++) {
			if (vars[i] < min) {
				min = vars[i];
			}
		}
		return min;
	}

	public ChangeCommandController getChangeCommandController() {
		return changeCommandController;
	}

	public void setChangeCommandController(ChangeCommandController changeCommandController) {
		this.changeCommandController = changeCommandController;
	}

	public Surface getSurface() {
		return surface;
	}

	public void setSurface(Surface surface) {
		this.surface = surface;
	}

	@Override
	public Object2D getObject2D(WorldObject worldObject) {
		Object2D object2D = null;
		Array<Actor> actors = new Array<Actor>();
		actors.addAll(getStage().getActors());
		for (Actor actor : actors) {
			if (actor instanceof Object2D && ((Object2D) actor).getWorldObject() == worldObject) {
				object2D = (Object2D) actor;
				break;
			}
		}
		return object2D;
	}

	@Override
	public Stage getStage() {
		// TODO Auto-generated method stub
		return this.stage;
	}

	@Override
	public float[] getScales() {
		return new float[] { 1 / scaleX, 1 / scaleY };
	}

	public InputMultiplexer getInputMultiplexer() {
		return inputMultiplexer;
	}

	public void setInputMultiplexer(InputMultiplexer inputMultiplexer) {
		this.inputMultiplexer = inputMultiplexer;
	}

	@Override
	public void rectifyPosition(Object2D object2D) {
		
		if (object2D.getWorldObject().isConstraint()) {
			String role = object2D.getWorldObject().getModel().getInfo().getProperties().getProperty("role", "");
			Vector3 center = new Vector3(object2D.getAbsoluteOrigin(), 0).mul(surface.getSurfaceToWorldTransform());
			if (role.equals("door")) {
				ProjectManager.getManager().getCurrentScene().addDoor(object2D.getWorldObject(), center);
			} else {
				ProjectManager.getManager().getCurrentScene().addConstraint(object2D.getWorldObject(), center);
			}
		}else if( !object2D.getWorldObject().getType().equals(ObjectType.MODELED)){
			surfaceAssist(object2D);
		}
	}

	@Override
	public void clear() {
		getStage().clear();
	}

	@Override
	public void addActor(Object actor) {
		// TODO Auto-generated method stub

	}

	@Override
	public void removeActor(Object actor) {
		if (actor instanceof Object2D) {
			Object2D object2D = (Object2D) actor;
			this.attachedActors.removeValue(object2D, true);
			wallSpaceManager.removeActor(object2D);
			object2D.delete();
		}
	}

	@Override
	public void handle(Event event) {
		if(!isHandleEvent())
			return;
		SceneEvent sceneEvent = SceneEvent.valueOf(event.getTopic());
		switch (sceneEvent) {
		case REMOVE_OBJECT_REQUEST:
			removeActor(event.getData());
			break;
		case OBJECT_DROP:
			objectDropped((Map<String, Object>) event.getData());
			break;
		case OBJECT_CHANGED:
			updateObject2D((WorldObject) event.getData());
			break;
		case OBJECT_SELECTED:
			removeObjectMenuList();
			break;
		case OBJECT_RIGHT_CLICK: {
			displayRightClickMenu(event.getData());
		}
		default:
			break;
		}
	}
	
	private void displayRightClickMenu(Object data) {
		if (ProjectManager.getInstance().getCurrentProject() == null)
			return;
		removeObjectMenuList();
		HashMap map = (HashMap) data;

		Object source = map.get("source");
		Vector2 location = (Vector2) map.getOrDefault("location", new Vector2());

		ArrayList<ActionItem> actions;

		if (source instanceof Object2D) {
			actions = getActionListOnObject(map);
		} else if (source instanceof String str && str.equals(RoomController.TOP_VIEW)) {
			actions = getActionListOnEmpty(map);
		} else {
			actions = new ArrayList<>();
		}

		ObjectMenuList menu = new ObjectMenuList(source, AssetsTextures.getInstance().getSkin(), "default", actions);

		menu.setPosition(location.x, location.y - menu.getHeight());

		stage.addActor(menu);
		stage.setKeyboardFocus(menu);
		stage.setScrollFocus(menu);

	}
	
	
	ArrayList<ActionItem> getActionListOnObject(HashMap map) {
		final Vector2 location = (Vector2) map.getOrDefault("location", new Vector2());

		Object2D target = (Object2D) map.get("source");
		ArrayList<ActionItem> actions = new ArrayList<>();
		//
		
		actions.add(new ActionItem(ObjectMenuList.COPY, IconsResource.getCopyDrawable(), () -> {
			if (target.getWorldObject() instanceof KitchenElement element) {
				SuperCadClipBoard.setContent(element);
			}
		}, target.getWorldObject() instanceof KitchenElement, "Ctrl+C"));

		if (!SuperCadClipBoard.getContent().isEmpty()) {
			actions.add(new ActionItem(ObjectMenuList.PASTE, IconsResource.getPasteDrawable(), () -> {
				WorldObject element = (WorldObject) SuperCadClipBoard.getContent().get(0).copy();
				Vector3 position = RoomController.getInstance()
						.toRealWorldCoordinate(new Vector3(location.x, location.y, element.getRealWorldPosition().y));
				HashMap<String, Object> eventData = new HashMap<>();
				eventData.put("position", position);
				eventData.put("element", element);
				Event pastevent = new Event(SceneEvent.COPY.name(), eventData);
				EventDriver.getDriver().deliverEvent(pastevent);
			}, true, "Ctrl+V"));
		}

		actions.add(new ActionItem(ObjectMenuList.EDIT, IconsResource.getEditDrawable(),
				() -> EventDriver.getDriver().deliverEvent(new Event(SceneEvent.EDIT_OBJECT.name(), target)), true,
				"Ctrl+E"));

		actions.add(new ActionItem(ObjectMenuList.FIT_SPACE, IconsResource.getResizeHorizontalDrawable(), () -> {
			Object2D selectedActor = (Object2D) GroupSelection.getInstance().getFirstElement();
			fitToPlacebySides(selectedActor, getAttachedActors());
		}, true, "Ctrl+F"));

		actions.add(new ActionItem(ObjectMenuList.DELETE, IconsResource.getRemoveDrawable(), () -> {
			RemoveObjectCommand rmoCmd = new RemoveObjectCommand("delete command", "", target);
			ChangeCommandController.getInstance().addCommand(rmoCmd);
			removeObjectMenuList();
		}, true, "Del"));
		
		if (!(target.getWorldObject() instanceof KitchenElement)) {
			actions.removeIf(
					a -> a.getTitle().equals(ObjectMenuList.COPY) || a.getTitle().equals(ObjectMenuList.FINITION));
		}
		if (target.getWorldObject() instanceof KitchenElement || target.getWorldObject() instanceof ModeledObject) {
			actions.add(new ActionItem(ObjectMenuList.FREEZE_OBJECT, IconsResource.getFreezeObjectDrawable(),
					() -> target.getWorldObject().setMoveable(false), target.getWorldObject().isMoveable(), null));
			actions.add(new ActionItem(ObjectMenuList.UNFREEZE_OBJECT, IconsResource.getUnFreezeObjectDrawable(),
					() -> target.getWorldObject().setMoveable(true), !target.getWorldObject().isMoveable(), null));
		}
		return actions;
	}
	
	
	
	ArrayList<ActionItem> getActionListOnEmpty(HashMap map) {
		final Vector2 location = (Vector2) map.getOrDefault("location", new Vector2());
		ArrayList<ActionItem> actions = new ArrayList<>();

		actions.add(new ActionItem(ObjectMenuList.PASTE, IconsResource.getPasteDrawable(), () -> {
			WorldObject element = (WorldObject) SuperCadClipBoard.getContent().get(0).copy();

			Vector3 position = RoomController.getInstance()
					.toRealWorldCoordinate(new Vector3(location.x, location.y, element.getRealWorldPosition().y));

			HashMap<String, Object> eventData = new HashMap<>();
			eventData.put("position", position);
			eventData.put("element", element);

			try {
				ProjectManager.getManager().getCurrentKitchen()
						.addElement(((KitchenElement) element).getDesignObject());
			} catch (DesignException e) {
				e.printStackTrace();
			}

			Event pastevent = new Event(SceneEvent.COPY.name(), eventData);
			EventDriver.getDriver().deliverEvent(pastevent);
		}, SuperCadClipBoard.hasItems(), "Ctrl+V"));
		
		actions.add(new ActionItem(ObjectMenuList.CREATE_HABILLAGE, null, () -> {
			Display.getDefault().asyncExec(() -> {
				Shell shell = new Shell(Display.getCurrent(), SWT.DIALOG_TRIM);
				HabillageCreator window = new HabillageCreator(shell);
				window.open();
			});
		}, true, null));

		return actions;
	}

	
	
	
	
	
	
	

	private void removeObjectMenuList() {
		ArrayList<Actor> actorsToRemove = new ArrayList<Actor>();
		for (Actor actor : stage.getActors()) {
			if (actor instanceof ObjectMenuList)
				actorsToRemove.add(actor);
		}
		for (Actor actor : actorsToRemove) {
			actor.remove();
		}
	}


	public void objectDropped(Map<String, Object> data) {
		Object object = data.get("object");
		Vector2 location = (Vector2) data.getOrDefault("location", new Vector2(600, 600));
		dropActor(object, location.x, location.y);
	}

	public void dispose() {
		attachedActors.clear();
		stage.dispose();
	}

	public Object2D getReference() {
		return reference;
	}

	public void setReference(Object2D reference) {
		this.reference = reference;
	}

	public boolean isHandleEvent() {
		return handleEvent;
	}

	public void setHandleEvent(boolean handleEvent) {
		this.handleEvent = handleEvent;
	}
	

}
