package dressing.ui.util;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;

import com.badlogic.gdx.math.Vector3;

import dressing.mathutils.Vector4;
import dressing.model.ProjectManager;
import gdxapp.object3d.Object2D;
import gdxapp.object3d.WorldObject;

public class ModelInstanceEditorWindow extends EditorWindow {

	private WorldObject worldObject;
	private Object2D object2D;
	Composite parentComposite;
	private Composite clientArea;
	private Spinner spinnerLargeur;

	private Spinner spinnerHauteur;

	private Spinner spinnerProfondeur;

	private Spinner spinnerX;

	private Spinner spinnerY;

	private Spinner spinnerZ;
	
	public ModelInstanceEditorWindow(Shell parentShell,Object2D object2D, int update) {
		super(parentShell, update);
		setTitle("Editeur Model 3D");
		this.object2D = object2D;
		if(object2D!=null && object2D.getWorldObject()!=null && object2D.getWorldObject().getName()!=null) {
			setTitle("Editeur Model 3D : "+object2D.getWorldObject().getName());
		}
	}

	@Override
	protected Composite createClientArea(Composite parent) {
		parentComposite=parent;
		clientArea = new Composite(parent, SWT.BORDER);
		clientArea.setLayout(new GridLayout(2, true));
		clientArea.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		Group grpDimension = new Group(clientArea, SWT.SHADOW_ETCHED_IN);
		grpDimension.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		grpDimension.setBounds(0, 0, 150, 100);
		grpDimension.setText("Dimensions");
		grpDimension.setLayout(new GridLayout(2, false));
		
		Label lblLargeur = new Label(grpDimension, SWT.NONE);
		lblLargeur.setText("Largeur");
		
		spinnerLargeur = new Spinner(grpDimension, SWT.BORDER);
		spinnerLargeur.setMaximum(10000);
		spinnerLargeur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Label lblHauteur = new Label(grpDimension, SWT.NONE);
		lblHauteur.setText("Hauteur");
		
		spinnerHauteur = new Spinner(grpDimension, SWT.BORDER);
		spinnerHauteur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		spinnerHauteur.setMaximum(10000);
		
		Label lblProfondeur = new Label(grpDimension, SWT.NONE);
		lblProfondeur.setText("Profondeur");
		
		spinnerProfondeur = new Spinner(grpDimension, SWT.BORDER);
		spinnerProfondeur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		spinnerProfondeur.setMaximum(10000);
		
		Group grpPosition = new Group(clientArea, SWT.SHADOW_ETCHED_IN);
		grpPosition.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		grpPosition.setText("Position");
		grpPosition.setLayout(new GridLayout(2, false));
		
		Label lblX = new Label(grpPosition, SWT.NONE);
		lblX.setText("X");
		
		spinnerX = new Spinner(grpPosition, SWT.BORDER);
		spinnerX.setMaximum(10000);
		spinnerX.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Label lblY = new Label(grpPosition, SWT.NONE);
		lblY.setText("Y");
		
		spinnerY = new Spinner(grpPosition, SWT.BORDER);
		spinnerY.setMaximum(10000);
		spinnerY.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Label lblZ = new Label(grpPosition, SWT.NONE);
		lblZ.setText("Z");
		
		spinnerZ = new Spinner(grpPosition, SWT.BORDER);
		spinnerZ.setMaximum(10000);
		spinnerZ.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		if(object2D!=null) {
			init();
		}
		parent.requestLayout();
		return clientArea;
	}

	@Override
	public boolean check() {
		// TODO Auto-generated method stub
		return true;
	}

	@Override
	protected void cancel() {
		// TODO Auto-generated method stub

	}
	
	@Override
	protected Point getInitialSize() {
		// TODO Auto-generated method stub
		return new Point(500, 400);
	}
	
	@Override
	protected boolean isMaximized() {
		return false;
	}
	
	public WorldObject getWorldObject() {
		return worldObject;
	}

	public void setWorldObject(WorldObject worldObject) {
		this.worldObject = worldObject;
	}

	public Object2D getObject2D() {
		return object2D;
	}

	public void setObject2D(Object2D object2d) {
		object2D = object2d;
		init();
	}

	private void init() {
		setWorldObject(object2D.getWorldObject());
		Vector4 dimension = worldObject.getRealWorldDimension().cpy();
		dimension.scl(1000);
		spinnerLargeur.setSelection(Math.round(dimension.x));
		spinnerHauteur.setSelection(Math.round(dimension.y));
		spinnerProfondeur.setSelection(Math.round(dimension.z));
		Vector3 position = worldObject.getRealWorldPosition().cpy();
		position.scl(1000);
		spinnerX.setSelection(Math.round(position.x));
		float y = position.y - dimension.y/2;
		spinnerY.setSelection(Math.round(y));
		spinnerZ.setSelection(Math.round(position.z));
	}
	
	@Override
	public boolean terminer() {
		if(!super.terminer()) {
			return false;
		}
		Vector4 newDimension = new Vector4(spinnerLargeur.getSelection(), spinnerHauteur.getSelection(), spinnerProfondeur.getSelection() ,0 ).scl(0.001f);
		Vector3 newPosition = new Vector3(spinnerX.getSelection(), spinnerY.getSelection(), spinnerZ.getSelection()).scl(0.001f);
		newPosition.y += newDimension.y/2;
		worldObject.setRealWorldPosition(newPosition);
		worldObject.setRealWorldDimension(newDimension);
		worldObject.setRequireRefrech(true);
		ProjectManager.getManager().getCurrentScene().update();
		finish();
		return true;
	}
}
