package dressing.ui.util;

import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;

public class DoubleViewerComparator extends ViewerComparator {
	private ColumnLabelProvider labelProvider;
	public DoubleViewerComparator(ColumnLabelProvider labelProvider) {
		super();
		this.labelProvider=labelProvider;
		
	}
	@Override
	public int compare(Viewer viewer, Object e1, Object e2) {
		String s1=labelProvider.getText(e1);
		String s2=labelProvider.getText(e2);
		double d1=Double.valueOf(s1);
		double d2=Double.valueOf(s2);
		
		Control c=viewer.getControl();
		Table table= (Table) c;
		if(s1!=null && s2!=null) {
			if(d1==d2) {
				return 0;
			}else
			if(table.getSortDirection()==SWT.DOWN)
			{
				return d1>d2?1:-1;
			}else {
				return d2>d1?1:-1;
			}
					
		}
		return super.compare(viewer, e1, e2);
	}
}
