package dressing.ui;

import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import dressing.config.persistence.ResourceManagers;
import dressing.ui.util.EditorWindow;
import param.Finition;
import param.Fournisseur_fabricant;
import param.Nature_panneaux;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.swt.widgets.Button;
import org.eclipse.core.databinding.beans.typed.PojoProperties;

public class NaturePanneauxEditorWindow extends EditorWindow {
	private Nature_panneaux nature;
	private Nature_panneaux natureOrigin;
	Composite parentComposite;
	private Composite clientArea;
	private Text txtName;
	private Text txtCode;
	private Text txtDescription;
	private Label lblDescription;

	public NaturePanneauxEditorWindow(Shell parentShell,Nature_panneaux frs,int update) {
		super(parentShell,update);	
		this.nature=frs;
		this.natureOrigin=EcoreUtil.copy(frs);
		setTitle("Editeur Nature/Type Panneaux");
	}

	@Override
	protected Composite createClientArea(Composite parent) {
		parentComposite=parent;
		clientArea = new Composite(parent, SWT.BORDER);
		clientArea.setLayout(new GridLayout(2, false));
		clientArea.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		Label lblName = new Label(clientArea, SWT.NONE);
		lblName.setText("Nom");
		
		txtName = new Text(clientArea, SWT.BORDER);
		txtName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Label lblEp = new Label(clientArea, SWT.NONE);
		lblEp.setText("Code");
		
		txtCode = new Text(clientArea, SWT.BORDER);
		txtCode.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		lblDescription = new Label(clientArea, SWT.NONE);
		lblDescription.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblDescription.setText("Description");
		
		txtDescription = new Text(clientArea, SWT.BORDER | SWT.MULTI);
		txtDescription.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		
		parent.requestLayout();	
		if(nature!=null) {
			initDataBindings();
		}
		return clientArea;
	}

	@Override
	public boolean terminer() {
		if(!super.terminer()) {
			return false;
		}
		String originName =txtName.getText().trim();
		String originCode=txtCode.getText().trim();
		this.nature.setName(originName);
		this.nature.setCode(originCode);

		if(getUpdateMode()==EditorWindow.create) {
			ResourceManagers.getIntance().getGestion().getNaturePanneaux().getNatures().add(nature);
		}
		ResourceManagers.getIntance().saveGestion();
		finish();
		return true;
	}
	
	@Override
	protected void cancel() {
		this.nature.setName(this.natureOrigin.getName());
		this.nature.setCode(this.natureOrigin.getCode());
		this.nature.setDescription(this.natureOrigin.getDescription());

	}
	@Override
	public boolean check() {
		errorExist=false;
		errorMessage="";
		String name =txtName.getText().trim();
		if(name==null || name.isEmpty()) {
			errorExist=true;
			errorMessage="Le nom est obligatoire";
		}
		return !errorExist;
	}
	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		IObservableValue observeTextTxtNameObserveWidget = WidgetProperties.text(new int[]{SWT.Modify, SWT.FocusOut}).observe(txtName);
		IObservableValue nameChantObserveValue = PojoProperties.value("name").observe(nature);
		bindingContext.bindValue(observeTextTxtNameObserveWidget, nameChantObserveValue, null, null);
		//
		IObservableValue observeTextTxtCodeObserveWidget = WidgetProperties.text(new int[]{SWT.Modify, SWT.FocusOut}).observe(txtCode);
		IObservableValue codeFrsObserveValue = PojoProperties.value("code").observe(nature);
		bindingContext.bindValue(observeTextTxtCodeObserveWidget, codeFrsObserveValue, null, null);
		//
		IObservableValue observeTextTxtDescriptionObserveWidget = WidgetProperties.text(new int[]{SWT.Modify, SWT.FocusOut}).observe(txtDescription);
		IObservableValue descriptionNatureObserveValue = PojoProperties.value("description").observe(nature);
		bindingContext.bindValue(observeTextTxtDescriptionObserveWidget, descriptionNatureObserveValue, null, null);
		//
		return bindingContext;
	}
}
