package dressing.ui;

import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.ResourceManager;

import dressing.config.ReportingPreferences;
import dressing.config.WorkspaceConfiguration;
import dressing.config.persistence.ResourceManagers;
import dressing.model.ModelProvider;
import dressing.ui.util.EditorWindow;
import dressing.ui.util.ImageChooserDialog;
import dressing.ui.util.ImageLoaderCache;
import param.Finition;
import param.Fournisseur_fabricant;
import param.Material;
import param.Nature_panneaux;
import param.PanelSize;
import java.io.File;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.beans.typed.PojoProperties;

import dressing.ui.engine3d.SceneTexture;
import dressing.ui.engine3d.SceneTexture.CATEGORY;
import dressing.ui.util.DoubleToStringConvertor;
import dressing.ui.util.NumericConvertor;
import dressing.ui.util.StringViewerComparator;

import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;

public class MaterialEditorWindow extends EditorWindow {
	private DataBindingContext m_bindingContext;

	private Material material;
	private Material materialOrigin;

	private Composite clientArea;
	private Text txtName;
	private Text txtEp;
	private Button btnSensFil;
	private Text txtprice;
	private Label lblFabricantfournisseur;
	private ElementComboSelect frsElementComboSelect;
	private Label lblFinition;
	private ElementComboSelect finitionElementComboSelect;
	private Button btnChooseImage;

	private CLabel lblImage;
	private Label labelImage;
	private Button btnCheckapplyTexture;
	private Label lblNaturetypePanneaux;

	private NaturePanneauxComboSelect naturePanneauxComboSelect;

	private PanneauxComboSelect panneauxComboSelect;
	private Table table;
	private TableViewer panelTableViewer;
	private Button btnSupprimer;
	private Button btnAjouterTout;

	private Button btnAddPanel;

	public MaterialEditorWindow(Shell parentShell, IEventBroker eventBroker,Material material,int update) {
		super(parentShell,update);
		
		this.material=material;
		this.materialOrigin=EcoreUtil.copy(material);
		setTitle("Editeur Matériaux");
	}

	@Override
	protected Composite createClientArea(Composite parent) {
		clientArea = new Composite(parent, SWT.BORDER);
		clientArea.setLayout(new GridLayout(5, false));
		clientArea.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		labelImage = new Label(clientArea, SWT.BORDER | SWT.WRAP);
		GridData gd_labelImage = new GridData(SWT.FILL, SWT.FILL, false, false, 2, 10);
		gd_labelImage.heightHint = 400;
		gd_labelImage.widthHint = 400;
		labelImage.setLayoutData(gd_labelImage);
		
		Label lblName = new Label(clientArea, SWT.NONE);
		lblName.setText("Nom");
		
		txtName = new Text(clientArea, SWT.BORDER);
		txtName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
		
		Label lblEp = new Label(clientArea, SWT.NONE);
		lblEp.setText("Epaisseur");
		
		txtEp = DoubleTextFieldFactory.createDoubleTextField(clientArea,SWT.BORDER);
		txtEp.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
		
		Label lblPrice = new Label(clientArea, SWT.NONE);
		lblPrice.setText("Prix (DT/m²)");
		txtprice = DoubleTextFieldFactory.createDoubleTextField(clientArea,SWT.BORDER);
		txtprice.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
		
		Label lblSensFibre = new Label(clientArea, SWT.NONE);
		lblSensFibre.setText("Sens du fil");
		
		btnSensFil = new Button(clientArea,SWT.CHECK);
		btnSensFil.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
		
		lblFabricantfournisseur = new Label(clientArea, SWT.NONE);
		lblFabricantfournisseur.setText("Fabricant/Fournisseur");
		
		frsElementComboSelect = new FournisseurComboSelect(clientArea, SWT.NONE);
		frsElementComboSelect.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
		ComboViewer comboViewer = frsElementComboSelect.getComboViewer();
		if(material.getFabricant()!=null) {
			comboViewer.setSelection(new StructuredSelection(material.getFabricant()), true);
		}
			
		comboViewer.addSelectionChangedListener(new  ISelectionChangedListener() {

			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				Object selection= frsElementComboSelect.getComboViewer().getStructuredSelection().getFirstElement();
				if(selection!=null && selection instanceof Fournisseur_fabricant)
				{
					material.setFabricant((Fournisseur_fabricant) selection);
				}
				
			}
			
		});
//		
		lblFinition = new Label(clientArea, SWT.NONE);
		lblFinition.setText("Finition");
//		
		finitionElementComboSelect = new FinitionsComboSelect(clientArea, SWT.NONE);
		finitionElementComboSelect.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));

		comboViewer = finitionElementComboSelect.getComboViewer();
		if(material.getFinition()!=null) {
			comboViewer.setSelection(new StructuredSelection(material.getFinition()), true);
		}
			
		comboViewer.addSelectionChangedListener(new  ISelectionChangedListener() {

			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				Object selection= finitionElementComboSelect.getComboViewer().getStructuredSelection().getFirstElement();
				if(selection!=null && selection instanceof Finition)
				{
					material.setFinition((Finition) selection);
				}
				
			}
			
		});
		//
		lblNaturetypePanneaux = new Label(clientArea, SWT.NONE);
		lblNaturetypePanneaux.setText("Nature/Type Panneaux");
		naturePanneauxComboSelect = new NaturePanneauxComboSelect(clientArea, SWT.NONE);
		naturePanneauxComboSelect.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));

		comboViewer = naturePanneauxComboSelect.getComboViewer();
		if(material.getNature_type()!=null) {
			comboViewer.setSelection(new StructuredSelection(material.getNature_type()), true);
		}
			
		comboViewer.addSelectionChangedListener(new  ISelectionChangedListener() {

			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				Object selection= naturePanneauxComboSelect.getComboViewer().getStructuredSelection().getFirstElement();
				if(selection!=null && selection instanceof Nature_panneaux)
				{
					material.setNature_type((Nature_panneaux) selection);
				}
				
			}
			
		});
		//
		Label lblEmail = new Label(clientArea, SWT.NONE);
		lblEmail.setText("Texture");
		
		lblImage = new CLabel(clientArea, SWT.NONE);
		lblImage.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		lblImage.setText("");
		
		btnChooseImage = new Button(clientArea, SWT.NONE);
		btnChooseImage.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		btnChooseImage.setText("...");
		
		btnCheckapplyTexture = new Button(clientArea, SWT.CHECK);
		btnCheckapplyTexture.setLayoutData(new GridData(SWT.LEFT, SWT.TOP, true, false, 3, 1));
		btnCheckapplyTexture.setText("Appliquer Texture");
		createPanelComposite();
		

		if(material!=null)
		{
			panelTableViewer.setInput(material.getPanelsizes());
			if(material.getImage()!=null&& !material.getImage().isEmpty()) {
				String imagePath = material.getImage();
				if(!ImageLoaderCache.isValidImagePath(imagePath)&& !ImageLoaderCache.isValidImageUrl(imagePath))
				{
					imagePath = WorkspaceConfiguration.TEXTURES_FOLDER + File.separator + material.getImage();
					if(!ImageLoaderCache.isValidImagePath(imagePath)&& !ImageLoaderCache.isValidImageUrl(imagePath))
					{
						imagePath=ModelProvider.getTextures(CATEGORY.ELEMENT).get(0).getPath();
					}
				}
				if (!ImageLoaderCache.isValidImagePath(imagePath)) {
					imagePath = null;
				}
				if (imagePath != null) {
					labelImage.setImage(ImageLoaderCache.getInstance().loadImage(imagePath, 400, 400));
				} else {
					// Create a new Image with the desired dimensions
					Image image = new Image(Display.getCurrent(), 400, 400);

					// Create a GC (Graphics Context) to draw on the image
					GC gc = new GC(image);

					// Set the background color of the image
					Color backgroundColor = Display.getCurrent().getSystemColor(SWT.COLOR_TRANSPARENT);
					gc.setBackground(backgroundColor);

					// Fill the entire image with the background color
					gc.fillRectangle(0, 0, 200, 200);
					gc.dispose();

					labelImage.setImage(image);
				}
			}
			m_bindingContext = initDataBindings();
		}
		
		addControl();
		parent.requestLayout();
		return clientArea;
	}

	private void createPanelComposite() {
		Composite	composite = new Composite(clientArea, SWT.BORDER);
		composite.setLayout(new GridLayout(5, false));
		composite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 3, 1));
		
		Label lblPanel = new Label(composite, SWT.NONE);
		lblPanel.setText("Panneaux: ");
		
		panneauxComboSelect = new PanneauxComboSelect(composite, SWT.BORDER);
		panneauxComboSelect.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));

		btnAddPanel = new Button(composite, SWT.NONE);
		GridData gd_btnAjouter = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
		gd_btnAjouter.widthHint = 100;
		btnAddPanel.setLayoutData(gd_btnAjouter);
		btnAddPanel.setText("Ajouter");
		btnAddPanel.setImage(ResourceManager.getPluginImage("Dressing", "icons/ajout.png"));
		btnAddPanel.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				Object selection = panneauxComboSelect.getComboViewer().getStructuredSelection().getFirstElement();
				if (selection != null && selection instanceof PanelSize&& !material.getPanelsizes().contains((PanelSize)selection)) {
					material.getPanelsizes().add((PanelSize) selection);
					
				}
				panelTableViewer.setInput(material.getPanelsizes());
				panelTableViewer.refresh();
				super.widgetSelected(e);
			}
		});
		ColumnLabelProvider nameLabelProvider = new ColumnLabelProvider() {
			public String getText(Object element) {
				if (element != null && element instanceof PanelSize) {
					return ((PanelSize) element).getName();
				}
				return "";
			}
		};
		ColumnLabelProvider widthLabelProvider = new ColumnLabelProvider() {
			public String getText(Object element) {
				if (element != null && element instanceof PanelSize) {
					return String.valueOf(((PanelSize) element).getWidth());
				}
				return "";
			}
		};
		ColumnLabelProvider heightLabelProvider = new ColumnLabelProvider() {
			public String getText(Object element) {
				if (element != null && element instanceof PanelSize) {
					return String.valueOf(((PanelSize) element).getHeight());
				}
				return "";
			}
		};
		
		btnAjouterTout = new Button(composite, SWT.NONE);
		btnAjouterTout.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				java.util.List<PanelSize> selection = ResourceManagers.getIntance().getGestion().getPanelsizes().getPanelSizes();
				for(PanelSize panel:selection) {
					if(panel!=null && !material.getPanelsizes().contains(panel)) {
						material.getPanelsizes().add((PanelSize) panel);
					}
				}
				panelTableViewer.setInput(material.getPanelsizes());
				panelTableViewer.refresh();
			}
		});
		btnAjouterTout.setText("Ajouter Tout");
		
		btnSupprimer = new Button(composite, SWT.NONE);
		btnSupprimer.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				IStructuredSelection selection = panelTableViewer.getStructuredSelection();
				if (selection != null && !selection.isEmpty() && selection.getFirstElement() instanceof PanelSize) {
					java.util.List selections = selection.toList();
					for (Object obj : selections) {
						material.getPanelsizes().remove((PanelSize) obj);
					}
				}

				panelTableViewer.refresh();

			}
		});
		btnSupprimer.setText("Supprimer");
		Composite	composite2 = new Composite(composite, SWT.NONE);
		composite2.setLayout(new GridLayout(1, true));
		composite2.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 5, 1));
		
		panelTableViewer = new TableViewer(composite2, SWT.BORDER | SWT.FULL_SELECTION| SWT.MULTI);
		table = panelTableViewer.getTable();
		table.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 5, 1));
		table.setHeaderVisible(true);
		table.setLinesVisible(true);
		createColumn(panelTableViewer, "Nom", true, null, SWT.LEFT, nameLabelProvider, new StringViewerComparator(nameLabelProvider));
		createColumn(panelTableViewer, "Longeur", true, null, SWT.LEFT, widthLabelProvider, new StringViewerComparator(widthLabelProvider));
		createColumn(panelTableViewer, "Largeur" , true, null, SWT.CENTER, heightLabelProvider, new StringViewerComparator(heightLabelProvider));

		ControlAdapter adaptor=new ControlAdapter() {

			@Override
			public void controlResized(ControlEvent e) {
			     Rectangle area = composite2.getClientArea();
			     int width = area.width - 2*table.getBorderWidth()-10;
			     Point vBarSize = table.getVerticalBar().getSize();
			      table.getHorizontalBar().getSize();
			      if(table.getVerticalBar().isVisible())
			      {
			    	  width -= vBarSize.x;
			      }
			      Point oldSize = table.getSize();
			      if (oldSize.x > area.width) {
			        // table is getting smaller so make the columns 
			        // smaller first and then resize the table to
			        // match the client area width
			    	table.getColumns()[0].setWidth(300);;
			    	for(int i=1;i<table.getColumnCount();i++) {
			    		table.getColumns()[i].setWidth((width-300)/(table.getColumnCount()-1));;
			    	}
			        table.setSize(area.width-10, area.height-10);
			      } else {
			        // table is getting bigger so make the table 
			        // bigger first and then make the columns wider
			        // to match the client area width
			        table.setSize(area.width-10, area.height-10);
			        table.getColumns()[0].setWidth(300);;
			        for(int i=1;i<table.getColumnCount();i++) {
			    		table.getColumns()[i].setWidth((width-300)/(table.getColumnCount()-1));;
			    	}

			      }
			}
			
		};
		composite.addControlListener(adaptor);
		table.addControlListener(adaptor);
		clientArea.addControlListener(adaptor);
		panelTableViewer.setContentProvider(ArrayContentProvider.getInstance());
	}
	public void addControl() {
		btnChooseImage.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				String imagePath1 = material.getImage();
				if(imagePath1==null || imagePath1.isEmpty()) {
					imagePath1=ModelProvider.getTextures(CATEGORY.ELEMENT).get(0).getPath();
				}
				if(!ImageLoaderCache.isValidImagePath(imagePath1)&& !ImageLoaderCache.isValidImageUrl(imagePath1))
				{
					imagePath1 = WorkspaceConfiguration.TEXTURES_FOLDER + File.separator + imagePath1;
					if(!ImageLoaderCache.isValidImagePath(imagePath1)&& !ImageLoaderCache.isValidImageUrl(imagePath1))
					{
						imagePath1=ModelProvider.getTextures(CATEGORY.ELEMENT).get(0).getPath();
					}
				}
				ImageChooserDialog chooserDialog= new ImageChooserDialog(getShell(),imagePath1);
				chooserDialog.setLocalPath(WorkspaceConfiguration.getTexturesFolder());
				
				int chooseImage=chooserDialog.open();
				if(chooseImage==Window.OK) {
					String imageOriginalPath=chooserDialog.getImageUri();
//					File imgfile=new File(imageOriginalPath);
					
//						lblImage.setText(imageOriginalPath);
						Image img=null;
						String imgName=null;
						if(ImageLoaderCache.isValidImagePath(imageOriginalPath))
						{
							img=ImageLoaderCache.createImageFromPathOrUrl(imageOriginalPath);
							File imgfile=new File(imageOriginalPath);
							imgName=imgfile.getName();
						
						}else if(ImageLoaderCache.isValidImageUrl(imageOriginalPath))
						{
							img=ImageLoaderCache.createImageFromPathOrUrl(imageOriginalPath);
							imgName=ImageLoaderCache.getImageNameFromURL(imageOriginalPath);
							
						}
						if(img!=null && imgName!=null && !imgName.isEmpty()) {
							String imagePath=WorkspaceConfiguration.getTexturesFolder()+File.separator+imgName;
							if(!imagePath.contentEquals(imageOriginalPath))
							{
								int width=img.getImageData().width;
								width=closestPowerOfTwo(width);
								img=ImageLoaderCache.getInstance().resizeImage(img, width, width);
								ImageLoaderCache.getInstance().saveImageToFile(img, imagePath);
								
							}
							if(ModelProvider.getTexture(imagePath)==null) {
								SceneTexture result = new SceneTexture(imagePath);
								result.setCategory(CATEGORY.ELEMENT);
								ModelProvider.addTexture(imagePath, result);
							}
							material.setImage(imgName);
							material.setApplyTexture(true);
							btnCheckapplyTexture.setSelection(true);
							lblImage.setText(imgName);
							labelImage.setImage(ImageLoaderCache.getInstance().loadImage(imagePath, 400, 400,false));
						}else {
							MessageDialog.openError(getShell(), "Erreur", "Le fichier choisi est une image invalide.");
						}
						img.dispose();
//
//									
				}
			}
		});
	}
	 public static int closestPowerOfTwo(int n) {
	        if (n <= 0) {
	            return 1; // The closest power of 2 for non-positive numbers is 1 (2^0)
	        }

	        int lowerPower = 1;
	        int upperPower = 1;

	        // Find the closest lower and upper powers of 2
	        while (upperPower < n) {
	            lowerPower = upperPower;
	            upperPower *= 2;
	        }

	        // Compare distances to find the closest
	        if (Math.abs(lowerPower - n) < Math.abs(upperPower - n)) {
	            return lowerPower;
	        } else {
	            return upperPower;
	        }
	    }
	@Override
	public boolean terminer() {
		if(!super.terminer()) {
			return false;
		}
		
		
		if(getUpdateMode()==EditorWindow.create) {
			boolean isdev = ReportingPreferences.getInstance().getProperty("user.dev", false);
			if(isdev) {
				ResourceManagers.getIntance().getSystemMaterialGroup().getMaterial().add(material);
			}else {
				ResourceManagers.getIntance().getMaterialGroup().getMaterial().add(material);
			}
		}
		ResourceManagers.getIntance().saveLibraryResource();
		finish();
		return false;
	}
	@Override
	public boolean check() {
		errorExist=false;
		errorMessage="";
		String name=txtName.getText();
		if(name==null || name.isEmpty()) {
			errorExist=true;
			errorMessage="Le nom est obligatoire";
		}
		String ep=txtEp.getText();
		try {
			Double dep =Double.valueOf(ep);
			if(dep<=0) {
				errorExist=true;
				errorMessage="L'épaisseur doit être supérieur à 0";
			}
		} catch (Exception e) {
			errorExist=true;
			errorMessage="L'épaisseur est obligatoire";
		}
		String price=txtprice.getText();
		try {
			Double dprice =Double.valueOf(price);
			if(dprice<=0) {
				errorExist=true;
				errorMessage="Le prix doit être supérieur à 0";
			}
		} catch (Exception e) {
			errorExist=true;
			errorMessage="Le prix est obligatoire";
		}
		return !errorExist;
	}
	public TableViewerColumn createColumn(TableViewer tableViewer,String title,boolean moveable,Image image,int alignment,ColumnLabelProvider labelprovider,ViewerComparator columnSorter) {
		TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, SWT.NONE);
		tableViewerColumn.setLabelProvider(labelprovider);
		TableColumn tblclmn = tableViewerColumn.getColumn();
		tblclmn.setAlignment(alignment);
		tblclmn.setMoveable(moveable);
		tblclmn.setText(title);
		tblclmn.setImage(image);
		tblclmn.addSelectionListener(new SelectionAdapter() {
		    @Override
		    public void widgetSelected(SelectionEvent e) {
		    	Table table =tableViewer.getTable();
		    	if(table.getSortColumn()==tblclmn) {
		    		int oldsortdirection =table.getSortDirection();
		    		if(oldsortdirection==SWT.DOWN) {
		    			table.setSortDirection( SWT.UP );
		    		}else {
		    			table.setSortDirection( SWT.DOWN );
		    		}
		    	}else {
		    		table.setSortDirection( SWT.DOWN );
		    	}
		        tableViewer.getTable().setSortColumn( tblclmn);
		        tableViewer.setComparator(columnSorter);
		        tableViewer.refresh();
		    }
		});
		
		return tableViewerColumn;
	}
	@Override
	protected void cancel() {
		this.material.setName(this.materialOrigin.getName());
		this.material.setEpaisseur(this.materialOrigin.getEpaisseur());
		this.material.setSensFil(this.materialOrigin.isSensFil());
		this.material.setPrice(this.materialOrigin.getPrice());
		this.material.setImage(this.materialOrigin.getImage());
	}
	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		IObservableValue observeTextTxtNameObserveWidget = WidgetProperties.text(new int[]{SWT.Modify, SWT.FocusOut}).observe(txtName);
		IObservableValue nameMaterialObserveValue = BeanProperties.value("name").observe(material);
		bindingContext.bindValue(observeTextTxtNameObserveWidget, nameMaterialObserveValue, null, null);
		//
		IObservableValue observeTextTxtEpObserveWidget = WidgetProperties.text(new int[]{SWT.Modify, SWT.FocusOut}).observe(txtEp);
		IObservableValue epaisseurMaterialObserveValue = BeanProperties.value("epaisseur").observe(material);
		UpdateValueStrategy strategy = new UpdateValueStrategy();
		strategy.setConverter(new DoubleToStringConvertor());
		UpdateValueStrategy strategy_1 = new UpdateValueStrategy();
		strategy_1.setConverter(new NumericConvertor());
		bindingContext.bindValue(observeTextTxtEpObserveWidget, epaisseurMaterialObserveValue, strategy, strategy_1);
		//
		IObservableValue observeTextTxtpriceObserveWidget = WidgetProperties.text(new int[]{SWT.Modify, SWT.FocusOut}).observe(txtprice);
		IObservableValue priceMaterialObserveValue = BeanProperties.value("price").observe(material);
		UpdateValueStrategy strategy_2 = new UpdateValueStrategy();
		strategy_2.setConverter(new DoubleToStringConvertor());
		UpdateValueStrategy strategy_3 = new UpdateValueStrategy();
		strategy_3.setConverter(new NumericConvertor());
		bindingContext.bindValue(observeTextTxtpriceObserveWidget, priceMaterialObserveValue, strategy_2, strategy_3);
		//
		IObservableValue observeSelectionBtnSensFilObserveWidget = WidgetProperties.buttonSelection().observe(btnSensFil);
		IObservableValue sensFilMaterialObserveValue = BeanProperties.value("sensFil").observe(material);
		bindingContext.bindValue(observeSelectionBtnSensFilObserveWidget, sensFilMaterialObserveValue, null, null);
		//
		//
		IObservableValue observeTextLblImageObserveWidget_1 = WidgetProperties.text().observe(lblImage);
		IObservableValue imageoriginalPathArticleObserveValue = PojoProperties.value("image").observe(material);
		bindingContext.bindValue(observeTextLblImageObserveWidget_1, imageoriginalPathArticleObserveValue, null, null);
		//
		//
		IObservableValue observeSelectionBtnCheckButtonObserveWidget = WidgetProperties.buttonSelection().observe(btnCheckapplyTexture);
		IObservableValue panneauxFrsObserveValue = PojoProperties.value("applyTexture").observe(material);
		bindingContext.bindValue(observeSelectionBtnCheckButtonObserveWidget, panneauxFrsObserveValue, null, null);
		//
		return bindingContext;
	}
	@Override
	protected Point getInitialSize() {
		
		return new Point(1080, 810);
	}
}
