package dressing.handlers.gdx;

import java.util.HashMap;
import java.util.List;

import javax.inject.Inject;

import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.internal.workbench.E4Workbench;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledToolItem;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

import dressing.controller.tools.ToolController;
import dressing.model.ProjectManager;
import gdxapp.shapes.ShapeType;
import supercad.eclipse.service.EclipseServiceProvider;

public class ToolControlHandler {
	

	@Inject
	private static ECommandService commandService;
	@Inject
	private static EHandlerService handlerService;
	
	private static ToolControlHandler instance;

	public ToolControlHandler() {
		
	}
	
	@Execute
	public boolean execute(ParameterizedCommand command) {
		if(command.getParameterMap().get("dressing.commandparameter.tool.mode")!=null)
		{
			
			String state = "";
			command.getCommand().getState(state);
		
			String persp = (String) command.getParameterMap().get("dressing.commandparameter.tool.mode");
			switch (persp) {
			case "zoom":
				ToolController.getInstance().setZOOM();
				break;
			case "selectionZone":
				ToolController.getInstance().setSELECT_ZONE();
				break;
			case "selectionMode":
				ToolController.getInstance().setSELECT_Objects();
				break;
			case "surfaceSelection":
				ToolController.getInstance().setSELECT_SURFACE();
				//ToolController.getInstance().setSELECT_Objects();
	        	 break;
			case "mesureDistance":
				ToolController.getInstance().setMEASURE_DISTANCE();
				break;
			case "drawWall":
				ToolController.getInstance().setDRAW_WALL();
				break;
			case "drawRoomPolygon":
				ToolController.getInstance().setDRAW_ROOM_POLYGONE(ShapeType.POLYGON);
				break;
			case "allowDragWall":
				ToolController.getInstance().setALLOW_WALL_MOVE();

				break;
			case "drawMarblePolygon":
				ToolController.getInstance().setDRAW_POLYGONE_MARBLE();
	        	 break;
			case "dragObjects":
				ToolController.getInstance().setDRAG_OBJECTS();
				break;
			case "drawExtrusion":
				ToolController.getInstance().setDrawExtrusion();
				break;
			
			case "write text":
				ToolController.getInstance().setWriteText();
				break;
			case "unzoom":
				ToolController.getInstance().unzoom();
				break;
			case "arrow":
				ToolController.getInstance().setARROW_TAKER();
				break;
			case "polyline":
				ToolController.getInstance().setDRAW_ROOM_POLYGONE(ShapeType.POLYLINE);
				break;
			case "FreeMove":
				ToolController.getInstance().setFREE_MOVE();
				break;
			case "FreezeMove":
				ToolController.getInstance().setFREEZE_MOVE();
				break;
			default:
				ToolController.getInstance().setSELECT_Objects();
				break ;
			}
			
			return true;
		}
		return false;
	}
	
	@SuppressWarnings("restriction")
	public void triggerSelectObject() {
		try {
			MPart part = EclipseServiceProvider.getServiceProvider().getPartService().getActivePart();
			MWindow window = EclipseServiceProvider.getServiceProvider().getModelService() .getTopLevelWindowFor(part);
			MHandledToolItem selectItem = EclipseServiceProvider.getServiceProvider().getModelService().findElements(window, 
					"dressing.handledtoolitem.cursor.mode", MHandledToolItem.class).get(0);
			MHandledToolItem surfaceItem = EclipseServiceProvider.getServiceProvider().getModelService().findElements(window, 
					"dressing.handledtoolitem.surfaceSelection", MHandledToolItem.class).get(0);
			
			MHandledToolItem zoomItem = EclipseServiceProvider.getServiceProvider().getModelService().findElements(window, 
					"dressing.handledtoolitem.zoom", MHandledToolItem.class).get(0);
			MHandledToolItem measureItem = EclipseServiceProvider.getServiceProvider().getModelService().findElements(window, 
					"dressing.handledtoolitem.measure.distance", MHandledToolItem.class).get(0);
			surfaceItem.setSelected(false);
			selectItem.setSelected(true);
			zoomItem.setSelected(false);
			measureItem.setSelected(false);
			Event event = new Event();
			Widget widget = (Widget) selectItem.getWidget();
	        event.widget = widget;
	        event.type = SWT.Selection;
	        //Notify listeners (simulate a press)
	        for (Listener listener : widget.getListeners(SWT.Selection)) {
	            listener.handleEvent(event);
	        }
		}catch (Exception e) {
			e.printStackTrace();
		}
		
	}

	public synchronized void threadSafeTriggerSelectObject() {
		Display.getDefault().syncExec(() -> {
			triggerSelectObject();
		});
	}
	
	@SuppressWarnings("restriction")
	public void triggerDeactivateSelectObject() {
		try {
			MPart part = EclipseServiceProvider.getServiceProvider().getPartService().getActivePart();
			MWindow window = EclipseServiceProvider.getServiceProvider().getModelService() .getTopLevelWindowFor(part);
			MHandledToolItem selectItem = EclipseServiceProvider.getServiceProvider().getModelService().findElements(window, 
					"dressing.handledtoolitem.cursor.mode", MHandledToolItem.class).get(0);
			
			selectItem.setSelected(false);
		
		}catch (Exception e) {
			e.printStackTrace();
		}
		
	}
	@SuppressWarnings("restriction")
	public void triggerDeactivateZoom() {
		try {
			MPart part = EclipseServiceProvider.getServiceProvider().getPartService().getActivePart();
			MWindow window = EclipseServiceProvider.getServiceProvider().getModelService() .getTopLevelWindowFor(part);
			
			MHandledToolItem zoomItem = EclipseServiceProvider.getServiceProvider().getModelService().findElements(window, 
					"dressing.handledtoolitem.zoom", MHandledToolItem.class).get(0);
			zoomItem.setSelected(false);

		}catch (Exception e) {
			e.printStackTrace();
		}
		
	}
	
	@CanExecute
	public boolean check() {
		if(ProjectManager.getManager().getCurrentKitchen()==null) {
			return false;
		}
		return true;
	}

	public static ToolControlHandler getInstance() {
		if(instance == null)
			instance = new ToolControlHandler();
		return instance;
	}

}
